/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NavigableSet;
import java.util.TreeSet;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.KeepDeletedCells;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueTestUtil;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.regionserver.KeyValueScanFixture;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.ScanInfo;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.StoreScanner;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdge;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManagerTestHelper;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestStoreScanner
extends TestCase {
    private static final String CF_STR = "cf";
    final byte[] CF = Bytes.toBytes((String)"cf");
    static Configuration CONF = HBaseConfiguration.create();
    private ScanInfo scanInfo = new ScanInfo(CONF, this.CF, 0, Integer.MAX_VALUE, Long.MAX_VALUE, KeepDeletedCells.FALSE, 0L, KeyValue.COMPARATOR);
    private ScanType scanType = ScanType.USER_SCAN;
    private static final KeyValue[] kvs = new KeyValue[]{KeyValueTestUtil.create((String)"R1", (String)"cf", (String)"a", (long)11L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)"cf", (String)"b", (long)11L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)"cf", (String)"c", (long)11L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)"cf", (String)"d", (long)11L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)"cf", (String)"e", (long)11L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)"cf", (String)"f", (long)11L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)"cf", (String)"g", (long)11L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)"cf", (String)"h", (long)11L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)"cf", (String)"i", (long)11L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R2", (String)"cf", (String)"a", (long)11L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care")};

    public void setUp() throws Exception {
        super.setUp();
    }

    NavigableSet<byte[]> getCols(String ... strCols) {
        TreeSet<byte[]> cols = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        for (String col : strCols) {
            byte[] bytes = Bytes.toBytes((String)col);
            cols.add(bytes);
        }
        return cols;
    }

    public void testScanTimeRange() throws IOException {
        String r1 = "R1";
        KeyValue[] kvs = new KeyValue[]{KeyValueTestUtil.create((String)r1, (String)CF_STR, (String)"a", (long)1L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)r1, (String)CF_STR, (String)"a", (long)2L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)r1, (String)CF_STR, (String)"a", (long)3L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)r1, (String)CF_STR, (String)"a", (long)4L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)r1, (String)CF_STR, (String)"a", (long)5L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care")};
        List<KeyValueScanner> scanners = Arrays.asList(new KeyValueScanner[]{new KeyValueScanFixture(KeyValue.COMPARATOR, kvs)});
        Scan scanSpec = new Scan(Bytes.toBytes((String)r1));
        scanSpec.setTimeRange(0L, 6L);
        scanSpec.setMaxVersions();
        StoreScanner scan = new StoreScanner(scanSpec, this.scanInfo, this.scanType, this.getCols("a"), scanners);
        ArrayList results = new ArrayList();
        TestStoreScanner.assertEquals((boolean)true, (boolean)scan.next(results));
        TestStoreScanner.assertEquals((int)5, (int)results.size());
        TestStoreScanner.assertEquals((Object)kvs[kvs.length - 1], results.get(0));
        scanSpec = new Scan(Bytes.toBytes((String)r1));
        scanSpec.setTimeRange(1L, 3L);
        scanSpec.setMaxVersions();
        scan = new StoreScanner(scanSpec, this.scanInfo, this.scanType, this.getCols("a"), scanners);
        results = new ArrayList();
        TestStoreScanner.assertEquals((boolean)true, (boolean)scan.next(results));
        TestStoreScanner.assertEquals((int)2, (int)results.size());
        scanSpec = new Scan(Bytes.toBytes((String)r1));
        scanSpec.setTimeRange(5L, 10L);
        scanSpec.setMaxVersions();
        scan = new StoreScanner(scanSpec, this.scanInfo, this.scanType, this.getCols("a"), scanners);
        results = new ArrayList();
        TestStoreScanner.assertEquals((boolean)true, (boolean)scan.next(results));
        TestStoreScanner.assertEquals((int)1, (int)results.size());
        scanSpec = new Scan(Bytes.toBytes((String)r1));
        scanSpec.setTimeRange(0L, 10L);
        scanSpec.setMaxVersions(3);
        scan = new StoreScanner(scanSpec, this.scanInfo, this.scanType, this.getCols("a"), scanners);
        results = new ArrayList();
        TestStoreScanner.assertEquals((boolean)true, (boolean)scan.next(results));
        TestStoreScanner.assertEquals((int)3, (int)results.size());
    }

    public void testScanSameTimestamp() throws IOException {
        KeyValue[] kvs = new KeyValue[]{KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)1L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)1L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care")};
        List<KeyValueScanner> scanners = Arrays.asList(new KeyValueScanner[]{new KeyValueScanFixture(KeyValue.COMPARATOR, kvs)});
        Scan scanSpec = new Scan(Bytes.toBytes((String)"R1"));
        StoreScanner scan = new StoreScanner(scanSpec, this.scanInfo, this.scanType, this.getCols("a"), scanners);
        ArrayList results = new ArrayList();
        TestStoreScanner.assertEquals((boolean)true, (boolean)scan.next(results));
        TestStoreScanner.assertEquals((int)1, (int)results.size());
        TestStoreScanner.assertEquals((Object)kvs[0], results.get(0));
    }

    public void testWontNextToNext() throws IOException {
        KeyValue[] kvs = new KeyValue[]{KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)2L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)1L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R2", (String)CF_STR, (String)"a", (long)1L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care")};
        List<KeyValueScanner> scanners = KeyValueScanFixture.scanFixture(new KeyValue[][]{kvs});
        Scan scanSpec = new Scan(Bytes.toBytes((String)"R1"));
        StoreScanner scan = new StoreScanner(scanSpec, this.scanInfo, this.scanType, this.getCols("a"), scanners);
        ArrayList results = new ArrayList();
        scan.next(results);
        TestStoreScanner.assertEquals((int)1, (int)results.size());
        TestStoreScanner.assertEquals((Object)kvs[0], results.get(0));
        results.clear();
        scan.next(results);
        TestStoreScanner.assertEquals((int)1, (int)results.size());
        TestStoreScanner.assertEquals((Object)kvs[2], results.get(0));
        results.clear();
        scan.next(results);
        TestStoreScanner.assertEquals((int)0, (int)results.size());
    }

    public void testDeleteVersionSameTimestamp() throws IOException {
        KeyValue[] kvs = new KeyValue[]{KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)1L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)1L, (KeyValue.Type)KeyValue.Type.Delete, (String)"dont-care")};
        List<KeyValueScanner> scanners = KeyValueScanFixture.scanFixture(new KeyValue[][]{kvs});
        Scan scanSpec = new Scan(Bytes.toBytes((String)"R1"));
        StoreScanner scan = new StoreScanner(scanSpec, this.scanInfo, this.scanType, this.getCols("a"), scanners);
        ArrayList results = new ArrayList();
        TestStoreScanner.assertFalse((boolean)scan.next(results));
        TestStoreScanner.assertEquals((int)0, (int)results.size());
    }

    public void testDeletedRowThenGoodRow() throws IOException {
        KeyValue[] kvs = new KeyValue[]{KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)1L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)1L, (KeyValue.Type)KeyValue.Type.Delete, (String)"dont-care"), KeyValueTestUtil.create((String)"R2", (String)CF_STR, (String)"a", (long)20L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care")};
        List<KeyValueScanner> scanners = KeyValueScanFixture.scanFixture(new KeyValue[][]{kvs});
        Scan scanSpec = new Scan(Bytes.toBytes((String)"R1"));
        StoreScanner scan = new StoreScanner(scanSpec, this.scanInfo, this.scanType, this.getCols("a"), scanners);
        ArrayList results = new ArrayList();
        TestStoreScanner.assertEquals((boolean)true, (boolean)scan.next(results));
        TestStoreScanner.assertEquals((int)0, (int)results.size());
        TestStoreScanner.assertEquals((boolean)true, (boolean)scan.next(results));
        TestStoreScanner.assertEquals((int)1, (int)results.size());
        TestStoreScanner.assertEquals((Object)kvs[2], results.get(0));
        TestStoreScanner.assertEquals((boolean)false, (boolean)scan.next(results));
    }

    public void testDeleteVersionMaskingMultiplePuts() throws IOException {
        long now = System.currentTimeMillis();
        KeyValue[] kvs1 = new KeyValue[]{KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)now, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)now, (KeyValue.Type)KeyValue.Type.Delete, (String)"dont-care")};
        KeyValue[] kvs2 = new KeyValue[]{KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)(now - 500L), (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)(now - 100L), (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)now, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care")};
        List<KeyValueScanner> scanners = KeyValueScanFixture.scanFixture(kvs1, kvs2);
        StoreScanner scan = new StoreScanner(new Scan(Bytes.toBytes((String)"R1")), this.scanInfo, this.scanType, this.getCols("a"), scanners);
        ArrayList results = new ArrayList();
        TestStoreScanner.assertEquals((boolean)true, (boolean)scan.next(results));
        TestStoreScanner.assertEquals((int)1, (int)results.size());
        TestStoreScanner.assertEquals((Object)kvs2[1], results.get(0));
    }

    public void testDeleteVersionsMixedAndMultipleVersionReturn() throws IOException {
        long now = System.currentTimeMillis();
        KeyValue[] kvs1 = new KeyValue[]{KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)now, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)now, (KeyValue.Type)KeyValue.Type.Delete, (String)"dont-care")};
        KeyValue[] kvs2 = new KeyValue[]{KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)(now - 500L), (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)(now + 500L), (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)now, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R2", (String)CF_STR, (String)"z", (long)now, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care")};
        List<KeyValueScanner> scanners = KeyValueScanFixture.scanFixture(kvs1, kvs2);
        Scan scanSpec = new Scan(Bytes.toBytes((String)"R1")).setMaxVersions(2);
        StoreScanner scan = new StoreScanner(scanSpec, this.scanInfo, this.scanType, this.getCols("a"), scanners);
        ArrayList results = new ArrayList();
        TestStoreScanner.assertEquals((boolean)true, (boolean)scan.next(results));
        TestStoreScanner.assertEquals((int)2, (int)results.size());
        TestStoreScanner.assertEquals((Object)kvs2[1], results.get(0));
        TestStoreScanner.assertEquals((Object)kvs2[0], results.get(1));
    }

    public void testWildCardOneVersionScan() throws IOException {
        KeyValue[] kvs = new KeyValue[]{KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)2L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"b", (long)1L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)1L, (KeyValue.Type)KeyValue.Type.DeleteColumn, (String)"dont-care")};
        List<KeyValueScanner> scanners = KeyValueScanFixture.scanFixture(new KeyValue[][]{kvs});
        StoreScanner scan = new StoreScanner(new Scan(Bytes.toBytes((String)"R1")), this.scanInfo, this.scanType, null, scanners);
        ArrayList results = new ArrayList();
        TestStoreScanner.assertEquals((boolean)true, (boolean)scan.next(results));
        TestStoreScanner.assertEquals((int)2, (int)results.size());
        TestStoreScanner.assertEquals((Object)kvs[0], results.get(0));
        TestStoreScanner.assertEquals((Object)kvs[1], results.get(1));
    }

    public void testWildCardScannerUnderDeletes() throws IOException {
        KeyValue[] kvs = new KeyValue[]{KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)2L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)1L, (KeyValue.Type)KeyValue.Type.DeleteColumn, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"b", (long)2L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"b", (long)1L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"c", (long)10L, (KeyValue.Type)KeyValue.Type.Delete, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"c", (long)10L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"c", (long)9L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"d", (long)11L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"d", (long)10L, (KeyValue.Type)KeyValue.Type.DeleteColumn, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"d", (long)9L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"d", (long)8L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care")};
        List<KeyValueScanner> scanners = KeyValueScanFixture.scanFixture(new KeyValue[][]{kvs});
        StoreScanner scan = new StoreScanner(new Scan().setMaxVersions(2), this.scanInfo, this.scanType, null, scanners);
        ArrayList results = new ArrayList();
        TestStoreScanner.assertEquals((boolean)true, (boolean)scan.next(results));
        TestStoreScanner.assertEquals((int)5, (int)results.size());
        TestStoreScanner.assertEquals((Object)kvs[0], results.get(0));
        TestStoreScanner.assertEquals((Object)kvs[2], results.get(1));
        TestStoreScanner.assertEquals((Object)kvs[3], results.get(2));
        TestStoreScanner.assertEquals((Object)kvs[6], results.get(3));
        TestStoreScanner.assertEquals((Object)kvs[7], results.get(4));
    }

    public void testDeleteFamily() throws IOException {
        KeyValue[] kvs = new KeyValue[]{KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)100L, (KeyValue.Type)KeyValue.Type.DeleteFamily, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"b", (long)11L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"c", (long)11L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"d", (long)11L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"e", (long)11L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"e", (long)11L, (KeyValue.Type)KeyValue.Type.DeleteColumn, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"f", (long)11L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"g", (long)11L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"g", (long)11L, (KeyValue.Type)KeyValue.Type.Delete, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"h", (long)11L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"i", (long)11L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R2", (String)CF_STR, (String)"a", (long)11L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care")};
        List<KeyValueScanner> scanners = KeyValueScanFixture.scanFixture(new KeyValue[][]{kvs});
        StoreScanner scan = new StoreScanner(new Scan().setMaxVersions(Integer.MAX_VALUE), this.scanInfo, this.scanType, null, scanners);
        ArrayList results = new ArrayList();
        TestStoreScanner.assertEquals((boolean)true, (boolean)scan.next(results));
        TestStoreScanner.assertEquals((int)0, (int)results.size());
        TestStoreScanner.assertEquals((boolean)true, (boolean)scan.next(results));
        TestStoreScanner.assertEquals((int)1, (int)results.size());
        TestStoreScanner.assertEquals((Object)kvs[kvs.length - 1], results.get(0));
        TestStoreScanner.assertEquals((boolean)false, (boolean)scan.next(results));
    }

    public void testDeleteColumn() throws IOException {
        KeyValue[] kvs = new KeyValue[]{KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)10L, (KeyValue.Type)KeyValue.Type.DeleteColumn, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)9L, (KeyValue.Type)KeyValue.Type.Delete, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)8L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"b", (long)5L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care")};
        List<KeyValueScanner> scanners = KeyValueScanFixture.scanFixture(new KeyValue[][]{kvs});
        StoreScanner scan = new StoreScanner(new Scan(), this.scanInfo, this.scanType, null, scanners);
        ArrayList results = new ArrayList();
        TestStoreScanner.assertEquals((boolean)true, (boolean)scan.next(results));
        TestStoreScanner.assertEquals((int)1, (int)results.size());
        TestStoreScanner.assertEquals((Object)kvs[3], results.get(0));
    }

    public void testSkipColumn() throws IOException {
        List<KeyValueScanner> scanners = KeyValueScanFixture.scanFixture(new KeyValue[][]{kvs});
        StoreScanner scan = new StoreScanner(new Scan(), this.scanInfo, this.scanType, this.getCols("a", "d"), scanners);
        ArrayList results = new ArrayList();
        TestStoreScanner.assertEquals((boolean)true, (boolean)scan.next(results));
        TestStoreScanner.assertEquals((int)2, (int)results.size());
        TestStoreScanner.assertEquals((Object)kvs[0], results.get(0));
        TestStoreScanner.assertEquals((Object)kvs[3], results.get(1));
        results.clear();
        TestStoreScanner.assertEquals((boolean)true, (boolean)scan.next(results));
        TestStoreScanner.assertEquals((int)1, (int)results.size());
        TestStoreScanner.assertEquals((Object)kvs[kvs.length - 1], results.get(0));
        results.clear();
        TestStoreScanner.assertEquals((boolean)false, (boolean)scan.next(results));
    }

    public void testWildCardTtlScan() throws IOException {
        long now = System.currentTimeMillis();
        KeyValue[] kvs = new KeyValue[]{KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)(now - 1000L), (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"b", (long)(now - 10L), (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"c", (long)(now - 200L), (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"d", (long)(now - 10000L), (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R2", (String)CF_STR, (String)"a", (long)now, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R2", (String)CF_STR, (String)"b", (long)(now - 10L), (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R2", (String)CF_STR, (String)"c", (long)(now - 200L), (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R2", (String)CF_STR, (String)"c", (long)(now - 1000L), (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care")};
        List<KeyValueScanner> scanners = KeyValueScanFixture.scanFixture(new KeyValue[][]{kvs});
        Scan scan = new Scan();
        scan.setMaxVersions(1);
        ScanInfo scanInfo = new ScanInfo(CONF, this.CF, 0, 1, 500L, KeepDeletedCells.FALSE, 0L, KeyValue.COMPARATOR);
        ScanType scanType = ScanType.USER_SCAN;
        StoreScanner scanner = new StoreScanner(scan, scanInfo, scanType, null, scanners);
        ArrayList results = new ArrayList();
        TestStoreScanner.assertEquals((boolean)true, (boolean)scanner.next(results));
        TestStoreScanner.assertEquals((int)2, (int)results.size());
        TestStoreScanner.assertEquals((Object)kvs[1], results.get(0));
        TestStoreScanner.assertEquals((Object)kvs[2], results.get(1));
        results.clear();
        TestStoreScanner.assertEquals((boolean)true, (boolean)scanner.next(results));
        TestStoreScanner.assertEquals((int)3, (int)results.size());
        TestStoreScanner.assertEquals((Object)kvs[4], results.get(0));
        TestStoreScanner.assertEquals((Object)kvs[5], results.get(1));
        TestStoreScanner.assertEquals((Object)kvs[6], results.get(2));
        results.clear();
        TestStoreScanner.assertEquals((boolean)false, (boolean)scanner.next(results));
    }

    public void testScannerReseekDoesntNPE() throws Exception {
        List<KeyValueScanner> scanners = KeyValueScanFixture.scanFixture(new KeyValue[][]{kvs});
        StoreScanner scan = new StoreScanner(new Scan(), this.scanInfo, this.scanType, this.getCols("a", "d"), scanners);
        scan.updateReaders(new ArrayList());
        scan.updateReaders(new ArrayList());
        scan.peek();
    }

    public void SKIP_testPeek() throws Exception {
        KeyValue[] kvs = new KeyValue[]{KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)1L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)1L, (KeyValue.Type)KeyValue.Type.Delete, (String)"dont-care")};
        List<KeyValueScanner> scanners = KeyValueScanFixture.scanFixture(new KeyValue[][]{kvs});
        Scan scanSpec = new Scan(Bytes.toBytes((String)"R1"));
        StoreScanner scan = new StoreScanner(scanSpec, this.scanInfo, this.scanType, this.getCols("a"), scanners);
        TestStoreScanner.assertNull((Object)scan.peek());
    }

    public void testExpiredDeleteFamily() throws Exception {
        long now = System.currentTimeMillis();
        KeyValue[] kvs = new KeyValue[]{new KeyValue(Bytes.toBytes((String)"R1"), Bytes.toBytes((String)CF_STR), null, now - 1000L, KeyValue.Type.DeleteFamily), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)(now - 10L), (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care")};
        List<KeyValueScanner> scanners = KeyValueScanFixture.scanFixture(new KeyValue[][]{kvs});
        Scan scan = new Scan();
        scan.setMaxVersions(1);
        ScanInfo scanInfo = new ScanInfo(CONF, this.CF, 0, 1, 500L, KeepDeletedCells.FALSE, 0L, KeyValue.COMPARATOR);
        ScanType scanType = ScanType.USER_SCAN;
        StoreScanner scanner = new StoreScanner(scan, scanInfo, scanType, null, scanners);
        ArrayList results = new ArrayList();
        TestStoreScanner.assertEquals((boolean)true, (boolean)scanner.next(results));
        TestStoreScanner.assertEquals((int)1, (int)results.size());
        TestStoreScanner.assertEquals((Object)kvs[1], results.get(0));
        results.clear();
        TestStoreScanner.assertEquals((boolean)false, (boolean)scanner.next(results));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeleteMarkerLongevity() throws Exception {
        try {
            final long now = System.currentTimeMillis();
            EnvironmentEdgeManagerTestHelper.injectEdge((EnvironmentEdge)new EnvironmentEdge(){

                public long currentTime() {
                    return now;
                }
            });
            KeyValue[] kvs = new KeyValue[]{new KeyValue(Bytes.toBytes((String)"R1"), Bytes.toBytes((String)CF_STR), null, now - 100L, KeyValue.Type.DeleteFamily), new KeyValue(Bytes.toBytes((String)"R1"), Bytes.toBytes((String)CF_STR), null, now - 1000L, KeyValue.Type.DeleteFamily), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)(now - 50L), (KeyValue.Type)KeyValue.Type.Put, (String)"v3"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)(now - 55L), (KeyValue.Type)KeyValue.Type.Delete, (String)"dontcare"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)(now - 55L), (KeyValue.Type)KeyValue.Type.Put, (String)"deleted-version v2"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)(now - 60L), (KeyValue.Type)KeyValue.Type.Put, (String)"v1"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)(now - 65L), (KeyValue.Type)KeyValue.Type.Put, (String)"v0"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)(now - 100L), (KeyValue.Type)KeyValue.Type.DeleteColumn, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"b", (long)(now - 600L), (KeyValue.Type)KeyValue.Type.DeleteColumn, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"b", (long)(now - 70L), (KeyValue.Type)KeyValue.Type.Put, (String)"v2"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"b", (long)(now - 750L), (KeyValue.Type)KeyValue.Type.Put, (String)"v1"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"c", (long)(now - 500L), (KeyValue.Type)KeyValue.Type.Delete, (String)"dontcare"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"c", (long)(now - 600L), (KeyValue.Type)KeyValue.Type.Put, (String)"v1"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"c", (long)(now - 1000L), (KeyValue.Type)KeyValue.Type.Delete, (String)"dontcare"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"d", (long)(now - 60L), (KeyValue.Type)KeyValue.Type.Put, (String)"expired put"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"d", (long)(now - 100L), (KeyValue.Type)KeyValue.Type.Delete, (String)"not-expired delete")};
            List<KeyValueScanner> scanners = KeyValueScanFixture.scanFixture(new KeyValue[][]{kvs});
            Scan scan = new Scan();
            scan.setMaxVersions(2);
            ScanInfo scanInfo = new ScanInfo(CONF, Bytes.toBytes((String)CF_STR), 0, 2, 500L, KeepDeletedCells.FALSE, 200L, KeyValue.COMPARATOR);
            StoreScanner scanner = new StoreScanner(scan, scanInfo, ScanType.COMPACT_DROP_DELETES, null, scanners, Long.MIN_VALUE);
            ArrayList results = new ArrayList();
            results = new ArrayList();
            TestStoreScanner.assertEquals((boolean)true, (boolean)scanner.next(results));
            TestStoreScanner.assertEquals((Object)kvs[0], results.get(0));
            TestStoreScanner.assertEquals((Object)kvs[2], results.get(1));
            TestStoreScanner.assertEquals((Object)kvs[3], results.get(2));
            TestStoreScanner.assertEquals((Object)kvs[5], results.get(3));
            TestStoreScanner.assertEquals((Object)kvs[9], results.get(4));
            TestStoreScanner.assertEquals((Object)kvs[14], results.get(5));
            TestStoreScanner.assertEquals((Object)kvs[15], results.get(6));
            TestStoreScanner.assertEquals((int)7, (int)results.size());
            scanner.close();
        }
        finally {
            EnvironmentEdgeManagerTestHelper.reset();
        }
    }
}

