/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.access.AccessControlLists;
import org.apache.hadoop.hbase.security.access.HbaseObjectWritableFor96Migration;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.SecureTestUtil;
import org.apache.hadoop.hbase.security.access.TableAuthManager;
import org.apache.hadoop.hbase.security.access.TablePermission;
import org.apache.hadoop.hbase.security.access.UserPermission;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.io.Text;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestTablePermissions {
    private static final Log LOG = LogFactory.getLog(TestTablePermissions.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static ZooKeeperWatcher ZKW;
    private static final Abortable ABORTABLE;
    private static TableName TEST_TABLE;
    private static TableName TEST_TABLE2;
    private static byte[] TEST_FAMILY;
    private static byte[] TEST_QUALIFIER;

    @BeforeClass
    public static void beforeClass() throws Exception {
        Configuration conf = UTIL.getConfiguration();
        SecureTestUtil.enableSecurity(conf);
        UTIL.startMiniCluster();
        UTIL.waitTableEnabled(AccessControlLists.ACL_TABLE_NAME);
        ZKW = new ZooKeeperWatcher(UTIL.getConfiguration(), "TestTablePermissions", ABORTABLE);
        UTIL.createTable(TEST_TABLE, TEST_FAMILY);
        UTIL.createTable(TEST_TABLE2, TEST_FAMILY);
    }

    @AfterClass
    public static void afterClass() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @After
    public void tearDown() throws Exception {
        Configuration conf = UTIL.getConfiguration();
        AccessControlLists.removeTablePermissions((Configuration)conf, (TableName)TEST_TABLE);
        AccessControlLists.removeTablePermissions((Configuration)conf, (TableName)TEST_TABLE2);
        AccessControlLists.removeTablePermissions((Configuration)conf, (TableName)AccessControlLists.ACL_TABLE_NAME);
    }

    @Test
    public void testMigration() throws DeserializationException {
        Configuration conf = UTIL.getConfiguration();
        ListMultimap<String, TablePermission> permissions = this.createPermissions();
        byte[] bytes = TestTablePermissions.writePermissionsAsBytes(permissions, conf);
        AccessControlLists.readPermissions((byte[])bytes, (Configuration)conf);
    }

    public static byte[] writePermissionsAsBytes(ListMultimap<String, ? extends Permission> perms, Configuration conf) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            TestTablePermissions.writePermissions(new DataOutputStream(bos), perms, conf);
            return bos.toByteArray();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error serializing permissions", ioe);
        }
    }

    public static void writePermissions(DataOutput out, ListMultimap<String, ? extends Permission> perms, Configuration conf) throws IOException {
        Set keys = perms.keySet();
        out.writeInt(keys.size());
        for (String key : keys) {
            Text.writeString((DataOutput)out, (String)key);
            HbaseObjectWritableFor96Migration.writeObject((DataOutput)out, (Object)perms.get((Object)key), List.class, (Configuration)conf);
        }
    }

    @Test
    public void testBasicWrite() throws Exception {
        Configuration conf = UTIL.getConfiguration();
        AccessControlLists.addUserPermission((Configuration)conf, (UserPermission)new UserPermission(Bytes.toBytes((String)"george"), TEST_TABLE, null, (byte[])null, new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}));
        AccessControlLists.addUserPermission((Configuration)conf, (UserPermission)new UserPermission(Bytes.toBytes((String)"hubert"), TEST_TABLE, null, (byte[])null, new Permission.Action[]{Permission.Action.READ}));
        AccessControlLists.addUserPermission((Configuration)conf, (UserPermission)new UserPermission(Bytes.toBytes((String)"humphrey"), TEST_TABLE, TEST_FAMILY, TEST_QUALIFIER, new Permission.Action[]{Permission.Action.READ}));
        ListMultimap perms = AccessControlLists.getTablePermissions((Configuration)conf, (TableName)TEST_TABLE);
        List userPerms = perms.get((Object)"george");
        Assert.assertNotNull((String)"Should have permissions for george", (Object)userPerms);
        Assert.assertEquals((String)"Should have 1 permission for george", (long)1L, (long)userPerms.size());
        TablePermission permission = (TablePermission)userPerms.get(0);
        Assert.assertEquals((String)("Permission should be for " + TEST_TABLE), (Object)TEST_TABLE, (Object)permission.getTableName());
        Assert.assertNull((String)"Column family should be empty", (Object)permission.getFamily());
        Assert.assertNotNull((Object)permission.getActions());
        Assert.assertEquals((long)2L, (long)permission.getActions().length);
        List<Permission.Action> actions = Arrays.asList(permission.getActions());
        Assert.assertTrue((boolean)actions.contains(Permission.Action.READ));
        Assert.assertTrue((boolean)actions.contains(Permission.Action.WRITE));
        userPerms = perms.get((Object)"hubert");
        Assert.assertNotNull((String)"Should have permissions for hubert", (Object)userPerms);
        Assert.assertEquals((String)"Should have 1 permission for hubert", (long)1L, (long)userPerms.size());
        permission = (TablePermission)userPerms.get(0);
        Assert.assertEquals((String)("Permission should be for " + TEST_TABLE), (Object)TEST_TABLE, (Object)permission.getTableName());
        Assert.assertNull((String)"Column family should be empty", (Object)permission.getFamily());
        Assert.assertNotNull((Object)permission.getActions());
        Assert.assertEquals((long)1L, (long)permission.getActions().length);
        actions = Arrays.asList(permission.getActions());
        Assert.assertTrue((boolean)actions.contains(Permission.Action.READ));
        Assert.assertFalse((boolean)actions.contains(Permission.Action.WRITE));
        userPerms = perms.get((Object)"humphrey");
        Assert.assertNotNull((String)"Should have permissions for humphrey", (Object)userPerms);
        Assert.assertEquals((String)"Should have 1 permission for humphrey", (long)1L, (long)userPerms.size());
        permission = (TablePermission)userPerms.get(0);
        Assert.assertEquals((String)("Permission should be for " + TEST_TABLE), (Object)TEST_TABLE, (Object)permission.getTableName());
        Assert.assertTrue((String)("Permission should be for family " + TEST_FAMILY), (boolean)Bytes.equals((byte[])TEST_FAMILY, (byte[])permission.getFamily()));
        Assert.assertTrue((String)("Permission should be for qualifier " + TEST_QUALIFIER), (boolean)Bytes.equals((byte[])TEST_QUALIFIER, (byte[])permission.getQualifier()));
        Assert.assertNotNull((Object)permission.getActions());
        Assert.assertEquals((long)1L, (long)permission.getActions().length);
        actions = Arrays.asList(permission.getActions());
        Assert.assertTrue((boolean)actions.contains(Permission.Action.READ));
        Assert.assertFalse((boolean)actions.contains(Permission.Action.WRITE));
        AccessControlLists.addUserPermission((Configuration)conf, (UserPermission)new UserPermission(Bytes.toBytes((String)"hubert"), TEST_TABLE2, null, (byte[])null, new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}));
        Map allPerms = AccessControlLists.loadAll((Configuration)conf);
        Assert.assertEquals((String)"Full permission map should have entries for both test tables", (long)2L, (long)allPerms.size());
        userPerms = ((ListMultimap)allPerms.get(TEST_TABLE.getName())).get((Object)"hubert");
        Assert.assertNotNull((Object)userPerms);
        Assert.assertEquals((long)1L, (long)userPerms.size());
        permission = (TablePermission)userPerms.get(0);
        Assert.assertEquals((Object)TEST_TABLE, (Object)permission.getTableName());
        Assert.assertEquals((long)1L, (long)permission.getActions().length);
        Assert.assertEquals((Object)Permission.Action.READ, (Object)permission.getActions()[0]);
        userPerms = ((ListMultimap)allPerms.get(TEST_TABLE2.getName())).get((Object)"hubert");
        Assert.assertNotNull((Object)userPerms);
        Assert.assertEquals((long)1L, (long)userPerms.size());
        permission = (TablePermission)userPerms.get(0);
        Assert.assertEquals((Object)TEST_TABLE2, (Object)permission.getTableName());
        Assert.assertEquals((long)2L, (long)permission.getActions().length);
        actions = Arrays.asList(permission.getActions());
        Assert.assertTrue((boolean)actions.contains(Permission.Action.READ));
        Assert.assertTrue((boolean)actions.contains(Permission.Action.WRITE));
    }

    @Test
    public void testPersistence() throws Exception {
        Configuration conf = UTIL.getConfiguration();
        AccessControlLists.addUserPermission((Configuration)conf, (UserPermission)new UserPermission(Bytes.toBytes((String)"albert"), TEST_TABLE, null, (byte[])null, new Permission.Action[]{Permission.Action.READ}));
        AccessControlLists.addUserPermission((Configuration)conf, (UserPermission)new UserPermission(Bytes.toBytes((String)"betty"), TEST_TABLE, null, (byte[])null, new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}));
        AccessControlLists.addUserPermission((Configuration)conf, (UserPermission)new UserPermission(Bytes.toBytes((String)"clark"), TEST_TABLE, TEST_FAMILY, new Permission.Action[]{Permission.Action.READ}));
        AccessControlLists.addUserPermission((Configuration)conf, (UserPermission)new UserPermission(Bytes.toBytes((String)"dwight"), TEST_TABLE, TEST_FAMILY, TEST_QUALIFIER, new Permission.Action[]{Permission.Action.WRITE}));
        ListMultimap preperms = AccessControlLists.getTablePermissions((Configuration)conf, (TableName)TEST_TABLE);
        HTable table = new HTable(conf, TEST_TABLE);
        table.put(new Put(Bytes.toBytes((String)"row1")).add(TEST_FAMILY, TEST_QUALIFIER, Bytes.toBytes((String)"v1")));
        table.put(new Put(Bytes.toBytes((String)"row2")).add(TEST_FAMILY, TEST_QUALIFIER, Bytes.toBytes((String)"v2")));
        HBaseAdmin admin = UTIL.getHBaseAdmin();
        admin.split(TEST_TABLE);
        Thread.sleep(10000L);
        ListMultimap postperms = AccessControlLists.getTablePermissions((Configuration)conf, (TableName)TEST_TABLE);
        this.checkMultimapEqual((ListMultimap<String, TablePermission>)preperms, (ListMultimap<String, TablePermission>)postperms);
    }

    @Test
    public void testSerialization() throws Exception {
        Configuration conf = UTIL.getConfiguration();
        ListMultimap<String, TablePermission> permissions = this.createPermissions();
        byte[] permsData = AccessControlLists.writePermissionsAsBytes(permissions, (Configuration)conf);
        ListMultimap copy = AccessControlLists.readPermissions((byte[])permsData, (Configuration)conf);
        this.checkMultimapEqual(permissions, (ListMultimap<String, TablePermission>)copy);
    }

    private ListMultimap<String, TablePermission> createPermissions() {
        ArrayListMultimap permissions = ArrayListMultimap.create();
        permissions.put((Object)"george", (Object)new TablePermission(TEST_TABLE, null, new Permission.Action[]{Permission.Action.READ}));
        permissions.put((Object)"george", (Object)new TablePermission(TEST_TABLE, TEST_FAMILY, new Permission.Action[]{Permission.Action.WRITE}));
        permissions.put((Object)"george", (Object)new TablePermission(TEST_TABLE2, null, new Permission.Action[]{Permission.Action.READ}));
        permissions.put((Object)"hubert", (Object)new TablePermission(TEST_TABLE2, null, new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}));
        return permissions;
    }

    public void checkMultimapEqual(ListMultimap<String, TablePermission> first, ListMultimap<String, TablePermission> second) {
        Assert.assertEquals((long)first.size(), (long)second.size());
        for (String key : first.keySet()) {
            List firstPerms = first.get((Object)key);
            List secondPerms = second.get((Object)key);
            Assert.assertNotNull((Object)secondPerms);
            Assert.assertEquals((long)firstPerms.size(), (long)secondPerms.size());
            LOG.info((Object)("First permissions: " + firstPerms.toString()));
            LOG.info((Object)("Second permissions: " + secondPerms.toString()));
            for (TablePermission p : firstPerms) {
                Assert.assertTrue((String)("Permission " + p.toString() + " not found"), (boolean)secondPerms.contains(p));
            }
        }
    }

    @Test
    public void testEquals() throws Exception {
        TablePermission p1 = new TablePermission(TEST_TABLE, null, new Permission.Action[]{Permission.Action.READ});
        TablePermission p2 = new TablePermission(TEST_TABLE, null, new Permission.Action[]{Permission.Action.READ});
        Assert.assertTrue((boolean)p1.equals((Object)p2));
        Assert.assertTrue((boolean)p2.equals((Object)p1));
        p1 = new TablePermission(TEST_TABLE, null, new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE});
        p2 = new TablePermission(TEST_TABLE, null, new Permission.Action[]{Permission.Action.WRITE, Permission.Action.READ});
        Assert.assertTrue((boolean)p1.equals((Object)p2));
        Assert.assertTrue((boolean)p2.equals((Object)p1));
        p1 = new TablePermission(TEST_TABLE, TEST_FAMILY, new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE});
        p2 = new TablePermission(TEST_TABLE, TEST_FAMILY, new Permission.Action[]{Permission.Action.WRITE, Permission.Action.READ});
        Assert.assertTrue((boolean)p1.equals((Object)p2));
        Assert.assertTrue((boolean)p2.equals((Object)p1));
        p1 = new TablePermission(TEST_TABLE, TEST_FAMILY, TEST_QUALIFIER, new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE});
        p2 = new TablePermission(TEST_TABLE, TEST_FAMILY, TEST_QUALIFIER, new Permission.Action[]{Permission.Action.WRITE, Permission.Action.READ});
        Assert.assertTrue((boolean)p1.equals((Object)p2));
        Assert.assertTrue((boolean)p2.equals((Object)p1));
        p1 = new TablePermission(TEST_TABLE, null, new Permission.Action[]{Permission.Action.READ});
        p2 = new TablePermission(TEST_TABLE, TEST_FAMILY, new Permission.Action[]{Permission.Action.READ});
        Assert.assertFalse((boolean)p1.equals((Object)p2));
        Assert.assertFalse((boolean)p2.equals((Object)p1));
        p1 = new TablePermission(TEST_TABLE, null, new Permission.Action[]{Permission.Action.READ});
        p2 = new TablePermission(TEST_TABLE, null, new Permission.Action[]{Permission.Action.WRITE});
        Assert.assertFalse((boolean)p1.equals((Object)p2));
        Assert.assertFalse((boolean)p2.equals((Object)p1));
        p2 = new TablePermission(TEST_TABLE, null, new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE});
        Assert.assertFalse((boolean)p1.equals((Object)p2));
        Assert.assertFalse((boolean)p2.equals((Object)p1));
        p1 = new TablePermission(TEST_TABLE, null, new Permission.Action[]{Permission.Action.READ});
        p2 = new TablePermission(TEST_TABLE2, null, new Permission.Action[]{Permission.Action.READ});
        Assert.assertFalse((boolean)p1.equals((Object)p2));
        Assert.assertFalse((boolean)p2.equals((Object)p1));
        p2 = new TablePermission(TEST_TABLE, null, new Permission.Action[0]);
        Assert.assertFalse((boolean)p1.equals((Object)p2));
        Assert.assertFalse((boolean)p2.equals((Object)p1));
    }

    @Test
    public void testGlobalPermission() throws Exception {
        Configuration conf = UTIL.getConfiguration();
        AccessControlLists.addUserPermission((Configuration)conf, (UserPermission)new UserPermission(Bytes.toBytes((String)"user1"), new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}));
        AccessControlLists.addUserPermission((Configuration)conf, (UserPermission)new UserPermission(Bytes.toBytes((String)"user2"), new Permission.Action[]{Permission.Action.CREATE}));
        AccessControlLists.addUserPermission((Configuration)conf, (UserPermission)new UserPermission(Bytes.toBytes((String)"user3"), new Permission.Action[]{Permission.Action.ADMIN, Permission.Action.READ, Permission.Action.CREATE}));
        ListMultimap perms = AccessControlLists.getTablePermissions((Configuration)conf, null);
        List user1Perms = perms.get((Object)"user1");
        Assert.assertEquals((String)"Should have 1 permission for user1", (long)1L, (long)user1Perms.size());
        Assert.assertEquals((String)"user1 should have WRITE permission", (Object[])new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}, (Object[])((TablePermission)user1Perms.get(0)).getActions());
        List user2Perms = perms.get((Object)"user2");
        Assert.assertEquals((String)"Should have 1 permission for user2", (long)1L, (long)user2Perms.size());
        Assert.assertEquals((String)"user2 should have CREATE permission", (Object[])new Permission.Action[]{Permission.Action.CREATE}, (Object[])((TablePermission)user2Perms.get(0)).getActions());
        List user3Perms = perms.get((Object)"user3");
        Assert.assertEquals((String)"Should have 1 permission for user3", (long)1L, (long)user3Perms.size());
        Assert.assertEquals((String)"user3 should have ADMIN, READ, CREATE permission", (Object[])new Permission.Action[]{Permission.Action.ADMIN, Permission.Action.READ, Permission.Action.CREATE}, (Object[])((TablePermission)user3Perms.get(0)).getActions());
    }

    @Test
    public void testAuthManager() throws Exception {
        Configuration conf = UTIL.getConfiguration();
        TableAuthManager authManager = TableAuthManager.getOrCreate((ZooKeeperWatcher)ZKW, (Configuration)conf);
        User currentUser = User.getCurrent();
        Assert.assertTrue((boolean)authManager.authorize(currentUser, Permission.Action.ADMIN));
        for (int i = 1; i <= 50; ++i) {
            AccessControlLists.addUserPermission((Configuration)conf, (UserPermission)new UserPermission(Bytes.toBytes((String)("testauth" + i)), new Permission.Action[]{Permission.Action.ADMIN, Permission.Action.READ, Permission.Action.WRITE}));
            Assert.assertTrue((String)("Failed current user auth check on iter " + i), (boolean)authManager.authorize(currentUser, Permission.Action.ADMIN));
        }
    }

    static {
        ABORTABLE = new Abortable(){
            private final AtomicBoolean abort = new AtomicBoolean(false);

            public void abort(String why, Throwable e) {
                LOG.info((Object)why, e);
                this.abort.set(true);
            }

            public boolean isAborted() {
                return this.abort.get();
            }
        };
        TEST_TABLE = TableName.valueOf((String)"perms_test");
        TEST_TABLE2 = TableName.valueOf((String)"perms_test2");
        TEST_FAMILY = Bytes.toBytes((String)"f1");
        TEST_QUALIFIER = Bytes.toBytes((String)"col1");
    }
}

