/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.token;

import com.google.protobuf.ServiceException;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.ipc.AsyncRpcClient;
import org.apache.hadoop.hbase.ipc.RpcClient;
import org.apache.hadoop.hbase.ipc.RpcClientImpl;
import org.apache.hadoop.hbase.security.token.SecureTestCluster;
import org.apache.hadoop.hbase.security.token.TokenUtil;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.SecurityTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SecurityTests.class, MediumTests.class})
public class TestDelegationTokenWithEncryption
extends SecureTestCluster {
    @BeforeClass
    public static void setUp() throws Exception {
        TEST_UTIL.getConfiguration().set("hbase.rpc.protection", "privacy");
        SecureTestCluster.setUp();
    }

    private void testPutGetWithDelegationToken(Class<? extends RpcClient> rpcImplClass) throws IOException, ServiceException {
        TEST_UTIL.getConfiguration().set("hbase.rpc.client.impl", rpcImplClass.getName());
        try (Connection conn = ConnectionFactory.createConnection((Configuration)TEST_UTIL.getConfiguration());
             Table table = conn.getTable(TableName.valueOf((String)"testtable"));){
            Put p = new Put(Bytes.toBytes((String)"row"));
            p.addColumn(Bytes.toBytes((String)"family"), Bytes.toBytes((String)"data"), Bytes.toBytes((String)"testdata"));
            table.put(p);
            Get g = new Get(Bytes.toBytes((String)"row"));
            Result result = table.get(g);
            Assert.assertArrayEquals((byte[])Bytes.toBytes((String)"testdata"), (byte[])result.getValue(Bytes.toBytes((String)"family"), Bytes.toBytes((String)"data")));
        }
    }

    @Test
    public void testPutGetWithDelegationToken() throws Exception {
        try (Connection conn = ConnectionFactory.createConnection((Configuration)TEST_UTIL.getConfiguration());){
            Token token = TokenUtil.obtainToken((Connection)conn);
            UserGroupInformation.getCurrentUser().addToken(token);
            Admin admin = conn.getAdmin();
            HTableDescriptor tableDescriptor = new HTableDescriptor(new HTableDescriptor(TableName.valueOf((String)"testtable")));
            tableDescriptor.addFamily(new HColumnDescriptor("family"));
            admin.createTable(tableDescriptor);
            this.testPutGetWithDelegationToken(RpcClientImpl.class);
            this.testPutGetWithDelegationToken(AsyncRpcClient.class);
        }
    }
}

