/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.token;

import com.google.protobuf.BlockingRpcChannel;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.ipc.AsyncRpcClient;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.ipc.RpcClient;
import org.apache.hadoop.hbase.ipc.RpcClientImpl;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.AuthenticationProtos;
import org.apache.hadoop.hbase.security.AccessDeniedException;
import org.apache.hadoop.hbase.security.token.SecureTestCluster;
import org.apache.hadoop.hbase.security.token.TokenUtil;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.SecurityTests;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SecurityTests.class, MediumTests.class})
public class TestGenerateDelegationToken
extends SecureTestCluster {
    private void testTokenAuth(Class<? extends RpcClient> rpcImplClass) throws IOException, ServiceException {
        TEST_UTIL.getConfiguration().set("hbase.rpc.client.impl", rpcImplClass.getName());
        try (Connection conn = ConnectionFactory.createConnection((Configuration)TEST_UTIL.getConfiguration());
             Table table = conn.getTable(TableName.META_TABLE_NAME);){
            CoprocessorRpcChannel rpcChannel = table.coprocessorService(HConstants.EMPTY_START_ROW);
            AuthenticationProtos.AuthenticationService.BlockingInterface service = AuthenticationProtos.AuthenticationService.newBlockingStub((BlockingRpcChannel)rpcChannel);
            AuthenticationProtos.WhoAmIResponse response = service.whoAmI(null, AuthenticationProtos.WhoAmIRequest.getDefaultInstance());
            Assert.assertEquals((Object)USERNAME, (Object)response.getUsername());
            Assert.assertEquals((Object)UserGroupInformation.AuthenticationMethod.TOKEN.name(), (Object)response.getAuthMethod());
            try {
                service.getAuthenticationToken(null, AuthenticationProtos.GetAuthenticationTokenRequest.getDefaultInstance());
            }
            catch (ServiceException e) {
                AccessDeniedException exc = (AccessDeniedException)((Object)ProtobufUtil.getRemoteException((ServiceException)e));
                Assert.assertTrue((boolean)exc.getMessage().contains("Token generation only allowed for Kerberos authenticated clients"));
            }
        }
    }

    @Test
    public void test() throws Exception {
        try (Connection conn = ConnectionFactory.createConnection((Configuration)TEST_UTIL.getConfiguration());){
            Token token = TokenUtil.obtainToken((Connection)conn);
            UserGroupInformation.getCurrentUser().addToken(token);
            this.testTokenAuth(RpcClientImpl.class);
            this.testTokenAuth(AsyncRpcClient.class);
        }
    }
}

