/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql;

import java.util.HashSet;
import junit.framework.Assert;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.junit.Test;

public class TestErrorMsg {
    @Test
    public void testUniqueErrorCode() {
        HashSet<Integer> numbers = new HashSet<Integer>();
        for (ErrorMsg err : ErrorMsg.values()) {
            int code = err.getErrorCode();
            Assert.assertTrue((String)("duplicated error number " + code), (boolean)numbers.add(code));
        }
    }

    @Test
    public void testReverseMatch() {
        this.testReverseMatch(ErrorMsg.OP_NOT_ALLOWED_IN_AUTOCOMMIT, "COMMIT");
        this.testReverseMatch(ErrorMsg.OP_NOT_ALLOWED_IN_TXN, "ALTER TABLE", "1");
        this.testReverseMatch(ErrorMsg.OP_NOT_ALLOWED_WITHOUT_TXN, "ROLLBACK");
    }

    private void testReverseMatch(ErrorMsg errorMsg, String ... args) {
        String parametrizedMsg = errorMsg.format(args);
        ErrorMsg canonicalMsg = ErrorMsg.getErrorMsg((String)parametrizedMsg);
        Assert.assertEquals((String)"Didn't find expected msg", (int)errorMsg.getErrorCode(), (int)canonicalMsg.getErrorCode());
    }
}

