/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HouseKeeperService;
import org.apache.hadoop.hive.metastore.api.CompactionRequest;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.ShowCompactRequest;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponse;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponseElement;
import org.apache.hadoop.hive.metastore.txn.CompactionTxnHandler;
import org.apache.hadoop.hive.metastore.txn.TxnDbUtil;
import org.apache.hadoop.hive.metastore.txn.TxnHandler;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.txn.AcidCompactionHistoryService;
import org.apache.hadoop.hive.ql.txn.compactor.Cleaner;
import org.apache.hadoop.hive.ql.txn.compactor.Initiator;
import org.apache.hadoop.hive.ql.txn.compactor.Worker;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class TestTxnCommands2 {
    private static final String TEST_DATA_DIR = new File(System.getProperty("java.io.tmpdir") + File.separator + TestTxnCommands2.class.getCanonicalName() + "-" + System.currentTimeMillis()).getPath().replaceAll("\\\\", "/");
    private static final String TEST_WAREHOUSE_DIR = TEST_DATA_DIR + "/warehouse";
    private static int BUCKET_COUNT = 2;
    @Rule
    public TestName testName = new TestName();
    private HiveConf hiveConf;
    private Driver d;

    @Before
    public void setUp() throws Exception {
        this.tearDown();
        this.hiveConf = new HiveConf(this.getClass());
        this.hiveConf.set(HiveConf.ConfVars.PREEXECHOOKS.varname, "");
        this.hiveConf.set(HiveConf.ConfVars.POSTEXECHOOKS.varname, "");
        this.hiveConf.set(HiveConf.ConfVars.HIVE_SUPPORT_CONCURRENCY.varname, "false");
        this.hiveConf.set(HiveConf.ConfVars.METASTOREWAREHOUSE.varname, TEST_WAREHOUSE_DIR);
        this.hiveConf.setVar(HiveConf.ConfVars.HIVEMAPREDMODE, "nonstrict");
        TxnDbUtil.setConfValues((HiveConf)this.hiveConf);
        TxnDbUtil.prepDb();
        File f = new File(TEST_WAREHOUSE_DIR);
        if (f.exists()) {
            FileUtil.fullyDelete((File)f);
        }
        if (!new File(TEST_WAREHOUSE_DIR).mkdirs()) {
            throw new RuntimeException("Could not create " + TEST_WAREHOUSE_DIR);
        }
        SessionState.start((SessionState)new SessionState(this.hiveConf));
        this.d = new Driver(this.hiveConf);
        this.dropTables();
        this.runStatementOnDriver("create table " + (Object)((Object)Table.ACIDTBL) + "(a int, b int) clustered by (a) into " + BUCKET_COUNT + " buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.runStatementOnDriver("create table " + (Object)((Object)Table.ACIDTBLPART) + "(a int, b int) partitioned by (p string) clustered by (a) into " + BUCKET_COUNT + " buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.runStatementOnDriver("create table " + (Object)((Object)Table.NONACIDORCTBL) + "(a int, b int) clustered by (a) into " + BUCKET_COUNT + " buckets stored as orc TBLPROPERTIES ('transactional'='false')");
        this.runStatementOnDriver("create table " + (Object)((Object)Table.NONACIDPART) + "(a int, b int) partitioned by (p string) stored as orc TBLPROPERTIES ('transactional'='false')");
    }

    private void dropTables() throws Exception {
        for (Table t : Table.values()) {
            this.runStatementOnDriver("drop table if exists " + (Object)((Object)t));
        }
    }

    @After
    public void tearDown() throws Exception {
        try {
            if (this.d != null) {
                this.dropTables();
                this.d.destroy();
                this.d.close();
                this.d = null;
            }
            TxnDbUtil.cleanDb();
        }
        finally {
            FileUtils.deleteDirectory((File)new File(TEST_DATA_DIR));
        }
    }

    @Test
    public void testOrcPPD() throws Exception {
        this.testOrcPPD(true);
    }

    @Test
    public void testOrcNoPPD() throws Exception {
        this.testOrcPPD(false);
    }

    private void testOrcPPD(boolean enablePPD) throws Exception {
        List<String> explain;
        boolean originalPpd = this.hiveConf.getBoolVar(HiveConf.ConfVars.HIVEOPTINDEXFILTER);
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVEOPTINDEXFILTER, enablePPD);
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBL) + "(a,b) " + this.makeValuesClause(new int[][]{{1, 2}, {3, 4}}));
        String query = "update " + (Object)((Object)Table.ACIDTBL) + " set b = 5 where a = 3";
        if (enablePPD) {
            explain = this.runStatementOnDriver("explain " + query);
            TestTxnCommands2.assertPredicateIsPushed("filterExpr: (a = 3)", explain);
        }
        this.runStatementOnDriver(query);
        query = "select a,b from " + (Object)((Object)Table.ACIDTBL) + " where b = 4 order by a,b";
        if (enablePPD) {
            explain = this.runStatementOnDriver("explain " + query);
            TestTxnCommands2.assertPredicateIsPushed("filterExpr: (b = 4)", explain);
        }
        List<String> rs0 = this.runStatementOnDriver(query);
        Assert.assertEquals((String)"Read failed", (long)0L, (long)rs0.size());
        this.runStatementOnDriver("alter table " + (Object)((Object)Table.ACIDTBL) + " compact 'MAJOR'");
        Worker t = new Worker();
        t.setThreadId((int)t.getId());
        t.setHiveConf(this.hiveConf);
        AtomicBoolean stop = new AtomicBoolean();
        AtomicBoolean looped = new AtomicBoolean();
        stop.set(true);
        t.init(stop, looped);
        t.run();
        int[][] tableData2 = new int[][]{{1, 7}, {5, 6}, {7, 8}, {9, 10}};
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBL) + "(a,b) " + this.makeValuesClause(tableData2));
        if (enablePPD) {
            explain = this.runStatementOnDriver("explain delete from " + (Object)((Object)Table.ACIDTBL) + " where a=7 and b=8");
            TestTxnCommands2.assertPredicateIsPushed("filterExpr: ((a = 7) and (b = 8))", explain);
        }
        this.runStatementOnDriver("delete from " + (Object)((Object)Table.ACIDTBL) + " where a=7 and b=8");
        query = "select a,b from " + (Object)((Object)Table.ACIDTBL) + " where a > 1 order by a,b";
        if (enablePPD) {
            explain = this.runStatementOnDriver("explain " + query);
            TestTxnCommands2.assertPredicateIsPushed("filterExpr: (a > 1)", explain);
        }
        List<String> rs1 = this.runStatementOnDriver(query);
        int[][] resultData = new int[][]{{3, 5}, {5, 6}, {9, 10}};
        Assert.assertEquals((String)"Update failed", this.stringifyValues(resultData), rs1);
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVEOPTINDEXFILTER, originalPpd);
    }

    private static void assertPredicateIsPushed(String ppd, List<String> queryPlan) {
        for (String line : queryPlan) {
            if (line == null || !line.contains(ppd)) continue;
            return;
        }
        Assert.assertFalse((String)("PPD '" + ppd + "' wasn't pushed"), (boolean)true);
    }

    @Ignore(value="alter table")
    @Test
    public void testAlterTable() throws Exception {
        int[][] tableData = new int[][]{{1, 2}};
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBL) + "(a,b) " + this.makeValuesClause(tableData));
        this.runStatementOnDriver("alter table " + (Object)((Object)Table.ACIDTBL) + " compact 'MAJOR'");
        Worker t = new Worker();
        t.setThreadId((int)t.getId());
        t.setHiveConf(this.hiveConf);
        AtomicBoolean stop = new AtomicBoolean();
        AtomicBoolean looped = new AtomicBoolean();
        stop.set(true);
        t.init(stop, looped);
        t.run();
        int[][] tableData2 = new int[][]{{5, 6}};
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBL) + "(a,b) " + this.makeValuesClause(tableData2));
        List<String> rs1 = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " where b > 0 order by a,b");
        this.runStatementOnDriver("alter table " + (Object)((Object)Table.ACIDTBL) + " add columns(c int)");
        int[][] moreTableData = new int[][]{{7, 8, 9}};
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBL) + "(a,b,c) " + this.makeValuesClause(moreTableData));
        List<String> rs0 = this.runStatementOnDriver("select a,b,c from " + (Object)((Object)Table.ACIDTBL) + " where a > 0 order by a,b,c");
    }

    @Ignore(value="not needed but useful for testing")
    @Test
    public void testNonAcidInsert() throws Exception {
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.NONACIDORCTBL) + "(a,b) values(1,2)");
        List<String> rs = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.NONACIDORCTBL));
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.NONACIDORCTBL) + "(a,b) values(2,3)");
        List<String> rs1 = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.NONACIDORCTBL));
    }

    @Test
    public void testNonAcidToAcidConversionAndMajorCompaction() throws Exception {
        FileSystem fs = FileSystem.get((Configuration)this.hiveConf);
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.NONACIDORCTBL) + "(a,b) values(1,2)");
        FileStatus[] status = fs.listStatus(new Path(TEST_WAREHOUSE_DIR + "/" + Table.NONACIDORCTBL.toString().toLowerCase()), FileUtils.STAGING_DIR_PATH_FILTER);
        Assert.assertEquals((long)BUCKET_COUNT, (long)status.length);
        for (int i = 0; i < status.length; ++i) {
            Assert.assertTrue((boolean)status[i].getPath().getName().matches("00000[01]_0"));
        }
        List<String> rs = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.NONACIDORCTBL));
        int[][] resultData = new int[][]{{1, 2}};
        Assert.assertEquals(this.stringifyValues(resultData), rs);
        rs = this.runStatementOnDriver("select count(*) from " + (Object)((Object)Table.NONACIDORCTBL));
        int resultCount = 1;
        Assert.assertEquals((long)resultCount, (long)Integer.parseInt(rs.get(0)));
        this.runStatementOnDriver("alter table " + (Object)((Object)Table.NONACIDORCTBL) + " SET TBLPROPERTIES ('transactional'='true')");
        status = fs.listStatus(new Path(TEST_WAREHOUSE_DIR + "/" + Table.NONACIDORCTBL.toString().toLowerCase()), FileUtils.STAGING_DIR_PATH_FILTER);
        Assert.assertEquals((long)BUCKET_COUNT, (long)status.length);
        for (int i = 0; i < status.length; ++i) {
            Assert.assertTrue((boolean)status[i].getPath().getName().matches("00000[01]_0"));
        }
        rs = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.NONACIDORCTBL));
        resultData = new int[][]{{1, 2}};
        Assert.assertEquals(this.stringifyValues(resultData), rs);
        rs = this.runStatementOnDriver("select count(*) from " + (Object)((Object)Table.NONACIDORCTBL));
        resultCount = 1;
        Assert.assertEquals((long)resultCount, (long)Integer.parseInt(rs.get(0)));
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.NONACIDORCTBL) + "(a,b) values(3,4)");
        status = fs.listStatus(new Path(TEST_WAREHOUSE_DIR + "/" + Table.NONACIDORCTBL.toString().toLowerCase()), FileUtils.STAGING_DIR_PATH_FILTER);
        Assert.assertEquals((long)3L, (long)status.length);
        boolean sawNewDelta = false;
        for (int i = 0; i < status.length; ++i) {
            if (status[i].getPath().getName().matches("delta_.*")) {
                sawNewDelta = true;
                FileStatus[] buckets = fs.listStatus(status[i].getPath(), FileUtils.STAGING_DIR_PATH_FILTER);
                Assert.assertEquals((long)BUCKET_COUNT, (long)buckets.length);
                Assert.assertTrue((boolean)buckets[0].getPath().getName().matches("bucket_0000[01]"));
                Assert.assertTrue((boolean)buckets[1].getPath().getName().matches("bucket_0000[01]"));
                continue;
            }
            Assert.assertTrue((boolean)status[i].getPath().getName().matches("00000[01]_0"));
        }
        Assert.assertTrue((boolean)sawNewDelta);
        rs = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.NONACIDORCTBL));
        resultData = new int[][]{{1, 2}, {3, 4}};
        Assert.assertEquals(this.stringifyValues(resultData), rs);
        rs = this.runStatementOnDriver("select count(*) from " + (Object)((Object)Table.NONACIDORCTBL));
        resultCount = 2;
        Assert.assertEquals((long)resultCount, (long)Integer.parseInt(rs.get(0)));
        this.runStatementOnDriver("alter table " + (Object)((Object)Table.NONACIDORCTBL) + " compact 'MAJOR'");
        Worker w = new Worker();
        w.setThreadId((int)w.getId());
        w.setHiveConf(this.hiveConf);
        AtomicBoolean stop = new AtomicBoolean();
        AtomicBoolean looped = new AtomicBoolean();
        stop.set(true);
        w.init(stop, looped);
        w.run();
        status = fs.listStatus(new Path(TEST_WAREHOUSE_DIR + "/" + Table.NONACIDORCTBL.toString().toLowerCase()), FileUtils.STAGING_DIR_PATH_FILTER);
        Assert.assertEquals((long)4L, (long)status.length);
        boolean sawNewBase = false;
        for (int i = 0; i < status.length; ++i) {
            if (!status[i].getPath().getName().matches("base_.*")) continue;
            sawNewBase = true;
            FileStatus[] buckets = fs.listStatus(status[i].getPath(), FileUtils.STAGING_DIR_PATH_FILTER);
            Assert.assertEquals((long)BUCKET_COUNT, (long)buckets.length);
            Assert.assertTrue((boolean)buckets[0].getPath().getName().matches("bucket_0000[01]"));
            Assert.assertTrue((boolean)buckets[1].getPath().getName().matches("bucket_0000[01]"));
        }
        Assert.assertTrue((boolean)sawNewBase);
        rs = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.NONACIDORCTBL));
        resultData = new int[][]{{1, 2}, {3, 4}};
        Assert.assertEquals(this.stringifyValues(resultData), rs);
        rs = this.runStatementOnDriver("select count(*) from " + (Object)((Object)Table.NONACIDORCTBL));
        resultCount = 2;
        Assert.assertEquals((long)resultCount, (long)Integer.parseInt(rs.get(0)));
        String fakeFile0 = TEST_WAREHOUSE_DIR + "/" + Table.NONACIDORCTBL.toString().toLowerCase() + "/subdir/000000_0";
        String fakeFile1 = TEST_WAREHOUSE_DIR + "/" + Table.NONACIDORCTBL.toString().toLowerCase() + "/subdir/000000_1";
        fs.create(new Path(fakeFile0));
        fs.create(new Path(fakeFile1));
        status = fs.listStatus(new Path(TEST_WAREHOUSE_DIR + "/" + Table.NONACIDORCTBL.toString().toLowerCase()), FileUtils.STAGING_DIR_PATH_FILTER);
        Assert.assertEquals((long)5L, (long)status.length);
        Cleaner c = new Cleaner();
        c.setThreadId((int)c.getId());
        c.setHiveConf(this.hiveConf);
        stop = new AtomicBoolean();
        looped = new AtomicBoolean();
        stop.set(true);
        c.init(stop, looped);
        c.run();
        status = fs.listStatus(new Path(TEST_WAREHOUSE_DIR + "/" + Table.NONACIDORCTBL.toString().toLowerCase()), FileUtils.STAGING_DIR_PATH_FILTER);
        Assert.assertEquals((long)1L, (long)status.length);
        Assert.assertTrue((boolean)status[0].getPath().getName().matches("base_.*"));
        FileStatus[] buckets = fs.listStatus(status[0].getPath(), FileUtils.STAGING_DIR_PATH_FILTER);
        Assert.assertEquals((long)BUCKET_COUNT, (long)buckets.length);
        Assert.assertTrue((boolean)buckets[0].getPath().getName().matches("bucket_0000[01]"));
        Assert.assertTrue((boolean)buckets[1].getPath().getName().matches("bucket_0000[01]"));
        rs = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.NONACIDORCTBL));
        resultData = new int[][]{{1, 2}, {3, 4}};
        Assert.assertEquals(this.stringifyValues(resultData), rs);
        rs = this.runStatementOnDriver("select count(*) from " + (Object)((Object)Table.NONACIDORCTBL));
        resultCount = 2;
        Assert.assertEquals((long)resultCount, (long)Integer.parseInt(rs.get(0)));
    }

    @Test
    public void testUpdateMixedCase() throws Exception {
        int[][] tableData = new int[][]{{1, 2}, {3, 3}, {5, 3}};
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBL) + "(a,b) " + this.makeValuesClause(tableData));
        this.runStatementOnDriver("update " + (Object)((Object)Table.ACIDTBL) + " set B = 7 where A=1");
        List<String> rs = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        int[][] updatedData = new int[][]{{1, 7}, {3, 3}, {5, 3}};
        Assert.assertEquals((String)"Update failed", this.stringifyValues(updatedData), rs);
        this.runStatementOnDriver("update " + (Object)((Object)Table.ACIDTBL) + " set B = B + 1 where A=1");
        List<String> rs2 = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        int[][] updatedData2 = new int[][]{{1, 8}, {3, 3}, {5, 3}};
        Assert.assertEquals((String)"Update failed", this.stringifyValues(updatedData2), rs2);
    }

    @Test
    public void testDeleteIn() throws Exception {
        int[][] tableData = new int[][]{{1, 2}, {3, 2}, {5, 2}, {1, 3}, {3, 3}, {5, 3}};
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBL) + "(a,b) " + this.makeValuesClause(tableData));
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.NONACIDORCTBL) + "(a,b) values(1,7),(3,7)");
        this.runStatementOnDriver("delete from " + (Object)((Object)Table.ACIDTBL) + " where a in(select a from " + (Object)((Object)Table.NONACIDORCTBL) + ")");
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBL) + "(a,b) select a,b from " + (Object)((Object)Table.NONACIDORCTBL));
        List<String> rs = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        int[][] updatedData = new int[][]{{1, 7}, {3, 7}, {5, 2}, {5, 3}};
        Assert.assertEquals((String)"Bulk update failed", this.stringifyValues(updatedData), rs);
        this.runStatementOnDriver("update " + (Object)((Object)Table.ACIDTBL) + " set b=19 where b in(select b from " + (Object)((Object)Table.NONACIDORCTBL) + " where a = 3)");
        List<String> rs2 = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        int[][] updatedData2 = new int[][]{{1, 19}, {3, 19}, {5, 2}, {5, 3}};
        Assert.assertEquals((String)"Bulk update2 failed", this.stringifyValues(updatedData2), rs2);
    }

    @Test
    public void testBucketizedInputFormat() throws Exception {
        int[][] tableData = new int[][]{{1, 2}};
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBLPART) + " partition(p=1) (a,b) " + this.makeValuesClause(tableData));
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBL) + "(a,b) select a,b from " + (Object)((Object)Table.ACIDTBLPART) + " where p = 1");
        List<String> rs = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL));
        Assert.assertEquals((String)("Insert into " + (Object)((Object)Table.ACIDTBL) + " didn't match:"), this.stringifyValues(tableData), rs);
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.NONACIDORCTBL) + "(a,b) select a,b from " + (Object)((Object)Table.ACIDTBLPART) + " where p = 1");
        List<String> rs2 = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.NONACIDORCTBL));
        Assert.assertEquals((String)("Insert into " + (Object)((Object)Table.NONACIDORCTBL) + " didn't match:"), this.stringifyValues(tableData), rs2);
    }

    @Test
    public void testInsertOverwriteWithSelfJoin() throws Exception {
        int[][] part1Data = new int[][]{{1, 7}};
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.NONACIDORCTBL) + "(a,b) " + this.makeValuesClause(part1Data));
        this.runStatementOnDriver("insert overwrite table " + (Object)((Object)Table.NONACIDORCTBL) + " select 2, 9 from " + (Object)((Object)Table.NONACIDORCTBL) + " T inner join " + (Object)((Object)Table.NONACIDORCTBL) + " S on T.a=S.a");
        List<String> rs = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.NONACIDORCTBL) + " order by a,b");
        int[][] joinData = new int[][]{{2, 9}};
        Assert.assertEquals((String)"Self join non-part insert overwrite failed", this.stringifyValues(joinData), rs);
        int[][] part2Data = new int[][]{{1, 8}};
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.NONACIDPART) + " partition(p=1) (a,b) " + this.makeValuesClause(part1Data));
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.NONACIDPART) + " partition(p=2) (a,b) " + this.makeValuesClause(part2Data));
        this.runStatementOnDriver("insert overwrite table " + (Object)((Object)Table.NONACIDPART) + " partition(p=1) select a,b from " + (Object)((Object)Table.NONACIDPART));
        List<String> rs2 = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.NONACIDPART) + " order by a,b");
        int[][] updatedData = new int[][]{{1, 7}, {1, 8}, {1, 8}};
        Assert.assertEquals((String)"Insert overwrite partition failed", this.stringifyValues(updatedData), rs2);
    }

    @Test
    public void testInitiatorWithMultipleFailedCompactions() throws Exception {
        String tblName = "hive12353";
        this.runStatementOnDriver("drop table if exists " + tblName);
        this.runStatementOnDriver("CREATE TABLE " + tblName + "(a INT, b STRING) " + " CLUSTERED BY(a) INTO 1 BUCKETS" + " STORED AS ORC  TBLPROPERTIES ('transactional'='true')");
        this.hiveConf.setIntVar(HiveConf.ConfVars.HIVE_COMPACTOR_DELTA_NUM_THRESHOLD, 4);
        for (int i = 0; i < 5; ++i) {
            this.runStatementOnDriver("insert into " + tblName + " values(" + (i + 1) + ", 'foo'),(" + (i + 2) + ", 'bar'),(" + (i + 3) + ", 'baz')");
        }
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVETESTMODEFAILCOMPACTION, true);
        int numFailedCompactions = this.hiveConf.getIntVar(HiveConf.ConfVars.COMPACTOR_INITIATOR_FAILED_THRESHOLD);
        CompactionTxnHandler txnHandler = new CompactionTxnHandler(this.hiveConf);
        AtomicBoolean stop = new AtomicBoolean(true);
        for (int i = 0; i < numFailedCompactions; ++i) {
            txnHandler.compact(new CompactionRequest("default", tblName, CompactionType.MINOR));
            TestTxnCommands2.runWorker(this.hiveConf);
        }
        Initiator init = new Initiator();
        init.setThreadId((int)init.getId());
        init.setHiveConf(this.hiveConf);
        init.init(stop, new AtomicBoolean());
        init.run();
        CompactionsByState cbs = TestTxnCommands2.countCompacts((TxnHandler)txnHandler);
        Assert.assertEquals((String)"Unexpected number of failed compactions", (long)numFailedCompactions, (long)cbs.failed);
        Assert.assertEquals((String)"Unexpected total number of compactions", (long)numFailedCompactions, (long)cbs.total);
        this.hiveConf.setTimeVar(HiveConf.ConfVars.COMPACTOR_HISTORY_REAPER_INTERVAL, 10L, TimeUnit.MILLISECONDS);
        AcidCompactionHistoryService compactionHistoryService = new AcidCompactionHistoryService();
        TestTxnCommands2.runHouseKeeperService((HouseKeeperService)compactionHistoryService, this.hiveConf);
        cbs = TestTxnCommands2.countCompacts((TxnHandler)txnHandler);
        Assert.assertEquals((String)"Number of failed compactions after History clean", (long)numFailedCompactions, (long)cbs.failed);
        Assert.assertEquals((String)"Total number of compactions after History clean", (long)numFailedCompactions, (long)cbs.total);
        txnHandler.compact(new CompactionRequest("default", tblName, CompactionType.MAJOR));
        TestTxnCommands2.runWorker(this.hiveConf);
        txnHandler.compact(new CompactionRequest("default", tblName, CompactionType.MINOR));
        TestTxnCommands2.runWorker(this.hiveConf);
        cbs = TestTxnCommands2.countCompacts((TxnHandler)txnHandler);
        Assert.assertEquals((String)"Unexpected num failed1", (long)(numFailedCompactions + 2), (long)cbs.failed);
        Assert.assertEquals((String)"Unexpected num total1", (long)(numFailedCompactions + 2), (long)cbs.total);
        TestTxnCommands2.runHouseKeeperService((HouseKeeperService)compactionHistoryService, this.hiveConf);
        cbs = TestTxnCommands2.countCompacts((TxnHandler)txnHandler);
        Assert.assertEquals((String)"Unexpected num failed2", (long)this.hiveConf.getIntVar(HiveConf.ConfVars.COMPACTOR_HISTORY_RETENTION_FAILED), (long)cbs.failed);
        Assert.assertEquals((String)"Unexpected num total2", (long)this.hiveConf.getIntVar(HiveConf.ConfVars.COMPACTOR_HISTORY_RETENTION_FAILED), (long)cbs.total);
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVETESTMODEFAILCOMPACTION, false);
        txnHandler.compact(new CompactionRequest("default", tblName, CompactionType.MINOR));
        cbs = TestTxnCommands2.countCompacts((TxnHandler)txnHandler);
        Assert.assertEquals((String)"Unexpected num failed3", (long)this.hiveConf.getIntVar(HiveConf.ConfVars.COMPACTOR_HISTORY_RETENTION_FAILED), (long)cbs.failed);
        Assert.assertEquals((String)"Unexpected num initiated", (long)1L, (long)cbs.initiated);
        Assert.assertEquals((String)"Unexpected num total3", (long)(this.hiveConf.getIntVar(HiveConf.ConfVars.COMPACTOR_HISTORY_RETENTION_FAILED) + 1), (long)cbs.total);
        TestTxnCommands2.runWorker(this.hiveConf);
        cbs = TestTxnCommands2.countCompacts((TxnHandler)txnHandler);
        Assert.assertEquals((String)"Unexpected num failed4", (long)this.hiveConf.getIntVar(HiveConf.ConfVars.COMPACTOR_HISTORY_RETENTION_FAILED), (long)cbs.failed);
        Assert.assertEquals((String)"Unexpected num ready to clean", (long)1L, (long)cbs.readyToClean);
        Assert.assertEquals((String)"Unexpected num total4", (long)(this.hiveConf.getIntVar(HiveConf.ConfVars.COMPACTOR_HISTORY_RETENTION_FAILED) + 1), (long)cbs.total);
        TestTxnCommands2.runCleaner(this.hiveConf);
        TestTxnCommands2.runHouseKeeperService((HouseKeeperService)compactionHistoryService, this.hiveConf);
        cbs = TestTxnCommands2.countCompacts((TxnHandler)txnHandler);
        Assert.assertEquals((String)"Unexpected num failed5", (long)this.hiveConf.getIntVar(HiveConf.ConfVars.COMPACTOR_HISTORY_RETENTION_FAILED), (long)cbs.failed);
        Assert.assertEquals((String)"Unexpected num succeeded", (long)1L, (long)cbs.succeeded);
        Assert.assertEquals((String)"Unexpected num total5", (long)(this.hiveConf.getIntVar(HiveConf.ConfVars.COMPACTOR_HISTORY_RETENTION_FAILED) + 1), (long)cbs.total);
    }

    private static CompactionsByState countCompacts(TxnHandler txnHandler) throws MetaException {
        ShowCompactResponse resp = txnHandler.showCompact(new ShowCompactRequest());
        CompactionsByState compactionsByState = new CompactionsByState();
        compactionsByState.total = resp.getCompactsSize();
        for (ShowCompactResponseElement compact : resp.getCompacts()) {
            if ("failed".equals(compact.getState())) {
                compactionsByState.failed++;
                continue;
            }
            if ("ready for cleaning".equals(compact.getState())) {
                compactionsByState.readyToClean++;
                continue;
            }
            if ("initiated".equals(compact.getState())) {
                compactionsByState.initiated++;
                continue;
            }
            if ("succeeded".equals(compact.getState())) {
                compactionsByState.succeeded++;
                continue;
            }
            if ("working".equals(compact.getState())) {
                compactionsByState.working++;
                continue;
            }
            if (!"attempted".equals(compact.getState())) continue;
            compactionsByState.attempted++;
        }
        return compactionsByState;
    }

    private static void runWorker(HiveConf hiveConf) throws MetaException {
        AtomicBoolean stop = new AtomicBoolean(true);
        Worker t = new Worker();
        t.setThreadId((int)t.getId());
        t.setHiveConf(hiveConf);
        AtomicBoolean looped = new AtomicBoolean();
        t.init(stop, looped);
        t.run();
    }

    private static void runCleaner(HiveConf hiveConf) throws MetaException {
        AtomicBoolean stop = new AtomicBoolean(true);
        Cleaner t = new Cleaner();
        t.setThreadId((int)t.getId());
        t.setHiveConf(hiveConf);
        AtomicBoolean looped = new AtomicBoolean();
        t.init(stop, looped);
        t.run();
    }

    private static void runHouseKeeperService(HouseKeeperService houseKeeperService, HiveConf conf) throws Exception {
        int lastCount = houseKeeperService.getIsAliveCounter();
        houseKeeperService.start(conf);
        while (houseKeeperService.getIsAliveCounter() <= lastCount) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        houseKeeperService.stop();
    }

    @Test
    public void writeBetweenWorkerAndCleaner() throws Exception {
        String tblName = "hive12352";
        this.runStatementOnDriver("drop table if exists " + tblName);
        this.runStatementOnDriver("CREATE TABLE " + tblName + "(a INT, b STRING) " + " CLUSTERED BY(a) INTO 1 BUCKETS" + " STORED AS ORC  TBLPROPERTIES ('transactional'='true')");
        this.runStatementOnDriver("insert into " + tblName + " values(1, 'foo'),(2, 'bar'),(3, 'baz')");
        this.runStatementOnDriver("update " + tblName + " set b = 'blah' where a = 3");
        CompactionTxnHandler txnHandler = new CompactionTxnHandler(this.hiveConf);
        txnHandler.compact(new CompactionRequest("default", tblName, CompactionType.MINOR));
        Worker t = new Worker();
        t.setThreadId((int)t.getId());
        t.setHiveConf(this.hiveConf);
        AtomicBoolean stop = new AtomicBoolean(true);
        AtomicBoolean looped = new AtomicBoolean();
        t.init(stop, looped);
        t.run();
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVETESTMODEROLLBACKTXN, true);
        this.runStatementOnDriver("delete from " + tblName + " where a = 1");
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVETESTMODEROLLBACKTXN, false);
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("1\tfoo");
        expected.add("2\tbar");
        expected.add("3\tblah");
        Assert.assertEquals((String)"", expected, this.runStatementOnDriver("select a,b from " + tblName + " order by a"));
        Cleaner c = new Cleaner();
        c.setThreadId((int)c.getId());
        c.setHiveConf(this.hiveConf);
        c.init(stop, new AtomicBoolean());
        c.run();
        Initiator i = new Initiator();
        i.setThreadId((int)i.getId());
        i.setHiveConf(this.hiveConf);
        i.init(stop, new AtomicBoolean());
        i.run();
        Assert.assertEquals((String)"", expected, this.runStatementOnDriver("select a,b from " + tblName + " order by a"));
    }

    private List<String> stringifyValues(int[][] rowsIn) {
        assert (rowsIn.length > 0);
        int[][] rows = (int[][])rowsIn.clone();
        Arrays.sort(rows, new RowComp());
        ArrayList<String> rs = new ArrayList<String>();
        for (int[] row : rows) {
            assert (row.length > 0);
            StringBuilder sb = new StringBuilder();
            for (int value : row) {
                sb.append(value).append("\t");
            }
            sb.setLength(sb.length() - 1);
            rs.add(sb.toString());
        }
        return rs;
    }

    private String makeValuesClause(int[][] rows) {
        assert (rows.length > 0);
        StringBuilder sb = new StringBuilder("values");
        for (int[] row : rows) {
            assert (row.length > 0);
            if (row.length > 1) {
                sb.append("(");
            }
            for (int value : row) {
                sb.append(value).append(",");
            }
            sb.setLength(sb.length() - 1);
            if (row.length > 1) {
                sb.append(")");
            }
            sb.append(",");
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    private List<String> runStatementOnDriver(String stmt) throws Exception {
        CommandProcessorResponse cpr = this.d.run(stmt);
        if (cpr.getResponseCode() != 0) {
            throw new RuntimeException(stmt + " failed: " + cpr);
        }
        ArrayList<String> rs = new ArrayList<String>();
        this.d.getResults(rs);
        return rs;
    }

    private static final class RowComp
    implements Comparator<int[]> {
        private RowComp() {
        }

        @Override
        public int compare(int[] row1, int[] row2) {
            assert (row1 != null && row2 != null && row1.length == row2.length);
            for (int i = 0; i < row1.length; ++i) {
                int comp = Integer.compare(row1[i], row2[i]);
                if (comp == 0) continue;
                return comp;
            }
            return 0;
        }
    }

    private static class CompactionsByState {
        private int attempted;
        private int failed;
        private int initiated;
        private int readyToClean;
        private int succeeded;
        private int working;
        private int total;

        private CompactionsByState() {
        }
    }

    private static enum Table {
        ACIDTBL("acidTbl"),
        ACIDTBLPART("acidTblPart"),
        NONACIDORCTBL("nonAcidOrcTbl"),
        NONACIDPART("nonAcidPart");

        private final String name;

        public String toString() {
            return this.name;
        }

        private Table(String name) {
            this.name = name;
        }
    }
}

