/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import java.io.IOException;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Properties;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.HiveIntervalDayTime;
import org.apache.hadoop.hive.common.type.HiveIntervalYearMonth;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.RandomRowObjectSource;
import org.apache.hadoop.hive.ql.exec.vector.VectorAssignRowSameBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorDeserializeRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorExtractRowSameBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorSerializeRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatchCtx;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.binarysortable.fast.BinarySortableDeserializeRead;
import org.apache.hadoop.hive.serde2.binarysortable.fast.BinarySortableSerializeWrite;
import org.apache.hadoop.hive.serde2.fast.DeserializeRead;
import org.apache.hadoop.hive.serde2.fast.SerializeWrite;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveCharWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.HiveIntervalDayTimeWritable;
import org.apache.hadoop.hive.serde2.io.HiveIntervalYearMonthWritable;
import org.apache.hadoop.hive.serde2.io.HiveVarcharWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.lazy.LazySerDeParameters;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.serde2.lazy.fast.LazySimpleDeserializeRead;
import org.apache.hadoop.hive.serde2.lazy.fast.LazySimpleSerializeWrite;
import org.apache.hadoop.hive.serde2.lazybinary.fast.LazyBinaryDeserializeRead;
import org.apache.hadoop.hive.serde2.lazybinary.fast.LazyBinarySerializeWrite;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;

public class TestVectorSerDeRow
extends TestCase {
    void deserializeAndVerify(ByteStream.Output output, DeserializeRead deserializeRead, RandomRowObjectSource source, Object[] expectedRow) throws HiveException, IOException {
        deserializeRead.set(output.getData(), 0, output.getLength());
        PrimitiveObjectInspector.PrimitiveCategory[] primitiveCategories = source.primitiveCategories();
        block18: for (int i = 0; i < primitiveCategories.length; ++i) {
            Object expected = expectedRow[i];
            PrimitiveObjectInspector.PrimitiveCategory primitiveCategory = primitiveCategories[i];
            PrimitiveTypeInfo primitiveTypeInfo = source.primitiveTypeInfos()[i];
            if (deserializeRead.readCheckNull()) {
                throw new HiveException("Unexpected NULL");
            }
            switch (primitiveCategory) {
                case BOOLEAN: {
                    Comparable<Boolean> value = deserializeRead.readBoolean();
                    BooleanWritable expectedWritable = (BooleanWritable)expected;
                    if (((Boolean)value).equals(expectedWritable.get())) continue block18;
                    TestCase.fail((String)("Boolean field mismatch (expected " + expected + " found " + value + ")"));
                    continue block18;
                }
                case BYTE: {
                    Comparable<Boolean> value = deserializeRead.readByte();
                    BooleanWritable expectedWritable = (ByteWritable)expected;
                    if (((Byte)value).equals(expectedWritable.get())) continue block18;
                    TestCase.fail((String)("Byte field mismatch (expected " + (Integer)expected + " found " + (Byte)value + ")"));
                    continue block18;
                }
                case SHORT: {
                    Comparable<Boolean> value = deserializeRead.readShort();
                    BooleanWritable expectedWritable = (ShortWritable)expected;
                    if (((Short)value).equals(expectedWritable.get())) continue block18;
                    TestCase.fail((String)("Short field mismatch (expected " + expected + " found " + value + ")"));
                    continue block18;
                }
                case INT: {
                    Comparable<Boolean> value = deserializeRead.readInt();
                    BooleanWritable expectedWritable = (IntWritable)expected;
                    if (((Integer)value).equals(expectedWritable.get())) continue block18;
                    TestCase.fail((String)("Int field mismatch (expected " + expected + " found " + value + ")"));
                    continue block18;
                }
                case LONG: {
                    Comparable<Boolean> value = deserializeRead.readLong();
                    BooleanWritable expectedWritable = (LongWritable)expected;
                    if (((Long)value).equals(expectedWritable.get())) continue block18;
                    TestCase.fail((String)("Long field mismatch (expected " + expected + " found " + value + ")"));
                    continue block18;
                }
                case DATE: {
                    DeserializeRead.ReadDateResults readDateResults = deserializeRead.createReadDateResults();
                    deserializeRead.readDate(readDateResults);
                    java.util.Date value = readDateResults.getDate();
                    DateWritable expectedWritable = (DateWritable)expected;
                    if (value.equals(expectedWritable.get())) continue block18;
                    TestCase.fail((String)("Date field mismatch (expected " + expected.toString() + " found " + ((Date)value).toString() + ")"));
                    continue block18;
                }
                case FLOAT: {
                    Comparable<Boolean> value = Float.valueOf(deserializeRead.readFloat());
                    BooleanWritable expectedWritable = (FloatWritable)expected;
                    if (((Float)value).equals(Float.valueOf(expectedWritable.get()))) continue block18;
                    TestCase.fail((String)("Float field mismatch (expected " + expected + " found " + value + ")"));
                    continue block18;
                }
                case DOUBLE: {
                    Comparable<Boolean> value = deserializeRead.readDouble();
                    BooleanWritable expectedWritable = (DoubleWritable)expected;
                    if (((Double)value).equals(expectedWritable.get())) continue block18;
                    TestCase.fail((String)("Double field mismatch (expected " + expected + " found " + value + ")"));
                    continue block18;
                }
                case STRING: {
                    Text expectedWritable;
                    DeserializeRead.ReadStringResults readStringResults = deserializeRead.createReadStringResults();
                    deserializeRead.readString(readStringResults);
                    char[] charsBuffer = new char[readStringResults.bytes.length];
                    for (int c = 0; c < charsBuffer.length; ++c) {
                        charsBuffer[c] = (char)(readStringResults.bytes[c] & 0xFF);
                    }
                    byte[] stringBytes = Arrays.copyOfRange(readStringResults.bytes, readStringResults.start, readStringResults.start + readStringResults.length);
                    char[] charsRange = new char[stringBytes.length];
                    for (int c = 0; c < charsRange.length; ++c) {
                        charsRange[c] = (char)(stringBytes[c] & 0xFF);
                    }
                    Text text = new Text(stringBytes);
                    String value = text.toString();
                    if (value.equals((expectedWritable = (Text)expected).toString())) continue block18;
                    TestCase.fail((String)("String field mismatch (expected '" + expectedWritable.toString() + "' found '" + value + "')"));
                    continue block18;
                }
                case CHAR: {
                    DeserializeRead.ReadHiveCharResults readHiveCharResults = deserializeRead.createReadHiveCharResults();
                    deserializeRead.readHiveChar(readHiveCharResults);
                    HiveChar hiveChar = readHiveCharResults.getHiveChar();
                    DateWritable expectedWritable = (HiveCharWritable)expected;
                    if (hiveChar.equals((Object)expectedWritable.getHiveChar())) continue block18;
                    TestCase.fail((String)("Char field mismatch (expected '" + expectedWritable.getHiveChar() + "' found '" + hiveChar + "')"));
                    continue block18;
                }
                case VARCHAR: {
                    DeserializeRead.ReadHiveVarcharResults readHiveVarcharResults = deserializeRead.createReadHiveVarcharResults();
                    deserializeRead.readHiveVarchar(readHiveVarcharResults);
                    HiveVarchar hiveVarchar = readHiveVarcharResults.getHiveVarchar();
                    DateWritable expectedWritable = (HiveVarcharWritable)expected;
                    if (hiveVarchar.equals(expectedWritable.getHiveVarchar())) continue block18;
                    TestCase.fail((String)("Varchar field mismatch (expected '" + expectedWritable.getHiveVarchar() + "' found '" + hiveVarchar + "')"));
                    continue block18;
                }
                case DECIMAL: {
                    DateWritable expectedWritable;
                    DeserializeRead.ReadDecimalResults readDecimalResults = deserializeRead.createReadDecimalResults();
                    deserializeRead.readHiveDecimal(readDecimalResults);
                    java.util.Date value = readDecimalResults.getHiveDecimal();
                    if (value == null) {
                        TestCase.fail((String)"Decimal field evaluated to NULL");
                    }
                    if (value.equals((expectedWritable = (HiveDecimalWritable)expected).getHiveDecimal())) continue block18;
                    DecimalTypeInfo decimalTypeInfo = (DecimalTypeInfo)primitiveTypeInfo;
                    int precision = decimalTypeInfo.getPrecision();
                    int scale = decimalTypeInfo.getScale();
                    TestCase.fail((String)("Decimal field mismatch (expected " + expectedWritable.getHiveDecimal() + " found " + value.toString() + ") precision " + precision + ", scale " + scale));
                    continue block18;
                }
                case TIMESTAMP: {
                    DeserializeRead.ReadTimestampResults readTimestampResults = deserializeRead.createReadTimestampResults();
                    deserializeRead.readTimestamp(readTimestampResults);
                    java.util.Date value = readTimestampResults.getTimestamp();
                    DateWritable expectedWritable = (TimestampWritable)expected;
                    if (((Timestamp)value).equals(expectedWritable.getTimestamp())) continue block18;
                    TestCase.fail((String)("Timestamp field mismatch (expected " + expectedWritable.getTimestamp() + " found " + ((Timestamp)value).toString() + ")"));
                    continue block18;
                }
                case INTERVAL_YEAR_MONTH: {
                    DeserializeRead.ReadIntervalYearMonthResults readIntervalYearMonthResults = deserializeRead.createReadIntervalYearMonthResults();
                    deserializeRead.readIntervalYearMonth(readIntervalYearMonthResults);
                    java.util.Date value = readIntervalYearMonthResults.getHiveIntervalYearMonth();
                    DateWritable expectedWritable = (HiveIntervalYearMonthWritable)expected;
                    HiveIntervalYearMonth expectedValue = expectedWritable.getHiveIntervalYearMonth();
                    if (value.equals(expectedValue)) continue block18;
                    TestCase.fail((String)("HiveIntervalYearMonth field mismatch (expected " + expectedValue + " found " + value.toString() + ")"));
                    continue block18;
                }
                case INTERVAL_DAY_TIME: {
                    DeserializeRead.ReadIntervalDayTimeResults readIntervalDayTimeResults = deserializeRead.createReadIntervalDayTimeResults();
                    deserializeRead.readIntervalDayTime(readIntervalDayTimeResults);
                    java.util.Date value = readIntervalDayTimeResults.getHiveIntervalDayTime();
                    DateWritable expectedWritable = (HiveIntervalDayTimeWritable)expected;
                    HiveIntervalYearMonth expectedValue = expectedWritable.getHiveIntervalDayTime();
                    if (value.equals(expectedValue)) continue block18;
                    TestCase.fail((String)("HiveIntervalDayTime field mismatch (expected " + expectedValue + " found " + value.toString() + ")"));
                    continue block18;
                }
                case BINARY: {
                    DeserializeRead.ReadBinaryResults readBinaryResults = deserializeRead.createReadBinaryResults();
                    deserializeRead.readBinary(readBinaryResults);
                    byte[] byteArray = Arrays.copyOfRange(readBinaryResults.bytes, readBinaryResults.start, readBinaryResults.start + readBinaryResults.length);
                    DateWritable expectedWritable = (BytesWritable)expected;
                    if (byteArray.length != expectedWritable.getLength()) {
                        TestCase.fail((String)("Byte Array field mismatch (expected " + expected + " found " + byteArray + ")"));
                    }
                    byte[] expectedBytes = expectedWritable.getBytes();
                    for (int b = 0; b < byteArray.length; ++b) {
                        if (byteArray[b] == expectedBytes[b]) continue;
                        TestCase.fail((String)("Byte Array field mismatch (expected " + expected + " found " + byteArray + ")"));
                    }
                    continue block18;
                }
                default: {
                    throw new HiveException("Unexpected primitive category " + primitiveCategory);
                }
            }
        }
        deserializeRead.extraFieldsCheck();
        TestCase.assertTrue((!deserializeRead.readBeyondConfiguredFieldsWarned() ? 1 : 0) != 0);
        TestCase.assertTrue((!deserializeRead.readBeyondBufferRangeWarned() ? 1 : 0) != 0);
        TestCase.assertTrue((!deserializeRead.bufferRangeHasExtraDataWarned() ? 1 : 0) != 0);
    }

    void serializeBatch(VectorizedRowBatch batch, VectorSerializeRow vectorSerializeRow, DeserializeRead deserializeRead, RandomRowObjectSource source, Object[][] randomRows, int firstRandomRowIndex) throws HiveException, IOException {
        ByteStream.Output output = new ByteStream.Output();
        for (int i = 0; i < batch.size; ++i) {
            output.reset();
            vectorSerializeRow.setOutput(output);
            vectorSerializeRow.serializeWrite(batch, i);
            Object[] expectedRow = randomRows[firstRandomRowIndex + i];
            byte[] bytes = output.getData();
            int length = output.getLength();
            char[] chars = new char[length];
            for (int c = 0; c < chars.length; ++c) {
                chars[c] = (char)(bytes[c] & 0xFF);
            }
            this.deserializeAndVerify(output, deserializeRead, source, expectedRow);
        }
    }

    void testVectorSerializeRow(int caseNum, Random r, SerializationType serializationType) throws HiveException, IOException, SerDeException {
        BinarySortableSerializeWrite serializeWrite;
        BinarySortableDeserializeRead deserializeRead;
        String[] emptyScratchTypeNames = new String[]{};
        RandomRowObjectSource source = new RandomRowObjectSource();
        source.init(r);
        VectorizedRowBatchCtx batchContext = new VectorizedRowBatchCtx();
        batchContext.init(source.rowStructObjectInspector(), emptyScratchTypeNames);
        VectorizedRowBatch batch = batchContext.createVectorizedRowBatch();
        VectorAssignRowSameBatch vectorAssignRow = new VectorAssignRowSameBatch();
        vectorAssignRow.init(source.typeNames());
        vectorAssignRow.setOneBatch(batch);
        int fieldCount = source.typeNames().size();
        switch (serializationType) {
            case BINARY_SORTABLE: {
                deserializeRead = new BinarySortableDeserializeRead(source.primitiveTypeInfos());
                serializeWrite = new BinarySortableSerializeWrite(fieldCount);
                break;
            }
            case LAZY_BINARY: {
                deserializeRead = new LazyBinaryDeserializeRead((TypeInfo[])source.primitiveTypeInfos());
                serializeWrite = new LazyBinarySerializeWrite(fieldCount);
                break;
            }
            case LAZY_SIMPLE: {
                StructObjectInspector rowObjectInspector = source.rowStructObjectInspector();
                LazySerDeParameters lazySerDeParams = this.getSerDeParams(rowObjectInspector);
                byte separator = 9;
                deserializeRead = new LazySimpleDeserializeRead((TypeInfo[])source.primitiveTypeInfos(), separator, lazySerDeParams);
                serializeWrite = new LazySimpleSerializeWrite(fieldCount, separator, lazySerDeParams);
                break;
            }
            default: {
                throw new Error("Unknown serialization type " + (Object)((Object)serializationType));
            }
        }
        VectorSerializeRow vectorSerializeRow = new VectorSerializeRow((SerializeWrite)serializeWrite);
        vectorSerializeRow.init(source.typeNames());
        Object[][] randomRows = source.randomRows(100000);
        int firstRandomRowIndex = 0;
        for (int i = 0; i < randomRows.length; ++i) {
            Object[] row = randomRows[i];
            vectorAssignRow.assignRow(batch.size, row);
            ++batch.size;
            if (batch.size != 1024) continue;
            this.serializeBatch(batch, vectorSerializeRow, (DeserializeRead)deserializeRead, source, randomRows, firstRandomRowIndex);
            firstRandomRowIndex = i + 1;
            batch.reset();
        }
        if (batch.size > 0) {
            this.serializeBatch(batch, vectorSerializeRow, (DeserializeRead)deserializeRead, source, randomRows, firstRandomRowIndex);
        }
    }

    void examineBatch(VectorizedRowBatch batch, VectorExtractRowSameBatch vectorExtractRow, Object[][] randomRows, int firstRandomRowIndex) {
        int rowSize = vectorExtractRow.getCount();
        Object[] row = new Object[rowSize];
        for (int i = 0; i < batch.size; ++i) {
            vectorExtractRow.extractRow(i, row);
            Object[] expectedRow = randomRows[firstRandomRowIndex + i];
            for (int c = 0; c < rowSize; ++c) {
                if (row[c] == null) {
                    TestVectorSerDeRow.fail((String)"Unexpected NULL from extractRow");
                }
                if (row[c].equals(expectedRow[c])) continue;
                TestVectorSerDeRow.fail((String)("Row " + (firstRandomRowIndex + i) + " and column " + c + " mismatch"));
            }
        }
    }

    private ByteStream.Output serializeRow(Object[] row, RandomRowObjectSource source, SerializeWrite serializeWrite) throws HiveException, IOException {
        ByteStream.Output output = new ByteStream.Output();
        serializeWrite.set(output);
        PrimitiveTypeInfo[] primitiveTypeInfos = source.primitiveTypeInfos();
        block18: for (int i = 0; i < primitiveTypeInfos.length; ++i) {
            Object object = row[i];
            PrimitiveObjectInspector.PrimitiveCategory primitiveCategory = primitiveTypeInfos[i].getPrimitiveCategory();
            switch (primitiveCategory) {
                case BOOLEAN: {
                    BooleanWritable expectedWritable = (BooleanWritable)object;
                    boolean value = expectedWritable.get();
                    serializeWrite.writeBoolean(value);
                    continue block18;
                }
                case BYTE: {
                    BooleanWritable expectedWritable = (ByteWritable)object;
                    byte value = expectedWritable.get();
                    serializeWrite.writeByte(value);
                    continue block18;
                }
                case SHORT: {
                    BooleanWritable expectedWritable = (ShortWritable)object;
                    short value = expectedWritable.get();
                    serializeWrite.writeShort(value);
                    continue block18;
                }
                case INT: {
                    BooleanWritable expectedWritable = (IntWritable)object;
                    int value = expectedWritable.get();
                    serializeWrite.writeInt(value);
                    continue block18;
                }
                case LONG: {
                    BooleanWritable expectedWritable = (LongWritable)object;
                    long value = expectedWritable.get();
                    serializeWrite.writeLong(value);
                    continue block18;
                }
                case DATE: {
                    BooleanWritable expectedWritable = (DateWritable)object;
                    Date value = expectedWritable.get();
                    serializeWrite.writeDate(value);
                    continue block18;
                }
                case FLOAT: {
                    BooleanWritable expectedWritable = (FloatWritable)object;
                    float value = expectedWritable.get();
                    serializeWrite.writeFloat(value);
                    continue block18;
                }
                case DOUBLE: {
                    BooleanWritable expectedWritable = (DoubleWritable)object;
                    double value = expectedWritable.get();
                    serializeWrite.writeDouble(value);
                    continue block18;
                }
                case STRING: {
                    Text text = (Text)object;
                    serializeWrite.writeString(text.getBytes(), 0, text.getLength());
                    continue block18;
                }
                case CHAR: {
                    BooleanWritable expectedWritable = (HiveCharWritable)object;
                    HiveChar value = expectedWritable.getHiveChar();
                    serializeWrite.writeHiveChar(value);
                    continue block18;
                }
                case VARCHAR: {
                    BooleanWritable expectedWritable = (HiveVarcharWritable)object;
                    HiveVarchar value = expectedWritable.getHiveVarchar();
                    serializeWrite.writeHiveVarchar(value);
                    continue block18;
                }
                case BINARY: {
                    BooleanWritable expectedWritable = (BytesWritable)object;
                    byte[] bytes = expectedWritable.getBytes();
                    int length = expectedWritable.getLength();
                    serializeWrite.writeBinary(bytes, 0, length);
                    continue block18;
                }
                case TIMESTAMP: {
                    BooleanWritable expectedWritable = (TimestampWritable)object;
                    Timestamp value = expectedWritable.getTimestamp();
                    serializeWrite.writeTimestamp(value);
                    continue block18;
                }
                case INTERVAL_YEAR_MONTH: {
                    BooleanWritable expectedWritable = (HiveIntervalYearMonthWritable)object;
                    HiveIntervalYearMonth value = expectedWritable.getHiveIntervalYearMonth();
                    serializeWrite.writeHiveIntervalYearMonth(value);
                    continue block18;
                }
                case INTERVAL_DAY_TIME: {
                    BooleanWritable expectedWritable = (HiveIntervalDayTimeWritable)object;
                    HiveIntervalDayTime value = expectedWritable.getHiveIntervalDayTime();
                    serializeWrite.writeHiveIntervalDayTime(value);
                    continue block18;
                }
                case DECIMAL: {
                    BooleanWritable expectedWritable = (HiveDecimalWritable)object;
                    HiveDecimal value = expectedWritable.getHiveDecimal();
                    serializeWrite.writeHiveDecimal(value, ((DecimalTypeInfo)primitiveTypeInfos[i]).scale());
                    continue block18;
                }
                default: {
                    throw new HiveException("Unexpected primitive category " + primitiveCategory);
                }
            }
        }
        return output;
    }

    private Properties createProperties(String fieldNames, String fieldTypes) {
        Properties tbl = new Properties();
        tbl.setProperty("serialization.format", "9");
        tbl.setProperty("columns", fieldNames);
        tbl.setProperty("columns.types", fieldTypes);
        tbl.setProperty("serialization.null.format", "NULL");
        return tbl;
    }

    private LazySerDeParameters getSerDeParams(StructObjectInspector rowObjectInspector) throws SerDeException {
        String fieldNames = ObjectInspectorUtils.getFieldNames((StructObjectInspector)rowObjectInspector);
        String fieldTypes = ObjectInspectorUtils.getFieldTypes((StructObjectInspector)rowObjectInspector);
        Configuration conf = new Configuration();
        Properties tbl = this.createProperties(fieldNames, fieldTypes);
        return new LazySerDeParameters(conf, tbl, LazySimpleSerDe.class.getName());
    }

    void testVectorDeserializeRow(int caseNum, Random r, SerializationType serializationType) throws HiveException, IOException, SerDeException {
        BinarySortableSerializeWrite serializeWrite;
        BinarySortableDeserializeRead deserializeRead;
        String[] emptyScratchTypeNames = new String[]{};
        RandomRowObjectSource source = new RandomRowObjectSource();
        source.init(r);
        VectorizedRowBatchCtx batchContext = new VectorizedRowBatchCtx();
        batchContext.init(source.rowStructObjectInspector(), emptyScratchTypeNames);
        VectorizedRowBatch batch = batchContext.createVectorizedRowBatch();
        for (ColumnVector cv : batch.cols) {
            Arrays.fill(cv.isNull, true);
        }
        int fieldCount = source.typeNames().size();
        switch (serializationType) {
            case BINARY_SORTABLE: {
                deserializeRead = new BinarySortableDeserializeRead(source.primitiveTypeInfos());
                serializeWrite = new BinarySortableSerializeWrite(fieldCount);
                break;
            }
            case LAZY_BINARY: {
                deserializeRead = new LazyBinaryDeserializeRead((TypeInfo[])source.primitiveTypeInfos());
                serializeWrite = new LazyBinarySerializeWrite(fieldCount);
                break;
            }
            case LAZY_SIMPLE: {
                StructObjectInspector rowObjectInspector = source.rowStructObjectInspector();
                ColumnVector[] lazySerDeParams = this.getSerDeParams(rowObjectInspector);
                int separator = 9;
                deserializeRead = new LazySimpleDeserializeRead((TypeInfo[])source.primitiveTypeInfos(), (byte)separator, (LazySerDeParameters)lazySerDeParams);
                serializeWrite = new LazySimpleSerializeWrite(fieldCount, (byte)separator, (LazySerDeParameters)lazySerDeParams);
                break;
            }
            default: {
                throw new Error("Unknown serialization type " + (Object)((Object)serializationType));
            }
        }
        VectorDeserializeRow vectorDeserializeRow = new VectorDeserializeRow((DeserializeRead)deserializeRead);
        vectorDeserializeRow.init();
        for (ColumnVector cv : batch.cols) {
            Arrays.fill(cv.isNull, true);
            cv.noNulls = false;
        }
        VectorExtractRowSameBatch vectorExtractRow = new VectorExtractRowSameBatch();
        vectorExtractRow.init(source.typeNames());
        vectorExtractRow.setOneBatch(batch);
        Object[][] randomRows = source.randomRows(100000);
        int firstRandomRowIndex = 0;
        for (int i = 0; i < randomRows.length; ++i) {
            Object[] row = randomRows[i];
            ByteStream.Output output = this.serializeRow(row, source, (SerializeWrite)serializeWrite);
            vectorDeserializeRow.setBytes(output.getData(), 0, output.getLength());
            vectorDeserializeRow.deserializeByValue(batch, batch.size);
            ++batch.size;
            if (batch.size != 1024) continue;
            this.examineBatch(batch, vectorExtractRow, randomRows, firstRandomRowIndex);
            firstRandomRowIndex = i + 1;
            batch.reset();
        }
        if (batch.size > 0) {
            this.examineBatch(batch, vectorExtractRow, randomRows, firstRandomRowIndex);
        }
    }

    public void testVectorSerDeRow() throws Throwable {
        try {
            int c;
            Random r = new Random(5678L);
            for (c = 0; c < 10; ++c) {
                this.testVectorSerializeRow(c, r, SerializationType.BINARY_SORTABLE);
            }
            for (c = 0; c < 10; ++c) {
                this.testVectorSerializeRow(c, r, SerializationType.LAZY_BINARY);
            }
            for (c = 0; c < 10; ++c) {
                this.testVectorSerializeRow(c, r, SerializationType.LAZY_SIMPLE);
            }
            for (c = 0; c < 10; ++c) {
                this.testVectorDeserializeRow(c, r, SerializationType.BINARY_SORTABLE);
            }
            for (c = 0; c < 10; ++c) {
                this.testVectorDeserializeRow(c, r, SerializationType.LAZY_BINARY);
            }
            for (c = 0; c < 10; ++c) {
                this.testVectorDeserializeRow(c, r, SerializationType.LAZY_SIMPLE);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static enum SerializationType {
        NONE,
        BINARY_SORTABLE,
        LAZY_BINARY,
        LAZY_SIMPLE;

    }
}

