/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import junit.framework.Assert;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.FuncBin;
import org.apache.hadoop.hive.ql.exec.vector.expressions.FuncHex;
import org.apache.hadoop.hive.ql.exec.vector.expressions.FuncLogWithBaseDoubleToDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.FuncPowerDoubleToDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.FuncRand;
import org.apache.hadoop.hive.ql.exec.vector.expressions.FuncRandNoSeed;
import org.apache.hadoop.hive.ql.exec.vector.expressions.ISetDoubleArg;
import org.apache.hadoop.hive.ql.exec.vector.expressions.ISetLongArg;
import org.apache.hadoop.hive.ql.exec.vector.expressions.PosModDoubleToDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.PosModLongToLong;
import org.apache.hadoop.hive.ql.exec.vector.expressions.RoundWithNumDigitsDoubleToDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringHex;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncACosDoubleToDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncASinDoubleToDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncATanDoubleToDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncAbsDoubleToDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncAbsLongToLong;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncCeilDoubleToLong;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncCosDoubleToDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncDegreesDoubleToDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncExpDoubleToDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncFloorDoubleToLong;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncLnDoubleToDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncLnLongToDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncLog10DoubleToDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncLog10LongToDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncLog2DoubleToDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncLog2LongToDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncRadiansDoubleToDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncRoundDoubleToDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncSignDoubleToDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncSignLongToDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncSinDoubleToDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncSqrtDoubleToDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncTanDoubleToDouble;
import org.junit.Test;

public class TestVectorMathFunctions {
    private static final double eps = 1.0E-7;

    private static boolean equalsWithinTolerance(double a, double b) {
        return Math.abs(a - b) < 1.0E-7;
    }

    @Test
    public void testVectorRound() {
        VectorizedRowBatch b = TestVectorMathFunctions.getVectorizedRowBatchDoubleInDoubleOut();
        FuncRoundDoubleToDouble expr = new FuncRoundDoubleToDouble(0, 1);
        DoubleColumnVector resultV = (DoubleColumnVector)b.cols[1];
        b.cols[0].noNulls = true;
        expr.evaluate(b);
        Assert.assertEquals((Object)-2.0, (Object)resultV.vector[0]);
        Assert.assertEquals((Object)-1.0, (Object)resultV.vector[1]);
        Assert.assertEquals((Object)0.0, (Object)resultV.vector[2]);
        Assert.assertEquals((Object)0.0, (Object)resultV.vector[3]);
        Assert.assertEquals((Object)1.0, (Object)resultV.vector[4]);
        Assert.assertEquals((Object)1.0, (Object)resultV.vector[5]);
        Assert.assertEquals((Object)2.0, (Object)resultV.vector[6]);
        b.cols[0].noNulls = false;
        b.cols[0].isNull[3] = true;
        resultV.noNulls = true;
        expr.evaluate(b);
        Assert.assertEquals((boolean)true, (boolean)resultV.isNull[3]);
        Assert.assertEquals((boolean)false, (boolean)resultV.noNulls);
        b.cols[0].isRepeating = true;
        resultV.isRepeating = false;
        expr.evaluate(b);
        Assert.assertEquals((Object)-2.0, (Object)resultV.vector[0]);
        Assert.assertEquals((boolean)true, (boolean)resultV.isRepeating);
        resultV.isRepeating = false;
        b.cols[0].noNulls = true;
        expr.evaluate(b);
        Assert.assertEquals((Object)-2.0, (Object)resultV.vector[0]);
        Assert.assertEquals((boolean)true, (boolean)resultV.isRepeating);
    }

    @Test
    public void testRoundToDecimalPlaces() {
        VectorizedRowBatch b = TestVectorMathFunctions.getVectorizedRowBatchDoubleInDoubleOut();
        RoundWithNumDigitsDoubleToDouble expr = new RoundWithNumDigitsDoubleToDouble(0, 4L, 1);
        ((ISetLongArg)expr).setArg(4L);
        expr.evaluate(b);
        DoubleColumnVector resultV = (DoubleColumnVector)b.cols[1];
        Assert.assertEquals((Object)1.2346, (Object)resultV.vector[7]);
    }

    public static VectorizedRowBatch getVectorizedRowBatchDoubleInLongOut() {
        VectorizedRowBatch batch = new VectorizedRowBatch(2);
        LongColumnVector lcv = new LongColumnVector();
        DoubleColumnVector dcv = new DoubleColumnVector();
        dcv.vector[0] = -1.5;
        dcv.vector[1] = -0.5;
        dcv.vector[2] = -0.1;
        dcv.vector[3] = 0.0;
        dcv.vector[4] = 0.5;
        dcv.vector[5] = 0.7;
        dcv.vector[6] = 1.5;
        batch.cols[0] = dcv;
        batch.cols[1] = lcv;
        batch.size = 7;
        return batch;
    }

    public static VectorizedRowBatch getVectorizedRowBatchDoubleInDoubleOut() {
        VectorizedRowBatch batch = new VectorizedRowBatch(2);
        DoubleColumnVector outV = new DoubleColumnVector();
        DoubleColumnVector inV = new DoubleColumnVector();
        inV.vector[0] = -1.5;
        inV.vector[1] = -0.5;
        inV.vector[2] = -0.1;
        inV.vector[3] = 0.0;
        inV.vector[4] = 0.5;
        inV.vector[5] = 0.7;
        inV.vector[6] = 1.5;
        inV.vector[7] = 1.2345678;
        batch.cols[0] = inV;
        batch.cols[1] = outV;
        batch.size = 8;
        return batch;
    }

    public static VectorizedRowBatch getVectorizedRowBatchLongInDoubleOut() {
        VectorizedRowBatch batch = new VectorizedRowBatch(2);
        LongColumnVector lcv = new LongColumnVector();
        DoubleColumnVector dcv = new DoubleColumnVector();
        lcv.vector[0] = -2L;
        lcv.vector[1] = -1L;
        lcv.vector[2] = 0L;
        lcv.vector[3] = 1L;
        lcv.vector[4] = 2L;
        batch.cols[0] = lcv;
        batch.cols[1] = dcv;
        batch.size = 5;
        return batch;
    }

    public static VectorizedRowBatch getVectorizedRowBatchLongInLongOut() {
        VectorizedRowBatch batch = new VectorizedRowBatch(2);
        LongColumnVector inV = new LongColumnVector();
        LongColumnVector outV = new LongColumnVector();
        inV.vector[0] = -2L;
        inV.vector[1] = 2L;
        batch.cols[0] = inV;
        batch.cols[1] = outV;
        batch.size = 2;
        return batch;
    }

    public static VectorizedRowBatch getBatchForStringMath() {
        VectorizedRowBatch batch = new VectorizedRowBatch(3);
        LongColumnVector inL = new LongColumnVector();
        BytesColumnVector inS = new BytesColumnVector();
        BytesColumnVector outS = new BytesColumnVector();
        inL.vector[0] = 0L;
        inL.vector[1] = 255L;
        inL.vector[2] = 0L;
        inS.initBuffer();
        try {
            inS.setVal(0, "00".getBytes("UTF-8"), 0, 2);
            inS.setVal(1, "3232".getBytes("UTF-8"), 0, 4);
            byte[] bad = "bad data".getBytes("UTF-8");
            inS.setVal(2, bad, 0, bad.length);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            Assert.assertTrue((boolean)false);
        }
        batch.cols[0] = inS;
        batch.cols[1] = inL;
        batch.cols[2] = outS;
        batch.size = 3;
        return batch;
    }

    @Test
    public void testVectorSin() {
        VectorizedRowBatch b = TestVectorMathFunctions.getVectorizedRowBatchDoubleInDoubleOut();
        DoubleColumnVector resultV = (DoubleColumnVector)b.cols[1];
        b.cols[0].noNulls = true;
        FuncSinDoubleToDouble expr = new FuncSinDoubleToDouble(0, 1);
        expr.evaluate(b);
        Assert.assertEquals((Object)Math.sin(0.5), (Object)resultV.vector[4]);
    }

    @Test
    public void testVectorCos() {
        VectorizedRowBatch b = TestVectorMathFunctions.getVectorizedRowBatchDoubleInDoubleOut();
        DoubleColumnVector resultV = (DoubleColumnVector)b.cols[1];
        b.cols[0].noNulls = true;
        FuncCosDoubleToDouble expr = new FuncCosDoubleToDouble(0, 1);
        expr.evaluate(b);
        Assert.assertEquals((Object)Math.cos(0.5), (Object)resultV.vector[4]);
    }

    @Test
    public void testVectorTan() {
        VectorizedRowBatch b = TestVectorMathFunctions.getVectorizedRowBatchDoubleInDoubleOut();
        DoubleColumnVector resultV = (DoubleColumnVector)b.cols[1];
        b.cols[0].noNulls = true;
        FuncTanDoubleToDouble expr = new FuncTanDoubleToDouble(0, 1);
        expr.evaluate(b);
        Assert.assertEquals((Object)Math.tan(0.5), (Object)resultV.vector[4]);
    }

    @Test
    public void testVectorASin() {
        VectorizedRowBatch b = TestVectorMathFunctions.getVectorizedRowBatchDoubleInDoubleOut();
        DoubleColumnVector resultV = (DoubleColumnVector)b.cols[1];
        b.cols[0].noNulls = true;
        FuncASinDoubleToDouble expr = new FuncASinDoubleToDouble(0, 1);
        expr.evaluate(b);
        Assert.assertEquals((Object)Math.asin(0.5), (Object)resultV.vector[4]);
    }

    @Test
    public void testVectorACos() {
        VectorizedRowBatch b = TestVectorMathFunctions.getVectorizedRowBatchDoubleInDoubleOut();
        DoubleColumnVector resultV = (DoubleColumnVector)b.cols[1];
        b.cols[0].noNulls = true;
        FuncACosDoubleToDouble expr = new FuncACosDoubleToDouble(0, 1);
        expr.evaluate(b);
        Assert.assertEquals((Object)Math.acos(0.5), (Object)resultV.vector[4]);
    }

    @Test
    public void testVectorATan() {
        VectorizedRowBatch b = TestVectorMathFunctions.getVectorizedRowBatchDoubleInDoubleOut();
        DoubleColumnVector resultV = (DoubleColumnVector)b.cols[1];
        b.cols[0].noNulls = true;
        FuncATanDoubleToDouble expr = new FuncATanDoubleToDouble(0, 1);
        expr.evaluate(b);
        Assert.assertEquals((Object)Math.atan(0.5), (Object)resultV.vector[4]);
    }

    @Test
    public void testVectorDegrees() {
        VectorizedRowBatch b = TestVectorMathFunctions.getVectorizedRowBatchDoubleInDoubleOut();
        DoubleColumnVector resultV = (DoubleColumnVector)b.cols[1];
        b.cols[0].noNulls = true;
        FuncDegreesDoubleToDouble expr = new FuncDegreesDoubleToDouble(0, 1);
        expr.evaluate(b);
        Assert.assertEquals((Object)Math.toDegrees(0.5), (Object)resultV.vector[4]);
    }

    @Test
    public void testVectorRadians() {
        VectorizedRowBatch b = TestVectorMathFunctions.getVectorizedRowBatchDoubleInDoubleOut();
        DoubleColumnVector resultV = (DoubleColumnVector)b.cols[1];
        b.cols[0].noNulls = true;
        FuncRadiansDoubleToDouble expr = new FuncRadiansDoubleToDouble(0, 1);
        expr.evaluate(b);
        Assert.assertEquals((Object)Math.toRadians(0.5), (Object)resultV.vector[4]);
    }

    @Test
    public void testVectorFloor() {
        VectorizedRowBatch b = TestVectorMathFunctions.getVectorizedRowBatchDoubleInLongOut();
        LongColumnVector resultV = (LongColumnVector)b.cols[1];
        b.cols[0].noNulls = true;
        FuncFloorDoubleToLong expr = new FuncFloorDoubleToLong(0, 1);
        expr.evaluate(b);
        Assert.assertEquals((long)-2L, (long)resultV.vector[0]);
        Assert.assertEquals((long)1L, (long)resultV.vector[6]);
    }

    @Test
    public void testVectorCeil() {
        VectorizedRowBatch b = TestVectorMathFunctions.getVectorizedRowBatchDoubleInLongOut();
        LongColumnVector resultV = (LongColumnVector)b.cols[1];
        b.cols[0].noNulls = true;
        FuncCeilDoubleToLong expr = new FuncCeilDoubleToLong(0, 1);
        expr.evaluate(b);
        Assert.assertEquals((long)-1L, (long)resultV.vector[0]);
        Assert.assertEquals((long)2L, (long)resultV.vector[6]);
    }

    @Test
    public void testVectorExp() {
        VectorizedRowBatch b = TestVectorMathFunctions.getVectorizedRowBatchDoubleInDoubleOut();
        DoubleColumnVector resultV = (DoubleColumnVector)b.cols[1];
        b.cols[0].noNulls = true;
        FuncExpDoubleToDouble expr = new FuncExpDoubleToDouble(0, 1);
        expr.evaluate(b);
        Assert.assertEquals((Object)Math.exp(0.5), (Object)resultV.vector[4]);
    }

    @Test
    public void testVectorLn() {
        VectorizedRowBatch b = TestVectorMathFunctions.getVectorizedRowBatchDoubleInDoubleOut();
        DoubleColumnVector resultV = (DoubleColumnVector)b.cols[1];
        b.cols[0].noNulls = true;
        FuncLnDoubleToDouble expr = new FuncLnDoubleToDouble(0, 1);
        expr.evaluate(b);
        Assert.assertEquals((Object)Math.log(0.5), (Object)resultV.vector[4]);
        b = TestVectorMathFunctions.getVectorizedRowBatchLongInDoubleOut();
        resultV = (DoubleColumnVector)b.cols[1];
        b.cols[0].noNulls = true;
        expr = new FuncLnLongToDouble(0, 1);
        expr.evaluate(b);
        Assert.assertEquals((Object)Math.log(2.0), (Object)resultV.vector[4]);
    }

    @Test
    public void testVectorLog2() {
        VectorizedRowBatch b = TestVectorMathFunctions.getVectorizedRowBatchDoubleInDoubleOut();
        DoubleColumnVector resultV = (DoubleColumnVector)b.cols[1];
        b.cols[0].noNulls = true;
        FuncLog2DoubleToDouble expr = new FuncLog2DoubleToDouble(0, 1);
        expr.evaluate(b);
        Assert.assertEquals((Object)(Math.log(0.5) / Math.log(2.0)), (Object)resultV.vector[4]);
        b = TestVectorMathFunctions.getVectorizedRowBatchLongInDoubleOut();
        resultV = (DoubleColumnVector)b.cols[1];
        b.cols[0].noNulls = true;
        expr = new FuncLog2LongToDouble(0, 1);
        expr.evaluate(b);
        Assert.assertEquals((Object)(Math.log(1.0) / Math.log(2.0)), (Object)resultV.vector[3]);
    }

    @Test
    public void testVectorLog10() {
        VectorizedRowBatch b = TestVectorMathFunctions.getVectorizedRowBatchDoubleInDoubleOut();
        DoubleColumnVector resultV = (DoubleColumnVector)b.cols[1];
        b.cols[0].noNulls = true;
        FuncLog10DoubleToDouble expr = new FuncLog10DoubleToDouble(0, 1);
        expr.evaluate(b);
        Assert.assertTrue((boolean)TestVectorMathFunctions.equalsWithinTolerance(Math.log(0.5) / Math.log(10.0), resultV.vector[4]));
        b = TestVectorMathFunctions.getVectorizedRowBatchLongInDoubleOut();
        resultV = (DoubleColumnVector)b.cols[1];
        b.cols[0].noNulls = true;
        expr = new FuncLog10LongToDouble(0, 1);
        expr.evaluate(b);
        Assert.assertEquals((Object)(Math.log(1.0) / Math.log(10.0)), (Object)resultV.vector[3]);
    }

    @Test
    public void testVectorRand() {
        VectorizedRowBatch b = new VectorizedRowBatch(1);
        DoubleColumnVector v = new DoubleColumnVector();
        b.cols[0] = v;
        int n = b.size = 1024;
        v.noNulls = true;
        FuncRandNoSeed expr = new FuncRandNoSeed(0);
        expr.evaluate(b);
        double sum = 0.0;
        for (int i = 0; i != n; ++i) {
            sum += v.vector[i];
            Assert.assertTrue((v.vector[i] >= 0.0 && v.vector[i] <= 1.0 ? 1 : 0) != 0);
        }
        double avg = sum / (double)n;
        Assert.assertTrue((avg > 0.3 && avg < 0.7 ? 1 : 0) != 0);
        Arrays.fill(v.vector, 0.0);
        expr = new FuncRand(99999L, 0);
        expr.evaluate(b);
        sum = 0.0;
        for (int i = 0; i != n; ++i) {
            sum += v.vector[i];
            Assert.assertTrue((v.vector[i] >= 0.0 && v.vector[i] <= 1.0 ? 1 : 0) != 0);
        }
        avg = sum / (double)n;
        Assert.assertTrue((avg > 0.3 && avg < 0.7 ? 1 : 0) != 0);
    }

    @Test
    public void testVectorLogBase() {
        VectorizedRowBatch b = TestVectorMathFunctions.getVectorizedRowBatchDoubleInDoubleOut();
        DoubleColumnVector resultV = (DoubleColumnVector)b.cols[1];
        b.cols[0].noNulls = true;
        FuncLogWithBaseDoubleToDouble expr = new FuncLogWithBaseDoubleToDouble(10.0, 0, 1);
        ((ISetDoubleArg)expr).setArg(10.0);
        expr.evaluate(b);
        Assert.assertTrue((boolean)TestVectorMathFunctions.equalsWithinTolerance(Math.log(0.5) / Math.log(10.0), resultV.vector[4]));
    }

    @Test
    public void testVectorPosMod() {
        VectorizedRowBatch b = TestVectorMathFunctions.getVectorizedRowBatchDoubleInDoubleOut();
        DoubleColumnVector inV = (DoubleColumnVector)b.cols[0];
        DoubleColumnVector resultV = (DoubleColumnVector)b.cols[1];
        b.cols[0].noNulls = true;
        inV.vector[4] = -4.0;
        PosModDoubleToDouble expr = new PosModDoubleToDouble(0, 0.3, 1);
        expr.evaluate(b);
        Assert.assertTrue((boolean)TestVectorMathFunctions.equalsWithinTolerance(0.19999999999999984, resultV.vector[4]));
        b = TestVectorMathFunctions.getVectorizedRowBatchLongInLongOut();
        LongColumnVector resV2 = (LongColumnVector)b.cols[1];
        b.cols[0].noNulls = true;
        expr = new PosModLongToLong(0, 3L, 1);
        expr.evaluate(b);
        Assert.assertEquals((long)1L, (long)resV2.vector[0]);
    }

    @Test
    public void testVectorPower() {
        VectorizedRowBatch b = TestVectorMathFunctions.getVectorizedRowBatchDoubleInDoubleOut();
        DoubleColumnVector resultV = (DoubleColumnVector)b.cols[1];
        b.cols[0].noNulls = true;
        FuncPowerDoubleToDouble expr = new FuncPowerDoubleToDouble(0, 2.0, 1);
        ((ISetDoubleArg)expr).setArg(2.0);
        expr.evaluate(b);
        Assert.assertTrue((boolean)TestVectorMathFunctions.equalsWithinTolerance(0.25, resultV.vector[4]));
    }

    @Test
    public void testVectorSqrt() {
        VectorizedRowBatch b = TestVectorMathFunctions.getVectorizedRowBatchDoubleInDoubleOut();
        DoubleColumnVector resultV = (DoubleColumnVector)b.cols[1];
        b.cols[0].noNulls = true;
        FuncSqrtDoubleToDouble expr = new FuncSqrtDoubleToDouble(0, 1);
        expr.evaluate(b);
        Assert.assertEquals((Object)Math.sqrt(0.5), (Object)resultV.vector[4]);
    }

    @Test
    public void testVectorAbs() {
        VectorizedRowBatch b = TestVectorMathFunctions.getVectorizedRowBatchDoubleInDoubleOut();
        DoubleColumnVector resultV = (DoubleColumnVector)b.cols[1];
        b.cols[0].noNulls = true;
        FuncAbsDoubleToDouble expr = new FuncAbsDoubleToDouble(0, 1);
        expr.evaluate(b);
        Assert.assertEquals((Object)1.5, (Object)resultV.vector[0]);
        Assert.assertEquals((Object)0.5, (Object)resultV.vector[4]);
        b = TestVectorMathFunctions.getVectorizedRowBatchLongInLongOut();
        LongColumnVector resultVLong = (LongColumnVector)b.cols[1];
        b.cols[0].noNulls = true;
        expr = new FuncAbsLongToLong(0, 1);
        expr.evaluate(b);
        Assert.assertEquals((long)2L, (long)resultVLong.vector[0]);
        Assert.assertEquals((long)2L, (long)resultVLong.vector[1]);
    }

    @Test
    public void testVectorSign() {
        VectorizedRowBatch b = TestVectorMathFunctions.getVectorizedRowBatchDoubleInDoubleOut();
        DoubleColumnVector resultV = (DoubleColumnVector)b.cols[1];
        b.cols[0].noNulls = true;
        FuncSignDoubleToDouble expr = new FuncSignDoubleToDouble(0, 1);
        expr.evaluate(b);
        Assert.assertEquals((Object)-1.0, (Object)resultV.vector[0]);
        Assert.assertEquals((Object)1.0, (Object)resultV.vector[4]);
        b = TestVectorMathFunctions.getVectorizedRowBatchLongInDoubleOut();
        resultV = (DoubleColumnVector)b.cols[1];
        b.cols[0].noNulls = true;
        expr = new FuncSignLongToDouble(0, 1);
        expr.evaluate(b);
        Assert.assertEquals((Object)-1.0, (Object)resultV.vector[0]);
        Assert.assertEquals((Object)1.0, (Object)resultV.vector[4]);
    }

    @Test
    public void testVectorBin() {
        VectorizedRowBatch b = TestVectorMathFunctions.getBatchForStringMath();
        BytesColumnVector resultV = (BytesColumnVector)b.cols[2];
        b.cols[0].noNulls = true;
        FuncBin expr = new FuncBin(1, 2);
        expr.evaluate(b);
        String s = new String(resultV.vector[1], resultV.start[1], resultV.length[1]);
        Assert.assertEquals((String)"11111111", (String)s);
    }

    @Test
    public void testVectorHex() {
        VectorizedRowBatch b = TestVectorMathFunctions.getBatchForStringMath();
        BytesColumnVector resultV = (BytesColumnVector)b.cols[2];
        b.cols[1].noNulls = true;
        FuncHex expr = new FuncHex(1, 2);
        expr.evaluate(b);
        String s = new String(resultV.vector[1], resultV.start[1], resultV.length[1]);
        Assert.assertEquals((String)"FF", (String)s);
        b = TestVectorMathFunctions.getBatchForStringMath();
        resultV = (BytesColumnVector)b.cols[2];
        b.cols[0].noNulls = true;
        expr = new StringHex(0, 2);
        expr.evaluate(b);
        s = new String(resultV.vector[1], resultV.start[1], resultV.length[1]);
        Assert.assertEquals((String)"33323332", (String)s);
    }
}

