/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ListColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.MapColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.StructColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampUtils;
import org.apache.hadoop.hive.ql.exec.vector.UnionColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.OrcStruct;
import org.apache.hadoop.hive.ql.io.orc.OrcUnion;
import org.apache.hadoop.hive.ql.io.orc.Reader;
import org.apache.hadoop.hive.ql.io.orc.RecordReader;
import org.apache.hadoop.hive.ql.io.orc.RecordReaderImpl;
import org.apache.hadoop.hive.ql.io.orc.Writer;
import org.apache.hadoop.hive.ql.io.sarg.PredicateLeaf;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgumentFactory;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BinaryObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BooleanObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ByteObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.FloatObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveDecimalObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ShortObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.TimestampObjectInspector;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hive.common.util.HiveTestUtils;
import org.apache.orc.BinaryColumnStatistics;
import org.apache.orc.BooleanColumnStatistics;
import org.apache.orc.ColumnStatistics;
import org.apache.orc.CompressionKind;
import org.apache.orc.DecimalColumnStatistics;
import org.apache.orc.DoubleColumnStatistics;
import org.apache.orc.IntegerColumnStatistics;
import org.apache.orc.OrcFile;
import org.apache.orc.OrcProto;
import org.apache.orc.OrcUtils;
import org.apache.orc.Reader;
import org.apache.orc.StringColumnStatistics;
import org.apache.orc.StripeInformation;
import org.apache.orc.StripeStatistics;
import org.apache.orc.TypeDescription;
import org.apache.orc.impl.MemoryManager;
import org.apache.orc.impl.MetadataReader;
import org.apache.orc.impl.OrcIndex;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class TestVectorOrcFile {
    Path workDir = new Path(System.getProperty("test.tmp.dir", "target" + File.separator + "test" + File.separator + "tmp"));
    Configuration conf;
    FileSystem fs;
    Path testFilePath;
    @Rule
    public TestName testCaseName = new TestName();

    private static InnerStruct inner(int i, String s) {
        return new InnerStruct(i, s);
    }

    private static Map<String, InnerStruct> map(InnerStruct ... items) {
        HashMap<String, InnerStruct> result = new HashMap<String, InnerStruct>();
        for (InnerStruct i : items) {
            result.put(i.string1.toString(), i);
        }
        return result;
    }

    private static List<InnerStruct> list(InnerStruct ... items) {
        ArrayList<InnerStruct> result = new ArrayList<InnerStruct>();
        result.addAll(Arrays.asList(items));
        return result;
    }

    private static BytesWritable bytes(int ... items) {
        BytesWritable result = new BytesWritable();
        result.setSize(items.length);
        for (int i = 0; i < items.length; ++i) {
            result.getBytes()[i] = (byte)items[i];
        }
        return result;
    }

    private static byte[] bytesArray(int ... items) {
        byte[] result = new byte[items.length];
        for (int i = 0; i < items.length; ++i) {
            result[i] = (byte)items[i];
        }
        return result;
    }

    private static ByteBuffer byteBuf(int ... items) {
        ByteBuffer result = ByteBuffer.allocate(items.length);
        for (int item : items) {
            result.put((byte)item);
        }
        result.flip();
        return result;
    }

    @Before
    public void openFileSystem() throws Exception {
        this.conf = new Configuration();
        this.fs = FileSystem.getLocal((Configuration)this.conf);
        this.testFilePath = new Path(this.workDir, "TestVectorOrcFile." + this.testCaseName.getMethodName() + ".orc");
        this.fs.delete(this.testFilePath, false);
    }

    @Test
    public void testReadFormat_0_11() throws Exception {
        Path oldFilePath = new Path(HiveTestUtils.getFileFromClasspath((String)"orc-file-11-format.orc"));
        Reader reader = OrcFile.createReader((Path)oldFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(this.fs));
        int stripeCount = 0;
        int rowCount = 0;
        long currentOffset = -1L;
        for (StripeInformation stripe : reader.getStripes()) {
            ++stripeCount;
            rowCount = (int)((long)rowCount + stripe.getNumberOfRows());
            if (currentOffset < 0L) {
                currentOffset = stripe.getOffset() + stripe.getIndexLength() + stripe.getDataLength() + stripe.getFooterLength();
                continue;
            }
            Assert.assertEquals((long)currentOffset, (long)stripe.getOffset());
            currentOffset += stripe.getIndexLength() + stripe.getDataLength() + stripe.getFooterLength();
        }
        Assert.assertEquals((long)reader.getNumberOfRows(), (long)rowCount);
        Assert.assertEquals((int)2, (int)stripeCount);
        ColumnStatistics[] stats = reader.getStatistics();
        Assert.assertEquals((long)7500L, (long)stats[1].getNumberOfValues());
        Assert.assertEquals((long)3750L, (long)((BooleanColumnStatistics)stats[1]).getFalseCount());
        Assert.assertEquals((long)3750L, (long)((BooleanColumnStatistics)stats[1]).getTrueCount());
        Assert.assertEquals((String)"count: 7500 hasNull: true true: 3750", (String)stats[1].toString());
        Assert.assertEquals((long)2048L, (long)((IntegerColumnStatistics)stats[3]).getMaximum());
        Assert.assertEquals((long)1024L, (long)((IntegerColumnStatistics)stats[3]).getMinimum());
        Assert.assertEquals((boolean)true, (boolean)((IntegerColumnStatistics)stats[3]).isSumDefined());
        Assert.assertEquals((long)11520000L, (long)((IntegerColumnStatistics)stats[3]).getSum());
        Assert.assertEquals((String)"count: 7500 hasNull: true min: 1024 max: 2048 sum: 11520000", (String)stats[3].toString());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)((IntegerColumnStatistics)stats[5]).getMaximum());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)((IntegerColumnStatistics)stats[5]).getMinimum());
        Assert.assertEquals((boolean)false, (boolean)((IntegerColumnStatistics)stats[5]).isSumDefined());
        Assert.assertEquals((String)"count: 7500 hasNull: true min: 9223372036854775807 max: 9223372036854775807", (String)stats[5].toString());
        Assert.assertEquals((Object)-15.0, (Object)((DoubleColumnStatistics)stats[7]).getMinimum());
        Assert.assertEquals((Object)-5.0, (Object)((DoubleColumnStatistics)stats[7]).getMaximum());
        Assert.assertEquals((double)-75000.0, (double)((DoubleColumnStatistics)stats[7]).getSum(), (double)1.0E-5);
        Assert.assertEquals((String)"count: 7500 hasNull: true min: -15.0 max: -5.0 sum: -75000.0", (String)stats[7].toString());
        Assert.assertEquals((String)"count: 7500 hasNull: true min: bye max: hi sum: 0", (String)stats[9].toString());
        StructObjectInspector readerInspector = (StructObjectInspector)reader.getObjectInspector();
        Assert.assertEquals((Object)ObjectInspector.Category.STRUCT, (Object)readerInspector.getCategory());
        Assert.assertEquals((String)"struct<boolean1:boolean,byte1:tinyint,short1:smallint,int1:int,long1:bigint,float1:float,double1:double,bytes1:binary,string1:string,middle:struct<list:array<struct<int1:int,string1:string>>>,list:array<struct<int1:int,string1:string>>,map:map<string,struct<int1:int,string1:string>>,ts:timestamp,decimal1:decimal(38,18)>", (String)readerInspector.getTypeName());
        List fields = readerInspector.getAllStructFieldRefs();
        BooleanObjectInspector bo = (BooleanObjectInspector)readerInspector.getStructFieldRef("boolean1").getFieldObjectInspector();
        ByteObjectInspector by = (ByteObjectInspector)readerInspector.getStructFieldRef("byte1").getFieldObjectInspector();
        ShortObjectInspector sh = (ShortObjectInspector)readerInspector.getStructFieldRef("short1").getFieldObjectInspector();
        IntObjectInspector in = (IntObjectInspector)readerInspector.getStructFieldRef("int1").getFieldObjectInspector();
        LongObjectInspector lo = (LongObjectInspector)readerInspector.getStructFieldRef("long1").getFieldObjectInspector();
        FloatObjectInspector fl = (FloatObjectInspector)readerInspector.getStructFieldRef("float1").getFieldObjectInspector();
        DoubleObjectInspector dbl = (DoubleObjectInspector)readerInspector.getStructFieldRef("double1").getFieldObjectInspector();
        BinaryObjectInspector bi = (BinaryObjectInspector)readerInspector.getStructFieldRef("bytes1").getFieldObjectInspector();
        StringObjectInspector st = (StringObjectInspector)readerInspector.getStructFieldRef("string1").getFieldObjectInspector();
        StructObjectInspector mid = (StructObjectInspector)readerInspector.getStructFieldRef("middle").getFieldObjectInspector();
        List midFields = mid.getAllStructFieldRefs();
        ListObjectInspector midli = (ListObjectInspector)((StructField)midFields.get(0)).getFieldObjectInspector();
        StructObjectInspector inner = (StructObjectInspector)midli.getListElementObjectInspector();
        List inFields = inner.getAllStructFieldRefs();
        ListObjectInspector li = (ListObjectInspector)readerInspector.getStructFieldRef("list").getFieldObjectInspector();
        MapObjectInspector ma = (MapObjectInspector)readerInspector.getStructFieldRef("map").getFieldObjectInspector();
        TimestampObjectInspector tso = (TimestampObjectInspector)readerInspector.getStructFieldRef("ts").getFieldObjectInspector();
        HiveDecimalObjectInspector dco = (HiveDecimalObjectInspector)readerInspector.getStructFieldRef("decimal1").getFieldObjectInspector();
        StringObjectInspector mk = (StringObjectInspector)ma.getMapKeyObjectInspector();
        RecordReader rows = reader.rows();
        Object row = rows.next(null);
        Assert.assertNotNull((Object)row);
        Assert.assertEquals((boolean)false, (boolean)bo.get(readerInspector.getStructFieldData(row, (StructField)fields.get(0))));
        Assert.assertEquals((int)1, (int)by.get(readerInspector.getStructFieldData(row, (StructField)fields.get(1))));
        Assert.assertEquals((int)1024, (int)sh.get(readerInspector.getStructFieldData(row, (StructField)fields.get(2))));
        Assert.assertEquals((int)65536, (int)in.get(readerInspector.getStructFieldData(row, (StructField)fields.get(3))));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)lo.get(readerInspector.getStructFieldData(row, (StructField)fields.get(4))));
        Assert.assertEquals((double)1.0, (double)fl.get(readerInspector.getStructFieldData(row, (StructField)fields.get(5))), (double)1.0E-5);
        Assert.assertEquals((double)-15.0, (double)dbl.get(readerInspector.getStructFieldData(row, (StructField)fields.get(6))), (double)1.0E-5);
        Assert.assertEquals((Object)TestVectorOrcFile.bytes(0, 1, 2, 3, 4), (Object)bi.getPrimitiveWritableObject(readerInspector.getStructFieldData(row, (StructField)fields.get(7))));
        Assert.assertEquals((String)"hi", (String)st.getPrimitiveJavaObject(readerInspector.getStructFieldData(row, (StructField)fields.get(8))));
        List midRow = midli.getList(mid.getStructFieldData(readerInspector.getStructFieldData(row, (StructField)fields.get(9)), (StructField)midFields.get(0)));
        Assert.assertNotNull((Object)midRow);
        Assert.assertEquals((int)2, (int)midRow.size());
        Assert.assertEquals((int)1, (int)in.get(inner.getStructFieldData(midRow.get(0), (StructField)inFields.get(0))));
        Assert.assertEquals((String)"bye", (String)st.getPrimitiveJavaObject(inner.getStructFieldData(midRow.get(0), (StructField)inFields.get(1))));
        Assert.assertEquals((int)2, (int)in.get(inner.getStructFieldData(midRow.get(1), (StructField)inFields.get(0))));
        Assert.assertEquals((String)"sigh", (String)st.getPrimitiveJavaObject(inner.getStructFieldData(midRow.get(1), (StructField)inFields.get(1))));
        List list = li.getList(readerInspector.getStructFieldData(row, (StructField)fields.get(10)));
        Assert.assertEquals((int)2, (int)list.size());
        Assert.assertEquals((int)3, (int)in.get(inner.getStructFieldData(list.get(0), (StructField)inFields.get(0))));
        Assert.assertEquals((String)"good", (String)st.getPrimitiveJavaObject(inner.getStructFieldData(list.get(0), (StructField)inFields.get(1))));
        Assert.assertEquals((int)4, (int)in.get(inner.getStructFieldData(list.get(1), (StructField)inFields.get(0))));
        Assert.assertEquals((String)"bad", (String)st.getPrimitiveJavaObject(inner.getStructFieldData(list.get(1), (StructField)inFields.get(1))));
        Map map = ma.getMap(readerInspector.getStructFieldData(row, (StructField)fields.get(11)));
        Assert.assertEquals((int)0, (int)map.size());
        Assert.assertEquals((Object)Timestamp.valueOf("2000-03-12 15:00:00"), (Object)tso.getPrimitiveJavaObject(readerInspector.getStructFieldData(row, (StructField)fields.get(12))));
        Assert.assertEquals((Object)HiveDecimal.create((String)"12345678.6547456"), (Object)dco.getPrimitiveJavaObject(readerInspector.getStructFieldData(row, (StructField)fields.get(13))));
        Assert.assertEquals((boolean)true, (boolean)rows.hasNext());
        rows.seekToRow(7499L);
        row = rows.next(null);
        Assert.assertEquals((boolean)true, (boolean)bo.get(readerInspector.getStructFieldData(row, (StructField)fields.get(0))));
        Assert.assertEquals((int)100, (int)by.get(readerInspector.getStructFieldData(row, (StructField)fields.get(1))));
        Assert.assertEquals((int)2048, (int)sh.get(readerInspector.getStructFieldData(row, (StructField)fields.get(2))));
        Assert.assertEquals((int)65536, (int)in.get(readerInspector.getStructFieldData(row, (StructField)fields.get(3))));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)lo.get(readerInspector.getStructFieldData(row, (StructField)fields.get(4))));
        Assert.assertEquals((double)2.0, (double)fl.get(readerInspector.getStructFieldData(row, (StructField)fields.get(5))), (double)1.0E-5);
        Assert.assertEquals((double)-5.0, (double)dbl.get(readerInspector.getStructFieldData(row, (StructField)fields.get(6))), (double)1.0E-5);
        Assert.assertEquals((Object)TestVectorOrcFile.bytes(new int[0]), (Object)bi.getPrimitiveWritableObject(readerInspector.getStructFieldData(row, (StructField)fields.get(7))));
        Assert.assertEquals((String)"bye", (String)st.getPrimitiveJavaObject(readerInspector.getStructFieldData(row, (StructField)fields.get(8))));
        midRow = midli.getList(mid.getStructFieldData(readerInspector.getStructFieldData(row, (StructField)fields.get(9)), (StructField)midFields.get(0)));
        Assert.assertNotNull((Object)midRow);
        Assert.assertEquals((int)2, (int)midRow.size());
        Assert.assertEquals((int)1, (int)in.get(inner.getStructFieldData(midRow.get(0), (StructField)inFields.get(0))));
        Assert.assertEquals((String)"bye", (String)st.getPrimitiveJavaObject(inner.getStructFieldData(midRow.get(0), (StructField)inFields.get(1))));
        Assert.assertEquals((int)2, (int)in.get(inner.getStructFieldData(midRow.get(1), (StructField)inFields.get(0))));
        Assert.assertEquals((String)"sigh", (String)st.getPrimitiveJavaObject(inner.getStructFieldData(midRow.get(1), (StructField)inFields.get(1))));
        list = li.getList(readerInspector.getStructFieldData(row, (StructField)fields.get(10)));
        Assert.assertEquals((int)3, (int)list.size());
        Assert.assertEquals((int)100000000, (int)in.get(inner.getStructFieldData(list.get(0), (StructField)inFields.get(0))));
        Assert.assertEquals((String)"cat", (String)st.getPrimitiveJavaObject(inner.getStructFieldData(list.get(0), (StructField)inFields.get(1))));
        Assert.assertEquals((int)-100000, (int)in.get(inner.getStructFieldData(list.get(1), (StructField)inFields.get(0))));
        Assert.assertEquals((String)"in", (String)st.getPrimitiveJavaObject(inner.getStructFieldData(list.get(1), (StructField)inFields.get(1))));
        Assert.assertEquals((int)1234, (int)in.get(inner.getStructFieldData(list.get(2), (StructField)inFields.get(0))));
        Assert.assertEquals((String)"hat", (String)st.getPrimitiveJavaObject(inner.getStructFieldData(list.get(2), (StructField)inFields.get(1))));
        map = ma.getMap(readerInspector.getStructFieldData(row, (StructField)fields.get(11)));
        Assert.assertEquals((int)2, (int)map.size());
        boolean[] found = new boolean[2];
        for (Object key : map.keySet()) {
            String str = mk.getPrimitiveJavaObject(key);
            if (str.equals("chani")) {
                Assert.assertEquals((boolean)false, (boolean)found[0]);
                Assert.assertEquals((int)5, (int)in.get(inner.getStructFieldData(map.get(key), (StructField)inFields.get(0))));
                Assert.assertEquals((String)str, (String)st.getPrimitiveJavaObject(inner.getStructFieldData(map.get(key), (StructField)inFields.get(1))));
                found[0] = true;
                continue;
            }
            if (str.equals("mauddib")) {
                Assert.assertEquals((boolean)false, (boolean)found[1]);
                Assert.assertEquals((int)1, (int)in.get(inner.getStructFieldData(map.get(key), (StructField)inFields.get(0))));
                Assert.assertEquals((String)str, (String)st.getPrimitiveJavaObject(inner.getStructFieldData(map.get(key), (StructField)inFields.get(1))));
                found[1] = true;
                continue;
            }
            throw new IllegalArgumentException("Unknown key " + str);
        }
        Assert.assertEquals((boolean)true, (boolean)found[0]);
        Assert.assertEquals((boolean)true, (boolean)found[1]);
        Assert.assertEquals((Object)Timestamp.valueOf("2000-03-12 15:00:01"), (Object)tso.getPrimitiveJavaObject(readerInspector.getStructFieldData(row, (StructField)fields.get(12))));
        Assert.assertEquals((Object)HiveDecimal.create((String)"12345678.6547457"), (Object)dco.getPrimitiveJavaObject(readerInspector.getStructFieldData(row, (StructField)fields.get(13))));
        Assert.assertEquals((boolean)false, (boolean)rows.hasNext());
        rows.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTimestamp() throws Exception {
        Class<TestVectorOrcFile> clazz = TestVectorOrcFile.class;
        synchronized (TestVectorOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(Timestamp.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            TypeDescription schema = TypeDescription.createTimestamp();
            Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).setSchema(schema).stripeSize(100000L).bufferSize(10000).version(OrcFile.Version.V_0_11));
            ArrayList tslist = Lists.newArrayList();
            tslist.add(Timestamp.valueOf("2037-01-01 00:00:00.000999"));
            tslist.add(Timestamp.valueOf("2003-01-01 00:00:00.000000222"));
            tslist.add(Timestamp.valueOf("1999-01-01 00:00:00.999999999"));
            tslist.add(Timestamp.valueOf("1995-01-01 00:00:00.688888888"));
            tslist.add(Timestamp.valueOf("2002-01-01 00:00:00.1"));
            tslist.add(Timestamp.valueOf("2010-03-02 00:00:00.000009001"));
            tslist.add(Timestamp.valueOf("2005-01-01 00:00:00.000002229"));
            tslist.add(Timestamp.valueOf("2006-01-01 00:00:00.900203003"));
            tslist.add(Timestamp.valueOf("2003-01-01 00:00:00.800000007"));
            tslist.add(Timestamp.valueOf("1996-08-02 00:00:00.723100809"));
            tslist.add(Timestamp.valueOf("1998-11-02 00:00:00.857340643"));
            tslist.add(Timestamp.valueOf("2008-10-02 00:00:00"));
            VectorizedRowBatch batch = new VectorizedRowBatch(1, 1024);
            LongColumnVector vec = new LongColumnVector(1024);
            batch.cols[0] = vec;
            batch.reset();
            batch.size = tslist.size();
            for (int i = 0; i < tslist.size(); ++i) {
                Timestamp ts = (Timestamp)tslist.get(i);
                vec.vector[i] = TimestampUtils.getTimeNanoSec((Timestamp)ts);
            }
            writer.addRowBatch(batch);
            writer.close();
            Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(this.fs));
            RecordReader rows = reader.rows(null);
            int idx = 0;
            while (rows.hasNext()) {
                Object row = rows.next(null);
                Assert.assertEquals((int)((Timestamp)tslist.get(idx++)).getNanos(), (int)((TimestampWritable)row).getNanos());
            }
            Assert.assertEquals((long)tslist.size(), (long)rows.getRowNumber());
            Assert.assertEquals((int)0, (int)writer.getSchema().getMaximumId());
            boolean[] expected = new boolean[]{false};
            boolean[] included = OrcUtils.includeColumns((String)"", (TypeDescription)writer.getSchema());
            Assert.assertEquals((boolean)true, (boolean)Arrays.equals(expected, included));
            return;
        }
    }

    @Test
    public void testStringAndBinaryStatistics() throws Exception {
        TypeDescription schema = TypeDescription.createStruct().addField("bytes1", TypeDescription.createBinary()).addField("string1", TypeDescription.createString());
        Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).setSchema(schema).stripeSize(100000L).bufferSize(10000));
        VectorizedRowBatch batch = schema.createRowBatch();
        batch.size = 4;
        BytesColumnVector field1 = (BytesColumnVector)batch.cols[0];
        BytesColumnVector field2 = (BytesColumnVector)batch.cols[1];
        field1.setVal(0, TestVectorOrcFile.bytesArray(0, 1, 2, 3, 4));
        field1.setVal(1, TestVectorOrcFile.bytesArray(0, 1, 2, 3));
        field1.setVal(2, TestVectorOrcFile.bytesArray(0, 1, 2, 3, 4, 5));
        field1.noNulls = false;
        field1.isNull[3] = true;
        field2.setVal(0, "foo".getBytes());
        field2.setVal(1, "bar".getBytes());
        field2.noNulls = false;
        field2.isNull[2] = true;
        field2.setVal(3, "hi".getBytes());
        writer.addRowBatch(batch);
        writer.close();
        schema = writer.getSchema();
        Assert.assertEquals((int)2, (int)schema.getMaximumId());
        Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(this.fs));
        boolean[] expected = new boolean[]{false, false, true};
        boolean[] included = OrcUtils.includeColumns((String)"string1", (TypeDescription)schema);
        Assert.assertEquals((boolean)true, (boolean)Arrays.equals(expected, included));
        expected = new boolean[]{false, false, false};
        included = OrcUtils.includeColumns((String)"", (TypeDescription)schema);
        Assert.assertEquals((boolean)true, (boolean)Arrays.equals(expected, included));
        expected = new boolean[]{false, false, false};
        included = OrcUtils.includeColumns(null, (TypeDescription)schema);
        Assert.assertEquals((boolean)true, (boolean)Arrays.equals(expected, included));
        ColumnStatistics[] stats = reader.getStatistics();
        Assert.assertEquals((long)4L, (long)stats[0].getNumberOfValues());
        Assert.assertEquals((String)"count: 4 hasNull: false", (String)stats[0].toString());
        Assert.assertEquals((long)3L, (long)stats[1].getNumberOfValues());
        Assert.assertEquals((long)15L, (long)((BinaryColumnStatistics)stats[1]).getSum());
        Assert.assertEquals((String)"count: 3 hasNull: true sum: 15", (String)stats[1].toString());
        Assert.assertEquals((long)3L, (long)stats[2].getNumberOfValues());
        Assert.assertEquals((String)"bar", (String)((StringColumnStatistics)stats[2]).getMinimum());
        Assert.assertEquals((String)"hi", (String)((StringColumnStatistics)stats[2]).getMaximum());
        Assert.assertEquals((long)8L, (long)((StringColumnStatistics)stats[2]).getSum());
        Assert.assertEquals((String)"count: 3 hasNull: true min: bar max: hi sum: 8", (String)stats[2].toString());
        StructObjectInspector readerInspector = (StructObjectInspector)reader.getObjectInspector();
        Assert.assertEquals((Object)ObjectInspector.Category.STRUCT, (Object)readerInspector.getCategory());
        Assert.assertEquals((String)"struct<bytes1:binary,string1:string>", (String)readerInspector.getTypeName());
        List fields = readerInspector.getAllStructFieldRefs();
        BinaryObjectInspector bi = (BinaryObjectInspector)readerInspector.getStructFieldRef("bytes1").getFieldObjectInspector();
        StringObjectInspector st = (StringObjectInspector)readerInspector.getStructFieldRef("string1").getFieldObjectInspector();
        RecordReader rows = reader.rows();
        Object row = rows.next(null);
        Assert.assertNotNull((Object)row);
        Assert.assertEquals((Object)TestVectorOrcFile.bytes(0, 1, 2, 3, 4), (Object)bi.getPrimitiveWritableObject(readerInspector.getStructFieldData(row, (StructField)fields.get(0))));
        Assert.assertEquals((String)"foo", (String)st.getPrimitiveJavaObject(readerInspector.getStructFieldData(row, (StructField)fields.get(1))));
        Assert.assertEquals((boolean)true, (boolean)rows.hasNext());
        row = rows.next(row);
        Assert.assertEquals((Object)TestVectorOrcFile.bytes(0, 1, 2, 3), (Object)bi.getPrimitiveWritableObject(readerInspector.getStructFieldData(row, (StructField)fields.get(0))));
        Assert.assertEquals((String)"bar", (String)st.getPrimitiveJavaObject(readerInspector.getStructFieldData(row, (StructField)fields.get(1))));
        Assert.assertEquals((boolean)true, (boolean)rows.hasNext());
        row = rows.next(row);
        Assert.assertEquals((Object)TestVectorOrcFile.bytes(0, 1, 2, 3, 4, 5), (Object)bi.getPrimitiveWritableObject(readerInspector.getStructFieldData(row, (StructField)fields.get(0))));
        Assert.assertNull((Object)st.getPrimitiveJavaObject(readerInspector.getStructFieldData(row, (StructField)fields.get(1))));
        Assert.assertEquals((boolean)true, (boolean)rows.hasNext());
        row = rows.next(row);
        Assert.assertNull((Object)bi.getPrimitiveWritableObject(readerInspector.getStructFieldData(row, (StructField)fields.get(0))));
        Assert.assertEquals((String)"hi", (String)st.getPrimitiveJavaObject(readerInspector.getStructFieldData(row, (StructField)fields.get(1))));
        Assert.assertEquals((boolean)false, (boolean)rows.hasNext());
        rows.close();
    }

    @Test
    public void testStripeLevelStats() throws Exception {
        TypeDescription schema = TypeDescription.createStruct().addField("int1", TypeDescription.createInt()).addField("string1", TypeDescription.createString());
        Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).setSchema(schema).stripeSize(100000L).bufferSize(10000));
        VectorizedRowBatch batch = schema.createRowBatch();
        batch.size = 1000;
        LongColumnVector field1 = (LongColumnVector)batch.cols[0];
        BytesColumnVector field2 = (BytesColumnVector)batch.cols[1];
        field1.isRepeating = true;
        field2.isRepeating = true;
        for (int b = 0; b < 11; ++b) {
            if (b >= 5) {
                if (b >= 10) {
                    field1.vector[0] = 3L;
                    field2.setVal(0, "three".getBytes());
                } else {
                    field1.vector[0] = 2L;
                    field2.setVal(0, "two".getBytes());
                }
            } else {
                field1.vector[0] = 1L;
                field2.setVal(0, "one".getBytes());
            }
            writer.addRowBatch(batch);
        }
        writer.close();
        Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(this.fs));
        schema = writer.getSchema();
        Assert.assertEquals((int)2, (int)schema.getMaximumId());
        boolean[] expected = new boolean[]{false, true, false};
        boolean[] included = OrcUtils.includeColumns((String)"int1", (TypeDescription)schema);
        Assert.assertEquals((boolean)true, (boolean)Arrays.equals(expected, included));
        List stats = reader.getStripeStatistics();
        int numStripes = stats.size();
        Assert.assertEquals((int)3, (int)numStripes);
        StripeStatistics ss1 = (StripeStatistics)stats.get(0);
        StripeStatistics ss2 = (StripeStatistics)stats.get(1);
        StripeStatistics ss3 = (StripeStatistics)stats.get(2);
        Assert.assertEquals((long)5000L, (long)ss1.getColumnStatistics()[0].getNumberOfValues());
        Assert.assertEquals((long)5000L, (long)ss2.getColumnStatistics()[0].getNumberOfValues());
        Assert.assertEquals((long)1000L, (long)ss3.getColumnStatistics()[0].getNumberOfValues());
        Assert.assertEquals((long)5000L, (long)ss1.getColumnStatistics()[1].getNumberOfValues());
        Assert.assertEquals((long)5000L, (long)ss2.getColumnStatistics()[1].getNumberOfValues());
        Assert.assertEquals((long)1000L, (long)ss3.getColumnStatistics()[1].getNumberOfValues());
        Assert.assertEquals((long)1L, (long)((IntegerColumnStatistics)ss1.getColumnStatistics()[1]).getMinimum());
        Assert.assertEquals((long)2L, (long)((IntegerColumnStatistics)ss2.getColumnStatistics()[1]).getMinimum());
        Assert.assertEquals((long)3L, (long)((IntegerColumnStatistics)ss3.getColumnStatistics()[1]).getMinimum());
        Assert.assertEquals((long)1L, (long)((IntegerColumnStatistics)ss1.getColumnStatistics()[1]).getMaximum());
        Assert.assertEquals((long)2L, (long)((IntegerColumnStatistics)ss2.getColumnStatistics()[1]).getMaximum());
        Assert.assertEquals((long)3L, (long)((IntegerColumnStatistics)ss3.getColumnStatistics()[1]).getMaximum());
        Assert.assertEquals((long)5000L, (long)((IntegerColumnStatistics)ss1.getColumnStatistics()[1]).getSum());
        Assert.assertEquals((long)10000L, (long)((IntegerColumnStatistics)ss2.getColumnStatistics()[1]).getSum());
        Assert.assertEquals((long)3000L, (long)((IntegerColumnStatistics)ss3.getColumnStatistics()[1]).getSum());
        Assert.assertEquals((long)5000L, (long)ss1.getColumnStatistics()[2].getNumberOfValues());
        Assert.assertEquals((long)5000L, (long)ss2.getColumnStatistics()[2].getNumberOfValues());
        Assert.assertEquals((long)1000L, (long)ss3.getColumnStatistics()[2].getNumberOfValues());
        Assert.assertEquals((String)"one", (String)((StringColumnStatistics)ss1.getColumnStatistics()[2]).getMinimum());
        Assert.assertEquals((String)"two", (String)((StringColumnStatistics)ss2.getColumnStatistics()[2]).getMinimum());
        Assert.assertEquals((String)"three", (String)((StringColumnStatistics)ss3.getColumnStatistics()[2]).getMinimum());
        Assert.assertEquals((String)"one", (String)((StringColumnStatistics)ss1.getColumnStatistics()[2]).getMaximum());
        Assert.assertEquals((String)"two", (String)((StringColumnStatistics)ss2.getColumnStatistics()[2]).getMaximum());
        Assert.assertEquals((String)"three", (String)((StringColumnStatistics)ss3.getColumnStatistics()[2]).getMaximum());
        Assert.assertEquals((long)15000L, (long)((StringColumnStatistics)ss1.getColumnStatistics()[2]).getSum());
        Assert.assertEquals((long)15000L, (long)((StringColumnStatistics)ss2.getColumnStatistics()[2]).getSum());
        Assert.assertEquals((long)5000L, (long)((StringColumnStatistics)ss3.getColumnStatistics()[2]).getSum());
        RecordReaderImpl recordReader = (RecordReaderImpl)reader.rows();
        OrcProto.RowIndex[] index = recordReader.readRowIndex(0, null, null).getRowGroupIndex();
        Assert.assertEquals((int)3, (int)index.length);
        List items = index[1].getEntryList();
        Assert.assertEquals((int)1, (int)items.size());
        Assert.assertEquals((int)3, (int)((OrcProto.RowIndexEntry)items.get(0)).getPositionsCount());
        Assert.assertEquals((long)0L, (long)((OrcProto.RowIndexEntry)items.get(0)).getPositions(0));
        Assert.assertEquals((long)0L, (long)((OrcProto.RowIndexEntry)items.get(0)).getPositions(1));
        Assert.assertEquals((long)0L, (long)((OrcProto.RowIndexEntry)items.get(0)).getPositions(2));
        Assert.assertEquals((long)1L, (long)((OrcProto.RowIndexEntry)items.get(0)).getStatistics().getIntStatistics().getMinimum());
        index = recordReader.readRowIndex(1, null, null).getRowGroupIndex();
        Assert.assertEquals((int)3, (int)index.length);
        items = index[1].getEntryList();
        Assert.assertEquals((long)2L, (long)((OrcProto.RowIndexEntry)items.get(0)).getStatistics().getIntStatistics().getMaximum());
    }

    private static void setInner(StructColumnVector inner, int rowId, int i, String value) {
        ((LongColumnVector)inner.fields[0]).vector[rowId] = i;
        if (value != null) {
            ((BytesColumnVector)inner.fields[1]).setVal(rowId, value.getBytes());
        } else {
            inner.fields[1].isNull[rowId] = true;
            inner.fields[1].noNulls = false;
        }
    }

    private static void setInnerList(ListColumnVector list, int rowId, List<InnerStruct> value) {
        if (value != null) {
            if (list.childCount + value.size() > list.child.isNull.length) {
                list.child.ensureSize(list.childCount * 2, true);
            }
            list.lengths[rowId] = value.size();
            list.offsets[rowId] = list.childCount;
            int i = 0;
            while ((long)i < list.lengths[rowId]) {
                InnerStruct inner = value.get(i);
                TestVectorOrcFile.setInner((StructColumnVector)list.child, i + list.childCount, inner.int1, inner.string1.toString());
                ++i;
            }
            list.childCount += value.size();
        } else {
            list.isNull[rowId] = true;
            list.noNulls = false;
        }
    }

    private static void setInnerMap(MapColumnVector map, int rowId, Map<String, InnerStruct> value) {
        if (value != null) {
            if (map.childCount >= map.keys.isNull.length) {
                map.keys.ensureSize(map.childCount * 2, true);
                map.values.ensureSize(map.childCount * 2, true);
            }
            map.lengths[rowId] = value.size();
            int offset = map.childCount;
            map.offsets[rowId] = offset;
            for (Map.Entry<String, InnerStruct> entry : value.entrySet()) {
                ((BytesColumnVector)map.keys).setVal(offset, entry.getKey().getBytes());
                InnerStruct inner = entry.getValue();
                TestVectorOrcFile.setInner((StructColumnVector)map.values, offset, inner.int1, inner.string1.toString());
                ++offset;
            }
            map.childCount = offset;
        } else {
            map.isNull[rowId] = true;
            map.noNulls = false;
        }
    }

    private static void setMiddleStruct(StructColumnVector middle, int rowId, MiddleStruct value) {
        if (value != null) {
            TestVectorOrcFile.setInnerList((ListColumnVector)middle.fields[0], rowId, value.list);
        } else {
            middle.isNull[rowId] = true;
            middle.noNulls = false;
        }
    }

    private static void setBigRow(VectorizedRowBatch batch, int rowId, Boolean b1, Byte b2, Short s1, Integer i1, Long l1, Float f1, Double d1, BytesWritable b3, String s2, MiddleStruct m1, List<InnerStruct> l2, Map<String, InnerStruct> m2) {
        ((LongColumnVector)batch.cols[0]).vector[rowId] = b1 != false ? 1L : 0L;
        ((LongColumnVector)batch.cols[1]).vector[rowId] = b2.byteValue();
        ((LongColumnVector)batch.cols[2]).vector[rowId] = s1.shortValue();
        ((LongColumnVector)batch.cols[3]).vector[rowId] = i1.intValue();
        ((LongColumnVector)batch.cols[4]).vector[rowId] = l1;
        ((DoubleColumnVector)batch.cols[5]).vector[rowId] = f1.floatValue();
        ((DoubleColumnVector)batch.cols[6]).vector[rowId] = d1;
        if (b3 != null) {
            ((BytesColumnVector)batch.cols[7]).setVal(rowId, b3.getBytes(), 0, b3.getLength());
        } else {
            batch.cols[7].isNull[rowId] = true;
            batch.cols[7].noNulls = false;
        }
        if (s2 != null) {
            ((BytesColumnVector)batch.cols[8]).setVal(rowId, s2.getBytes());
        } else {
            batch.cols[8].isNull[rowId] = true;
            batch.cols[8].noNulls = false;
        }
        TestVectorOrcFile.setMiddleStruct((StructColumnVector)batch.cols[9], rowId, m1);
        TestVectorOrcFile.setInnerList((ListColumnVector)batch.cols[10], rowId, l2);
        TestVectorOrcFile.setInnerMap((MapColumnVector)batch.cols[11], rowId, m2);
    }

    private static TypeDescription createInnerSchema() {
        return TypeDescription.createStruct().addField("int1", TypeDescription.createInt()).addField("string1", TypeDescription.createString());
    }

    private static TypeDescription createBigRowSchema() {
        return TypeDescription.createStruct().addField("boolean1", TypeDescription.createBoolean()).addField("byte1", TypeDescription.createByte()).addField("short1", TypeDescription.createShort()).addField("int1", TypeDescription.createInt()).addField("long1", TypeDescription.createLong()).addField("float1", TypeDescription.createFloat()).addField("double1", TypeDescription.createDouble()).addField("bytes1", TypeDescription.createBinary()).addField("string1", TypeDescription.createString()).addField("middle", TypeDescription.createStruct().addField("list", TypeDescription.createList((TypeDescription)TestVectorOrcFile.createInnerSchema()))).addField("list", TypeDescription.createList((TypeDescription)TestVectorOrcFile.createInnerSchema())).addField("map", TypeDescription.createMap((TypeDescription)TypeDescription.createString(), (TypeDescription)TestVectorOrcFile.createInnerSchema()));
    }

    static void assertArrayEquals(boolean[] expected, boolean[] actual) {
        Assert.assertEquals((int)expected.length, (int)actual.length);
        boolean diff = false;
        for (int i = 0; i < expected.length; ++i) {
            if (expected[i] == actual[i]) continue;
            System.out.println("Difference at " + i + " expected: " + expected[i] + " actual: " + actual[i]);
            diff = true;
        }
        Assert.assertEquals((boolean)false, (boolean)diff);
    }

    @Test
    public void test1() throws Exception {
        TypeDescription schema = TestVectorOrcFile.createBigRowSchema();
        Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).setSchema(schema).stripeSize(100000L).bufferSize(10000));
        VectorizedRowBatch batch = schema.createRowBatch();
        batch.size = 2;
        TestVectorOrcFile.setBigRow(batch, 0, false, (byte)1, (short)1024, 65536, Long.MAX_VALUE, Float.valueOf(1.0f), -15.0, TestVectorOrcFile.bytes(0, 1, 2, 3, 4), "hi", new MiddleStruct(TestVectorOrcFile.inner(1, "bye"), TestVectorOrcFile.inner(2, "sigh")), TestVectorOrcFile.list(TestVectorOrcFile.inner(3, "good"), TestVectorOrcFile.inner(4, "bad")), TestVectorOrcFile.map(new InnerStruct[0]));
        TestVectorOrcFile.setBigRow(batch, 1, true, (byte)100, (short)2048, 65536, Long.MAX_VALUE, Float.valueOf(2.0f), -5.0, TestVectorOrcFile.bytes(new int[0]), "bye", new MiddleStruct(TestVectorOrcFile.inner(1, "bye"), TestVectorOrcFile.inner(2, "sigh")), TestVectorOrcFile.list(TestVectorOrcFile.inner(100000000, "cat"), TestVectorOrcFile.inner(-100000, "in"), TestVectorOrcFile.inner(1234, "hat")), TestVectorOrcFile.map(TestVectorOrcFile.inner(5, "chani"), TestVectorOrcFile.inner(1, "mauddib")));
        writer.addRowBatch(batch);
        writer.close();
        Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(this.fs));
        schema = writer.getSchema();
        Assert.assertEquals((int)23, (int)schema.getMaximumId());
        boolean[] expected = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
        boolean[] included = OrcUtils.includeColumns((String)"", (TypeDescription)schema);
        Assert.assertEquals((boolean)true, (boolean)Arrays.equals(expected, included));
        expected = new boolean[]{false, true, false, false, false, false, false, false, false, true, true, true, true, true, true, false, false, false, false, true, true, true, true, true};
        included = OrcUtils.includeColumns((String)"boolean1,string1,middle,map", (TypeDescription)schema);
        TestVectorOrcFile.assertArrayEquals(expected, included);
        expected = new boolean[]{false, true, false, false, false, false, false, false, false, true, true, true, true, true, true, false, false, false, false, true, true, true, true, true};
        included = OrcUtils.includeColumns((String)"boolean1,string1,middle,map", (TypeDescription)schema);
        TestVectorOrcFile.assertArrayEquals(expected, included);
        expected = new boolean[]{false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true};
        included = OrcUtils.includeColumns((String)"boolean1,byte1,short1,int1,long1,float1,double1,bytes1,string1,middle,list,map", (TypeDescription)schema);
        Assert.assertEquals((boolean)true, (boolean)Arrays.equals(expected, included));
        ColumnStatistics[] stats = reader.getStatistics();
        Assert.assertEquals((long)2L, (long)stats[1].getNumberOfValues());
        Assert.assertEquals((long)1L, (long)((BooleanColumnStatistics)stats[1]).getFalseCount());
        Assert.assertEquals((long)1L, (long)((BooleanColumnStatistics)stats[1]).getTrueCount());
        Assert.assertEquals((String)"count: 2 hasNull: false true: 1", (String)stats[1].toString());
        Assert.assertEquals((long)2048L, (long)((IntegerColumnStatistics)stats[3]).getMaximum());
        Assert.assertEquals((long)1024L, (long)((IntegerColumnStatistics)stats[3]).getMinimum());
        Assert.assertEquals((boolean)true, (boolean)((IntegerColumnStatistics)stats[3]).isSumDefined());
        Assert.assertEquals((long)3072L, (long)((IntegerColumnStatistics)stats[3]).getSum());
        Assert.assertEquals((String)"count: 2 hasNull: false min: 1024 max: 2048 sum: 3072", (String)stats[3].toString());
        StripeStatistics ss = (StripeStatistics)reader.getStripeStatistics().get(0);
        Assert.assertEquals((long)2L, (long)ss.getColumnStatistics()[0].getNumberOfValues());
        Assert.assertEquals((long)1L, (long)((BooleanColumnStatistics)ss.getColumnStatistics()[1]).getTrueCount());
        Assert.assertEquals((long)1024L, (long)((IntegerColumnStatistics)ss.getColumnStatistics()[3]).getMinimum());
        Assert.assertEquals((long)2048L, (long)((IntegerColumnStatistics)ss.getColumnStatistics()[3]).getMaximum());
        Assert.assertEquals((long)3072L, (long)((IntegerColumnStatistics)ss.getColumnStatistics()[3]).getSum());
        Assert.assertEquals((Object)-15.0, (Object)((DoubleColumnStatistics)stats[7]).getMinimum());
        Assert.assertEquals((Object)-5.0, (Object)((DoubleColumnStatistics)stats[7]).getMaximum());
        Assert.assertEquals((double)-20.0, (double)((DoubleColumnStatistics)stats[7]).getSum(), (double)1.0E-5);
        Assert.assertEquals((String)"count: 2 hasNull: false min: -15.0 max: -5.0 sum: -20.0", (String)stats[7].toString());
        Assert.assertEquals((String)"count: 2 hasNull: false min: bye max: hi sum: 5", (String)stats[9].toString());
        StructObjectInspector readerInspector = (StructObjectInspector)reader.getObjectInspector();
        Assert.assertEquals((Object)ObjectInspector.Category.STRUCT, (Object)readerInspector.getCategory());
        Assert.assertEquals((String)"struct<boolean1:boolean,byte1:tinyint,short1:smallint,int1:int,long1:bigint,float1:float,double1:double,bytes1:binary,string1:string,middle:struct<list:array<struct<int1:int,string1:string>>>,list:array<struct<int1:int,string1:string>>,map:map<string,struct<int1:int,string1:string>>>", (String)readerInspector.getTypeName());
        List fields = readerInspector.getAllStructFieldRefs();
        BooleanObjectInspector bo = (BooleanObjectInspector)readerInspector.getStructFieldRef("boolean1").getFieldObjectInspector();
        ByteObjectInspector by = (ByteObjectInspector)readerInspector.getStructFieldRef("byte1").getFieldObjectInspector();
        ShortObjectInspector sh = (ShortObjectInspector)readerInspector.getStructFieldRef("short1").getFieldObjectInspector();
        IntObjectInspector in = (IntObjectInspector)readerInspector.getStructFieldRef("int1").getFieldObjectInspector();
        LongObjectInspector lo = (LongObjectInspector)readerInspector.getStructFieldRef("long1").getFieldObjectInspector();
        FloatObjectInspector fl = (FloatObjectInspector)readerInspector.getStructFieldRef("float1").getFieldObjectInspector();
        DoubleObjectInspector dbl = (DoubleObjectInspector)readerInspector.getStructFieldRef("double1").getFieldObjectInspector();
        BinaryObjectInspector bi = (BinaryObjectInspector)readerInspector.getStructFieldRef("bytes1").getFieldObjectInspector();
        StringObjectInspector st = (StringObjectInspector)readerInspector.getStructFieldRef("string1").getFieldObjectInspector();
        StructObjectInspector mid = (StructObjectInspector)readerInspector.getStructFieldRef("middle").getFieldObjectInspector();
        List midFields = mid.getAllStructFieldRefs();
        ListObjectInspector midli = (ListObjectInspector)((StructField)midFields.get(0)).getFieldObjectInspector();
        StructObjectInspector inner = (StructObjectInspector)midli.getListElementObjectInspector();
        List inFields = inner.getAllStructFieldRefs();
        ListObjectInspector li = (ListObjectInspector)readerInspector.getStructFieldRef("list").getFieldObjectInspector();
        MapObjectInspector ma = (MapObjectInspector)readerInspector.getStructFieldRef("map").getFieldObjectInspector();
        StringObjectInspector mk = (StringObjectInspector)ma.getMapKeyObjectInspector();
        RecordReader rows = reader.rows();
        Object row = rows.next(null);
        Assert.assertNotNull((Object)row);
        Assert.assertEquals((boolean)false, (boolean)bo.get(readerInspector.getStructFieldData(row, (StructField)fields.get(0))));
        Assert.assertEquals((int)1, (int)by.get(readerInspector.getStructFieldData(row, (StructField)fields.get(1))));
        Assert.assertEquals((int)1024, (int)sh.get(readerInspector.getStructFieldData(row, (StructField)fields.get(2))));
        Assert.assertEquals((int)65536, (int)in.get(readerInspector.getStructFieldData(row, (StructField)fields.get(3))));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)lo.get(readerInspector.getStructFieldData(row, (StructField)fields.get(4))));
        Assert.assertEquals((double)1.0, (double)fl.get(readerInspector.getStructFieldData(row, (StructField)fields.get(5))), (double)1.0E-5);
        Assert.assertEquals((double)-15.0, (double)dbl.get(readerInspector.getStructFieldData(row, (StructField)fields.get(6))), (double)1.0E-5);
        Assert.assertEquals((Object)TestVectorOrcFile.bytes(0, 1, 2, 3, 4), (Object)bi.getPrimitiveWritableObject(readerInspector.getStructFieldData(row, (StructField)fields.get(7))));
        Assert.assertEquals((String)"hi", (String)st.getPrimitiveJavaObject(readerInspector.getStructFieldData(row, (StructField)fields.get(8))));
        List midRow = midli.getList(mid.getStructFieldData(readerInspector.getStructFieldData(row, (StructField)fields.get(9)), (StructField)midFields.get(0)));
        Assert.assertNotNull((Object)midRow);
        Assert.assertEquals((int)2, (int)midRow.size());
        Assert.assertEquals((int)1, (int)in.get(inner.getStructFieldData(midRow.get(0), (StructField)inFields.get(0))));
        Assert.assertEquals((String)"bye", (String)st.getPrimitiveJavaObject(inner.getStructFieldData(midRow.get(0), (StructField)inFields.get(1))));
        Assert.assertEquals((int)2, (int)in.get(inner.getStructFieldData(midRow.get(1), (StructField)inFields.get(0))));
        Assert.assertEquals((String)"sigh", (String)st.getPrimitiveJavaObject(inner.getStructFieldData(midRow.get(1), (StructField)inFields.get(1))));
        List list = li.getList(readerInspector.getStructFieldData(row, (StructField)fields.get(10)));
        Assert.assertEquals((int)2, (int)list.size());
        Assert.assertEquals((int)3, (int)in.get(inner.getStructFieldData(list.get(0), (StructField)inFields.get(0))));
        Assert.assertEquals((String)"good", (String)st.getPrimitiveJavaObject(inner.getStructFieldData(list.get(0), (StructField)inFields.get(1))));
        Assert.assertEquals((int)4, (int)in.get(inner.getStructFieldData(list.get(1), (StructField)inFields.get(0))));
        Assert.assertEquals((String)"bad", (String)st.getPrimitiveJavaObject(inner.getStructFieldData(list.get(1), (StructField)inFields.get(1))));
        Map map = ma.getMap(readerInspector.getStructFieldData(row, (StructField)fields.get(11)));
        Assert.assertEquals((int)0, (int)map.size());
        Assert.assertEquals((boolean)true, (boolean)rows.hasNext());
        row = rows.next(row);
        Assert.assertEquals((boolean)true, (boolean)bo.get(readerInspector.getStructFieldData(row, (StructField)fields.get(0))));
        Assert.assertEquals((int)100, (int)by.get(readerInspector.getStructFieldData(row, (StructField)fields.get(1))));
        Assert.assertEquals((int)2048, (int)sh.get(readerInspector.getStructFieldData(row, (StructField)fields.get(2))));
        Assert.assertEquals((int)65536, (int)in.get(readerInspector.getStructFieldData(row, (StructField)fields.get(3))));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)lo.get(readerInspector.getStructFieldData(row, (StructField)fields.get(4))));
        Assert.assertEquals((double)2.0, (double)fl.get(readerInspector.getStructFieldData(row, (StructField)fields.get(5))), (double)1.0E-5);
        Assert.assertEquals((double)-5.0, (double)dbl.get(readerInspector.getStructFieldData(row, (StructField)fields.get(6))), (double)1.0E-5);
        Assert.assertEquals((Object)TestVectorOrcFile.bytes(new int[0]), (Object)bi.getPrimitiveWritableObject(readerInspector.getStructFieldData(row, (StructField)fields.get(7))));
        Assert.assertEquals((String)"bye", (String)st.getPrimitiveJavaObject(readerInspector.getStructFieldData(row, (StructField)fields.get(8))));
        midRow = midli.getList(mid.getStructFieldData(readerInspector.getStructFieldData(row, (StructField)fields.get(9)), (StructField)midFields.get(0)));
        Assert.assertNotNull((Object)midRow);
        Assert.assertEquals((int)2, (int)midRow.size());
        Assert.assertEquals((int)1, (int)in.get(inner.getStructFieldData(midRow.get(0), (StructField)inFields.get(0))));
        Assert.assertEquals((String)"bye", (String)st.getPrimitiveJavaObject(inner.getStructFieldData(midRow.get(0), (StructField)inFields.get(1))));
        Assert.assertEquals((int)2, (int)in.get(inner.getStructFieldData(midRow.get(1), (StructField)inFields.get(0))));
        Assert.assertEquals((String)"sigh", (String)st.getPrimitiveJavaObject(inner.getStructFieldData(midRow.get(1), (StructField)inFields.get(1))));
        list = li.getList(readerInspector.getStructFieldData(row, (StructField)fields.get(10)));
        Assert.assertEquals((int)3, (int)list.size());
        Assert.assertEquals((int)100000000, (int)in.get(inner.getStructFieldData(list.get(0), (StructField)inFields.get(0))));
        Assert.assertEquals((String)"cat", (String)st.getPrimitiveJavaObject(inner.getStructFieldData(list.get(0), (StructField)inFields.get(1))));
        Assert.assertEquals((int)-100000, (int)in.get(inner.getStructFieldData(list.get(1), (StructField)inFields.get(0))));
        Assert.assertEquals((String)"in", (String)st.getPrimitiveJavaObject(inner.getStructFieldData(list.get(1), (StructField)inFields.get(1))));
        Assert.assertEquals((int)1234, (int)in.get(inner.getStructFieldData(list.get(2), (StructField)inFields.get(0))));
        Assert.assertEquals((String)"hat", (String)st.getPrimitiveJavaObject(inner.getStructFieldData(list.get(2), (StructField)inFields.get(1))));
        map = ma.getMap(readerInspector.getStructFieldData(row, (StructField)fields.get(11)));
        Assert.assertEquals((int)2, (int)map.size());
        boolean[] found = new boolean[2];
        for (Object key : map.keySet()) {
            String str = mk.getPrimitiveJavaObject(key);
            if (str.equals("chani")) {
                Assert.assertEquals((boolean)false, (boolean)found[0]);
                Assert.assertEquals((int)5, (int)in.get(inner.getStructFieldData(map.get(key), (StructField)inFields.get(0))));
                Assert.assertEquals((String)str, (String)st.getPrimitiveJavaObject(inner.getStructFieldData(map.get(key), (StructField)inFields.get(1))));
                found[0] = true;
                continue;
            }
            if (str.equals("mauddib")) {
                Assert.assertEquals((boolean)false, (boolean)found[1]);
                Assert.assertEquals((int)1, (int)in.get(inner.getStructFieldData(map.get(key), (StructField)inFields.get(0))));
                Assert.assertEquals((String)str, (String)st.getPrimitiveJavaObject(inner.getStructFieldData(map.get(key), (StructField)inFields.get(1))));
                found[1] = true;
                continue;
            }
            throw new IllegalArgumentException("Unknown key " + str);
        }
        Assert.assertEquals((boolean)true, (boolean)found[0]);
        Assert.assertEquals((boolean)true, (boolean)found[1]);
        Assert.assertEquals((boolean)false, (boolean)rows.hasNext());
        rows.close();
    }

    @Test
    public void testColumnProjection() throws Exception {
        TypeDescription schema = TestVectorOrcFile.createInnerSchema();
        Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).setSchema(schema).stripeSize(1000L).compress(CompressionKind.NONE).bufferSize(100).rowIndexStride(1000));
        VectorizedRowBatch batch = schema.createRowBatch();
        Random r1 = new Random(1L);
        Random r2 = new Random(2L);
        int minInt = 0;
        int maxInt = 0;
        String minStr = null;
        String maxStr = null;
        batch.size = 1000;
        boolean first = true;
        for (int b = 0; b < 21; ++b) {
            for (int r = 0; r < 1000; ++r) {
                int x = r1.nextInt();
                String y = Long.toHexString(r2.nextLong());
                if (first || x < minInt) {
                    minInt = x;
                }
                if (first || x > maxInt) {
                    maxInt = x;
                }
                if (first || y.compareTo(minStr) < 0) {
                    minStr = y;
                }
                if (first || y.compareTo(maxStr) > 0) {
                    maxStr = y;
                }
                first = false;
                ((LongColumnVector)batch.cols[0]).vector[r] = x;
                ((BytesColumnVector)batch.cols[1]).setVal(r, y.getBytes());
            }
            writer.addRowBatch(batch);
        }
        writer.close();
        Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(this.fs));
        ColumnStatistics[] stats = reader.getStatistics();
        Assert.assertEquals((int)3, (int)stats.length);
        for (ColumnStatistics s : stats) {
            Assert.assertEquals((long)21000L, (long)s.getNumberOfValues());
            if (s instanceof IntegerColumnStatistics) {
                Assert.assertEquals((long)minInt, (long)((IntegerColumnStatistics)s).getMinimum());
                Assert.assertEquals((long)maxInt, (long)((IntegerColumnStatistics)s).getMaximum());
                continue;
            }
            if (!(s instanceof StringColumnStatistics)) continue;
            Assert.assertEquals((String)maxStr, (String)((StringColumnStatistics)s).getMaximum());
            Assert.assertEquals((String)minStr, (String)((StringColumnStatistics)s).getMinimum());
        }
        List types = reader.getTypes();
        Assert.assertEquals((int)3, (int)types.size());
        Assert.assertEquals((Object)OrcProto.Type.Kind.STRUCT, (Object)((OrcProto.Type)types.get(0)).getKind());
        Assert.assertEquals((int)2, (int)((OrcProto.Type)types.get(0)).getSubtypesCount());
        Assert.assertEquals((int)1, (int)((OrcProto.Type)types.get(0)).getSubtypes(0));
        Assert.assertEquals((int)2, (int)((OrcProto.Type)types.get(0)).getSubtypes(1));
        Assert.assertEquals((Object)OrcProto.Type.Kind.INT, (Object)((OrcProto.Type)types.get(1)).getKind());
        Assert.assertEquals((int)0, (int)((OrcProto.Type)types.get(1)).getSubtypesCount());
        Assert.assertEquals((Object)OrcProto.Type.Kind.STRING, (Object)((OrcProto.Type)types.get(2)).getKind());
        Assert.assertEquals((int)0, (int)((OrcProto.Type)types.get(2)).getSubtypesCount());
        RecordReader rows1 = reader.rows(new boolean[]{true, true, false});
        RecordReader rows2 = reader.rows(new boolean[]{true, false, true});
        r1 = new Random(1L);
        r2 = new Random(2L);
        OrcStruct row1 = null;
        OrcStruct row2 = null;
        for (int i = 0; i < 21000; ++i) {
            Assert.assertEquals((boolean)true, (boolean)rows1.hasNext());
            Assert.assertEquals((boolean)true, (boolean)rows2.hasNext());
            row1 = (OrcStruct)rows1.next(row1);
            row2 = (OrcStruct)rows2.next(row2);
            Assert.assertEquals((int)r1.nextInt(), (int)((IntWritable)row1.getFieldValue(0)).get());
            Assert.assertEquals((String)Long.toHexString(r2.nextLong()), (String)row2.getFieldValue(1).toString());
        }
        Assert.assertEquals((boolean)false, (boolean)rows1.hasNext());
        Assert.assertEquals((boolean)false, (boolean)rows2.hasNext());
        rows1.close();
        rows2.close();
    }

    @Test
    public void testEmptyFile() throws Exception {
        TypeDescription schema = TestVectorOrcFile.createBigRowSchema();
        Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).setSchema(schema).stripeSize(1000L).compress(CompressionKind.NONE).bufferSize(100));
        writer.close();
        Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(this.fs));
        Assert.assertEquals((boolean)false, (boolean)reader.rows().hasNext());
        Assert.assertEquals((Object)CompressionKind.NONE, (Object)reader.getCompressionKind());
        Assert.assertEquals((long)0L, (long)reader.getNumberOfRows());
        Assert.assertEquals((int)0, (int)reader.getCompressionSize());
        Assert.assertEquals((boolean)false, (boolean)reader.getMetadataKeys().iterator().hasNext());
        Assert.assertEquals((long)3L, (long)reader.getContentLength());
        Assert.assertEquals((boolean)false, (boolean)reader.getStripes().iterator().hasNext());
    }

    @Test
    public void metaData() throws Exception {
        TypeDescription schema = TestVectorOrcFile.createBigRowSchema();
        Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).setSchema(schema).stripeSize(1000L).compress(CompressionKind.NONE).bufferSize(100));
        writer.addUserMetadata("my.meta", TestVectorOrcFile.byteBuf(1, 2, 3, 4, 5, 6, 7, -1, -2, 127, -128));
        writer.addUserMetadata("clobber", TestVectorOrcFile.byteBuf(1, 2, 3));
        writer.addUserMetadata("clobber", TestVectorOrcFile.byteBuf(4, 3, 2, 1));
        ByteBuffer bigBuf = ByteBuffer.allocate(40000);
        Random random = new Random(0L);
        random.nextBytes(bigBuf.array());
        writer.addUserMetadata("big", bigBuf);
        bigBuf.position(0);
        VectorizedRowBatch batch = schema.createRowBatch();
        batch.size = 1;
        TestVectorOrcFile.setBigRow(batch, 0, true, (byte)127, (short)1024, 42, 0xA80000000L, Float.valueOf(3.1415f), -2.713, null, null, null, null, null);
        writer.addRowBatch(batch);
        writer.addUserMetadata("clobber", TestVectorOrcFile.byteBuf(5, 7, 11, 13, 17, 19));
        writer.close();
        Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(this.fs));
        Assert.assertEquals((Object)TestVectorOrcFile.byteBuf(5, 7, 11, 13, 17, 19), (Object)reader.getMetadataValue("clobber"));
        Assert.assertEquals((Object)TestVectorOrcFile.byteBuf(1, 2, 3, 4, 5, 6, 7, -1, -2, 127, -128), (Object)reader.getMetadataValue("my.meta"));
        Assert.assertEquals((Object)bigBuf, (Object)reader.getMetadataValue("big"));
        try {
            reader.getMetadataValue("unknown");
            Assert.assertTrue((boolean)false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        int i = 0;
        for (String key : reader.getMetadataKeys()) {
            if ("my.meta".equals(key) || "clobber".equals(key) || "big".equals(key)) {
                ++i;
                continue;
            }
            throw new IllegalArgumentException("unknown key " + key);
        }
        Assert.assertEquals((int)3, (int)i);
        int numStripes = reader.getStripeStatistics().size();
        Assert.assertEquals((int)1, (int)numStripes);
    }

    public void createOrcDateFile(Path file, int minYear, int maxYear) throws IOException {
        TypeDescription schema = TypeDescription.createStruct().addField("time", TypeDescription.createTimestamp()).addField("date", TypeDescription.createDate());
        Writer writer = OrcFile.createWriter((Path)file, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).setSchema(schema).stripeSize(100000L).bufferSize(10000).blockPadding(false));
        VectorizedRowBatch batch = schema.createRowBatch();
        batch.size = 1000;
        for (int year = minYear; year < maxYear; ++year) {
            for (int ms = 1000; ms < 2000; ++ms) {
                ((LongColumnVector)batch.cols[0]).vector[ms - 1000] = TimestampUtils.getTimeNanoSec((Timestamp)Timestamp.valueOf(year + "-05-05 12:34:56." + ms));
                ((LongColumnVector)batch.cols[1]).vector[ms - 1000] = new DateWritable(new Date(year - 1900, 11, 25)).getDays();
            }
            writer.addRowBatch(batch);
        }
        writer.close();
        Reader reader = OrcFile.createReader((Path)file, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf));
        RecordReader rows = reader.rows();
        OrcStruct row = null;
        for (int year = minYear; year < maxYear; ++year) {
            for (int ms = 1000; ms < 2000; ++ms) {
                row = (OrcStruct)rows.next(row);
                Assert.assertEquals((Object)new TimestampWritable(Timestamp.valueOf(year + "-05-05 12:34:56." + ms)), (Object)row.getFieldValue(0));
                Assert.assertEquals((Object)new DateWritable(new Date(year - 1900, 11, 25)), (Object)row.getFieldValue(1));
            }
        }
    }

    @Test
    public void testDate1900() throws Exception {
        this.createOrcDateFile(this.testFilePath, 1900, 1970);
    }

    @Test
    public void testDate2038() throws Exception {
        this.createOrcDateFile(this.testFilePath, 2038, 2250);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void setUnion(VectorizedRowBatch batch, int rowId, Timestamp ts, Integer tag, Integer i, String s, HiveDecimalWritable dec) {
        UnionColumnVector union = (UnionColumnVector)batch.cols[1];
        if (ts != null) {
            ((LongColumnVector)batch.cols[0]).vector[rowId] = TimestampUtils.getTimeNanoSec((Timestamp)ts);
        } else {
            batch.cols[0].isNull[rowId] = true;
            batch.cols[0].noNulls = false;
        }
        if (tag != null) {
            union.tags[rowId] = tag;
            if (tag == 0) {
                if (i != null) {
                    ((LongColumnVector)union.fields[tag.intValue()]).vector[rowId] = i.intValue();
                } else {
                    union.fields[tag.intValue()].isNull[rowId] = true;
                    union.fields[tag.intValue()].noNulls = false;
                }
            } else {
                if (tag != 1) throw new IllegalArgumentException("Bad tag " + tag);
                if (s != null) {
                    ((BytesColumnVector)union.fields[tag]).setVal(rowId, s.getBytes());
                } else {
                    union.fields[tag.intValue()].isNull[rowId] = true;
                    union.fields[tag.intValue()].noNulls = false;
                }
            }
        } else {
            batch.cols[1].isNull[rowId] = true;
            batch.cols[1].noNulls = false;
        }
        if (dec != null) {
            ((DecimalColumnVector)batch.cols[2]).vector[rowId] = dec;
            return;
        } else {
            batch.cols[2].isNull[rowId] = true;
            batch.cols[2].noNulls = false;
        }
    }

    @Test
    public void testUnionAndTimestamp() throws Exception {
        int i;
        int i2;
        TypeDescription schema = TypeDescription.createStruct().addField("time", TypeDescription.createTimestamp()).addField("union", TypeDescription.createUnion().addUnionChild(TypeDescription.createInt()).addUnionChild(TypeDescription.createString())).addField("decimal", TypeDescription.createDecimal().withPrecision(38).withScale(18));
        HiveDecimal maxValue = HiveDecimal.create((String)"10000000000000000000");
        Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).setSchema(schema).stripeSize(1000L).compress(CompressionKind.NONE).bufferSize(100).blockPadding(false));
        VectorizedRowBatch batch = schema.createRowBatch();
        batch.size = 6;
        TestVectorOrcFile.setUnion(batch, 0, Timestamp.valueOf("2000-03-12 15:00:00"), 0, 42, null, new HiveDecimalWritable("12345678.6547456"));
        TestVectorOrcFile.setUnion(batch, 1, Timestamp.valueOf("2000-03-20 12:00:00.123456789"), 1, null, "hello", new HiveDecimalWritable("-5643.234"));
        TestVectorOrcFile.setUnion(batch, 2, null, null, null, null, null);
        TestVectorOrcFile.setUnion(batch, 3, null, 0, null, null, null);
        TestVectorOrcFile.setUnion(batch, 4, null, 1, null, null, null);
        TestVectorOrcFile.setUnion(batch, 5, Timestamp.valueOf("1970-01-01 00:00:00"), 0, 200000, null, new HiveDecimalWritable("10000000000000000000"));
        writer.addRowBatch(batch);
        batch.reset();
        Random rand = new Random(42L);
        for (i2 = 1970; i2 < 2038; ++i2) {
            Timestamp ts = Timestamp.valueOf(i2 + "-05-05 12:34:56." + i2);
            HiveDecimal dec = HiveDecimal.create((BigInteger)new BigInteger(64, rand), (int)rand.nextInt(18));
            if ((i2 & 1) == 0) {
                TestVectorOrcFile.setUnion(batch, batch.size++, ts, 0, i2 * i2, null, new HiveDecimalWritable(dec));
            } else {
                TestVectorOrcFile.setUnion(batch, batch.size++, ts, 1, null, Integer.toString(i2 * i2), new HiveDecimalWritable(dec));
            }
            if (maxValue.compareTo(dec) >= 0) continue;
            maxValue = dec;
        }
        writer.addRowBatch(batch);
        batch.reset();
        batch.size = 1000;
        for (int c = 0; c < batch.cols.length; ++c) {
            batch.cols[c].setRepeating(true);
        }
        TestVectorOrcFile.setUnion(batch, 0, null, 0, 1732050807, null, null);
        for (i2 = 0; i2 < 5; ++i2) {
            writer.addRowBatch(batch);
        }
        batch.reset();
        batch.size = 3;
        TestVectorOrcFile.setUnion(batch, 0, null, 0, 0, null, null);
        TestVectorOrcFile.setUnion(batch, 1, null, 0, 10, null, null);
        TestVectorOrcFile.setUnion(batch, 2, null, 0, 138, null, null);
        writer.addRowBatch(batch);
        writer.close();
        Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(this.fs));
        schema = writer.getSchema();
        Assert.assertEquals((int)5, (int)schema.getMaximumId());
        boolean[] expected = new boolean[]{false, false, false, false, false, false};
        boolean[] included = OrcUtils.includeColumns((String)"", (TypeDescription)schema);
        Assert.assertEquals((boolean)true, (boolean)Arrays.equals(expected, included));
        expected = new boolean[]{false, true, false, false, false, true};
        included = OrcUtils.includeColumns((String)"time,decimal", (TypeDescription)schema);
        Assert.assertEquals((boolean)true, (boolean)Arrays.equals(expected, included));
        expected = new boolean[]{false, false, true, true, true, false};
        included = OrcUtils.includeColumns((String)"union", (TypeDescription)schema);
        Assert.assertEquals((boolean)true, (boolean)Arrays.equals(expected, included));
        Assert.assertEquals((boolean)false, (boolean)reader.getMetadataKeys().iterator().hasNext());
        Assert.assertEquals((long)5077L, (long)reader.getNumberOfRows());
        DecimalColumnStatistics stats = (DecimalColumnStatistics)reader.getStatistics()[5];
        Assert.assertEquals((long)71L, (long)stats.getNumberOfValues());
        Assert.assertEquals((Object)HiveDecimal.create((String)"-5643.234"), (Object)stats.getMinimum());
        Assert.assertEquals((Object)maxValue, (Object)stats.getMaximum());
        int stripeCount = 0;
        int rowCount = 0;
        long currentOffset = -1L;
        for (StripeInformation stripe : reader.getStripes()) {
            ++stripeCount;
            rowCount = (int)((long)rowCount + stripe.getNumberOfRows());
            if (currentOffset < 0L) {
                currentOffset = stripe.getOffset() + stripe.getLength();
                continue;
            }
            Assert.assertEquals((long)currentOffset, (long)stripe.getOffset());
            currentOffset += stripe.getLength();
        }
        Assert.assertEquals((long)reader.getNumberOfRows(), (long)rowCount);
        Assert.assertEquals((int)2, (int)stripeCount);
        Assert.assertEquals((long)reader.getContentLength(), (long)currentOffset);
        RecordReader rows = reader.rows();
        Assert.assertEquals((long)0L, (long)rows.getRowNumber());
        Assert.assertEquals((double)0.0, (double)rows.getProgress(), (double)1.0E-6);
        Assert.assertEquals((boolean)true, (boolean)rows.hasNext());
        OrcStruct row = (OrcStruct)rows.next(null);
        Assert.assertEquals((long)1L, (long)rows.getRowNumber());
        ObjectInspector inspector = reader.getObjectInspector();
        Assert.assertEquals((String)"struct<time:timestamp,union:uniontype<int,string>,decimal:decimal(38,18)>", (String)inspector.getTypeName());
        Assert.assertEquals((Object)new TimestampWritable(Timestamp.valueOf("2000-03-12 15:00:00")), (Object)row.getFieldValue(0));
        OrcUnion union = (OrcUnion)row.getFieldValue(1);
        Assert.assertEquals((int)0, (int)union.getTag());
        Assert.assertEquals((Object)new IntWritable(42), (Object)union.getObject());
        Assert.assertEquals((Object)new HiveDecimalWritable(HiveDecimal.create((String)"12345678.6547456")), (Object)row.getFieldValue(2));
        row = (OrcStruct)rows.next((Object)row);
        Assert.assertEquals((long)2L, (long)rows.getRowNumber());
        Assert.assertEquals((Object)new TimestampWritable(Timestamp.valueOf("2000-03-20 12:00:00.123456789")), (Object)row.getFieldValue(0));
        Assert.assertEquals((int)1, (int)union.getTag());
        Assert.assertEquals((Object)new Text("hello"), (Object)union.getObject());
        Assert.assertEquals((Object)new HiveDecimalWritable(HiveDecimal.create((String)"-5643.234")), (Object)row.getFieldValue(2));
        row = (OrcStruct)rows.next((Object)row);
        Assert.assertEquals(null, (Object)row.getFieldValue(0));
        Assert.assertEquals(null, (Object)row.getFieldValue(1));
        Assert.assertEquals(null, (Object)row.getFieldValue(2));
        row = (OrcStruct)rows.next((Object)row);
        Assert.assertEquals(null, (Object)row.getFieldValue(0));
        union = (OrcUnion)row.getFieldValue(1);
        Assert.assertEquals((int)0, (int)union.getTag());
        Assert.assertEquals(null, (Object)union.getObject());
        Assert.assertEquals(null, (Object)row.getFieldValue(2));
        row = (OrcStruct)rows.next((Object)row);
        Assert.assertEquals(null, (Object)row.getFieldValue(0));
        Assert.assertEquals((int)1, (int)union.getTag());
        Assert.assertEquals(null, (Object)union.getObject());
        Assert.assertEquals(null, (Object)row.getFieldValue(2));
        row = (OrcStruct)rows.next((Object)row);
        Assert.assertEquals((Object)new TimestampWritable(Timestamp.valueOf("1970-01-01 00:00:00")), (Object)row.getFieldValue(0));
        Assert.assertEquals((Object)new IntWritable(200000), (Object)union.getObject());
        Assert.assertEquals((Object)new HiveDecimalWritable(HiveDecimal.create((String)"10000000000000000000")), (Object)row.getFieldValue(2));
        rand = new Random(42L);
        for (i = 1970; i < 2038; ++i) {
            row = (OrcStruct)rows.next((Object)row);
            Assert.assertEquals((Object)new TimestampWritable(Timestamp.valueOf(i + "-05-05 12:34:56." + i)), (Object)row.getFieldValue(0));
            if ((i & 1) == 0) {
                Assert.assertEquals((int)0, (int)union.getTag());
                Assert.assertEquals((Object)new IntWritable(i * i), (Object)union.getObject());
            } else {
                Assert.assertEquals((int)1, (int)union.getTag());
                Assert.assertEquals((Object)new Text(Integer.toString(i * i)), (Object)union.getObject());
            }
            Assert.assertEquals((Object)new HiveDecimalWritable(HiveDecimal.create((BigInteger)new BigInteger(64, rand), (int)rand.nextInt(18))), (Object)row.getFieldValue(2));
        }
        for (i = 0; i < 5000; ++i) {
            row = (OrcStruct)rows.next((Object)row);
            Assert.assertEquals((Object)new IntWritable(1732050807), (Object)union.getObject());
        }
        row = (OrcStruct)rows.next((Object)row);
        Assert.assertEquals((Object)new IntWritable(0), (Object)union.getObject());
        row = (OrcStruct)rows.next((Object)row);
        Assert.assertEquals((Object)new IntWritable(10), (Object)union.getObject());
        row = (OrcStruct)rows.next((Object)row);
        Assert.assertEquals((Object)new IntWritable(138), (Object)union.getObject());
        Assert.assertEquals((boolean)false, (boolean)rows.hasNext());
        Assert.assertEquals((double)1.0, (double)rows.getProgress(), (double)1.0E-5);
        Assert.assertEquals((long)reader.getNumberOfRows(), (long)rows.getRowNumber());
        rows.seekToRow(1L);
        row = (OrcStruct)rows.next((Object)row);
        Assert.assertEquals((Object)new TimestampWritable(Timestamp.valueOf("2000-03-20 12:00:00.123456789")), (Object)row.getFieldValue(0));
        Assert.assertEquals((int)1, (int)union.getTag());
        Assert.assertEquals((Object)new Text("hello"), (Object)union.getObject());
        Assert.assertEquals((Object)new HiveDecimalWritable(HiveDecimal.create((String)"-5643.234")), (Object)row.getFieldValue(2));
        rows.close();
    }

    @Test
    public void testSnappy() throws Exception {
        TypeDescription schema = TestVectorOrcFile.createInnerSchema();
        Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).setSchema(schema).stripeSize(1000L).compress(CompressionKind.SNAPPY).bufferSize(100));
        VectorizedRowBatch batch = schema.createRowBatch();
        Random rand = new Random(12L);
        batch.size = 1000;
        for (int b = 0; b < 10; ++b) {
            for (int r = 0; r < 1000; ++r) {
                ((LongColumnVector)batch.cols[0]).vector[r] = rand.nextInt();
                ((BytesColumnVector)batch.cols[1]).setVal(r, Integer.toHexString(rand.nextInt()).getBytes());
            }
            writer.addRowBatch(batch);
        }
        writer.close();
        Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(this.fs));
        RecordReader rows = reader.rows();
        rand = new Random(12L);
        OrcStruct row = null;
        for (int i = 0; i < 10000; ++i) {
            Assert.assertEquals((boolean)true, (boolean)rows.hasNext());
            row = (OrcStruct)rows.next(row);
            Assert.assertEquals((int)rand.nextInt(), (int)((IntWritable)row.getFieldValue(0)).get());
            Assert.assertEquals((String)Integer.toHexString(rand.nextInt()), (String)row.getFieldValue(1).toString());
        }
        Assert.assertEquals((boolean)false, (boolean)rows.hasNext());
        rows.close();
    }

    @Test
    public void testWithoutIndex() throws Exception {
        TypeDescription schema = TestVectorOrcFile.createInnerSchema();
        Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).setSchema(schema).stripeSize(5000L).compress(CompressionKind.SNAPPY).bufferSize(1000).rowIndexStride(0));
        VectorizedRowBatch batch = schema.createRowBatch();
        Random rand = new Random(24L);
        batch.size = 5;
        for (int c = 0; c < batch.cols.length; ++c) {
            batch.cols[c].setRepeating(true);
        }
        for (int i = 0; i < 10000; ++i) {
            ((LongColumnVector)batch.cols[0]).vector[0] = rand.nextInt();
            ((BytesColumnVector)batch.cols[1]).setVal(0, Integer.toBinaryString(rand.nextInt()).getBytes());
            writer.addRowBatch(batch);
        }
        writer.close();
        Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(this.fs));
        Assert.assertEquals((long)50000L, (long)reader.getNumberOfRows());
        Assert.assertEquals((int)0, (int)reader.getRowIndexStride());
        StripeInformation stripe = (StripeInformation)reader.getStripes().iterator().next();
        Assert.assertEquals((boolean)true, (stripe.getDataLength() != 0L ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)stripe.getIndexLength());
        RecordReader rows = reader.rows();
        rand = new Random(24L);
        OrcStruct row = null;
        for (int i = 0; i < 10000; ++i) {
            int intVal = rand.nextInt();
            String strVal = Integer.toBinaryString(rand.nextInt());
            for (int j = 0; j < 5; ++j) {
                Assert.assertEquals((boolean)true, (boolean)rows.hasNext());
                row = (OrcStruct)rows.next(row);
                Assert.assertEquals((int)intVal, (int)((IntWritable)row.getFieldValue(0)).get());
                Assert.assertEquals((String)strVal, (String)row.getFieldValue(1).toString());
            }
        }
        Assert.assertEquals((boolean)false, (boolean)rows.hasNext());
        rows.close();
    }

    @Test
    public void testSeek() throws Exception {
        int i;
        TypeDescription schema = TestVectorOrcFile.createBigRowSchema();
        Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).setSchema(schema).stripeSize(200000L).bufferSize(65536).rowIndexStride(1000));
        VectorizedRowBatch batch = schema.createRowBatch();
        Random rand = new Random(42L);
        int COUNT = 32768;
        long[] intValues = new long[32768];
        double[] doubleValues = new double[32768];
        String[] stringValues = new String[32768];
        BytesWritable[] byteValues = new BytesWritable[32768];
        String[] words = new String[128];
        for (i = 0; i < words.length; ++i) {
            words[i] = Integer.toHexString(rand.nextInt());
        }
        for (i = 0; i < 16384; ++i) {
            intValues[2 * i] = rand.nextLong();
            intValues[2 * i + 1] = intValues[2 * i];
            stringValues[2 * i] = words[rand.nextInt(words.length)];
            stringValues[2 * i + 1] = stringValues[2 * i];
        }
        for (i = 0; i < 32768; ++i) {
            doubleValues[i] = rand.nextDouble();
            byte[] buf = new byte[20];
            rand.nextBytes(buf);
            byteValues[i] = new BytesWritable(buf);
        }
        for (i = 0; i < 32768; ++i) {
            this.appendRandomRow(batch, intValues, doubleValues, stringValues, byteValues, words, i);
            if (batch.size != 1024) continue;
            writer.addRowBatch(batch);
            batch.reset();
        }
        if (batch.size != 0) {
            writer.addRowBatch(batch);
        }
        writer.close();
        Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(this.fs));
        Assert.assertEquals((long)32768L, (long)reader.getNumberOfRows());
        RecordReader rows = reader.rows();
        MetadataReader meta = ((RecordReaderImpl)rows).getMetadataReader();
        OrcIndex index = meta.readRowIndex((StripeInformation)reader.getStripes().get(0), null, null, null, null, null);
        for (int c = 1; c < 9; ++c) {
            OrcProto.RowIndex colIndex = index.getRowGroupIndex()[c];
            Assert.assertEquals((long)1000L, (long)colIndex.getEntry(0).getStatistics().getNumberOfValues());
        }
        OrcStruct row = null;
        for (int i2 = Short.MAX_VALUE; i2 >= 0; --i2) {
            rows.seekToRow((long)i2);
            row = (OrcStruct)rows.next(row);
            BigRow expected = this.createRandomRow(intValues, doubleValues, stringValues, byteValues, words, i2);
            Assert.assertEquals((boolean)expected.boolean1, (boolean)((BooleanWritable)row.getFieldValue(0)).get());
            Assert.assertEquals((byte)expected.byte1, (byte)((ByteWritable)row.getFieldValue(1)).get());
            Assert.assertEquals((short)expected.short1, (short)((ShortWritable)row.getFieldValue(2)).get());
            Assert.assertEquals((int)expected.int1, (int)((IntWritable)row.getFieldValue(3)).get());
            Assert.assertEquals((long)expected.long1, (long)((LongWritable)row.getFieldValue(4)).get());
            Assert.assertEquals((double)expected.float1.floatValue(), (double)((FloatWritable)row.getFieldValue(5)).get(), (double)1.0E-4);
            Assert.assertEquals((double)expected.double1, (double)((DoubleWritable)row.getFieldValue(6)).get(), (double)1.0E-4);
            Assert.assertEquals((Object)expected.bytes1, (Object)row.getFieldValue(7));
            Assert.assertEquals((Object)expected.string1, (Object)row.getFieldValue(8));
            List<InnerStruct> expectedList = expected.middle.list;
            List actualList = (List)((OrcStruct)row.getFieldValue(9)).getFieldValue(0);
            this.compareList(expectedList, actualList, "middle list " + i2);
            this.compareList(expected.list, (List)row.getFieldValue(10), "list " + i2);
        }
        rows.close();
        Iterator stripeIterator = reader.getStripes().iterator();
        long offsetOfStripe2 = 0L;
        long offsetOfStripe4 = 0L;
        long lastRowOfStripe2 = 0L;
        for (int i3 = 0; i3 < 5; ++i3) {
            StripeInformation stripe = (StripeInformation)stripeIterator.next();
            if (i3 < 2) {
                lastRowOfStripe2 += stripe.getNumberOfRows();
                continue;
            }
            if (i3 == 2) {
                offsetOfStripe2 = stripe.getOffset();
                lastRowOfStripe2 += stripe.getNumberOfRows() - 1L;
                continue;
            }
            if (i3 != 4) continue;
            offsetOfStripe4 = stripe.getOffset();
        }
        boolean[] columns = new boolean[reader.getStatistics().length];
        columns[5] = true;
        columns[9] = true;
        rows = reader.rowsOptions(new Reader.Options().range(offsetOfStripe2, offsetOfStripe4 - offsetOfStripe2).include(columns));
        rows.seekToRow(lastRowOfStripe2);
        for (int i4 = 0; i4 < 2; ++i4) {
            row = (OrcStruct)rows.next((Object)row);
            BigRow expected = this.createRandomRow(intValues, doubleValues, stringValues, byteValues, words, (int)(lastRowOfStripe2 + (long)i4));
            Assert.assertEquals((long)expected.long1, (long)((LongWritable)row.getFieldValue(4)).get());
            Assert.assertEquals((Object)expected.string1, (Object)row.getFieldValue(8));
        }
        rows.close();
    }

    private void compareInner(InnerStruct expect, OrcStruct actual, String context) throws Exception {
        if (expect == null || actual == null) {
            Assert.assertEquals((String)context, null, (Object)expect);
            Assert.assertEquals((String)context, null, (Object)actual);
        } else {
            Assert.assertEquals((String)context, (int)expect.int1, (int)((IntWritable)actual.getFieldValue(0)).get());
            Assert.assertEquals((String)context, (Object)expect.string1, (Object)actual.getFieldValue(1));
        }
    }

    private void compareList(List<InnerStruct> expect, List<OrcStruct> actual, String context) throws Exception {
        Assert.assertEquals((String)context, (int)expect.size(), (int)actual.size());
        for (int j = 0; j < expect.size(); ++j) {
            this.compareInner(expect.get(j), actual.get(j), context + " at " + j);
        }
    }

    private void appendRandomRow(VectorizedRowBatch batch, long[] intValues, double[] doubleValues, String[] stringValues, BytesWritable[] byteValues, String[] words, int i) {
        InnerStruct inner = new InnerStruct((int)intValues[i], stringValues[i]);
        InnerStruct inner2 = new InnerStruct((int)(intValues[i] >> 32), words[i % words.length] + "-x");
        TestVectorOrcFile.setBigRow(batch, batch.size++, (intValues[i] & 1L) == 0L, (byte)intValues[i], (short)intValues[i], (int)intValues[i], intValues[i], Float.valueOf((float)doubleValues[i]), doubleValues[i], byteValues[i], stringValues[i], new MiddleStruct(inner, inner2), TestVectorOrcFile.list(new InnerStruct[0]), TestVectorOrcFile.map(inner, inner2));
    }

    private BigRow createRandomRow(long[] intValues, double[] doubleValues, String[] stringValues, BytesWritable[] byteValues, String[] words, int i) {
        InnerStruct inner = new InnerStruct((int)intValues[i], stringValues[i]);
        InnerStruct inner2 = new InnerStruct((int)(intValues[i] >> 32), words[i % words.length] + "-x");
        return new BigRow((intValues[i] & 1L) == 0L, (byte)intValues[i], (short)intValues[i], (int)intValues[i], intValues[i], Float.valueOf((float)doubleValues[i]), doubleValues[i], byteValues[i], stringValues[i], new MiddleStruct(inner, inner2), TestVectorOrcFile.list(new InnerStruct[0]), TestVectorOrcFile.map(inner, inner2));
    }

    @Test
    public void testMemoryManagementV11() throws Exception {
        TypeDescription schema = TestVectorOrcFile.createInnerSchema();
        MyMemoryManager memory = new MyMemoryManager(this.conf, 10000L, 0.1);
        Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).setSchema(schema).compress(CompressionKind.NONE).stripeSize(50000L).bufferSize(100).rowIndexStride(0).memory((MemoryManager)memory).version(OrcFile.Version.V_0_11));
        Assert.assertEquals((Object)this.testFilePath, (Object)memory.path);
        VectorizedRowBatch batch = schema.createRowBatch();
        batch.size = 1;
        for (int i = 0; i < 2500; ++i) {
            ((LongColumnVector)batch.cols[0]).vector[0] = i * 300;
            ((BytesColumnVector)batch.cols[1]).setVal(0, Integer.toHexString(10 * i).getBytes());
            writer.addRowBatch(batch);
        }
        writer.close();
        Assert.assertEquals(null, (Object)memory.path);
        Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(this.fs));
        int i = 0;
        for (StripeInformation stripe : reader.getStripes()) {
            Assert.assertTrue((String)("stripe " + ++i + " is too long at " + stripe.getDataLength()), (stripe.getDataLength() < 5000L ? 1 : 0) != 0);
        }
        Assert.assertEquals((int)25, (int)i);
        Assert.assertEquals((long)2500L, (long)reader.getNumberOfRows());
    }

    @Test
    public void testMemoryManagementV12() throws Exception {
        TypeDescription schema = TestVectorOrcFile.createInnerSchema();
        MyMemoryManager memory = new MyMemoryManager(this.conf, 10000L, 0.1);
        Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).setSchema(schema).compress(CompressionKind.NONE).stripeSize(50000L).bufferSize(100).rowIndexStride(0).memory((MemoryManager)memory).version(OrcFile.Version.V_0_12));
        VectorizedRowBatch batch = schema.createRowBatch();
        Assert.assertEquals((Object)this.testFilePath, (Object)memory.path);
        batch.size = 1;
        for (int i = 0; i < 2500; ++i) {
            ((LongColumnVector)batch.cols[0]).vector[0] = i * 300;
            ((BytesColumnVector)batch.cols[1]).setVal(0, Integer.toHexString(10 * i).getBytes());
            writer.addRowBatch(batch);
        }
        writer.close();
        Assert.assertEquals(null, (Object)memory.path);
        Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(this.fs));
        int i = 0;
        for (StripeInformation stripe : reader.getStripes()) {
            Assert.assertTrue((String)("stripe " + ++i + " is too long at " + stripe.getDataLength()), (stripe.getDataLength() < 5000L ? 1 : 0) != 0);
        }
        Assert.assertEquals((int)3, (int)i);
        Assert.assertEquals((long)2500L, (long)reader.getNumberOfRows());
    }

    @Test
    public void testPredicatePushdown() throws Exception {
        int i;
        TypeDescription schema = TestVectorOrcFile.createInnerSchema();
        Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).setSchema(schema).stripeSize(400000L).compress(CompressionKind.NONE).bufferSize(500).rowIndexStride(1000));
        VectorizedRowBatch batch = schema.createRowBatch();
        batch.ensureSize(3500);
        batch.size = 3500;
        for (int i2 = 0; i2 < 3500; ++i2) {
            ((LongColumnVector)batch.cols[0]).vector[i2] = i2 * 300;
            ((BytesColumnVector)batch.cols[1]).setVal(i2, Integer.toHexString(10 * i2).getBytes());
        }
        writer.addRowBatch(batch);
        writer.close();
        Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(this.fs));
        Assert.assertEquals((long)3500L, (long)reader.getNumberOfRows());
        SearchArgument sarg = SearchArgumentFactory.newBuilder().startAnd().startNot().lessThan("int1", PredicateLeaf.Type.LONG, (Object)300000L).end().lessThan("int1", PredicateLeaf.Type.LONG, (Object)600000L).end().build();
        RecordReader rows = reader.rowsOptions(new Reader.Options().range(0L, Long.MAX_VALUE).include(new boolean[]{true, true, true}).searchArgument(sarg, new String[]{null, "int1", "string1"}));
        Assert.assertEquals((long)1000L, (long)rows.getRowNumber());
        OrcStruct row = null;
        for (i = 1000; i < 2000; ++i) {
            Assert.assertTrue((boolean)rows.hasNext());
            row = (OrcStruct)rows.next(row);
            Assert.assertEquals((int)(300 * i), (int)((IntWritable)row.getFieldValue(0)).get());
            Assert.assertEquals((String)Integer.toHexString(10 * i), (String)row.getFieldValue(1).toString());
        }
        Assert.assertTrue((!rows.hasNext() ? 1 : 0) != 0);
        Assert.assertEquals((long)3500L, (long)rows.getRowNumber());
        sarg = SearchArgumentFactory.newBuilder().startAnd().lessThan("int1", PredicateLeaf.Type.LONG, (Object)0L).end().build();
        rows = reader.rowsOptions(new Reader.Options().range(0L, Long.MAX_VALUE).include(new boolean[]{true, true, true}).searchArgument(sarg, new String[]{null, "int1", "string1"}));
        Assert.assertEquals((long)3500L, (long)rows.getRowNumber());
        Assert.assertTrue((!rows.hasNext() ? 1 : 0) != 0);
        sarg = SearchArgumentFactory.newBuilder().startOr().lessThan("int1", PredicateLeaf.Type.LONG, (Object)30000L).startNot().lessThan("int1", PredicateLeaf.Type.LONG, (Object)1020000L).end().end().build();
        rows = reader.rowsOptions(new Reader.Options().range(0L, Long.MAX_VALUE).include(new boolean[]{true, true, true}).searchArgument(sarg, new String[]{null, "int1", "string1"}));
        row = null;
        for (i = 0; i < 1000; ++i) {
            Assert.assertTrue((boolean)rows.hasNext());
            Assert.assertEquals((long)i, (long)rows.getRowNumber());
            row = (OrcStruct)rows.next((Object)row);
            Assert.assertEquals((int)(300 * i), (int)((IntWritable)row.getFieldValue(0)).get());
            Assert.assertEquals((String)Integer.toHexString(10 * i), (String)row.getFieldValue(1).toString());
        }
        for (i = 3000; i < 3500; ++i) {
            Assert.assertTrue((boolean)rows.hasNext());
            Assert.assertEquals((long)i, (long)rows.getRowNumber());
            row = (OrcStruct)rows.next((Object)row);
            Assert.assertEquals((int)(300 * i), (int)((IntWritable)row.getFieldValue(0)).get());
            Assert.assertEquals((String)Integer.toHexString(10 * i), (String)row.getFieldValue(1).toString());
        }
        Assert.assertTrue((!rows.hasNext() ? 1 : 0) != 0);
        Assert.assertEquals((long)3500L, (long)rows.getRowNumber());
    }

    private static String pad(String value, int length) {
        if (value.length() == length) {
            return value;
        }
        if (value.length() > length) {
            return value.substring(0, length);
        }
        StringBuilder buf = new StringBuilder();
        buf.append(value);
        for (int i = 0; i < length - value.length(); ++i) {
            buf.append(' ');
        }
        return buf.toString();
    }

    @Test
    public void testRepeating() throws Exception {
        int f;
        int r;
        int c;
        TypeDescription schema = TypeDescription.createStruct().addField("bin", TypeDescription.createBinary()).addField("bool", TypeDescription.createBoolean()).addField("byte", TypeDescription.createByte()).addField("long", TypeDescription.createLong()).addField("float", TypeDescription.createFloat()).addField("double", TypeDescription.createDouble()).addField("date", TypeDescription.createDate()).addField("time", TypeDescription.createTimestamp()).addField("dec", TypeDescription.createDecimal().withPrecision(20).withScale(6)).addField("string", TypeDescription.createString()).addField("char", TypeDescription.createChar().withMaxLength(10)).addField("vc", TypeDescription.createVarchar().withMaxLength(10)).addField("struct", TypeDescription.createStruct().addField("sub1", TypeDescription.createInt())).addField("union", TypeDescription.createUnion().addUnionChild(TypeDescription.createString()).addUnionChild(TypeDescription.createInt())).addField("list", TypeDescription.createList((TypeDescription)TypeDescription.createInt())).addField("map", TypeDescription.createMap((TypeDescription)TypeDescription.createString(), (TypeDescription)TypeDescription.createString()));
        VectorizedRowBatch batch = schema.createRowBatch();
        Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).setSchema(schema).rowIndexStride(1000));
        batch.size = 1024;
        for (c = 0; c < batch.cols.length; ++c) {
            batch.cols[c].setRepeating(true);
            batch.cols[c].noNulls = false;
            batch.cols[c].isNull[0] = true;
        }
        writer.addRowBatch(batch);
        for (c = 0; c < batch.cols.length; ++c) {
            batch.cols[c].isNull[0] = false;
        }
        ((BytesColumnVector)batch.cols[0]).setVal(0, "Horton".getBytes());
        ((LongColumnVector)batch.cols[1]).vector[0] = 1L;
        ((LongColumnVector)batch.cols[2]).vector[0] = 130L;
        ((LongColumnVector)batch.cols[3]).vector[0] = 1311768467463790320L;
        ((DoubleColumnVector)batch.cols[4]).vector[0] = 1.125;
        ((DoubleColumnVector)batch.cols[5]).vector[0] = 9.765625E-4;
        ((LongColumnVector)batch.cols[6]).vector[0] = new DateWritable(new Date(111, 6, 1)).getDays();
        ((LongColumnVector)batch.cols[7]).vector[0] = TimestampUtils.getTimeNanoSec((Timestamp)new Timestamp(115, 9, 23, 10, 11, 59, 999999999));
        ((DecimalColumnVector)batch.cols[8]).vector[0] = new HiveDecimalWritable("1.234567");
        ((BytesColumnVector)batch.cols[9]).setVal(0, "Echelon".getBytes());
        ((BytesColumnVector)batch.cols[10]).setVal(0, "Juggernaut".getBytes());
        ((BytesColumnVector)batch.cols[11]).setVal(0, "Dreadnaught".getBytes());
        ((LongColumnVector)((StructColumnVector)batch.cols[12]).fields[0]).vector[0] = 123L;
        ((UnionColumnVector)batch.cols[13]).tags[0] = 1;
        ((LongColumnVector)((UnionColumnVector)batch.cols[13]).fields[1]).vector[0] = 1234L;
        ((ListColumnVector)batch.cols[14]).offsets[0] = 0L;
        ((ListColumnVector)batch.cols[14]).lengths[0] = 3L;
        ((ListColumnVector)batch.cols[14]).child.isRepeating = true;
        ((LongColumnVector)((ListColumnVector)batch.cols[14]).child).vector[0] = 31415L;
        ((MapColumnVector)batch.cols[15]).offsets[0] = 0L;
        ((MapColumnVector)batch.cols[15]).lengths[0] = 3L;
        ((MapColumnVector)batch.cols[15]).values.isRepeating = true;
        ((BytesColumnVector)((MapColumnVector)batch.cols[15]).keys).setVal(0, "ORC".getBytes());
        ((BytesColumnVector)((MapColumnVector)batch.cols[15]).keys).setVal(1, "Hive".getBytes());
        ((BytesColumnVector)((MapColumnVector)batch.cols[15]).keys).setVal(2, "LLAP".getBytes());
        ((BytesColumnVector)((MapColumnVector)batch.cols[15]).values).setVal(0, "fast".getBytes());
        writer.addRowBatch(batch);
        for (c = 0; c < batch.cols.length; ++c) {
            batch.cols[c].setRepeating(false);
            batch.cols[c].noNulls = false;
            Arrays.fill(batch.cols[c].isNull, true);
        }
        writer.addRowBatch(batch);
        batch.reset();
        batch.size = 1024;
        ((ListColumnVector)batch.cols[14]).child.ensureSize(3072, false);
        ((MapColumnVector)batch.cols[15]).keys.ensureSize(3072, false);
        ((MapColumnVector)batch.cols[15]).values.ensureSize(3072, false);
        for (int r2 = 0; r2 < 1024; ++r2) {
            int i;
            ((BytesColumnVector)batch.cols[0]).setVal(r2, Integer.toHexString(r2).getBytes());
            ((LongColumnVector)batch.cols[1]).vector[r2] = r2 % 2;
            ((LongColumnVector)batch.cols[2]).vector[r2] = r2 % 255;
            ((LongColumnVector)batch.cols[3]).vector[r2] = 31415L * (long)r2;
            ((DoubleColumnVector)batch.cols[4]).vector[r2] = 1.125 * (double)r2;
            ((DoubleColumnVector)batch.cols[5]).vector[r2] = 9.765625E-4 * (double)r2;
            ((LongColumnVector)batch.cols[6]).vector[r2] = new DateWritable(new Date(111, 6, 1)).getDays() + r2;
            ((LongColumnVector)batch.cols[7]).vector[r2] = TimestampUtils.getTimeNanoSec((Timestamp)new Timestamp(115, 9, 23, 10, 11, 59, 999999999)) + (long)r2 * 1000000000L;
            ((DecimalColumnVector)batch.cols[8]).vector[r2] = new HiveDecimalWritable("1.234567");
            ((BytesColumnVector)batch.cols[9]).setVal(r2, Integer.toString(r2).getBytes());
            ((BytesColumnVector)batch.cols[10]).setVal(r2, Integer.toHexString(r2).getBytes());
            ((BytesColumnVector)batch.cols[11]).setVal(r2, Integer.toHexString(r2 * 128).getBytes());
            ((LongColumnVector)((StructColumnVector)batch.cols[12]).fields[0]).vector[r2] = r2 + 13;
            ((UnionColumnVector)batch.cols[13]).tags[r2] = 1;
            ((LongColumnVector)((UnionColumnVector)batch.cols[13]).fields[1]).vector[r2] = r2 + 42;
            ((ListColumnVector)batch.cols[14]).offsets[r2] = 3 * r2;
            ((ListColumnVector)batch.cols[14]).lengths[r2] = 3L;
            for (i = 0; i < 3; ++i) {
                ((LongColumnVector)((ListColumnVector)batch.cols[14]).child).vector[3 * r2 + i] = 31415 + i;
            }
            ((MapColumnVector)batch.cols[15]).offsets[r2] = 3 * r2;
            ((MapColumnVector)batch.cols[15]).lengths[r2] = 3L;
            for (i = 0; i < 3; ++i) {
                ((BytesColumnVector)((MapColumnVector)batch.cols[15]).keys).setVal(3 * r2 + i, Integer.toHexString(3 * r2 + i).getBytes());
                ((BytesColumnVector)((MapColumnVector)batch.cols[15]).values).setVal(3 * r2 + i, Integer.toString(3 * r2 + i).getBytes());
            }
        }
        writer.addRowBatch(batch);
        writer.close();
        Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(this.fs));
        ColumnStatistics[] stats = reader.getStatistics();
        Assert.assertEquals((long)4096L, (long)stats[0].getNumberOfValues());
        Assert.assertEquals((boolean)false, (boolean)stats[0].hasNull());
        for (TypeDescription colType : schema.getChildren()) {
            Assert.assertEquals((String)("count on " + colType.getId()), (long)2048L, (long)stats[colType.getId()].getNumberOfValues());
            Assert.assertEquals((String)("hasNull on " + colType.getId()), (boolean)true, (boolean)stats[colType.getId()].hasNull());
        }
        Assert.assertEquals((long)8944L, (long)((BinaryColumnStatistics)stats[1]).getSum());
        Assert.assertEquals((long)1536L, (long)((BooleanColumnStatistics)stats[2]).getTrueCount());
        Assert.assertEquals((long)512L, (long)((BooleanColumnStatistics)stats[2]).getFalseCount());
        Assert.assertEquals((boolean)false, (boolean)((IntegerColumnStatistics)stats[4]).isSumDefined());
        Assert.assertEquals((long)0L, (long)((IntegerColumnStatistics)stats[4]).getMinimum());
        Assert.assertEquals((long)1311768467463790320L, (long)((IntegerColumnStatistics)stats[4]).getMaximum());
        Assert.assertEquals((String)"0", (String)((StringColumnStatistics)stats[10]).getMinimum());
        Assert.assertEquals((String)"Echelon", (String)((StringColumnStatistics)stats[10]).getMaximum());
        Assert.assertEquals((long)10154L, (long)((StringColumnStatistics)stats[10]).getSum());
        Assert.assertEquals((String)"0         ", (String)((StringColumnStatistics)stats[11]).getMinimum());
        Assert.assertEquals((String)"ff        ", (String)((StringColumnStatistics)stats[11]).getMaximum());
        Assert.assertEquals((long)20480L, (long)((StringColumnStatistics)stats[11]).getSum());
        Assert.assertEquals((String)"0", (String)((StringColumnStatistics)stats[12]).getMinimum());
        Assert.assertEquals((String)"ff80", (String)((StringColumnStatistics)stats[12]).getMaximum());
        Assert.assertEquals((long)14813L, (long)((StringColumnStatistics)stats[12]).getSum());
        RecordReader rows = reader.rows();
        OrcStruct row = null;
        for (r = 0; r < 1024; ++r) {
            Assert.assertEquals((boolean)true, (boolean)rows.hasNext());
            row = (OrcStruct)rows.next(row);
            for (f = 0; f < row.getNumFields(); ++f) {
                Assert.assertEquals((String)("non-null on row " + r + " field " + f), null, (Object)row.getFieldValue(f));
            }
        }
        for (r = 0; r < 1024; ++r) {
            Assert.assertEquals((boolean)true, (boolean)rows.hasNext());
            row = (OrcStruct)rows.next((Object)row);
            Assert.assertEquals((String)("row " + r), (String)"48 6f 72 74 6f 6e", (String)row.getFieldValue(0).toString());
            Assert.assertEquals((String)("row " + r), (String)"true", (String)row.getFieldValue(1).toString());
            Assert.assertEquals((String)("row " + r), (String)"-126", (String)row.getFieldValue(2).toString());
            Assert.assertEquals((String)("row " + r), (String)"1311768467463790320", (String)row.getFieldValue(3).toString());
            Assert.assertEquals((String)("row " + r), (String)"1.125", (String)row.getFieldValue(4).toString());
            Assert.assertEquals((String)("row " + r), (String)"9.765625E-4", (String)row.getFieldValue(5).toString());
            Assert.assertEquals((String)("row " + r), (String)"2011-07-01", (String)row.getFieldValue(6).toString());
            Assert.assertEquals((String)("row " + r), (String)"2015-10-23 10:11:59.999999999", (String)row.getFieldValue(7).toString());
            Assert.assertEquals((String)("row " + r), (String)"1.234567", (String)row.getFieldValue(8).toString());
            Assert.assertEquals((String)("row " + r), (String)"Echelon", (String)row.getFieldValue(9).toString());
            Assert.assertEquals((String)("row " + r), (String)"Juggernaut", (String)row.getFieldValue(10).toString());
            Assert.assertEquals((String)("row " + r), (String)"Dreadnaugh", (String)row.getFieldValue(11).toString());
            Assert.assertEquals((String)("row " + r), (String)"{123}", (String)row.getFieldValue(12).toString());
            Assert.assertEquals((String)("row " + r), (String)"union(1, 1234)", (String)row.getFieldValue(13).toString());
            Assert.assertEquals((String)("row " + r), (String)"[31415, 31415, 31415]", (String)row.getFieldValue(14).toString());
            Assert.assertEquals((String)("row " + r), (String)"{ORC=fast, Hive=fast, LLAP=fast}", (String)row.getFieldValue(15).toString());
        }
        for (r = 0; r < 1024; ++r) {
            Assert.assertEquals((boolean)true, (boolean)rows.hasNext());
            row = (OrcStruct)rows.next((Object)row);
            for (f = 0; f < row.getNumFields(); ++f) {
                Assert.assertEquals((String)("non-null on row " + r + " field " + f), null, (Object)row.getFieldValue(f));
            }
        }
        for (r = 0; r < 1024; ++r) {
            Assert.assertEquals((boolean)true, (boolean)rows.hasNext());
            row = (OrcStruct)rows.next((Object)row);
            byte[] hex = Integer.toHexString(r).getBytes();
            StringBuilder expected = new StringBuilder();
            for (int i = 0; i < hex.length; ++i) {
                if (i != 0) {
                    expected.append(' ');
                }
                expected.append(Integer.toHexString(hex[i]));
            }
            Assert.assertEquals((String)("row " + r), (String)expected.toString(), (String)row.getFieldValue(0).toString());
            Assert.assertEquals((String)("row " + r), (String)(r % 2 == 1 ? "true" : "false"), (String)row.getFieldValue(1).toString());
            Assert.assertEquals((String)("row " + r), (String)Integer.toString((byte)(r % 255)), (String)row.getFieldValue(2).toString());
            Assert.assertEquals((String)("row " + r), (String)Long.toString(31415L * (long)r), (String)row.getFieldValue(3).toString());
            Assert.assertEquals((String)("row " + r), (String)Float.toString(1.125f * (float)r), (String)row.getFieldValue(4).toString());
            Assert.assertEquals((String)("row " + r), (String)Double.toString(9.765625E-4 * (double)r), (String)row.getFieldValue(5).toString());
            Assert.assertEquals((String)("row " + r), (String)new Date(111, 6, 1 + r).toString(), (String)row.getFieldValue(6).toString());
            Assert.assertEquals((String)("row " + r), (String)new Timestamp(115, 9, 23, 10, 11, 59 + r, 999999999).toString(), (String)row.getFieldValue(7).toString());
            Assert.assertEquals((String)("row " + r), (String)"1.234567", (String)row.getFieldValue(8).toString());
            Assert.assertEquals((String)("row " + r), (String)Integer.toString(r), (String)row.getFieldValue(9).toString());
            Assert.assertEquals((String)("row " + r), (String)TestVectorOrcFile.pad(Integer.toHexString(r), 10), (String)row.getFieldValue(10).toString());
            Assert.assertEquals((String)("row " + r), (String)Integer.toHexString(r * 128), (String)row.getFieldValue(11).toString());
            Assert.assertEquals((String)("row " + r), (String)("{" + Integer.toString(r + 13) + "}"), (String)row.getFieldValue(12).toString());
            Assert.assertEquals((String)("row " + r), (String)("union(1, " + Integer.toString(r + 42) + ")"), (String)row.getFieldValue(13).toString());
            Assert.assertEquals((String)("row " + r), (String)"[31415, 31416, 31417]", (String)row.getFieldValue(14).toString());
            expected = new StringBuilder();
            expected.append('{');
            expected.append(Integer.toHexString(3 * r));
            expected.append('=');
            expected.append(3 * r);
            expected.append(", ");
            expected.append(Integer.toHexString(3 * r + 1));
            expected.append('=');
            expected.append(3 * r + 1);
            expected.append(", ");
            expected.append(Integer.toHexString(3 * r + 2));
            expected.append('=');
            expected.append(3 * r + 2);
            expected.append('}');
            Assert.assertEquals((String)("row " + r), (String)expected.toString(), (String)row.getFieldValue(15).toString());
        }
        Assert.assertEquals((boolean)false, (boolean)rows.hasNext());
    }

    private static String makeString(BytesColumnVector vector, int row) {
        if (vector.isRepeating) {
            row = 0;
        }
        if (vector.noNulls || !vector.isNull[row]) {
            return new String(vector.vector[row], vector.start[row], vector.length[row]);
        }
        return null;
    }

    @Test
    public void testStringPadding() throws Exception {
        TypeDescription schema = TypeDescription.createStruct().addField("char", TypeDescription.createChar().withMaxLength(10)).addField("varchar", TypeDescription.createVarchar().withMaxLength(10));
        Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).setSchema(schema));
        VectorizedRowBatch batch = schema.createRowBatch();
        batch.size = 4;
        for (int c = 0; c < batch.cols.length; ++c) {
            ((BytesColumnVector)batch.cols[c]).setVal(0, "".getBytes());
            ((BytesColumnVector)batch.cols[c]).setVal(1, "xyz".getBytes());
            ((BytesColumnVector)batch.cols[c]).setVal(2, "0123456789".getBytes());
            ((BytesColumnVector)batch.cols[c]).setVal(3, "0123456789abcdef".getBytes());
        }
        writer.addRowBatch(batch);
        writer.close();
        Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf));
        RecordReader rows = reader.rows();
        batch = rows.nextBatch(null);
        Assert.assertEquals((int)4, (int)batch.size);
        Assert.assertEquals((String)"", (String)TestVectorOrcFile.makeString((BytesColumnVector)batch.cols[0], 0));
        Assert.assertEquals((String)"xyz", (String)TestVectorOrcFile.makeString((BytesColumnVector)batch.cols[0], 1));
        Assert.assertEquals((String)"0123456789", (String)TestVectorOrcFile.makeString((BytesColumnVector)batch.cols[0], 2));
        Assert.assertEquals((String)"0123456789", (String)TestVectorOrcFile.makeString((BytesColumnVector)batch.cols[0], 3));
        Assert.assertEquals((String)"", (String)TestVectorOrcFile.makeString((BytesColumnVector)batch.cols[1], 0));
        Assert.assertEquals((String)"xyz", (String)TestVectorOrcFile.makeString((BytesColumnVector)batch.cols[1], 1));
        Assert.assertEquals((String)"0123456789", (String)TestVectorOrcFile.makeString((BytesColumnVector)batch.cols[1], 2));
        Assert.assertEquals((String)"0123456789", (String)TestVectorOrcFile.makeString((BytesColumnVector)batch.cols[1], 3));
    }

    @Test
    public void testNonDictionaryRepeatingString() throws Exception {
        int r;
        TypeDescription schema = TypeDescription.createStruct().addField("str", TypeDescription.createString());
        Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).setSchema(schema).rowIndexStride(1000));
        VectorizedRowBatch batch = schema.createRowBatch();
        batch.size = 1024;
        for (int r2 = 0; r2 < batch.size; ++r2) {
            ((BytesColumnVector)batch.cols[0]).setVal(r2, Integer.toString(r2 * 10001).getBytes());
        }
        writer.addRowBatch(batch);
        batch.cols[0].isRepeating = true;
        ((BytesColumnVector)batch.cols[0]).setVal(0, "Halloween".getBytes());
        writer.addRowBatch(batch);
        writer.close();
        Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf));
        RecordReader rows = reader.rows();
        batch = rows.nextBatch(null);
        Assert.assertEquals((int)1024, (int)batch.size);
        for (r = 0; r < 1024; ++r) {
            Assert.assertEquals((String)Integer.toString(r * 10001), (String)TestVectorOrcFile.makeString((BytesColumnVector)batch.cols[0], r));
        }
        batch = rows.nextBatch(batch);
        Assert.assertEquals((int)1024, (int)batch.size);
        for (r = 0; r < 1024; ++r) {
            Assert.assertEquals((String)"Halloween", (String)TestVectorOrcFile.makeString((BytesColumnVector)batch.cols[0], r));
        }
        Assert.assertEquals((boolean)false, (boolean)rows.hasNext());
    }

    @Test
    public void testStructs() throws Exception {
        TypeDescription schema = TypeDescription.createStruct().addField("struct", TypeDescription.createStruct().addField("inner", TypeDescription.createLong()));
        Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).setSchema(schema));
        VectorizedRowBatch batch = schema.createRowBatch();
        batch.size = 1024;
        StructColumnVector outer = (StructColumnVector)batch.cols[0];
        outer.noNulls = false;
        for (int r = 0; r < 1024; ++r) {
            if (r < 200 || r >= 400 && r < 600 || r >= 800) {
                outer.isNull[r] = true;
            }
            ((LongColumnVector)outer.fields[0]).vector[r] = r;
        }
        writer.addRowBatch(batch);
        writer.close();
        Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf));
        RecordReader rows = reader.rows();
        OrcStruct row = null;
        for (int r = 0; r < 1024; ++r) {
            Assert.assertEquals((boolean)true, (boolean)rows.hasNext());
            row = (OrcStruct)rows.next(row);
            OrcStruct inner = (OrcStruct)row.getFieldValue(0);
            if (r < 200 || r >= 400 && r < 600 || r >= 800) {
                Assert.assertEquals((String)("row " + r), null, (Object)inner);
                continue;
            }
            Assert.assertEquals((String)("row " + r), (String)("{" + r + "}"), (String)inner.toString());
        }
        Assert.assertEquals((boolean)false, (boolean)rows.hasNext());
    }

    @Test
    public void testUnions() throws Exception {
        TypeDescription schema = TypeDescription.createStruct().addField("outer", TypeDescription.createUnion().addUnionChild(TypeDescription.createInt()).addUnionChild(TypeDescription.createLong()));
        Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).setSchema(schema));
        VectorizedRowBatch batch = schema.createRowBatch();
        batch.size = 1024;
        UnionColumnVector outer = (UnionColumnVector)batch.cols[0];
        batch.cols[0].noNulls = false;
        for (int r = 0; r < 1024; ++r) {
            if (r < 200) {
                outer.isNull[r] = true;
            } else if (r < 300) {
                outer.tags[r] = 0;
            } else if (r < 400) {
                outer.tags[r] = 1;
            } else if (r < 600) {
                outer.isNull[r] = true;
            } else if (r < 800) {
                outer.tags[r] = 1;
            } else if (r < 1000) {
                outer.isNull[r] = true;
            } else {
                outer.tags[r] = 1;
            }
            ((LongColumnVector)outer.fields[0]).vector[r] = r;
            ((LongColumnVector)outer.fields[1]).vector[r] = -r;
        }
        writer.addRowBatch(batch);
        writer.close();
        Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf));
        RecordReader rows = reader.rows();
        OrcStruct row = null;
        for (int r = 0; r < 1024; ++r) {
            Assert.assertEquals((boolean)true, (boolean)rows.hasNext());
            row = (OrcStruct)rows.next(row);
            OrcUnion inner = (OrcUnion)row.getFieldValue(0);
            if (r < 200) {
                Assert.assertEquals((String)("row " + r), null, (Object)inner);
                continue;
            }
            if (r < 300) {
                Assert.assertEquals((String)("row " + r), (String)("union(0, " + r + ")"), (String)inner.toString());
                continue;
            }
            if (r < 400) {
                Assert.assertEquals((String)("row " + r), (String)("union(1, " + -r + ")"), (String)inner.toString());
                continue;
            }
            if (r < 600) {
                Assert.assertEquals((String)("row " + r), null, (Object)inner);
                continue;
            }
            if (r < 800) {
                Assert.assertEquals((String)("row " + r), (String)("union(1, " + -r + ")"), (String)inner.toString());
                continue;
            }
            if (r < 1000) {
                Assert.assertEquals((String)("row " + r), null, (Object)inner);
                continue;
            }
            Assert.assertEquals((String)("row " + r), (String)("union(1, " + -r + ")"), (String)inner.toString());
        }
        Assert.assertEquals((boolean)false, (boolean)rows.hasNext());
    }

    @Test
    public void testLists() throws Exception {
        TypeDescription schema = TypeDescription.createStruct().addField("list", TypeDescription.createList((TypeDescription)TypeDescription.createLong()));
        Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).setSchema(schema));
        VectorizedRowBatch batch = schema.createRowBatch();
        batch.size = 1024;
        ListColumnVector list = (ListColumnVector)batch.cols[0];
        list.noNulls = false;
        for (int r = 0; r < 1024; ++r) {
            if (r < 200) {
                list.isNull[r] = true;
            } else if (r < 300) {
                list.offsets[r] = r - 200;
                list.lengths[r] = 1L;
            } else if (r < 400) {
                list.isNull[r] = true;
            } else if (r < 500) {
                list.offsets[r] = r - 300;
                list.lengths[r] = 1L;
            } else if (r < 600) {
                list.isNull[r] = true;
            } else if (r < 700) {
                list.offsets[r] = r;
                list.lengths[r] = 2L;
            } else {
                list.isNull[r] = true;
            }
            ((LongColumnVector)list.child).vector[r] = r * 10;
        }
        writer.addRowBatch(batch);
        writer.close();
        Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf));
        RecordReader rows = reader.rows();
        OrcStruct row = null;
        for (int r = 0; r < 1024; ++r) {
            Assert.assertEquals((boolean)true, (boolean)rows.hasNext());
            row = (OrcStruct)rows.next(row);
            List inner = (List)row.getFieldValue(0);
            if (r < 200) {
                Assert.assertEquals((String)("row " + r), null, (Object)inner);
                continue;
            }
            if (r < 300) {
                Assert.assertEquals((String)("row " + r), (String)("[" + (r - 200) * 10 + "]"), (String)inner.toString());
                continue;
            }
            if (r < 400) {
                Assert.assertEquals((String)("row " + r), null, (Object)inner);
                continue;
            }
            if (r < 500) {
                Assert.assertEquals((String)("row " + r), (String)("[" + (r - 300) * 10 + "]"), (String)inner.toString());
                continue;
            }
            if (r < 600) {
                Assert.assertEquals((String)("row " + r), null, (Object)inner);
                continue;
            }
            if (r < 700) {
                Assert.assertEquals((String)("row " + r), (String)("[" + 10 * r + ", " + 10 * (r + 1) + "]"), (String)inner.toString());
                continue;
            }
            Assert.assertEquals((String)("row " + r), null, (Object)inner);
        }
        Assert.assertEquals((boolean)false, (boolean)rows.hasNext());
    }

    @Test
    public void testMaps() throws Exception {
        TypeDescription schema = TypeDescription.createStruct().addField("map", TypeDescription.createMap((TypeDescription)TypeDescription.createLong(), (TypeDescription)TypeDescription.createLong()));
        Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).setSchema(schema));
        VectorizedRowBatch batch = schema.createRowBatch();
        batch.size = 1024;
        MapColumnVector map = (MapColumnVector)batch.cols[0];
        map.noNulls = false;
        for (int r = 0; r < 1024; ++r) {
            if (r < 200) {
                map.isNull[r] = true;
            } else if (r < 300) {
                map.offsets[r] = r - 200;
                map.lengths[r] = 1L;
            } else if (r < 400) {
                map.isNull[r] = true;
            } else if (r < 500) {
                map.offsets[r] = r - 300;
                map.lengths[r] = 1L;
            } else if (r < 600) {
                map.isNull[r] = true;
            } else if (r < 700) {
                map.offsets[r] = r;
                map.lengths[r] = 2L;
            } else {
                map.isNull[r] = true;
            }
            ((LongColumnVector)map.keys).vector[r] = r;
            ((LongColumnVector)map.values).vector[r] = r * 10;
        }
        writer.addRowBatch(batch);
        writer.close();
        Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf));
        RecordReader rows = reader.rows();
        OrcStruct row = null;
        for (int r = 0; r < 1024; ++r) {
            Assert.assertEquals((boolean)true, (boolean)rows.hasNext());
            row = (OrcStruct)rows.next(row);
            Map inner = (Map)row.getFieldValue(0);
            if (r < 200) {
                Assert.assertEquals((String)("row " + r), null, (Object)inner);
                continue;
            }
            if (r < 300) {
                Assert.assertEquals((String)("row " + r), (String)("{" + (r - 200) + "=" + (r - 200) * 10 + "}"), (String)inner.toString());
                continue;
            }
            if (r < 400) {
                Assert.assertEquals((String)("row " + r), null, (Object)inner);
                continue;
            }
            if (r < 500) {
                Assert.assertEquals((String)("row " + r), (String)("{" + (r - 300) + "=" + (r - 300) * 10 + "}"), (String)inner.toString());
                continue;
            }
            if (r < 600) {
                Assert.assertEquals((String)("row " + r), null, (Object)inner);
                continue;
            }
            if (r < 700) {
                Assert.assertEquals((String)("row " + r), (String)("{" + r + "=" + r * 10 + ", " + (r + 1) + "=" + 10 * (r + 1) + "}"), (String)inner.toString());
                continue;
            }
            Assert.assertEquals((String)("row " + r), null, (Object)inner);
        }
        Assert.assertEquals((boolean)false, (boolean)rows.hasNext());
    }

    private static class MyMemoryManager
    extends MemoryManager {
        final long totalSpace;
        double rate;
        Path path = null;
        long lastAllocation = 0L;
        int rows = 0;
        MemoryManager.Callback callback;

        MyMemoryManager(Configuration conf, long totalSpace, double rate) {
            super(conf);
            this.totalSpace = totalSpace;
            this.rate = rate;
        }

        public void addWriter(Path path, long requestedAllocation, MemoryManager.Callback callback) {
            this.path = path;
            this.lastAllocation = requestedAllocation;
            this.callback = callback;
        }

        public synchronized void removeWriter(Path path) {
            this.path = null;
            this.lastAllocation = 0L;
        }

        public long getTotalMemoryPool() {
            return this.totalSpace;
        }

        public double getAllocationScale() {
            return this.rate;
        }

        public void addedRow(int count) throws IOException {
            this.rows += count;
            if (this.rows % 100 == 0) {
                this.callback.checkMemory(this.rate);
            }
        }
    }

    public static class BigRow {
        Boolean boolean1;
        Byte byte1;
        Short short1;
        Integer int1;
        Long long1;
        Float float1;
        Double double1;
        BytesWritable bytes1;
        Text string1;
        MiddleStruct middle;
        List<InnerStruct> list = new ArrayList<InnerStruct>();
        Map<Text, InnerStruct> map = new HashMap<Text, InnerStruct>();

        BigRow(Boolean b1, Byte b2, Short s1, Integer i1, Long l1, Float f1, Double d1, BytesWritable b3, String s2, MiddleStruct m1, List<InnerStruct> l2, Map<String, InnerStruct> m2) {
            this.boolean1 = b1;
            this.byte1 = b2;
            this.short1 = s1;
            this.int1 = i1;
            this.long1 = l1;
            this.float1 = f1;
            this.double1 = d1;
            this.bytes1 = b3;
            this.string1 = s2 == null ? null : new Text(s2);
            this.middle = m1;
            this.list = l2;
            if (m2 != null) {
                this.map = new HashMap<Text, InnerStruct>();
                for (Map.Entry<String, InnerStruct> item : m2.entrySet()) {
                    this.map.put(new Text(item.getKey()), item.getValue());
                }
            } else {
                this.map = null;
            }
        }
    }

    public static class MiddleStruct {
        List<InnerStruct> list = new ArrayList<InnerStruct>();

        MiddleStruct(InnerStruct ... items) {
            this.list.clear();
            this.list.addAll(Arrays.asList(items));
        }
    }

    public static class InnerStruct {
        int int1;
        Text string1 = new Text();

        InnerStruct(int int1, String string1) {
            this.int1 = int1;
            this.string1.set(string1);
        }

        public String toString() {
            return "{" + this.int1 + ", " + this.string1 + "}";
        }
    }
}

