/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet.serde;

import java.util.HashMap;
import junit.framework.TestCase;
import org.apache.hadoop.hive.ql.io.parquet.serde.AbstractParquetMapInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Writable;
import org.junit.Test;

public class TestAbstractParquetMapInspector
extends TestCase {
    private TestableAbstractParquetMapInspector inspector;

    public void setUp() {
        this.inspector = new TestableAbstractParquetMapInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector, (ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector);
    }

    @Test
    public void testNullMap() {
        TestAbstractParquetMapInspector.assertEquals((String)"Wrong size", (int)-1, (int)this.inspector.getMapSize(null));
        TestAbstractParquetMapInspector.assertNull((String)"Should be null", (Object)this.inspector.getMap(null));
    }

    @Test
    public void testNullContainer() {
        ArrayWritable map = new ArrayWritable(ArrayWritable.class, null);
        TestAbstractParquetMapInspector.assertEquals((String)"Wrong size", (int)-1, (int)this.inspector.getMapSize(map));
        TestAbstractParquetMapInspector.assertNull((String)"Should be null", (Object)this.inspector.getMap(map));
    }

    @Test
    public void testEmptyContainer() {
        ArrayWritable map = new ArrayWritable(ArrayWritable.class, (Writable[])new ArrayWritable[0]);
        TestAbstractParquetMapInspector.assertEquals((String)"Wrong size", (int)-1, (int)this.inspector.getMapSize(map));
        TestAbstractParquetMapInspector.assertNull((String)"Should be null", (Object)this.inspector.getMap(map));
    }

    @Test
    public void testRegularMap() {
        Writable[] entry1 = new Writable[]{new IntWritable(0), new IntWritable(1)};
        Writable[] entry2 = new Writable[]{new IntWritable(2), new IntWritable(3)};
        ArrayWritable map = new ArrayWritable(ArrayWritable.class, new Writable[]{new ArrayWritable(Writable.class, entry1), new ArrayWritable(Writable.class, entry2)});
        HashMap<IntWritable, IntWritable> expected = new HashMap<IntWritable, IntWritable>();
        expected.put(new IntWritable(0), new IntWritable(1));
        expected.put(new IntWritable(2), new IntWritable(3));
        TestAbstractParquetMapInspector.assertEquals((String)"Wrong size", (int)2, (int)this.inspector.getMapSize(map));
        TestAbstractParquetMapInspector.assertEquals((String)"Wrong result of inspection", expected, (Object)this.inspector.getMap(map));
    }

    @Test
    public void testHashMap() {
        HashMap<IntWritable, IntWritable> map = new HashMap<IntWritable, IntWritable>();
        map.put(new IntWritable(0), new IntWritable(1));
        map.put(new IntWritable(2), new IntWritable(3));
        map.put(new IntWritable(4), new IntWritable(5));
        map.put(new IntWritable(6), new IntWritable(7));
        TestAbstractParquetMapInspector.assertEquals((String)"Wrong size", (int)4, (int)this.inspector.getMapSize(map));
        TestAbstractParquetMapInspector.assertEquals((String)"Wrong result of inspection", map, (Object)this.inspector.getMap(map));
    }

    class TestableAbstractParquetMapInspector
    extends AbstractParquetMapInspector {
        public TestableAbstractParquetMapInspector(ObjectInspector keyInspector, ObjectInspector valueInspector) {
            super(keyInspector, valueInspector);
        }

        public Object getMapValueElement(Object o, Object o1) {
            throw new UnsupportedOperationException("Should not be called");
        }
    }
}

