/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import junit.framework.TestCase;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.PartitionDropOptions;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Index;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.ql.index.HiveIndex;
import org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.StringAppender;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.serde2.thrift.ThriftDeserializer;
import org.apache.hadoop.hive.serde2.thrift.test.Complex;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.util.StringUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.junit.Assert;

public class TestHive
extends TestCase {
    protected Hive hm;
    protected HiveConf hiveConf;
    private static final String SEPARATOR = "/";
    private static final char SEPARATOR_CHAR = '/';
    private static final String CUR_DIR = ".";
    private static final boolean WINDOWS = System.getProperty("os.name").startsWith("Windows");
    private static final Pattern hasDriveLetterSpecifier = Pattern.compile("^/?[a-zA-Z]:");

    protected void setUp() throws Exception {
        super.setUp();
        this.hiveConf = new HiveConf(((Object)((Object)this)).getClass());
        this.hiveConf.setFloat("fs.trash.checkpoint.interval", 30.0f);
        this.hiveConf.setFloat("fs.trash.interval", 30.0f);
        SessionState.start((HiveConf)this.hiveConf);
        try {
            this.hm = Hive.get((HiveConf)this.hiveConf);
        }
        catch (Exception e) {
            System.err.println(StringUtils.stringifyException((Throwable)e));
            System.err.println("Unable to initialize Hive Metastore using configuration: \n " + this.hiveConf);
            throw e;
        }
    }

    protected void tearDown() throws Exception {
        try {
            super.tearDown();
            this.hiveConf.setFloat("fs.trash.checkpoint.interval", 30.0f);
            this.hiveConf.setFloat("fs.trash.interval", 30.0f);
            Hive.closeCurrent();
        }
        catch (Exception e) {
            System.err.println(StringUtils.stringifyException((Throwable)e));
            System.err.println("Unable to close Hive Metastore using configruation: \n " + this.hiveConf);
            throw e;
        }
    }

    public void testTable() throws Throwable {
        try {
            String tableName = "table_for_testtable";
            try {
                this.hm.dropTable("default", tableName);
            }
            catch (HiveException e1) {
                e1.printStackTrace();
                TestHive.assertTrue((String)"Unable to drop table", (boolean)false);
            }
            Table tbl = new Table("default", tableName);
            List fields = tbl.getCols();
            fields.add(new FieldSchema("col1", "int", "int -- first column"));
            fields.add(new FieldSchema("col2", "string", "string -- second column"));
            fields.add(new FieldSchema("col3", "double", "double -- thrift column"));
            tbl.setFields(fields);
            tbl.setOutputFormatClass(HiveIgnoreKeyTextOutputFormat.class);
            tbl.setInputFormatClass(SequenceFileInputFormat.class);
            tbl.setProperty("comment", "this is a test table created as part junit tests");
            List bucketCols = tbl.getBucketCols();
            bucketCols.add("col1");
            try {
                tbl.setBucketCols(bucketCols);
            }
            catch (HiveException e) {
                e.printStackTrace();
                TestHive.assertTrue((String)("Unable to set bucket column for table: " + tableName), (boolean)false);
            }
            ArrayList<FieldSchema> partCols = new ArrayList<FieldSchema>();
            partCols.add(new FieldSchema("ds", "string", "partition column, date but in string format as date type is not yet supported in QL"));
            tbl.setPartCols(partCols);
            tbl.setNumBuckets(512);
            tbl.setOwner("pchakka");
            tbl.setRetention(10);
            tbl.setSerdeParam("field.delim", "1");
            tbl.setSerdeParam("line.delim", "\n");
            tbl.setSerdeParam("mapkey.delim", "3");
            tbl.setSerdeParam("colelction.delim", "2");
            tbl.setSerdeParam("field.delim", "1");
            tbl.setSerializationLib(LazySimpleSerDe.class.getName());
            tbl.setStoredAsSubDirectories(false);
            this.setNullCreateTableGrants();
            try {
                this.hm.createTable(tbl);
            }
            catch (HiveException e) {
                e.printStackTrace();
                TestHive.assertTrue((String)("Unable to create table: " + tableName), (boolean)false);
            }
            this.validateTable(tbl, tableName);
            try {
                this.hm.dropTable("default", tableName, true, false);
                Table ft2 = this.hm.getTable("default", tableName, false);
                TestHive.assertNull((String)"Unable to drop table ", (Object)ft2);
            }
            catch (HiveException e) {
                TestHive.assertTrue((String)("Unable to drop table: " + tableName), (boolean)false);
            }
        }
        catch (Throwable e) {
            System.err.println(StringUtils.stringifyException((Throwable)e));
            System.err.println("testTable failed");
            throw e;
        }
    }

    private void setNullCreateTableGrants() {
        SessionState.get().setCreateTableGrants(null);
    }

    public void testThriftTable() throws Throwable {
        String tableName = "table_for_test_thrifttable";
        try {
            try {
                this.hm.dropTable("default", tableName);
            }
            catch (HiveException e1) {
                System.err.println(StringUtils.stringifyException((Throwable)e1));
                TestHive.assertTrue((String)"Unable to drop table", (boolean)false);
            }
            Table tbl = new Table("default", tableName);
            tbl.setInputFormatClass(SequenceFileInputFormat.class.getName());
            tbl.setOutputFormatClass(SequenceFileOutputFormat.class.getName());
            tbl.setSerializationLib(ThriftDeserializer.class.getName());
            tbl.setSerdeParam("serialization.class", Complex.class.getName());
            tbl.setSerdeParam("serialization.format", TBinaryProtocol.class.getName());
            tbl.setStoredAsSubDirectories(false);
            this.setNullCreateTableGrants();
            try {
                this.hm.createTable(tbl);
            }
            catch (HiveException e) {
                System.err.println(StringUtils.stringifyException((Throwable)e));
                TestHive.assertTrue((String)("Unable to create table: " + tableName), (boolean)false);
            }
            this.validateTable(tbl, tableName);
            this.hm.dropTable("default", tableName);
        }
        catch (Throwable e) {
            System.err.println(StringUtils.stringifyException((Throwable)e));
            System.err.println("testThriftTable() failed");
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMetaStoreApiTiming() throws Throwable {
        Logger logger = LogManager.getLogger((String)"hive.ql.metadata.Hive");
        Level oldLevel = logger.getLevel();
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        LoggerConfig loggerConfig = config.getLoggerConfig(logger.getName());
        loggerConfig.setLevel(Level.DEBUG);
        ctx.updateLoggers();
        StringAppender appender = StringAppender.createStringAppender("%m");
        appender.addToLogger(logger.getName(), Level.DEBUG);
        appender.start();
        try {
            this.hm.clearMetaCallTiming();
            this.hm.getAllDatabases();
            this.hm.dumpAndClearMetaCallTiming("test");
            String logStr = appender.getOutput();
            String expectedString = "getAllDatabases_()=";
            Assert.assertTrue((String)(logStr + " should contain <" + expectedString), (boolean)logStr.contains(expectedString));
            appender.reset();
            this.hm.dumpAndClearMetaCallTiming("test");
            logStr = appender.getOutput();
            Assert.assertFalse((String)(logStr + " should not contain <" + expectedString), (boolean)logStr.contains(expectedString));
        }
        finally {
            loggerConfig.setLevel(oldLevel);
            ctx.updateLoggers();
            appender.removeFromLogger(logger.getName());
        }
    }

    private void validateTable(Table tbl, String tableName) throws MetaException {
        Warehouse wh = new Warehouse((org.apache.hadoop.conf.Configuration)this.hiveConf);
        Table ft = null;
        try {
            tbl.getTTable().setPrivilegesIsSet(false);
            ft = this.hm.getTable("default", tableName);
            TestHive.assertNotNull((String)"Unable to fetch table", (Object)ft);
            ft.checkValidity((org.apache.hadoop.conf.Configuration)this.hiveConf);
            TestHive.assertEquals((String)("Table names didn't match for table: " + tableName), (String)tbl.getTableName(), (String)ft.getTableName());
            TestHive.assertEquals((String)("Table owners didn't match for table: " + tableName), (String)tbl.getOwner(), (String)ft.getOwner());
            TestHive.assertEquals((String)("Table retention didn't match for table: " + tableName), (int)tbl.getRetention(), (int)ft.getRetention());
            TestHive.assertEquals((String)"Data location is not set correctly", (String)wh.getTablePath(this.hm.getDatabase("default"), tableName).toString(), (String)ft.getDataLocation().toString());
            tbl.setDataLocation(ft.getDataLocation());
            tbl.setCreateTime(ft.getTTable().getCreateTime());
            tbl.getParameters().put("transient_lastDdlTime", ft.getParameters().get("transient_lastDdlTime"));
            TestHive.assertTrue((String)("Tables  doesn't match: " + tableName), (boolean)ft.getTTable().equals(tbl.getTTable()));
            TestHive.assertEquals((String)"SerializationLib is not set correctly", (String)tbl.getSerializationLib(), (String)ft.getSerializationLib());
            TestHive.assertEquals((String)"Serde is not set correctly", (String)tbl.getDeserializer().getClass().getName(), (String)ft.getDeserializer().getClass().getName());
        }
        catch (HiveException e) {
            System.err.println(StringUtils.stringifyException((Throwable)e));
            TestHive.assertTrue((String)("Unable to fetch table correctly: " + tableName), (boolean)false);
        }
    }

    private static Table createTestTable(String dbName, String tableName) throws HiveException {
        Table tbl = new Table(dbName, tableName);
        tbl.setInputFormatClass(SequenceFileInputFormat.class.getName());
        tbl.setOutputFormatClass(SequenceFileOutputFormat.class.getName());
        tbl.setSerializationLib(ThriftDeserializer.class.getName());
        tbl.setSerdeParam("serialization.class", Complex.class.getName());
        tbl.setSerdeParam("serialization.format", TBinaryProtocol.class.getName());
        return tbl;
    }

    public void testHiveCloseCurrent() throws Throwable {
        Hive hive1 = Hive.get();
        Hive.closeCurrent();
        Hive hive2 = Hive.get();
        Hive.closeCurrent();
        TestHive.assertTrue((hive1 != hive2 ? 1 : 0) != 0);
    }

    public void testGetAndDropTables() throws Throwable {
        try {
            String dbName = "db_for_testgettables";
            String table1Name = "table1";
            this.hm.dropDatabase(dbName, true, true, true);
            Database db = new Database();
            db.setName(dbName);
            this.hm.createDatabase(db);
            ArrayList<String> ts = new ArrayList<String>(2);
            ts.add(table1Name);
            ts.add("table2");
            Table tbl1 = TestHive.createTestTable(dbName, (String)ts.get(0));
            this.hm.createTable(tbl1);
            Table tbl2 = TestHive.createTestTable(dbName, (String)ts.get(1));
            this.hm.createTable(tbl2);
            List fts = this.hm.getTablesForDb(dbName, ".*");
            TestHive.assertEquals(ts, (Object)fts);
            TestHive.assertEquals((int)2, (int)fts.size());
            fts = this.hm.getTablesForDb(dbName, ".*1");
            TestHive.assertEquals((int)1, (int)fts.size());
            TestHive.assertEquals((String)((String)ts.get(0)), (String)((String)fts.get(0)));
            Table table1 = this.hm.getTable(dbName, table1Name);
            TestHive.assertNotNull((Object)table1);
            TestHive.assertEquals((String)table1Name, (String)table1.getTableName());
            FileSystem fs = table1.getPath().getFileSystem((org.apache.hadoop.conf.Configuration)this.hiveConf);
            TestHive.assertTrue((boolean)fs.exists(table1.getPath()));
            this.hm.dropTable(dbName, table1Name);
            TestHive.assertFalse((boolean)fs.exists(table1.getPath()));
            for (String tableName : this.hm.getAllTables(dbName)) {
                Table table = this.hm.getTable(dbName, tableName);
                this.hm.dropTable(dbName, tableName);
                TestHive.assertFalse((boolean)fs.exists(table.getPath()));
            }
            this.hm.dropDatabase(dbName);
        }
        catch (Throwable e) {
            System.err.println(StringUtils.stringifyException((Throwable)e));
            System.err.println("testGetAndDropTables() failed");
            throw e;
        }
    }

    public void testDropTableTrash() throws Throwable {
        if (!ShimLoader.getHadoopShims().supportTrashFeature()) {
            return;
        }
        try {
            String dbName = "db_for_testdroptable";
            this.hm.dropDatabase(dbName, true, true, true);
            Database db = new Database();
            db.setName(dbName);
            this.hm.createDatabase(db);
            ArrayList<String> ts = new ArrayList<String>(2);
            String tableBaseName = "droptable";
            ts.add(tableBaseName + "1");
            ts.add(tableBaseName + "2");
            Table tbl1 = TestHive.createTestTable(dbName, (String)ts.get(0));
            this.hm.createTable(tbl1);
            Table tbl2 = TestHive.createTestTable(dbName, (String)ts.get(1));
            this.hm.createTable(tbl2);
            Table table1 = this.hm.getTable(dbName, (String)ts.get(0));
            TestHive.assertNotNull((Object)table1);
            TestHive.assertEquals((String)((String)ts.get(0)), (String)table1.getTableName());
            Path path1 = table1.getPath();
            FileSystem fs = path1.getFileSystem((org.apache.hadoop.conf.Configuration)this.hiveConf);
            TestHive.assertTrue((boolean)fs.exists(path1));
            Path trashDir = ShimLoader.getHadoopShims().getCurrentTrashPath((org.apache.hadoop.conf.Configuration)this.hiveConf, fs);
            TestHive.assertNotNull((String)"trash directory should not be null", (Object)trashDir);
            Path trash1 = TestHive.mergePaths(trashDir, path1);
            Path pathglob = trash1.suffix("*");
            Object[] before = fs.globStatus(pathglob);
            this.hm.dropTable(dbName, (String)ts.get(0));
            TestHive.assertFalse((boolean)fs.exists(path1));
            Object[] after = fs.globStatus(pathglob);
            TestHive.assertTrue((String)"trash dir before and after DROP TABLE noPURGE are not different", (before.length != after.length ? 1 : 0) != 0);
            Table table2 = this.hm.getTable(dbName, (String)ts.get(1));
            TestHive.assertNotNull((Object)table2);
            TestHive.assertEquals((String)((String)ts.get(1)), (String)table2.getTableName());
            Path path2 = table2.getPath();
            TestHive.assertTrue((boolean)fs.exists(path2));
            Path trash2 = TestHive.mergePaths(trashDir, path2);
            System.out.println("trashDir2 is " + trash2);
            pathglob = trash2.suffix("*");
            before = fs.globStatus(pathglob);
            this.hm.dropTable(dbName, (String)ts.get(1), true, true, true);
            TestHive.assertFalse((boolean)fs.exists(path2));
            after = fs.globStatus(pathglob);
            Arrays.sort(before);
            Arrays.sort(after);
            TestHive.assertEquals((String)"trash dir before and after DROP TABLE PURGE are different", (int)before.length, (int)after.length);
            TestHive.assertTrue((String)"trash dir before and after DROP TABLE PURGE are different", (boolean)Arrays.equals(before, after));
            for (String tableName : this.hm.getAllTables(dbName)) {
                Table table = this.hm.getTable(dbName, tableName);
                this.hm.dropTable(dbName, tableName);
                TestHive.assertFalse((boolean)fs.exists(table.getPath()));
            }
            this.hm.dropDatabase(dbName);
        }
        catch (Throwable e) {
            System.err.println(StringUtils.stringifyException((Throwable)e));
            System.err.println("testDropTableTrash() failed");
            throw e;
        }
    }

    private FileStatus[] getTrashContents() throws Exception {
        FileSystem fs = FileSystem.get((org.apache.hadoop.conf.Configuration)this.hiveConf);
        Path trashDir = ShimLoader.getHadoopShims().getCurrentTrashPath((org.apache.hadoop.conf.Configuration)this.hiveConf, fs);
        return fs.globStatus(trashDir.suffix("/*"));
    }

    private Table createPartitionedTable(String dbName, String tableName) throws Exception {
        try {
            this.hm.dropTable(dbName, tableName);
            this.hm.createTable(tableName, Arrays.asList("key", "value"), Arrays.asList("ds", "hr"), TextInputFormat.class, HiveIgnoreKeyTextOutputFormat.class);
            return this.hm.getTable(dbName, tableName);
        }
        catch (Exception exception) {
            TestHive.fail((String)("Unable to drop and create table " + dbName + CUR_DIR + tableName + " because " + StringUtils.stringifyException((Throwable)exception)));
            throw exception;
        }
    }

    private void cleanUpTableQuietly(String dbName, String tableName) {
        try {
            this.hm.dropTable(dbName, tableName, true, true, true);
        }
        catch (Exception exception) {
            TestHive.fail((String)("Unexpected exception: " + StringUtils.stringifyException((Throwable)exception)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDropPartitionsWithPurge() throws Exception {
        String dbName = "default";
        String tableName = "table_for_testDropPartitionsWithPurge";
        try {
            ImmutableMap partitionSpec = new ImmutableMap.Builder().put((Object)"ds", (Object)"20141216").put((Object)"hr", (Object)"12").build();
            int trashSizeBeforeDrop = this.getTrashContents().length;
            Table table = this.createPartitionedTable(dbName, tableName);
            this.hm.createPartition(table, (Map)partitionSpec);
            Partition partition = this.hm.getPartition(table, (Map)partitionSpec, false);
            TestHive.assertNotNull((String)"Newly created partition shouldn't be null!", (Object)partition);
            this.hm.dropPartition(dbName, tableName, partition.getValues(), PartitionDropOptions.instance().deleteData(true).purgeData(true));
            int trashSizeAfterDropPurge = this.getTrashContents().length;
            TestHive.assertEquals((String)"After dropPartitions(purge), trash should've remained unchanged!", (int)trashSizeBeforeDrop, (int)trashSizeAfterDropPurge);
            this.hm.createPartition(table, (Map)partitionSpec);
            partition = this.hm.getPartition(table, (Map)partitionSpec, false);
            TestHive.assertNotNull((String)"Newly created partition shouldn't be null!", (Object)partition);
            this.hm.dropPartition(dbName, tableName, partition.getValues(), PartitionDropOptions.instance().deleteData(true).purgeData(false));
            int trashSizeWithoutPurge = this.getTrashContents().length;
            TestHive.assertEquals((String)"After dropPartitions(noPurge), data should've gone to trash!", (int)trashSizeBeforeDrop, (int)trashSizeWithoutPurge);
        }
        catch (Exception e) {
            TestHive.fail((String)("Unexpected exception: " + StringUtils.stringifyException((Throwable)e)));
        }
        finally {
            this.cleanUpTableQuietly(dbName, tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAutoPurgeTablesAndPartitions() throws Throwable {
        String dbName = "default";
        String tableName = "table_for_testAutoPurgeTablesAndPartitions";
        try {
            Table table = this.createPartitionedTable(dbName, tableName);
            table.getParameters().put("auto.purge", "true");
            this.hm.alterTable(tableName, table);
            ImmutableMap partitionSpec = new ImmutableMap.Builder().put((Object)"ds", (Object)"20141216").put((Object)"hr", (Object)"12").build();
            int trashSizeBeforeDrop = this.getTrashContents().length;
            this.hm.createPartition(table, (Map)partitionSpec);
            Partition partition = this.hm.getPartition(table, (Map)partitionSpec, false);
            TestHive.assertNotNull((String)"Newly created partition shouldn't be null!", (Object)partition);
            this.hm.dropPartition(dbName, tableName, partition.getValues(), PartitionDropOptions.instance().deleteData(true).purgeData(false));
            int trashSizeAfterDrop = this.getTrashContents().length;
            TestHive.assertEquals((String)"After dropPartition(noPurge), data should still have skipped trash.", (int)trashSizeBeforeDrop, (int)trashSizeAfterDrop);
            trashSizeBeforeDrop = trashSizeAfterDrop;
            this.hm.dropTable(dbName, tableName);
            trashSizeAfterDrop = this.getTrashContents().length;
            TestHive.assertEquals((String)"After dropTable(noPurge), data should still have skipped trash.", (int)trashSizeBeforeDrop, (int)trashSizeAfterDrop);
        }
        catch (Exception e) {
            TestHive.fail((String)("Unexpected failure: " + StringUtils.stringifyException((Throwable)e)));
        }
        finally {
            this.cleanUpTableQuietly(dbName, tableName);
        }
    }

    public void testPartition() throws Throwable {
        try {
            String tableName = "table_for_testpartition";
            try {
                this.hm.dropTable("default", tableName);
            }
            catch (HiveException e) {
                System.err.println(StringUtils.stringifyException((Throwable)e));
                TestHive.assertTrue((String)("Unable to drop table: " + tableName), (boolean)false);
            }
            LinkedList<String> cols = new LinkedList<String>();
            cols.add("key");
            cols.add("value");
            LinkedList<String> part_cols = new LinkedList<String>();
            part_cols.add("ds");
            part_cols.add("hr");
            try {
                this.hm.createTable(tableName, cols, part_cols, TextInputFormat.class, HiveIgnoreKeyTextOutputFormat.class);
            }
            catch (HiveException e) {
                System.err.println(StringUtils.stringifyException((Throwable)e));
                TestHive.assertTrue((String)("Unable to create table: " + tableName), (boolean)false);
            }
            Table tbl = null;
            try {
                tbl = this.hm.getTable("default", tableName);
            }
            catch (HiveException e) {
                System.err.println(StringUtils.stringifyException((Throwable)e));
                TestHive.assertTrue((String)("Unable to fetch table: " + tableName), (boolean)false);
            }
            HashMap<String, String> part_spec = new HashMap<String, String>();
            part_spec.clear();
            part_spec.put("ds", "2008-04-08");
            part_spec.put("hr", "12");
            try {
                this.hm.createPartition(tbl, part_spec);
            }
            catch (HiveException e) {
                System.err.println(StringUtils.stringifyException((Throwable)e));
                TestHive.assertTrue((String)("Unable to create parition for table: " + tableName), (boolean)false);
            }
            this.hm.dropTable("default", tableName);
        }
        catch (Throwable e) {
            System.err.println(StringUtils.stringifyException((Throwable)e));
            System.err.println("testPartition() failed");
            throw e;
        }
    }

    public void testIndex() throws Throwable {
        try {
            String tableName = "table_for_testindex";
            String qTableName = "default." + tableName;
            try {
                this.hm.dropTable("default", tableName);
            }
            catch (HiveException e) {
                e.printStackTrace();
                TestHive.assertTrue((String)"Unable to drop table", (boolean)false);
            }
            Table tbl = new Table("default", tableName);
            List fields = tbl.getCols();
            fields.add(new FieldSchema("col1", "int", "int -- first column"));
            fields.add(new FieldSchema("col2", "string", "string -- second column"));
            fields.add(new FieldSchema("col3", "double", "double -- thrift column"));
            tbl.setFields(fields);
            tbl.setOutputFormatClass(HiveIgnoreKeyTextOutputFormat.class);
            tbl.setInputFormatClass(SequenceFileInputFormat.class);
            try {
                this.hm.createTable(tbl);
            }
            catch (HiveException e) {
                e.printStackTrace();
                TestHive.assertTrue((String)("Unable to create table: " + tableName), (boolean)false);
            }
            String indexName = "index_on_table_for_testindex";
            String indexHandlerClass = HiveIndex.IndexType.COMPACT_SUMMARY_TABLE.getHandlerClsName();
            ArrayList<String> indexedCols = new ArrayList<String>();
            indexedCols.add("col1");
            String indexTableName = "index_on_table_for_testindex_table";
            String qIndexTableName = "default." + indexTableName;
            boolean deferredRebuild = true;
            String inputFormat = SequenceFileInputFormat.class.getName();
            String outputFormat = SequenceFileOutputFormat.class.getName();
            String serde = null;
            String storageHandler = null;
            String location = null;
            String collItemDelim = null;
            String fieldDelim = null;
            String fieldEscape = null;
            String lineDelim = null;
            String mapKeyDelim = null;
            String indexComment = null;
            Map indexProps = null;
            Map tableProps = null;
            HashMap serdeProps = new HashMap();
            this.hm.createIndex(qTableName, indexName, indexHandlerClass, indexedCols, qIndexTableName, deferredRebuild, inputFormat, outputFormat, serde, storageHandler, location, indexProps, tableProps, serdeProps, collItemDelim, fieldDelim, fieldEscape, lineDelim, mapKeyDelim, indexComment);
            Index index = null;
            try {
                index = this.hm.getIndex(tableName, indexName);
                TestHive.assertNotNull((String)"Unable to fetch index", (Object)index);
                index.validate();
                TestHive.assertEquals((String)("Index names don't match for index: " + indexName), (String)indexName, (String)index.getIndexName());
                TestHive.assertEquals((String)("Table names don't match for index: " + indexName), (String)tableName, (String)index.getOrigTableName());
                TestHive.assertEquals((String)("Index table names didn't match for index: " + indexName), (String)indexTableName, (String)index.getIndexTableName());
                TestHive.assertEquals((String)("Index handler classes didn't match for index: " + indexName), (String)indexHandlerClass, (String)index.getIndexHandlerClass());
                TestHive.assertEquals((String)("Deferred rebuild didn't match for index: " + indexName), (boolean)deferredRebuild, (boolean)index.isDeferredRebuild());
            }
            catch (HiveException e) {
                System.err.println(StringUtils.stringifyException((Throwable)e));
                TestHive.assertTrue((String)("Unable to fetch index correctly: " + indexName), (boolean)false);
            }
            try {
                this.hm.dropIndex("default", tableName, indexName, false, true);
            }
            catch (HiveException e) {
                System.err.println(StringUtils.stringifyException((Throwable)e));
                TestHive.assertTrue((String)("Unable to drop index: " + indexName), (boolean)false);
            }
            boolean dropIndexException = false;
            try {
                this.hm.getIndex(tableName, indexName);
            }
            catch (HiveException e) {
                dropIndexException = true;
            }
            TestHive.assertTrue((String)("Unable to drop index: " + indexName), (boolean)dropIndexException);
            try {
                this.hm.dropTable(tableName);
                Table droppedTable = this.hm.getTable(tableName, false);
                TestHive.assertNull((String)("Unable to drop table " + tableName), (Object)droppedTable);
            }
            catch (HiveException e) {
                System.err.println(StringUtils.stringifyException((Throwable)e));
                TestHive.assertTrue((String)("Unable to drop table: " + tableName), (boolean)false);
            }
        }
        catch (Throwable e) {
            System.err.println(StringUtils.stringifyException((Throwable)e));
            System.err.println("testIndex failed");
            throw e;
        }
    }

    public void testHiveRefreshOnConfChange() throws Throwable {
        Hive prevHiveObj = Hive.get();
        prevHiveObj.getDatabaseCurrent();
        HiveConf newHconf = new HiveConf(this.hiveConf);
        Hive newHiveObj = Hive.get((HiveConf)newHconf);
        TestHive.assertTrue((prevHiveObj == newHiveObj ? 1 : 0) != 0);
        newHiveObj = Hive.get((HiveConf)newHconf, (boolean)true);
        TestHive.assertTrue((prevHiveObj != newHiveObj ? 1 : 0) != 0);
        prevHiveObj = Hive.get();
        prevHiveObj.getDatabaseCurrent();
        newHconf = new HiveConf(this.hiveConf);
        newHconf.setIntVar(HiveConf.ConfVars.METASTORETHRIFTCONNECTIONRETRIES, newHconf.getIntVar(HiveConf.ConfVars.METASTORETHRIFTCONNECTIONRETRIES) + 1);
        newHiveObj = Hive.get((HiveConf)newHconf);
        TestHive.assertTrue((prevHiveObj != newHiveObj ? 1 : 0) != 0);
    }

    private static Path mergePaths(Path path1, Path path2) {
        String path2Str = path2.toUri().getPath();
        path2Str = path2Str.substring(TestHive.startPositionWithoutWindowsDrive(path2Str));
        return new Path(path1.toUri().getScheme(), path1.toUri().getAuthority(), path1.toUri().getPath() + path2Str);
    }

    private static int startPositionWithoutWindowsDrive(String path) {
        if (TestHive.hasWindowsDrive(path)) {
            return path.charAt(0) == '/' ? 3 : 2;
        }
        return 0;
    }

    private static boolean hasWindowsDrive(String path) {
        return WINDOWS && hasDriveLetterSpecifier.matcher(path).find();
    }
}

