/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFAesDecrypt;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableBinaryObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableStringObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;

public class TestGenericUDFAesDecrypt {
    @Test
    public void testAesDec128ConstStr() throws HiveException {
        GenericUDFAesDecrypt udf = new GenericUDFAesDecrypt();
        WritableBinaryObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.writableBinaryObjectInspector;
        Text keyWr = new Text("1234567890123456");
        ConstantObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.getPrimitiveWritableConstantObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.stringTypeInfo, (Object)keyWr);
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI0, valueOI1};
        udf.initialize(arguments);
        this.runAndVerifyStr("y6Ss+zCYObpCbgfWfyNWTw==", keyWr, "ABC", udf);
        this.runAndVerifyStr("BQGHoM3lqYcsurCRq3PlUw==", keyWr, "", udf);
        this.runAndVerifyStr(null, keyWr, null, udf);
    }

    @Test
    public void testAesDec256ConstStr() throws HiveException, NoSuchAlgorithmException {
        int maxKeyLen = Cipher.getMaxAllowedKeyLength("AES");
        if (maxKeyLen < 256) {
            return;
        }
        GenericUDFAesDecrypt udf = new GenericUDFAesDecrypt();
        WritableBinaryObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.writableBinaryObjectInspector;
        Text keyWr = new Text("12345678901234561234567890123456");
        ConstantObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.getPrimitiveWritableConstantObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.stringTypeInfo, (Object)keyWr);
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI0, valueOI1};
        udf.initialize(arguments);
        this.runAndVerifyStr("nYfCuJeRd5eD60yXDw7WEA==", keyWr, "ABC", udf);
        this.runAndVerifyStr("mVClVqZ6W4VF6b842FOgCA==", keyWr, "", udf);
        this.runAndVerifyStr(null, keyWr, null, udf);
    }

    @Test
    public void testAesDec128Str() throws HiveException {
        GenericUDFAesDecrypt udf = new GenericUDFAesDecrypt();
        WritableBinaryObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.writableBinaryObjectInspector;
        WritableStringObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI0, valueOI1};
        udf.initialize(arguments);
        Text keyWr = new Text("1234567890123456");
        this.runAndVerifyStr("y6Ss+zCYObpCbgfWfyNWTw==", keyWr, "ABC", udf);
        this.runAndVerifyStr("BQGHoM3lqYcsurCRq3PlUw==", keyWr, "", udf);
        this.runAndVerifyStr(null, keyWr, null, udf);
    }

    @Test
    public void testAesDec128ConstBin() throws HiveException {
        GenericUDFAesDecrypt udf = new GenericUDFAesDecrypt();
        WritableBinaryObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.writableBinaryObjectInspector;
        BytesWritable keyWr = new BytesWritable("1234567890123456".getBytes());
        ConstantObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.getPrimitiveWritableConstantObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.binaryTypeInfo, (Object)keyWr);
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI0, valueOI1};
        udf.initialize(arguments);
        this.runAndVerifyBin("y6Ss+zCYObpCbgfWfyNWTw==", keyWr, "ABC", udf);
        this.runAndVerifyBin("BQGHoM3lqYcsurCRq3PlUw==", keyWr, "", udf);
        this.runAndVerifyBin(null, keyWr, null, udf);
    }

    @Test
    public void testAesDec128Bin() throws HiveException {
        GenericUDFAesDecrypt udf = new GenericUDFAesDecrypt();
        WritableBinaryObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.writableBinaryObjectInspector;
        WritableBinaryObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.writableBinaryObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI0, valueOI1};
        udf.initialize(arguments);
        BytesWritable keyWr = new BytesWritable("1234567890123456".getBytes());
        this.runAndVerifyBin("y6Ss+zCYObpCbgfWfyNWTw==", keyWr, "ABC", udf);
        this.runAndVerifyBin("BQGHoM3lqYcsurCRq3PlUw==", keyWr, "", udf);
        this.runAndVerifyBin(null, keyWr, null, udf);
    }

    @Test
    public void testAesDec192Bin() throws HiveException, NoSuchAlgorithmException {
        int maxKeyLen = Cipher.getMaxAllowedKeyLength("AES");
        if (maxKeyLen < 192) {
            return;
        }
        GenericUDFAesDecrypt udf = new GenericUDFAesDecrypt();
        WritableBinaryObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.writableBinaryObjectInspector;
        WritableBinaryObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.writableBinaryObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI0, valueOI1};
        udf.initialize(arguments);
        BytesWritable keyWr = new BytesWritable("123456789012345612345678".getBytes());
        this.runAndVerifyBin("ucvvpP9r2/LfQ6BilQuFtA==", keyWr, "ABC", udf);
        this.runAndVerifyBin("KqMT3cF6VwSISMaUVUB4Qw==", keyWr, "", udf);
        this.runAndVerifyBin(null, keyWr, null, udf);
    }

    @Test
    public void testAesDecKeyNullConstStr() throws HiveException {
        GenericUDFAesDecrypt udf = new GenericUDFAesDecrypt();
        WritableBinaryObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.writableBinaryObjectInspector;
        Text keyWr = null;
        ConstantObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.getPrimitiveWritableConstantObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.stringTypeInfo, keyWr);
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI0, valueOI1};
        udf.initialize(arguments);
        this.runAndVerifyStr("y6Ss+zCYObpCbgfWfyNWTw==", keyWr, null, udf);
    }

    @Test
    public void testAesDecKeyNullStr() throws HiveException {
        GenericUDFAesDecrypt udf = new GenericUDFAesDecrypt();
        WritableBinaryObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.writableBinaryObjectInspector;
        WritableStringObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI0, valueOI1};
        udf.initialize(arguments);
        Text keyWr = null;
        this.runAndVerifyStr("y6Ss+zCYObpCbgfWfyNWTw==", keyWr, null, udf);
    }

    @Test
    public void testAesDecKeyNullConstBin() throws HiveException {
        GenericUDFAesDecrypt udf = new GenericUDFAesDecrypt();
        WritableBinaryObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.writableBinaryObjectInspector;
        BytesWritable keyWr = null;
        ConstantObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.getPrimitiveWritableConstantObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.binaryTypeInfo, keyWr);
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI0, valueOI1};
        udf.initialize(arguments);
        this.runAndVerifyBin("y6Ss+zCYObpCbgfWfyNWTw==", keyWr, null, udf);
    }

    @Test
    public void testAesDecKeyNullBin() throws HiveException {
        GenericUDFAesDecrypt udf = new GenericUDFAesDecrypt();
        WritableBinaryObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.writableBinaryObjectInspector;
        WritableBinaryObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.writableBinaryObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI0, valueOI1};
        udf.initialize(arguments);
        BytesWritable keyWr = null;
        this.runAndVerifyBin("y6Ss+zCYObpCbgfWfyNWTw==", keyWr, null, udf);
    }

    private void runAndVerifyStr(String strBase64, Text keyWr, String expResult, GenericUDFAesDecrypt udf) throws HiveException {
        GenericUDF.DeferredJavaObject valueObj0 = new GenericUDF.DeferredJavaObject((Object)(strBase64 != null ? new BytesWritable(Base64.decodeBase64((String)strBase64)) : null));
        GenericUDF.DeferredJavaObject valueObj1 = new GenericUDF.DeferredJavaObject((Object)keyWr);
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{valueObj0, valueObj1};
        BytesWritable output = (BytesWritable)udf.evaluate(args);
        String expResultHex = expResult == null ? null : Hex.encodeHexString((byte[])expResult.getBytes());
        Assert.assertEquals((String)"aes_decrypt() test ", (Object)expResultHex, output != null ? this.copyBytesAndHex(output) : null);
    }

    private void runAndVerifyBin(String strBase64, BytesWritable keyWr, String expResult, GenericUDFAesDecrypt udf) throws HiveException {
        GenericUDF.DeferredJavaObject valueObj0 = new GenericUDF.DeferredJavaObject((Object)(strBase64 != null ? new BytesWritable(Base64.decodeBase64((String)strBase64)) : null));
        GenericUDF.DeferredJavaObject valueObj1 = new GenericUDF.DeferredJavaObject((Object)keyWr);
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{valueObj0, valueObj1};
        BytesWritable output = (BytesWritable)udf.evaluate(args);
        String expResultHex = expResult == null ? null : Hex.encodeHexString((byte[])expResult.getBytes());
        Assert.assertEquals((String)"aes_decrypt() test ", (Object)expResultHex, output != null ? this.copyBytesAndHex(output) : null);
    }

    private String copyBytesAndHex(BytesWritable bw) {
        int size = bw.getLength();
        byte[] bytes = new byte[size];
        System.arraycopy(bw.getBytes(), 0, bytes, 0, size);
        return Hex.encodeHexString((byte[])bytes);
    }
}

