/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFAesEncrypt;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableBinaryObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableStringObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;

public class TestGenericUDFAesEncrypt {
    @Test
    public void testAesEnc128ConstStr() throws HiveException {
        GenericUDFAesEncrypt udf = new GenericUDFAesEncrypt();
        WritableStringObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        Text keyWr = new Text("1234567890123456");
        ConstantObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.getPrimitiveWritableConstantObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.stringTypeInfo, (Object)keyWr);
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI0, valueOI1};
        udf.initialize(arguments);
        this.runAndVerifyStr("ABC", keyWr, "y6Ss+zCYObpCbgfWfyNWTw==", udf);
        this.runAndVerifyStr("", keyWr, "BQGHoM3lqYcsurCRq3PlUw==", udf);
        this.runAndVerifyStr(null, keyWr, null, udf);
    }

    @Test
    public void testAesEnc256ConstStr() throws HiveException, NoSuchAlgorithmException {
        int maxKeyLen = Cipher.getMaxAllowedKeyLength("AES");
        if (maxKeyLen < 256) {
            return;
        }
        GenericUDFAesEncrypt udf = new GenericUDFAesEncrypt();
        WritableStringObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        Text keyWr = new Text("12345678901234561234567890123456");
        ConstantObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.getPrimitiveWritableConstantObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.stringTypeInfo, (Object)keyWr);
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI0, valueOI1};
        udf.initialize(arguments);
        this.runAndVerifyStr("ABC", keyWr, "nYfCuJeRd5eD60yXDw7WEA==", udf);
        this.runAndVerifyStr("", keyWr, "mVClVqZ6W4VF6b842FOgCA==", udf);
        this.runAndVerifyStr(null, keyWr, null, udf);
    }

    @Test
    public void testAesEnc128Str() throws HiveException {
        GenericUDFAesEncrypt udf = new GenericUDFAesEncrypt();
        WritableStringObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        WritableStringObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI0, valueOI1};
        udf.initialize(arguments);
        Text keyWr = new Text("1234567890123456");
        this.runAndVerifyStr("ABC", keyWr, "y6Ss+zCYObpCbgfWfyNWTw==", udf);
        this.runAndVerifyStr("", keyWr, "BQGHoM3lqYcsurCRq3PlUw==", udf);
        this.runAndVerifyStr(null, keyWr, null, udf);
    }

    @Test
    public void testAesEnc128ConstBin() throws HiveException {
        GenericUDFAesEncrypt udf = new GenericUDFAesEncrypt();
        WritableBinaryObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.writableBinaryObjectInspector;
        BytesWritable keyWr = new BytesWritable("1234567890123456".getBytes());
        ConstantObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.getPrimitiveWritableConstantObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.binaryTypeInfo, (Object)keyWr);
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI0, valueOI1};
        udf.initialize(arguments);
        this.runAndVerifyBin(new byte[]{65, 66, 67}, keyWr, "y6Ss+zCYObpCbgfWfyNWTw==", udf);
        this.runAndVerifyBin(new byte[0], keyWr, "BQGHoM3lqYcsurCRq3PlUw==", udf);
        this.runAndVerifyBin(null, keyWr, null, udf);
    }

    @Test
    public void testAesEnc128Bin() throws HiveException {
        GenericUDFAesEncrypt udf = new GenericUDFAesEncrypt();
        WritableBinaryObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.writableBinaryObjectInspector;
        WritableBinaryObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.writableBinaryObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI0, valueOI1};
        udf.initialize(arguments);
        BytesWritable keyWr = new BytesWritable("1234567890123456".getBytes());
        this.runAndVerifyBin(new byte[]{65, 66, 67}, keyWr, "y6Ss+zCYObpCbgfWfyNWTw==", udf);
        this.runAndVerifyBin(new byte[0], keyWr, "BQGHoM3lqYcsurCRq3PlUw==", udf);
        this.runAndVerifyBin(null, keyWr, null, udf);
    }

    @Test
    public void testAesEnc192Bin() throws HiveException, NoSuchAlgorithmException {
        int maxKeyLen = Cipher.getMaxAllowedKeyLength("AES");
        if (maxKeyLen < 192) {
            return;
        }
        GenericUDFAesEncrypt udf = new GenericUDFAesEncrypt();
        WritableBinaryObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.writableBinaryObjectInspector;
        WritableBinaryObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.writableBinaryObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI0, valueOI1};
        udf.initialize(arguments);
        BytesWritable keyWr = new BytesWritable("123456789012345612345678".getBytes());
        this.runAndVerifyBin(new byte[]{65, 66, 67}, keyWr, "ucvvpP9r2/LfQ6BilQuFtA==", udf);
        this.runAndVerifyBin(new byte[0], keyWr, "KqMT3cF6VwSISMaUVUB4Qw==", udf);
        this.runAndVerifyBin(null, keyWr, null, udf);
    }

    @Test
    public void testAesEncKeyNullConstStr() throws HiveException {
        GenericUDFAesEncrypt udf = new GenericUDFAesEncrypt();
        WritableStringObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        Text keyWr = null;
        ConstantObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.getPrimitiveWritableConstantObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.stringTypeInfo, keyWr);
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI0, valueOI1};
        udf.initialize(arguments);
        this.runAndVerifyStr("ABC", keyWr, null, udf);
    }

    @Test
    public void testAesEncKeyNullStr() throws HiveException {
        GenericUDFAesEncrypt udf = new GenericUDFAesEncrypt();
        WritableStringObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        WritableStringObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI0, valueOI1};
        udf.initialize(arguments);
        Text keyWr = null;
        this.runAndVerifyStr("ABC", keyWr, null, udf);
    }

    @Test
    public void testAesEncKeyNullConstBin() throws HiveException {
        GenericUDFAesEncrypt udf = new GenericUDFAesEncrypt();
        WritableBinaryObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.writableBinaryObjectInspector;
        BytesWritable keyWr = null;
        ConstantObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.getPrimitiveWritableConstantObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.binaryTypeInfo, keyWr);
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI0, valueOI1};
        udf.initialize(arguments);
        this.runAndVerifyBin(new byte[]{65, 66, 67}, keyWr, null, udf);
    }

    @Test
    public void testAesEncKeyNullBin() throws HiveException {
        GenericUDFAesEncrypt udf = new GenericUDFAesEncrypt();
        WritableBinaryObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.writableBinaryObjectInspector;
        WritableBinaryObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.writableBinaryObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI0, valueOI1};
        udf.initialize(arguments);
        BytesWritable keyWr = null;
        this.runAndVerifyBin(new byte[]{65, 66, 67}, keyWr, null, udf);
    }

    private void runAndVerifyStr(String str, Text keyWr, String expResultBase64, GenericUDFAesEncrypt udf) throws HiveException {
        GenericUDF.DeferredJavaObject valueObj0 = new GenericUDF.DeferredJavaObject((Object)(str != null ? new Text(str) : null));
        GenericUDF.DeferredJavaObject valueObj1 = new GenericUDF.DeferredJavaObject((Object)keyWr);
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{valueObj0, valueObj1};
        BytesWritable output = (BytesWritable)udf.evaluate(args);
        Assert.assertEquals((String)"aes_encrypt() test ", (Object)expResultBase64, output != null ? this.copyBytesAndBase64(output) : null);
    }

    private void runAndVerifyBin(byte[] b, BytesWritable keyWr, String expResultBase64, GenericUDFAesEncrypt udf) throws HiveException {
        GenericUDF.DeferredJavaObject valueObj0 = new GenericUDF.DeferredJavaObject((Object)(b != null ? new BytesWritable(b) : null));
        GenericUDF.DeferredJavaObject valueObj1 = new GenericUDF.DeferredJavaObject((Object)keyWr);
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{valueObj0, valueObj1};
        BytesWritable output = (BytesWritable)udf.evaluate(args);
        Assert.assertEquals((String)"aes_encrypt() test ", (Object)expResultBase64, output != null ? this.copyBytesAndBase64(output) : null);
    }

    private String copyBytesAndBase64(BytesWritable bw) {
        int size = bw.getLength();
        byte[] bytes = new byte[size];
        System.arraycopy(bw.getBytes(), 0, bytes, 0, size);
        return new String(Base64.encodeBase64((byte[])bytes));
    }
}

