/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.sql.Timestamp;
import junit.framework.TestCase;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFLastDay;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableStringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableTimestampObjectInspector;
import org.apache.hadoop.io.Text;

public class TestGenericUDFLastDay
extends TestCase {
    public void testLastDay() throws HiveException {
        GenericUDFLastDay udf = new GenericUDFLastDay();
        WritableStringObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI0};
        udf.initialize(arguments);
        this.runAndVerify("2014-01-01", "2014-01-31", (GenericUDF)udf);
        this.runAndVerify("2014-01-14", "2014-01-31", (GenericUDF)udf);
        this.runAndVerify("2014-01-31", "2014-01-31", (GenericUDF)udf);
        this.runAndVerify("2014-02-02", "2014-02-28", (GenericUDF)udf);
        this.runAndVerify("2014-02-28", "2014-02-28", (GenericUDF)udf);
        this.runAndVerify("2016-02-03", "2016-02-29", (GenericUDF)udf);
        this.runAndVerify("2016-02-28", "2016-02-29", (GenericUDF)udf);
        this.runAndVerify("2016-02-29", "2016-02-29", (GenericUDF)udf);
        this.runAndVerify("2016-02-30", "2016-03-31", (GenericUDF)udf);
        this.runAndVerify("2014-01-32", "2014-02-28", (GenericUDF)udf);
        this.runAndVerify("01/14/2014", null, (GenericUDF)udf);
        this.runAndVerify(null, null, (GenericUDF)udf);
        this.runAndVerify("2014-01-01 10:30:45", "2014-01-31", (GenericUDF)udf);
        this.runAndVerify("2014-01-14 10:30:45", "2014-01-31", (GenericUDF)udf);
        this.runAndVerify("2014-01-31 10:30:45.1", "2014-01-31", (GenericUDF)udf);
        this.runAndVerify("2014-02-02 10:30:45.100", "2014-02-28", (GenericUDF)udf);
        this.runAndVerify("2014-02-28 10:30:45.001", "2014-02-28", (GenericUDF)udf);
        this.runAndVerify("2016-02-03 10:30:45.000000001", "2016-02-29", (GenericUDF)udf);
        this.runAndVerify("2016-02-28 10:30:45", "2016-02-29", (GenericUDF)udf);
        this.runAndVerify("2016-02-29 10:30:45", "2016-02-29", (GenericUDF)udf);
        this.runAndVerify("2016-02-30 10:30:45", "2016-03-31", (GenericUDF)udf);
        this.runAndVerify("2014-01-32 10:30:45", "2014-02-28", (GenericUDF)udf);
        this.runAndVerify("01/14/2014 10:30:45", null, (GenericUDF)udf);
        this.runAndVerify("2016-02-28T10:30:45", "2016-02-29", (GenericUDF)udf);
        this.runAndVerifyTs("1966-01-31 00:00:01", "1966-01-31", (GenericUDF)udf);
        this.runAndVerifyTs("1966-01-31 10:00:01", "1966-01-31", (GenericUDF)udf);
        this.runAndVerifyTs("1966-01-31 23:59:59", "1966-01-31", (GenericUDF)udf);
    }

    public void testLastDayTs() throws HiveException {
        GenericUDFLastDay udf = new GenericUDFLastDay();
        WritableTimestampObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.writableTimestampObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI0};
        udf.initialize(arguments);
        this.runAndVerifyTs("2014-01-01 10:30:45", "2014-01-31", (GenericUDF)udf);
        this.runAndVerifyTs("2014-01-14 10:30:45", "2014-01-31", (GenericUDF)udf);
        this.runAndVerifyTs("2014-01-31 10:30:45.1", "2014-01-31", (GenericUDF)udf);
        this.runAndVerifyTs("2014-02-02 10:30:45.100", "2014-02-28", (GenericUDF)udf);
        this.runAndVerifyTs("2014-02-28 10:30:45.001", "2014-02-28", (GenericUDF)udf);
        this.runAndVerifyTs("2016-02-03 10:30:45.000000001", "2016-02-29", (GenericUDF)udf);
        this.runAndVerifyTs("2016-02-28 10:30:45", "2016-02-29", (GenericUDF)udf);
        this.runAndVerifyTs("2016-02-29 10:30:45", "2016-02-29", (GenericUDF)udf);
        this.runAndVerifyTs("1966-01-31 00:00:01", "1966-01-31", (GenericUDF)udf);
        this.runAndVerifyTs("1966-01-31 10:00:01", "1966-01-31", (GenericUDF)udf);
        this.runAndVerifyTs("1966-01-31 23:59:59", "1966-01-31", (GenericUDF)udf);
    }

    private void runAndVerify(String str, String expResult, GenericUDF udf) throws HiveException {
        GenericUDF.DeferredJavaObject valueObj0 = new GenericUDF.DeferredJavaObject((Object)(str != null ? new Text(str) : null));
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{valueObj0};
        Text output = (Text)udf.evaluate(args);
        TestGenericUDFLastDay.assertEquals((String)"last_day() test ", (String)expResult, (String)(output != null ? output.toString() : null));
    }

    private void runAndVerifyTs(String str, String expResult, GenericUDF udf) throws HiveException {
        GenericUDF.DeferredJavaObject valueObj0 = new GenericUDF.DeferredJavaObject((Object)(str != null ? new TimestampWritable(Timestamp.valueOf(str)) : null));
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{valueObj0};
        Text output = (Text)udf.evaluate(args);
        TestGenericUDFLastDay.assertEquals((String)"last_day() test ", (String)expResult, (String)(output != null ? output.toString() : null));
    }
}

