/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hplsql;

import org.apache.hive.hplsql.Exec;
import org.apache.hive.hplsql.HplsqlParser;

public class Converter {
    Exec exec;
    boolean trace = false;

    Converter(Exec e) {
        this.exec = e;
        this.trace = this.exec.getTrace();
    }

    String dataType(HplsqlParser.DtypeContext type, HplsqlParser.Dtype_lenContext len) {
        String t = this.exec.getText(type);
        boolean enclosed = false;
        if (t.charAt(0) == '[') {
            t = t.substring(1, t.length() - 1);
            enclosed = true;
        }
        if (t.equalsIgnoreCase("BIT")) {
            t = "TINYINT";
        } else if (t.equalsIgnoreCase("DATETIME") || t.equalsIgnoreCase("SMALLDATETIME")) {
            t = "TIMESTAMP";
        } else if ((t.equalsIgnoreCase("VARCHAR") || t.equalsIgnoreCase("NVARCHAR")) && len.T_MAX() != null) {
            t = "STRING";
        } else if (t.equalsIgnoreCase("VARCHAR2") || t.equalsIgnoreCase("NCHAR") || t.equalsIgnoreCase("NVARCHAR")) {
            t = "STRING";
        } else if (t.equalsIgnoreCase("NUMBER") || t.equalsIgnoreCase("NUMERIC")) {
            t = "DECIMAL";
            if (len != null) {
                t = t + this.exec.getText(len);
            }
        } else {
            if (len != null) {
                if (!enclosed) {
                    return this.exec.getText(type, type.getStart(), len.getStop());
                }
                return t + this.exec.getText(len, len.getStart(), len.getStop());
            }
            if (!enclosed) {
                return this.exec.getText(type, type.getStart(), type.getStop());
            }
        }
        return t;
    }
}

