/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hplsql;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.Calendar;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.RuleNode;
import org.apache.hive.hplsql.Exec;
import org.apache.hive.hplsql.HplsqlParser;
import org.apache.hive.hplsql.Interval;
import org.apache.hive.hplsql.Query;
import org.apache.hive.hplsql.Signal;
import org.apache.hive.hplsql.Var;

public class Expression {
    Exec exec;
    boolean trace = false;

    Expression(Exec e) {
        this.exec = e;
        this.trace = this.exec.getTrace();
    }

    public void exec(HplsqlParser.ExprContext ctx) {
        try {
            if (ctx.T_ADD() != null) {
                this.operatorAdd(ctx);
            } else if (ctx.T_SUB() != null) {
                this.operatorSub(ctx);
            } else if (ctx.T_MUL() != null) {
                this.operatorMultiply(ctx);
            } else if (ctx.T_DIV() != null) {
                this.operatorDiv(ctx);
            } else if (ctx.interval_item() != null) {
                this.createInterval(ctx);
            } else {
                this.visitChildren(ctx);
            }
        }
        catch (Exception e) {
            this.exec.signal(e);
        }
    }

    public void execSql(HplsqlParser.ExprContext ctx) {
        StringBuilder sql = new StringBuilder();
        if (ctx.T_OPEN_P() != null) {
            sql.append("(");
            sql.append(this.evalPop(ctx.expr(0)).toString());
            sql.append(")");
        } else if (ctx.T_ADD() != null) {
            sql.append(this.evalPop(ctx.expr(0)).toString());
            sql.append(" + ");
            sql.append(this.evalPop(ctx.expr(1)).toString());
        } else if (ctx.T_SUB() != null) {
            sql.append(this.evalPop(ctx.expr(0)).toString());
            sql.append(" - ");
            sql.append(this.evalPop(ctx.expr(1)).toString());
        } else if (ctx.interval_item() != null) {
            sql.append(this.exec.getFormattedText(ctx));
        } else {
            this.visitChildren(ctx);
            sql.append(this.exec.stackPop().toString());
        }
        this.exec.stackPush(sql);
    }

    public void execBool(HplsqlParser.Bool_exprContext ctx) {
        if (ctx.bool_expr_atom() != null) {
            this.eval(ctx.bool_expr_atom());
            return;
        }
        Var result = this.evalPop(ctx.bool_expr(0));
        if (ctx.T_OPEN_P() != null) {
            if (ctx.T_NOT() != null) {
                result.negate();
            }
        } else if (ctx.bool_expr_logical_operator() != null) {
            if (ctx.bool_expr_logical_operator().T_AND() != null) {
                if (result.isTrue()) {
                    result = this.evalPop(ctx.bool_expr(1));
                }
            } else if (ctx.bool_expr_logical_operator().T_OR() != null && !result.isTrue()) {
                result = this.evalPop(ctx.bool_expr(1));
            }
        }
        this.exec.stackPush(result);
    }

    public void execBoolSql(HplsqlParser.Bool_exprContext ctx) {
        StringBuilder sql = new StringBuilder();
        if (ctx.T_OPEN_P() != null) {
            sql.append("(");
            sql.append(this.evalPop(ctx.bool_expr(0)).toString());
            sql.append(")");
        } else if (ctx.bool_expr_atom() != null) {
            sql.append(this.evalPop(ctx.bool_expr_atom()).toString());
        } else if (ctx.bool_expr_logical_operator() != null) {
            sql.append(this.evalPop(ctx.bool_expr(0)).toString());
            sql.append(" " + ctx.bool_expr_logical_operator().getText() + " ");
            sql.append(this.evalPop(ctx.bool_expr(1)).toString());
        }
        this.exec.stackPush(sql);
    }

    public Integer execBoolBinary(HplsqlParser.Bool_expr_binaryContext ctx) {
        HplsqlParser.Bool_expr_binary_operatorContext op = ctx.bool_expr_binary_operator();
        if (op.T_EQUAL() != null || op.T_EQUAL2() != null) {
            this.operatorEqual(ctx, true);
        } else if (op.T_NOTEQUAL() != null || op.T_NOTEQUAL2() != null) {
            this.operatorEqual(ctx, false);
        } else if (op.T_GREATER() != null || op.T_LESS() != null || op.T_GREATEREQUAL() != null || op.T_LESSEQUAL() != null) {
            this.operatorCompare(ctx, op);
        } else {
            this.exec.stackPush(false);
        }
        return 0;
    }

    public Integer execBoolBinarySql(HplsqlParser.Bool_expr_binaryContext ctx) {
        StringBuilder sql = new StringBuilder();
        sql.append(this.evalPop(ctx.expr(0)).toString());
        sql.append(" " + this.exec.getFormattedText(ctx.bool_expr_binary_operator()) + " ");
        sql.append(this.evalPop(ctx.expr(1)).toString());
        this.exec.stackPush(sql);
        return 0;
    }

    public Integer execBoolUnary(HplsqlParser.Bool_expr_unaryContext ctx) {
        Var v2;
        Var v1;
        Var v;
        int cmp;
        boolean val = false;
        if (ctx.T_IS() != null) {
            val = this.evalPop(ctx.expr(0)).isNull();
            if (ctx.T_NOT() != null) {
                val = !val;
            }
        } else if (ctx.T_BETWEEN() != null && (cmp = (v = this.evalPop(ctx.expr(0))).compareTo(v1 = this.evalPop(ctx.expr(1)))) >= 0 && (cmp = v.compareTo(v2 = this.evalPop(ctx.expr(2)))) <= 0) {
            val = true;
        }
        this.exec.stackPush(val);
        return 0;
    }

    public Integer execBoolUnarySql(HplsqlParser.Bool_expr_unaryContext ctx) {
        StringBuilder sql = new StringBuilder();
        if (ctx.T_IS() != null) {
            sql.append(this.evalPop(ctx.expr(0)).toString());
            sql.append(" " + this.exec.getText(ctx, ctx.T_IS().getSymbol(), ctx.T_NULL().getSymbol()));
        } else if (ctx.T_BETWEEN() != null) {
            sql.append(this.evalPop(ctx.expr(0)).toString());
            sql.append(" " + ctx.T_BETWEEN().getText() + " ");
            sql.append(this.evalPop(ctx.expr(1)).toString());
            sql.append(" " + ctx.T_AND().getText() + " ");
            sql.append(this.evalPop(ctx.expr(2)).toString());
        } else if (ctx.bool_expr_single_in() != null) {
            this.singleInClauseSql(ctx.bool_expr_single_in(), sql);
        } else if (ctx.bool_expr_multi_in() != null) {
            this.multiInClauseSql(ctx.bool_expr_multi_in(), sql);
        }
        this.exec.stackPush(sql);
        return 0;
    }

    public void singleInClauseSql(HplsqlParser.Bool_expr_single_inContext ctx, StringBuilder sql) {
        sql.append(this.evalPop(ctx.expr(0)).toString());
        if (ctx.T_NOT() != null) {
            sql.append(" " + ctx.T_NOT().getText());
        }
        sql.append(" " + ctx.T_IN().getText() + " (");
        if (ctx.select_stmt() != null) {
            sql.append(this.evalPop(ctx.select_stmt()));
        } else {
            int cnt = ctx.expr().size();
            for (int i = 1; i < cnt; ++i) {
                sql.append(this.evalPop(ctx.expr(i)).toString());
                if (i + 1 >= cnt) continue;
                sql.append(", ");
            }
        }
        sql.append(")");
    }

    public void multiInClauseSql(HplsqlParser.Bool_expr_multi_inContext ctx, StringBuilder sql) {
        int cnt = ctx.expr().size();
        sql.append("(");
        for (int i = 0; i < cnt; ++i) {
            sql.append(this.evalPop(ctx.expr(i)).toString());
            if (i + 1 >= cnt) continue;
            sql.append(", ");
        }
        sql.append(")");
        if (ctx.T_NOT() != null) {
            sql.append(" " + ctx.T_NOT().getText());
        }
        sql.append(" " + ctx.T_IN().getText() + " (");
        if (ctx.select_stmt() != null) {
            sql.append(this.evalPop(ctx.select_stmt()));
        }
        sql.append(")");
    }

    public void execCursorAttribute(HplsqlParser.Expr_cursor_attributeContext ctx) {
        String name = ctx.ident().getText();
        Var val = new Var(Var.Type.BOOL);
        Var cursor = this.exec.findCursor(name);
        if (cursor != null) {
            Query query = (Query)cursor.value;
            if (query != null) {
                if (ctx.T_ISOPEN() != null) {
                    val.setValue(query.isOpen());
                } else if (ctx.T_FOUND() != null) {
                    val.setValue(query.isFound());
                } else if (ctx.T_NOTFOUND() != null) {
                    val.setValue(query.isNotFound());
                }
            }
            this.exec.stackPush(val);
        } else {
            this.trace(ctx, "Cursor not found: " + name);
            this.exec.signal(Signal.Type.SQLEXCEPTION);
        }
    }

    public void operatorAdd(HplsqlParser.ExprContext ctx) {
        Var v1 = this.evalPop(ctx.expr(0));
        Var v2 = this.evalPop(ctx.expr(1));
        if (v1.value == null || v2.value == null) {
            this.evalNull();
        } else if (v1.type == Var.Type.BIGINT && v2.type == Var.Type.BIGINT) {
            this.exec.stackPush(new Var((Long)v1.value + (Long)v2.value));
        } else if (v1.type == Var.Type.BIGINT && v2.type == Var.Type.DATE) {
            this.exec.stackPush(this.changeDateByInt((Date)v2.value, (Long)v1.value, true));
        } else if (v1.type == Var.Type.DATE && v2.type == Var.Type.BIGINT) {
            this.exec.stackPush(this.changeDateByInt((Date)v1.value, (Long)v2.value, true));
        } else if (v1.type == Var.Type.DATE && v2.type == Var.Type.INTERVAL) {
            this.exec.stackPush(new Var(((Interval)v2.value).dateChange((Date)v1.value, true)));
        } else if (v1.type == Var.Type.TIMESTAMP && v2.type == Var.Type.INTERVAL) {
            this.exec.stackPush(new Var(((Interval)v2.value).timestampChange((Timestamp)v1.value, true), v1.scale));
        } else {
            this.evalNull();
        }
    }

    public void operatorSub(HplsqlParser.ExprContext ctx) {
        Var v1 = this.evalPop(ctx.expr(0));
        Var v2 = this.evalPop(ctx.expr(1));
        if (v1.value == null || v2.value == null) {
            this.evalNull();
        } else if (v1.type == Var.Type.BIGINT && v2.type == Var.Type.BIGINT) {
            this.exec.stackPush(new Var((Long)v1.value - (Long)v2.value));
        } else if (v1.type == Var.Type.DATE && v2.type == Var.Type.BIGINT) {
            this.exec.stackPush(this.changeDateByInt((Date)v1.value, (Long)v2.value, false));
        } else if (v1.type == Var.Type.DATE && v2.type == Var.Type.INTERVAL) {
            this.exec.stackPush(new Var(((Interval)v2.value).dateChange((Date)v1.value, false)));
        } else if (v1.type == Var.Type.TIMESTAMP && v2.type == Var.Type.INTERVAL) {
            this.exec.stackPush(new Var(((Interval)v2.value).timestampChange((Timestamp)v1.value, false), v1.scale));
        } else {
            this.evalNull();
        }
    }

    public void operatorMultiply(HplsqlParser.ExprContext ctx) {
        Var v1 = this.evalPop(ctx.expr(0));
        Var v2 = this.evalPop(ctx.expr(1));
        if (v1.value == null || v2.value == null) {
            this.evalNull();
        } else if (v1.type == Var.Type.BIGINT && v2.type == Var.Type.BIGINT) {
            this.exec.stackPush(new Var((Long)v1.value * (Long)v2.value));
        } else {
            this.exec.signal(Signal.Type.UNSUPPORTED_OPERATION, "Unsupported data types in multiplication operator");
        }
    }

    public void operatorDiv(HplsqlParser.ExprContext ctx) {
        Var v1 = this.evalPop(ctx.expr(0));
        Var v2 = this.evalPop(ctx.expr(1));
        if (v1.value == null || v2.value == null) {
            this.evalNull();
        } else if (v1.type == Var.Type.BIGINT && v2.type == Var.Type.BIGINT) {
            this.exec.stackPush(new Var((Long)v1.value / (Long)v2.value));
        } else {
            this.exec.signal(Signal.Type.UNSUPPORTED_OPERATION, "Unsupported data types in division operator");
        }
    }

    public Var changeDateByInt(Date d, Long i, boolean add) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(d.getTime());
        int days = i.intValue();
        if (!add) {
            days *= -1;
        }
        c.add(5, days);
        return new Var(new Date(c.getTimeInMillis()));
    }

    public void operatorEqual(HplsqlParser.Bool_expr_binaryContext ctx, boolean equal) {
        Var v1 = this.evalPop(ctx.expr(0));
        Var v2 = this.evalPop(ctx.expr(1));
        boolean eq = v1.equals(v2);
        if (!equal) {
            eq = !eq;
        }
        this.exec.stackPush(eq);
    }

    public void operatorCompare(HplsqlParser.Bool_expr_binaryContext ctx, HplsqlParser.Bool_expr_binary_operatorContext op) {
        Var v1 = this.evalPop(ctx.expr(0));
        Var v2 = this.evalPop(ctx.expr(1));
        int cmp = v1.compareTo(v2);
        boolean bool = false;
        if (op.T_GREATER() != null) {
            if (cmp > 0) {
                bool = true;
            }
        } else if (op.T_GREATEREQUAL() != null && cmp >= 0) {
            bool = true;
        }
        if (op.T_LESS() != null) {
            if (cmp < 0) {
                bool = true;
            }
        } else if (op.T_LESSEQUAL() != null && cmp <= 0) {
            bool = true;
        }
        this.exec.stackPush(bool);
    }

    public void operatorConcat(HplsqlParser.Expr_concatContext ctx) {
        StringBuilder val = new StringBuilder();
        int cnt = ctx.expr_concat_item().size();
        boolean nulls = true;
        for (int i = 0; i < cnt; ++i) {
            Var c = this.evalPop(ctx.expr_concat_item(i));
            if (c.isNull()) continue;
            val.append(c.toString());
            nulls = false;
        }
        if (nulls) {
            this.evalNull();
        } else {
            this.evalString(val);
        }
    }

    public void operatorConcatSql(HplsqlParser.Expr_concatContext ctx) {
        StringBuilder sql = new StringBuilder();
        sql.append("CONCAT(");
        int cnt = ctx.expr_concat_item().size();
        for (int i = 0; i < cnt; ++i) {
            sql.append(this.evalPop(ctx.expr_concat_item(i)).toString());
            if (i + 1 >= cnt) continue;
            sql.append(", ");
        }
        sql.append(")");
        this.exec.stackPush(sql);
    }

    public void execSimpleCase(HplsqlParser.Expr_case_simpleContext ctx) {
        int cnt = ctx.expr().size();
        boolean found = false;
        Var val = this.evalPop(ctx.expr(0));
        for (int i = 1; i < cnt; i += 2) {
            Var when = this.evalPop(ctx.expr(i));
            if (val.compareTo(when) != 0) continue;
            this.visit(ctx.expr(i + 1));
            found = true;
            break;
        }
        if (!found) {
            if (ctx.T_ELSE() != null) {
                this.visit(ctx.expr(cnt - 1));
            } else {
                this.evalNull();
            }
        }
    }

    public void execSimpleCaseSql(HplsqlParser.Expr_case_simpleContext ctx) {
        StringBuilder sql = new StringBuilder();
        sql.append("CASE ");
        sql.append(this.evalPop(ctx.expr(0)).toString());
        int cnt = ctx.T_WHEN().size();
        for (int i = 0; i < cnt; ++i) {
            sql.append(" WHEN ");
            sql.append(this.evalPop(ctx.expr(i * 2 + 1)).toString());
            sql.append(" THEN ");
            sql.append(this.evalPop(ctx.expr(i * 2 + 2)).toString());
        }
        if (ctx.T_ELSE() != null) {
            sql.append(" ELSE ");
            sql.append(this.evalPop(ctx.expr(cnt * 2 + 1)).toString());
        }
        sql.append(" END");
        this.exec.stackPush(sql);
    }

    public void execSearchedCase(HplsqlParser.Expr_case_searchedContext ctx) {
        int cnt = ctx.bool_expr().size();
        boolean found = false;
        for (int i = 0; i < cnt; ++i) {
            if (!this.evalPop(ctx.bool_expr(i)).isTrue()) continue;
            this.visit(ctx.expr(i));
            found = true;
            break;
        }
        if (!found) {
            if (ctx.T_ELSE() != null) {
                this.visit(ctx.expr(cnt));
            } else {
                this.evalNull();
            }
        }
    }

    public void execSearchedCaseSql(HplsqlParser.Expr_case_searchedContext ctx) {
        StringBuilder sql = new StringBuilder();
        sql.append("CASE");
        int cnt = ctx.T_WHEN().size();
        for (int i = 0; i < cnt; ++i) {
            sql.append(" WHEN ");
            sql.append(this.evalPop(ctx.bool_expr(i)).toString());
            sql.append(" THEN ");
            sql.append(this.evalPop(ctx.expr(i)).toString());
        }
        if (ctx.T_ELSE() != null) {
            sql.append(" ELSE ");
            sql.append(this.evalPop(ctx.expr(cnt)).toString());
        }
        sql.append(" END");
        this.exec.stackPush(sql);
    }

    public void createInterval(HplsqlParser.ExprContext ctx) {
        int num = this.evalPop(ctx.expr(0)).intValue();
        Interval interval = new Interval().set(num, ctx.interval_item().getText());
        this.exec.stackPush(new Var(interval));
    }

    void eval(ParserRuleContext ctx) {
        this.visit(ctx);
    }

    Var evalPop(ParserRuleContext ctx) {
        this.visit(ctx);
        if (!this.exec.stack.isEmpty()) {
            return this.exec.stackPop();
        }
        return Var.Empty;
    }

    void evalString(String string) {
        this.exec.stackPush(new Var(string));
    }

    void evalString(StringBuilder string) {
        this.evalString(string.toString());
    }

    void evalNull() {
        this.exec.stackPush(Var.Null);
    }

    Integer visit(ParserRuleContext ctx) {
        return (Integer)this.exec.visit((ParseTree)ctx);
    }

    Integer visitChildren(ParserRuleContext ctx) {
        return (Integer)this.exec.visitChildren((RuleNode)ctx);
    }

    public void trace(ParserRuleContext ctx, String message) {
        this.exec.trace(ctx, message);
    }
}

