/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hplsql;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;
import java.util.Stack;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.RuleNode;
import org.apache.hive.hplsql.Conf;
import org.apache.hive.hplsql.Exec;
import org.apache.hive.hplsql.HplsqlParser;
import org.apache.hive.hplsql.Query;
import org.apache.hive.hplsql.Signal;
import org.apache.hive.hplsql.Var;

public class Select {
    Exec exec = null;
    Stack<Var> stack = null;
    Conf conf;
    boolean trace = false;

    Select(Exec e) {
        this.exec = e;
        this.stack = this.exec.getStack();
        this.conf = this.exec.getConf();
        this.trace = this.exec.getTrace();
    }

    public Integer select(HplsqlParser.Select_stmtContext ctx) {
        if (ctx.parent instanceof HplsqlParser.StmtContext) {
            this.exec.stmtConnList.clear();
            this.trace(ctx, "SELECT");
        }
        boolean oldBuildSql = this.exec.buildSql;
        this.exec.buildSql = true;
        StringBuilder sql = new StringBuilder();
        if (ctx.cte_select_stmt() != null) {
            sql.append(this.evalPop(ctx.cte_select_stmt()).toString());
            sql.append("\n");
        }
        sql.append(this.evalPop(ctx.fullselect_stmt()).toString());
        this.exec.buildSql = oldBuildSql;
        if (!(ctx.parent instanceof HplsqlParser.StmtContext)) {
            this.exec.stackPush(sql);
            return 0;
        }
        if (this.trace && ctx.parent instanceof HplsqlParser.StmtContext) {
            this.trace(ctx, sql.toString());
        }
        if (this.exec.getOffline()) {
            this.trace(ctx, "Not executed - offline mode set");
            return 0;
        }
        String conn = this.exec.getStatementConnection();
        Query query = this.exec.executeQuery((ParserRuleContext)ctx, sql.toString(), conn);
        if (query.error()) {
            this.exec.signal(query);
            return 1;
        }
        this.trace(ctx, "SELECT completed successfully");
        this.exec.setSqlSuccess();
        try {
            int into_cnt;
            ResultSet rs = query.getResultSet();
            ResultSetMetaData rm = null;
            if (rs != null) {
                rm = rs.getMetaData();
            }
            if ((into_cnt = this.getIntoCount(ctx)) > 0) {
                this.trace(ctx, "SELECT INTO statement executed");
                if (rs.next()) {
                    for (int i = 1; i <= into_cnt; ++i) {
                        String into_name = this.getIntoVariable(ctx, i - 1);
                        Var var = this.exec.findVariable(into_name);
                        if (var != null) {
                            if (var.type != Var.Type.ROW) {
                                var.setValue(rs, rm, i);
                            } else {
                                var.setValues(rs, rm);
                            }
                            if (!this.trace) continue;
                            this.trace(ctx, var, rs, rm, i);
                            continue;
                        }
                        this.trace(ctx, "Variable not found: " + into_name);
                    }
                    this.exec.incRowCount();
                    this.exec.setSqlSuccess();
                } else {
                    this.exec.setSqlCode(100);
                    this.exec.signal(Signal.Type.NOTFOUND);
                }
            } else if (ctx.parent instanceof HplsqlParser.StmtContext) {
                int cols = rm.getColumnCount();
                if (this.trace) {
                    this.trace(ctx, "Standalone SELECT executed: " + cols + " columns in the result set");
                }
                while (rs.next()) {
                    for (int i = 1; i <= cols; ++i) {
                        if (i > 1) {
                            System.out.print("\t");
                        }
                        System.out.print(rs.getString(i));
                    }
                    System.out.println("");
                    this.exec.incRowCount();
                }
            } else {
                this.trace(ctx, "Scalar subquery executed, first row and first column fetched only");
                if (rs.next()) {
                    this.exec.stackPush(new Var().setValue(rs, rm, 1));
                    this.exec.setSqlSuccess();
                } else {
                    this.evalNull();
                    this.exec.setSqlCode(100);
                }
            }
        }
        catch (SQLException e) {
            this.exec.signal(query);
            this.exec.closeQuery(query, this.exec.conf.defaultConnection);
            return 1;
        }
        this.exec.closeQuery(query, this.exec.conf.defaultConnection);
        return 0;
    }

    public Integer cte(HplsqlParser.Cte_select_stmtContext ctx) {
        int cnt = ctx.cte_select_stmt_item().size();
        StringBuilder sql = new StringBuilder();
        sql.append("WITH ");
        for (int i = 0; i < cnt; ++i) {
            HplsqlParser.Cte_select_stmt_itemContext c = ctx.cte_select_stmt_item(i);
            sql.append(c.ident().getText());
            if (c.cte_select_cols() != null) {
                sql.append(" " + this.exec.getFormattedText(c.cte_select_cols()));
            }
            sql.append(" AS (");
            sql.append(this.evalPop(ctx.cte_select_stmt_item(i).fullselect_stmt()).toString());
            sql.append(")");
            if (i + 1 == cnt) continue;
            sql.append(",\n");
        }
        this.exec.stackPush(sql);
        return 0;
    }

    public Integer fullselect(HplsqlParser.Fullselect_stmtContext ctx) {
        int cnt = ctx.fullselect_stmt_item().size();
        StringBuilder sql = new StringBuilder();
        for (int i = 0; i < cnt; ++i) {
            String part = this.evalPop(ctx.fullselect_stmt_item(i)).toString();
            sql.append(part);
            if (i + 1 == cnt) continue;
            sql.append("\n" + this.getText(ctx.fullselect_set_clause(i)) + "\n");
        }
        this.exec.stackPush(sql);
        return 0;
    }

    public Integer subselect(HplsqlParser.Subselect_stmtContext ctx) {
        Var opt;
        StringBuilder sql = new StringBuilder();
        if (ctx.T_SELECT() != null) {
            sql.append(ctx.T_SELECT().getText());
        }
        sql.append(" " + this.evalPop(ctx.select_list()));
        if (ctx.from_clause() != null) {
            sql.append(" " + this.evalPop(ctx.from_clause()));
        } else {
            sql.append(" FROM " + this.conf.dualTable);
        }
        if (ctx.where_clause() != null) {
            sql.append(" " + this.evalPop(ctx.where_clause()));
        }
        if (ctx.group_by_clause() != null) {
            sql.append(" " + this.getText(ctx.group_by_clause()));
        }
        if (ctx.having_clause() != null) {
            sql.append(" " + this.getText(ctx.having_clause()));
        }
        if (ctx.order_by_clause() != null) {
            sql.append(" " + this.getText(ctx.order_by_clause()));
        }
        if (ctx.select_options() != null && !(opt = this.evalPop(ctx.select_options())).isNull()) {
            sql.append(" " + opt.toString());
        }
        if (ctx.select_list().select_list_limit() != null) {
            sql.append(" LIMIT " + this.evalPop(ctx.select_list().select_list_limit().expr()));
        }
        this.exec.stackPush(sql);
        return 0;
    }

    public Integer selectList(HplsqlParser.Select_listContext ctx) {
        StringBuilder sql = new StringBuilder();
        if (ctx.select_list_set() != null) {
            sql.append(this.exec.getText(ctx.select_list_set())).append(" ");
        }
        int cnt = ctx.select_list_item().size();
        for (int i = 0; i < cnt; ++i) {
            if (ctx.select_list_item(i).select_list_asterisk() == null) {
                sql.append(this.evalPop(ctx.select_list_item(i).expr()));
                if (ctx.select_list_item(i).select_list_alias() != null) {
                    sql.append(" " + this.exec.getText(ctx.select_list_item(i).select_list_alias()));
                }
            } else {
                sql.append(this.exec.getText(ctx.select_list_item(i).select_list_asterisk()));
            }
            if (i + 1 >= cnt) continue;
            sql.append(", ");
        }
        this.exec.stackPush(sql);
        return 0;
    }

    public Integer from(HplsqlParser.From_clauseContext ctx) {
        StringBuilder sql = new StringBuilder();
        sql.append(ctx.T_FROM().getText()).append(" ");
        sql.append(this.evalPop(ctx.from_table_clause()));
        int cnt = ctx.from_join_clause().size();
        for (int i = 0; i < cnt; ++i) {
            sql.append(this.evalPop(ctx.from_join_clause(i)));
        }
        this.exec.stackPush(sql);
        return 0;
    }

    public Integer fromTable(HplsqlParser.From_table_name_clauseContext ctx) {
        StringBuilder sql = new StringBuilder();
        sql.append(this.evalPop(ctx.table_name()));
        if (ctx.from_alias_clause() != null) {
            sql.append(" ").append(this.exec.getText(ctx.from_alias_clause()));
        }
        this.exec.stackPush(sql);
        return 0;
    }

    public Integer fromSubselect(HplsqlParser.From_subselect_clauseContext ctx) {
        StringBuilder sql = new StringBuilder();
        sql.append("(");
        sql.append(this.evalPop(ctx.select_stmt()).toString());
        sql.append(")");
        if (ctx.from_alias_clause() != null) {
            sql.append(" ").append(this.exec.getText(ctx.from_alias_clause()));
        }
        this.exec.stackPush(sql);
        return 0;
    }

    public Integer fromJoin(HplsqlParser.From_join_clauseContext ctx) {
        StringBuilder sql = new StringBuilder();
        if (ctx.T_COMMA() != null) {
            sql.append(", ");
            sql.append(this.evalPop(ctx.from_table_clause()));
        } else if (ctx.from_join_type_clause() != null) {
            sql.append(" ");
            sql.append(this.exec.getText(ctx.from_join_type_clause()));
            sql.append(" ");
            sql.append(this.evalPop(ctx.from_table_clause()));
            sql.append(" ");
            sql.append(this.exec.getText(ctx, ctx.T_ON().getSymbol(), ctx.bool_expr().getStop()));
        }
        this.exec.stackPush(sql);
        return 0;
    }

    public Integer fromTableValues(HplsqlParser.From_table_values_clauseContext ctx) {
        StringBuilder sql = new StringBuilder();
        int rows = ctx.from_table_values_row().size();
        sql.append("(");
        for (int i = 0; i < rows; ++i) {
            int cols = ctx.from_table_values_row(i).expr().size();
            int cols_as = ctx.from_alias_clause().L_ID().size();
            sql.append("SELECT ");
            for (int j = 0; j < cols; ++j) {
                sql.append(this.evalPop(ctx.from_table_values_row(i).expr(j)));
                if (j < cols_as) {
                    sql.append(" AS ");
                    sql.append(ctx.from_alias_clause().L_ID(j));
                }
                if (j + 1 >= cols) continue;
                sql.append(", ");
            }
            sql.append(" FROM " + this.conf.dualTable);
            if (i + 1 >= rows) continue;
            sql.append("\nUNION ALL\n");
        }
        sql.append(") ");
        if (ctx.from_alias_clause() != null) {
            sql.append(ctx.from_alias_clause().ident().getText());
        }
        this.exec.stackPush(sql);
        return 0;
    }

    public Integer where(HplsqlParser.Where_clauseContext ctx) {
        boolean oldBuildSql = this.exec.buildSql;
        this.exec.buildSql = true;
        StringBuilder sql = new StringBuilder();
        sql.append(ctx.T_WHERE().getText());
        sql.append(" " + this.evalPop(ctx.bool_expr()));
        this.exec.stackPush(sql);
        this.exec.buildSql = oldBuildSql;
        return 0;
    }

    HplsqlParser.Into_clauseContext getIntoClause(HplsqlParser.Select_stmtContext ctx) {
        if (ctx.fullselect_stmt().fullselect_stmt_item(0).subselect_stmt() != null) {
            return ctx.fullselect_stmt().fullselect_stmt_item(0).subselect_stmt().into_clause();
        }
        return null;
    }

    int getIntoCount(HplsqlParser.Select_stmtContext ctx) {
        HplsqlParser.Into_clauseContext into = this.getIntoClause(ctx);
        if (into != null) {
            return into.ident().size();
        }
        List<HplsqlParser.Select_list_itemContext> sl = ctx.fullselect_stmt().fullselect_stmt_item(0).subselect_stmt().select_list().select_list_item();
        if (sl.get(0).T_EQUAL() != null) {
            return sl.size();
        }
        return 0;
    }

    String getIntoVariable(HplsqlParser.Select_stmtContext ctx, int idx) {
        HplsqlParser.Into_clauseContext into = this.getIntoClause(ctx);
        if (into != null) {
            return into.ident(idx).getText();
        }
        HplsqlParser.Select_list_itemContext sl = ctx.fullselect_stmt().fullselect_stmt_item(0).subselect_stmt().select_list().select_list_item(idx);
        if (sl != null) {
            return sl.ident().getText();
        }
        return null;
    }

    public Integer option(HplsqlParser.Select_options_itemContext ctx) {
        if (ctx.T_LIMIT() != null) {
            this.exec.stackPush("LIMIT " + this.evalPop(ctx.expr()));
        }
        return 0;
    }

    void evalNull() {
        this.exec.stackPush(Var.Null);
    }

    Var evalPop(ParserRuleContext ctx) {
        this.exec.visit((ParseTree)ctx);
        if (!this.exec.stack.isEmpty()) {
            return this.exec.stackPop();
        }
        return Var.Empty;
    }

    String getText(ParserRuleContext ctx) {
        return ctx.start.getInputStream().getText(new Interval(ctx.start.getStartIndex(), ctx.stop.getStopIndex()));
    }

    Integer visit(ParserRuleContext ctx) {
        return (Integer)this.exec.visit((ParseTree)ctx);
    }

    Integer visitChildren(ParserRuleContext ctx) {
        return (Integer)this.exec.visitChildren((RuleNode)ctx);
    }

    void trace(ParserRuleContext ctx, String message) {
        this.exec.trace(ctx, message);
    }

    void trace(ParserRuleContext ctx, Var var, ResultSet rs, ResultSetMetaData rm, int idx) throws SQLException {
        this.exec.trace(ctx, var, rs, rm, idx);
    }
}

