/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hplsql.functions;

import org.apache.hive.hplsql.Exec;
import org.apache.hive.hplsql.HplsqlParser;
import org.apache.hive.hplsql.Var;
import org.apache.hive.hplsql.functions.FuncCommand;
import org.apache.hive.hplsql.functions.FuncSpecCommand;
import org.apache.hive.hplsql.functions.Function;

public class FunctionString
extends Function {
    public FunctionString(Exec e) {
        super(e);
    }

    @Override
    public void register(Function f) {
        f.map.put("CONCAT", new FuncCommand(){

            @Override
            public void run(HplsqlParser.Expr_func_paramsContext ctx) {
                FunctionString.this.concat(ctx);
            }
        });
        f.map.put("CHAR", new FuncCommand(){

            @Override
            public void run(HplsqlParser.Expr_func_paramsContext ctx) {
                FunctionString.this.char_(ctx);
            }
        });
        f.map.put("INSTR", new FuncCommand(){

            @Override
            public void run(HplsqlParser.Expr_func_paramsContext ctx) {
                FunctionString.this.instr(ctx);
            }
        });
        f.map.put("LEN", new FuncCommand(){

            @Override
            public void run(HplsqlParser.Expr_func_paramsContext ctx) {
                FunctionString.this.len(ctx);
            }
        });
        f.map.put("LENGTH", new FuncCommand(){

            @Override
            public void run(HplsqlParser.Expr_func_paramsContext ctx) {
                FunctionString.this.length(ctx);
            }
        });
        f.map.put("LOWER", new FuncCommand(){

            @Override
            public void run(HplsqlParser.Expr_func_paramsContext ctx) {
                FunctionString.this.lower(ctx);
            }
        });
        f.map.put("SUBSTR", new FuncCommand(){

            @Override
            public void run(HplsqlParser.Expr_func_paramsContext ctx) {
                FunctionString.this.substr(ctx);
            }
        });
        f.map.put("SUBSTRING", new FuncCommand(){

            @Override
            public void run(HplsqlParser.Expr_func_paramsContext ctx) {
                FunctionString.this.substr(ctx);
            }
        });
        f.map.put("TO_CHAR", new FuncCommand(){

            @Override
            public void run(HplsqlParser.Expr_func_paramsContext ctx) {
                FunctionString.this.toChar(ctx);
            }
        });
        f.map.put("UPPER", new FuncCommand(){

            @Override
            public void run(HplsqlParser.Expr_func_paramsContext ctx) {
                FunctionString.this.upper(ctx);
            }
        });
        f.specMap.put("SUBSTRING", new FuncSpecCommand(){

            @Override
            public void run(HplsqlParser.Expr_spec_funcContext ctx) {
                FunctionString.this.substring(ctx);
            }
        });
        f.specMap.put("TRIM", new FuncSpecCommand(){

            @Override
            public void run(HplsqlParser.Expr_spec_funcContext ctx) {
                FunctionString.this.trim(ctx);
            }
        });
    }

    void concat(HplsqlParser.Expr_func_paramsContext ctx) {
        StringBuilder val = new StringBuilder();
        int cnt = ctx.func_param().size();
        boolean nulls = true;
        for (int i = 0; i < cnt; ++i) {
            Var c = this.evalPop(ctx.func_param(i).expr());
            if (c.isNull()) continue;
            val.append(c.toString());
            nulls = false;
        }
        if (nulls) {
            this.evalNull();
        } else {
            this.evalString(val);
        }
    }

    void char_(HplsqlParser.Expr_func_paramsContext ctx) {
        int cnt = ctx.func_param().size();
        if (cnt != 1) {
            this.evalNull();
            return;
        }
        String str = this.evalPop(ctx.func_param(0).expr()).toString();
        this.evalString(str);
    }

    void instr(HplsqlParser.Expr_func_paramsContext ctx) {
        int cnt = ctx.func_param().size();
        if (cnt < 2) {
            this.evalNull();
            return;
        }
        String str = this.evalPop(ctx.func_param(0).expr()).toString();
        if (str == null) {
            this.evalNull();
            return;
        }
        if (str.isEmpty()) {
            this.evalInt(new Long(0L));
            return;
        }
        String substr = this.evalPop(ctx.func_param(1).expr()).toString();
        int pos = 1;
        int occur = 1;
        int idx = 0;
        if (cnt >= 3 && (pos = this.evalPop(ctx.func_param(2).expr()).intValue()) == 0) {
            pos = 1;
        }
        if (cnt >= 4 && (occur = this.evalPop(ctx.func_param(3).expr()).intValue()) < 0) {
            occur = 1;
        }
        for (int i = occur; i > 0; --i) {
            if (pos > 0) {
                idx = str.indexOf(substr, pos - 1);
            } else {
                str = str.substring(0, str.length() - pos * -1);
                idx = str.lastIndexOf(substr);
            }
            if (idx == -1) {
                idx = 0;
                break;
            }
            ++idx;
            if (i <= 1) continue;
            pos = pos > 0 ? idx + 1 : (str.length() - idx + 1) * -1;
        }
        this.evalInt(new Long(idx));
    }

    void len(HplsqlParser.Expr_func_paramsContext ctx) {
        if (ctx.func_param().size() != 1) {
            this.evalNull();
            return;
        }
        int len = this.evalPop(ctx.func_param(0).expr()).toString().trim().length();
        this.evalInt(new Long(len));
    }

    void length(HplsqlParser.Expr_func_paramsContext ctx) {
        if (ctx.func_param().size() != 1) {
            this.evalNull();
            return;
        }
        int len = this.evalPop(ctx.func_param(0).expr()).toString().length();
        this.evalInt(new Long(len));
    }

    void lower(HplsqlParser.Expr_func_paramsContext ctx) {
        if (ctx.func_param().size() != 1) {
            this.evalNull();
            return;
        }
        String str = this.evalPop(ctx.func_param(0).expr()).toString().toLowerCase();
        this.evalString(str);
    }

    void substr(HplsqlParser.Expr_func_paramsContext ctx) {
        int cnt = ctx.func_param().size();
        if (cnt < 2) {
            this.evalNull();
            return;
        }
        String str = this.evalPop(ctx.func_param(0).expr()).toString();
        int start = this.evalPop(ctx.func_param(1).expr()).intValue();
        int len = -1;
        if (start == 0) {
            start = 1;
        }
        if (cnt > 2) {
            len = this.evalPop(ctx.func_param(2).expr()).intValue();
        }
        this.substr(str, start, len);
    }

    void substr(String str, int start, int len) {
        if (str == null) {
            this.evalNull();
            return;
        }
        if (str.isEmpty()) {
            this.evalString(str);
            return;
        }
        if (start == 0) {
            start = 1;
        }
        if (len == -1) {
            if (start > 0) {
                this.evalString(str.substring(start - 1));
            }
        } else {
            this.evalString(str.substring(start - 1, start - 1 + len));
        }
    }

    void substring(HplsqlParser.Expr_spec_funcContext ctx) {
        String str = this.evalPop(ctx.expr(0)).toString();
        int start = this.evalPop(ctx.expr(1)).intValue();
        int len = -1;
        if (start == 0) {
            start = 1;
        }
        if (ctx.T_FOR() != null) {
            len = this.evalPop(ctx.expr(2)).intValue();
        }
        this.substr(str, start, len);
    }

    void trim(HplsqlParser.Expr_spec_funcContext ctx) {
        int cnt = ctx.expr().size();
        if (cnt != 1) {
            this.evalNull();
            return;
        }
        String str = this.evalPop(ctx.expr(0)).toString();
        this.evalString(str.trim());
    }

    void toChar(HplsqlParser.Expr_func_paramsContext ctx) {
        int cnt = ctx.func_param().size();
        if (cnt != 1) {
            this.evalNull();
            return;
        }
        String str = this.evalPop(ctx.func_param(0).expr()).toString();
        this.evalString(str);
    }

    void upper(HplsqlParser.Expr_func_paramsContext ctx) {
        if (ctx.func_param().size() != 1) {
            this.evalNull();
            return;
        }
        String str = this.evalPop(ctx.func_param(0).expr()).toString().toUpperCase();
        this.evalString(str);
    }
}

