/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.cache;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.hive.llap.cache.LowLevelCachePolicy;
import org.apache.hadoop.hive.llap.cache.MemoryManager;
import org.apache.hadoop.hive.llap.io.api.impl.LlapIoImpl;
import org.apache.hadoop.hive.llap.metrics.LlapDaemonCacheMetrics;

public class LowLevelCacheMemoryManager
implements MemoryManager {
    private final AtomicLong usedMemory;
    private final LowLevelCachePolicy evictor;
    private final LlapDaemonCacheMetrics metrics;
    private long maxSize;

    public LowLevelCacheMemoryManager(long maxSize, LowLevelCachePolicy evictor, LlapDaemonCacheMetrics metrics) {
        this.maxSize = maxSize;
        this.evictor = evictor;
        this.usedMemory = new AtomicLong(0L);
        this.metrics = metrics;
        if (LlapIoImpl.LOG.isInfoEnabled()) {
            LlapIoImpl.LOG.info("Memory manager initialized with max size {} and {} ability to evict blocks", (Object)maxSize, (Object)(evictor == null ? "no " : ""));
        }
    }

    @Override
    public boolean reserveMemory(long memoryToReserve, boolean waitForEviction) {
        int badCallCount = 0;
        int nextLog = 4;
        long evictedTotalMetric = 0L;
        long reservedTotalMetric = 0L;
        long remainingToReserve = memoryToReserve;
        boolean result = true;
        block2: while (remainingToReserve > 0L) {
            long usedMem = this.usedMemory.get();
            long newUsedMem = usedMem + remainingToReserve;
            if (newUsedMem <= this.maxSize) {
                if (!this.usedMemory.compareAndSet(usedMem, newUsedMem)) continue;
                reservedTotalMetric += remainingToReserve;
                break;
            }
            if (this.evictor == null) {
                return false;
            }
            long evicted = this.evictor.evictSomeBlocks(remainingToReserve);
            if (evicted == 0L) {
                if (!waitForEviction) {
                    result = false;
                    break;
                }
                if (++badCallCount != nextLog) continue;
                LlapIoImpl.LOG.warn("Cannot evict blocks for " + badCallCount + " calls; cache full?");
                nextLog <<= 1;
                try {
                    Thread.sleep(Math.min(1000, nextLog));
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    result = false;
                    break;
                }
            }
            evictedTotalMetric += evicted;
            badCallCount = 0;
            while (true) {
                long availableToReserveAfterEvict;
                long reservedAfterEvict;
                if (this.usedMemory.compareAndSet(usedMem, usedMem - evicted + (reservedAfterEvict = Math.min(remainingToReserve, availableToReserveAfterEvict = this.maxSize - usedMem + evicted)))) {
                    remainingToReserve -= reservedAfterEvict;
                    reservedTotalMetric += reservedAfterEvict;
                    continue block2;
                }
                usedMem = this.usedMemory.get();
            }
        }
        this.metrics.incrCacheCapacityUsed(reservedTotalMetric - evictedTotalMetric);
        return result;
    }

    @Override
    public void forceReservedMemory(int allocationSize, int count) {
        if (this.evictor == null) {
            return;
        }
        while (count > 0) {
            int evictedCount = this.evictor.tryEvictContiguousData(allocationSize, count);
            if (evictedCount == 0) {
                return;
            }
            count -= evictedCount;
        }
    }

    @Override
    public void releaseMemory(long memoryToRelease) {
        long oldV;
        do {
            oldV = this.usedMemory.get();
            assert (oldV >= memoryToRelease);
        } while (!this.usedMemory.compareAndSet(oldV, oldV - memoryToRelease));
        this.metrics.incrCacheCapacityUsed(-memoryToRelease);
    }

    @Override
    public String debugDumpForOom() {
        if (this.evictor == null) {
            return null;
        }
        return "cache state\n" + this.evictor.debugDumpForOom();
    }

    @Override
    public void updateMaxSize(long maxSize) {
        this.maxSize = maxSize;
    }
}

