/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.daemon.impl.comparator;

import java.util.Comparator;
import org.apache.hadoop.hive.llap.daemon.impl.TaskExecutorService;
import org.apache.hadoop.hive.llap.daemon.impl.TaskRunnerCallable;
import org.apache.hadoop.hive.llap.daemon.rpc.LlapDaemonProtocolProtos;

public class ShortestJobFirstComparator
implements Comparator<TaskExecutorService.TaskWrapper> {
    @Override
    public int compare(TaskExecutorService.TaskWrapper t1, TaskExecutorService.TaskWrapper t2) {
        TaskRunnerCallable o1 = t1.getTaskRunnerCallable();
        TaskRunnerCallable o2 = t2.getTaskRunnerCallable();
        boolean o1CanFinish = o1.canFinish();
        boolean o2CanFinish = o2.canFinish();
        if (o1CanFinish && !o2CanFinish) {
            return -1;
        }
        if (!o1CanFinish && o2CanFinish) {
            return 1;
        }
        LlapDaemonProtocolProtos.FragmentRuntimeInfo fri1 = o1.getFragmentRuntimeInfo();
        LlapDaemonProtocolProtos.FragmentRuntimeInfo fri2 = o2.getFragmentRuntimeInfo();
        if (o1.getQueryId().equals(o2.getQueryId())) {
            return Integer.compare(fri1.getWithinDagPriority(), fri2.getWithinDagPriority());
        }
        int knownPending1 = fri1.getNumSelfAndUpstreamTasks() - fri1.getNumSelfAndUpstreamCompletedTasks();
        int knownPending2 = fri2.getNumSelfAndUpstreamTasks() - fri2.getNumSelfAndUpstreamCompletedTasks();
        long waitTime1 = fri1.getCurrentAttemptStartTime() - fri1.getFirstAttemptStartTime();
        long waitTime2 = fri2.getCurrentAttemptStartTime() - fri2.getFirstAttemptStartTime();
        if (waitTime1 == 0L || waitTime2 == 0L) {
            return knownPending1 - knownPending2;
        }
        double ratio1 = (double)knownPending1 / (double)waitTime1;
        double ratio2 = (double)knownPending2 / (double)waitTime2;
        if (ratio1 < ratio2) {
            return -1;
        }
        if (ratio1 > ratio2) {
            return 1;
        }
        return 0;
    }
}

