/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.io.encoded;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.Pool;
import org.apache.hadoop.hive.common.io.Allocator;
import org.apache.hadoop.hive.common.io.DataCache;
import org.apache.hadoop.hive.common.io.DiskRange;
import org.apache.hadoop.hive.common.io.DiskRangeList;
import org.apache.hadoop.hive.common.io.encoded.EncodedColumnBatch;
import org.apache.hadoop.hive.common.io.encoded.MemoryBuffer;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.ConsumerFeedback;
import org.apache.hadoop.hive.llap.DebugUtils;
import org.apache.hadoop.hive.llap.cache.BufferUsageManager;
import org.apache.hadoop.hive.llap.cache.LowLevelCache;
import org.apache.hadoop.hive.llap.counters.LlapIOCounters;
import org.apache.hadoop.hive.llap.counters.QueryFragmentCounters;
import org.apache.hadoop.hive.llap.io.api.impl.LlapIoImpl;
import org.apache.hadoop.hive.llap.io.decode.OrcEncodedDataConsumer;
import org.apache.hadoop.hive.llap.io.metadata.OrcFileMetadata;
import org.apache.hadoop.hive.llap.io.metadata.OrcMetadataCache;
import org.apache.hadoop.hive.llap.io.metadata.OrcStripeMetadata;
import org.apache.hadoop.hive.ql.io.HdfsUtils;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcSplit;
import org.apache.hadoop.hive.ql.io.orc.RecordReaderImpl;
import org.apache.hadoop.hive.ql.io.orc.encoded.Consumer;
import org.apache.hadoop.hive.ql.io.orc.encoded.EncodedOrcFile;
import org.apache.hadoop.hive.ql.io.orc.encoded.EncodedReader;
import org.apache.hadoop.hive.ql.io.orc.encoded.OrcBatchKey;
import org.apache.hadoop.hive.ql.io.orc.encoded.Reader;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hive.common.util.FixedSizedObjectPool;
import org.apache.hive.orc.CompressionKind;
import org.apache.hive.orc.DataReader;
import org.apache.hive.orc.FileMetadata;
import org.apache.hive.orc.OrcConf;
import org.apache.hive.orc.OrcProto;
import org.apache.hive.orc.OrcUtils;
import org.apache.hive.orc.StripeInformation;
import org.apache.hive.orc.TypeDescription;
import org.apache.hive.orc.impl.DataReaderProperties;
import org.apache.hive.orc.impl.OrcIndex;
import org.apache.hive.orc.impl.RecordReaderImpl;
import org.apache.hive.orc.impl.RecordReaderUtils;
import org.apache.hive.orc.impl.SchemaEvolution;
import org.apache.tez.common.CallableWithNdc;
import org.apache.tez.common.counters.TezCounters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrcEncodedDataReader
extends CallableWithNdc<Void>
implements ConsumerFeedback<Reader.OrcEncodedColumnBatch> {
    private static final Logger LOG = LoggerFactory.getLogger(OrcEncodedDataReader.class);
    public static final FixedSizedObjectPool<EncodedColumnBatch.ColumnStreamData> CSD_POOL = new FixedSizedObjectPool(8192, (Pool.PoolObjectHelper)new Pool.PoolObjectHelper<EncodedColumnBatch.ColumnStreamData>(){

        public EncodedColumnBatch.ColumnStreamData create() {
            return new EncodedColumnBatch.ColumnStreamData();
        }

        public void resetBeforeOffer(EncodedColumnBatch.ColumnStreamData t) {
            t.reset();
        }
    });
    public static final FixedSizedObjectPool<Reader.OrcEncodedColumnBatch> ECB_POOL = new FixedSizedObjectPool(1024, (Pool.PoolObjectHelper)new Pool.PoolObjectHelper<Reader.OrcEncodedColumnBatch>(){

        public Reader.OrcEncodedColumnBatch create() {
            return new Reader.OrcEncodedColumnBatch();
        }

        public void resetBeforeOffer(Reader.OrcEncodedColumnBatch t) {
            t.reset();
        }
    });
    private static final Reader.PoolFactory POOL_FACTORY = new Reader.PoolFactory(){

        public <T> Pool<T> createPool(int size, Pool.PoolObjectHelper<T> helper) {
            return new FixedSizedObjectPool(size, helper);
        }

        public Pool<EncodedColumnBatch.ColumnStreamData> createColumnStreamDataPool() {
            return CSD_POOL;
        }

        public Pool<Reader.OrcEncodedColumnBatch> createEncodedColumnBatchPool() {
            return ECB_POOL;
        }
    };
    private final OrcMetadataCache metadataCache;
    private final LowLevelCache lowLevelCache;
    private final BufferUsageManager bufferManager;
    private final Configuration daemonConf;
    private final Configuration jobConf;
    private final FileSplit split;
    private List<Integer> includedColumnIds;
    private final SearchArgument sarg;
    private final String[] columnNames;
    private final OrcEncodedDataConsumer consumer;
    private final QueryFragmentCounters counters;
    private final UserGroupInformation ugi;
    private final SchemaEvolution evolution;
    private int stripeIxFrom;
    private OrcFileMetadata fileMetadata;
    private Path path;
    private Reader orcReader;
    private DataReader metadataReader;
    private EncodedReader stripeReader;
    private Object fileKey;
    private FileSystem fs;
    private boolean[][][] readState;
    private volatile boolean isStopped = false;
    private volatile boolean isPaused = false;
    boolean[] globalIncludes = null;

    public OrcEncodedDataReader(LowLevelCache lowLevelCache, BufferUsageManager bufferManager, OrcMetadataCache metadataCache, Configuration daemonConf, Configuration jobConf, FileSplit split, List<Integer> columnIds, SearchArgument sarg, String[] columnNames, OrcEncodedDataConsumer consumer, QueryFragmentCounters counters, TypeDescription readerSchema) throws IOException {
        this.lowLevelCache = lowLevelCache;
        this.metadataCache = metadataCache;
        this.bufferManager = bufferManager;
        this.daemonConf = daemonConf;
        this.split = split;
        this.includedColumnIds = columnIds;
        if (this.includedColumnIds != null) {
            Collections.sort(this.includedColumnIds);
        }
        this.sarg = sarg;
        this.columnNames = columnNames;
        this.consumer = consumer;
        this.counters = counters;
        try {
            this.ugi = UserGroupInformation.getCurrentUser();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.orcReader = null;
        this.fs = split.getPath().getFileSystem(jobConf);
        this.fileKey = OrcEncodedDataReader.determineFileId(this.fs, split, HiveConf.getBoolVar((Configuration)daemonConf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_CACHE_ALLOW_SYNTHETIC_FILEID));
        this.fileMetadata = this.getOrReadFileMetadata();
        if (readerSchema == null) {
            readerSchema = this.fileMetadata.getSchema();
        }
        this.globalIncludes = OrcInputFormat.genIncludedColumns((TypeDescription)readerSchema, this.includedColumnIds);
        boolean useZeroCopy = OrcConf.USE_ZEROCOPY.getBoolean(daemonConf);
        if (useZeroCopy != OrcConf.USE_ZEROCOPY.getBoolean(jobConf)) {
            jobConf = new Configuration(jobConf);
            jobConf.setBoolean(OrcConf.USE_ZEROCOPY.getAttribute(), useZeroCopy);
        }
        this.jobConf = jobConf;
        this.evolution = new SchemaEvolution(this.fileMetadata.getSchema(), readerSchema, this.globalIncludes);
        consumer.setFileMetadata(this.fileMetadata);
        consumer.setIncludedColumns(this.globalIncludes);
        consumer.setReaderSchema(readerSchema);
    }

    @Override
    public void stop() {
        LOG.debug("Encoded reader is being stopped");
        this.isStopped = true;
    }

    @Override
    public void pause() {
        this.isPaused = true;
    }

    @Override
    public void unpause() {
        this.isPaused = false;
    }

    protected Void callInternal() throws IOException, InterruptedException {
        return (Void)this.ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                return OrcEncodedDataReader.this.performDataRead();
            }
        });
    }

    protected Void performDataRead() throws IOException {
        long startTime = this.counters.startTimeCounter();
        LlapIoImpl.LOG.info("Processing data for {}", (Object)this.split.getPath());
        if (this.processStop()) {
            this.recordReaderTime(startTime);
            return null;
        }
        this.counters.setDesc(QueryFragmentCounters.Desc.TABLE, OrcEncodedDataReader.getDbAndTableName(this.split.getPath()));
        this.counters.setDesc(QueryFragmentCounters.Desc.FILE, this.split.getPath() + (this.fileKey == null ? "" : " (" + this.fileKey + ")"));
        try {
            this.validateFileMetadata();
            if (this.includedColumnIds == null) {
                this.includedColumnIds = OrcEncodedDataReader.getAllColumnIds(this.fileMetadata);
            }
            this.determineStripesToRead();
        }
        catch (Throwable t) {
            this.recordReaderTime(startTime);
            this.consumer.setError(t);
            return null;
        }
        if (this.readState.length == 0) {
            this.consumer.setDone();
            this.recordReaderTime(startTime);
            return null;
        }
        this.counters.setDesc(QueryFragmentCounters.Desc.STRIPES, this.stripeIxFrom + "," + this.readState.length);
        int stride = this.fileMetadata.getRowIndexStride();
        ArrayList<OrcStripeMetadata> stripeMetadatas = null;
        boolean[] sargColumns = null;
        try {
            boolean hasData;
            if (this.sarg != null && stride != 0) {
                TypeDescription schema = OrcUtils.convertTypeFromProtobuf(this.fileMetadata.getTypes(), (int)0);
                SchemaEvolution evolution = new SchemaEvolution(schema, null, this.globalIncludes);
                int[] filterColumns = RecordReaderImpl.mapSargColumnsToOrcInternalColIdx((List)this.sarg.getLeaves(), (SchemaEvolution)evolution);
                sargColumns = new boolean[this.globalIncludes.length];
                for (int i : filterColumns) {
                    if (i <= 0) continue;
                    sargColumns[i] = true;
                }
                stripeMetadatas = this.readStripesMetadata(this.globalIncludes, sargColumns);
            }
            if (!(hasData = this.determineRgsToRead(this.globalIncludes, stride, stripeMetadatas))) {
                this.consumer.setDone();
                this.recordReaderTime(startTime);
                return null;
            }
        }
        catch (Throwable t) {
            this.cleanupReaders();
            this.consumer.setError(t);
            this.recordReaderTime(startTime);
            return null;
        }
        if (this.processStop()) {
            this.cleanupReaders();
            this.recordReaderTime(startTime);
            return null;
        }
        try {
            this.ensureOrcReader();
            DataWrapperForOrc dw = new DataWrapperForOrc();
            this.stripeReader = this.orcReader.encodedReader(this.fileKey, (DataCache)dw, (DataReader)dw, POOL_FACTORY);
            this.stripeReader.setTracing(LlapIoImpl.ORC_LOGGER.isTraceEnabled());
        }
        catch (Throwable t) {
            this.consumer.setError(t);
            this.recordReaderTime(startTime);
            this.cleanupReaders();
            return null;
        }
        boolean hasFileId = this.fileKey != null;
        OrcBatchKey stripeKey = hasFileId ? new OrcBatchKey(this.fileKey, -1, 0) : null;
        for (int stripeIxMod = 0; stripeIxMod < this.readState.length; ++stripeIxMod) {
            StripeInformation stripe;
            if (this.processStop()) {
                this.cleanupReaders();
                this.recordReaderTime(startTime);
                return null;
            }
            int stripeIx = this.stripeIxFrom + stripeIxMod;
            boolean[][] colRgs = null;
            OrcStripeMetadata stripeMetadata = null;
            try {
                stripe = this.fileMetadata.getStripes().get(stripeIx);
                LlapIoImpl.ORC_LOGGER.trace("Reading stripe {}: {}, {}", new Object[]{stripeIx, stripe.getOffset(), stripe.getLength()});
                colRgs = this.readState[stripeIxMod];
                if (LlapIoImpl.ORC_LOGGER.isTraceEnabled()) {
                    LlapIoImpl.ORC_LOGGER.trace("readState[{}]: {}", (Object)stripeIxMod, (Object)Arrays.toString((Object[])colRgs));
                }
                if (colRgs.length > 0 && colRgs[0] == RecordReaderImpl.SargApplier.READ_NO_RGS) continue;
                boolean isFoundInCache = false;
                if (stripeMetadatas != null) {
                    stripeMetadata = stripeMetadatas.get(stripeIxMod);
                } else {
                    if (hasFileId && this.metadataCache != null) {
                        stripeKey.stripeIx = stripeIx;
                        stripeMetadata = this.metadataCache.getStripeMetadata(stripeKey);
                    }
                    boolean bl = isFoundInCache = stripeMetadata != null;
                    if (!isFoundInCache) {
                        this.counters.incrCounter(LlapIOCounters.METADATA_CACHE_MISS);
                        this.ensureMetadataReader();
                        long startTimeHdfs = this.counters.startTimeCounter();
                        stripeMetadata = new OrcStripeMetadata(new OrcBatchKey(this.fileKey, stripeIx, 0), this.metadataReader, stripe, this.globalIncludes, sargColumns);
                        this.counters.incrTimeCounter(LlapIOCounters.HDFS_TIME_NS, startTimeHdfs);
                        if (hasFileId && this.metadataCache != null) {
                            stripeMetadata = this.metadataCache.putStripeMetadata(stripeMetadata);
                            if (LlapIoImpl.ORC_LOGGER.isTraceEnabled()) {
                                LlapIoImpl.ORC_LOGGER.trace("Caching stripe {} metadata with includes: {}", (Object)stripeKey.stripeIx, (Object)DebugUtils.toString((boolean[])this.globalIncludes));
                            }
                        }
                    }
                    this.consumer.setStripeMetadata(stripeMetadata);
                }
                if (!stripeMetadata.hasAllIndexes(this.globalIncludes)) {
                    if (LlapIoImpl.ORC_LOGGER.isTraceEnabled()) {
                        LlapIoImpl.ORC_LOGGER.trace("Updating indexes in stripe {} metadata for includes: {}", (Object)stripeKey.stripeIx, (Object)DebugUtils.toString((boolean[])this.globalIncludes));
                    }
                    assert (isFoundInCache);
                    this.counters.incrCounter(LlapIOCounters.METADATA_CACHE_MISS);
                    this.ensureMetadataReader();
                    this.updateLoadedIndexes(stripeMetadata, stripe, this.globalIncludes, sargColumns);
                } else if (isFoundInCache) {
                    this.counters.incrCounter(LlapIOCounters.METADATA_CACHE_HIT);
                }
            }
            catch (Throwable t) {
                this.consumer.setError(t);
                this.cleanupReaders();
                this.recordReaderTime(startTime);
                return null;
            }
            if (this.processStop()) {
                this.cleanupReaders();
                this.recordReaderTime(startTime);
                return null;
            }
            try {
                this.stripeReader.readEncodedColumns(stripeIx, stripe, stripeMetadata.getRowIndexes(), stripeMetadata.getEncodings(), stripeMetadata.getStreams(), this.globalIncludes, colRgs, (Consumer)this.consumer);
                continue;
            }
            catch (Throwable t) {
                this.consumer.setError(t);
                this.cleanupReaders();
                this.recordReaderTime(startTime);
                return null;
            }
        }
        this.recordReaderTime(startTime);
        this.consumer.setDone();
        LlapIoImpl.LOG.trace("done processing {}", (Object)this.split);
        this.cleanupReaders();
        return null;
    }

    private void recordReaderTime(long startTime) {
        this.counters.incrTimeCounter(LlapIOCounters.TOTAL_IO_TIME_NS, startTime);
    }

    private static String getDbAndTableName(Path path) {
        String[] parts = path.toUri().getPath().toString().split("/");
        int dbIx = -1;
        for (int i = 0; i < parts.length - 2; ++i) {
            if (!parts[i].endsWith(".db")) continue;
            if (dbIx >= 0) {
                dbIx = -1;
                break;
            }
            dbIx = i;
        }
        if (dbIx >= 0) {
            return parts[dbIx].substring(0, parts[dbIx].length() - 3) + "." + parts[dbIx + 1];
        }
        boolean isInPartFields = false;
        for (int i = parts.length - 2; i >= 0; --i) {
            String p = parts[i];
            boolean isPartField = p.contains("=");
            if (isInPartFields && !isPartField || !isPartField && !p.startsWith("base_") && !p.startsWith("delta_") && !p.startsWith("bucket_")) {
                dbIx = i - 1;
                break;
            }
            isInPartFields = isPartField;
        }
        if (dbIx >= 0) {
            String dbName = parts[dbIx];
            if (dbName.endsWith(".db")) {
                dbName = dbName.substring(0, dbName.length() - 3);
            }
            return dbName + "." + parts[dbIx + 1];
        }
        return "unknown";
    }

    private void validateFileMetadata() throws IOException {
        long minAllocSize;
        if (this.fileMetadata.getCompressionKind() == CompressionKind.NONE) {
            return;
        }
        int bufferSize = this.fileMetadata.getCompressionBufferSize();
        if ((long)bufferSize < (minAllocSize = HiveConf.getSizeVar((Configuration)this.daemonConf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_ALLOCATOR_MIN_ALLOC))) {
            LOG.warn("ORC compression buffer size (" + bufferSize + ") is smaller than LLAP low-level cache minimum allocation size (" + minAllocSize + "). Decrease the value for " + HiveConf.ConfVars.LLAP_ALLOCATOR_MIN_ALLOC.toString() + " to avoid wasting memory");
        }
    }

    private boolean processStop() {
        if (!this.isStopped) {
            return false;
        }
        LOG.info("Encoded data reader is stopping");
        this.cleanupReaders();
        return true;
    }

    private static Object determineFileId(FileSystem fs, FileSplit split, boolean allowSynthetic) throws IOException {
        Object fileKey;
        if (split instanceof OrcSplit && (fileKey = ((OrcSplit)split).getFileKey()) != null) {
            return fileKey;
        }
        LOG.warn("Split for " + split.getPath() + " (" + split.getClass() + ") does not have file ID");
        return HdfsUtils.getFileId((FileSystem)fs, (Path)split.getPath(), (boolean)allowSynthetic);
    }

    private static List<Integer> getAllColumnIds(OrcFileMetadata metadata) {
        int rootColumn = OrcInputFormat.getRootColumn((boolean)true);
        List types = metadata.getTypes().get(rootColumn).getSubtypesList();
        ArrayList<Integer> columnIds = new ArrayList<Integer>(types.size());
        for (int i = 0; i < types.size(); ++i) {
            columnIds.add(i);
        }
        return columnIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLoadedIndexes(OrcStripeMetadata stripeMetadata, StripeInformation stripe, boolean[] stripeIncludes, boolean[] sargColumns) throws IOException {
        OrcStripeMetadata orcStripeMetadata = stripeMetadata;
        synchronized (orcStripeMetadata) {
            if (stripeMetadata.hasAllIndexes(stripeIncludes)) {
                return;
            }
            long startTime = this.counters.startTimeCounter();
            stripeMetadata.loadMissingIndexes(this.metadataReader, stripe, stripeIncludes, sargColumns);
            this.counters.incrTimeCounter(LlapIOCounters.HDFS_TIME_NS, startTime);
        }
    }

    private void cleanupReaders() {
        if (this.stripeReader != null) {
            try {
                this.stripeReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.metadataReader != null) {
            try {
                this.metadataReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void ensureOrcReader() throws IOException {
        if (this.orcReader != null) {
            return;
        }
        this.path = this.split.getPath();
        if (this.fileKey instanceof Long && HiveConf.getBoolVar((Configuration)this.daemonConf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_IO_USE_FILEID_PATH)) {
            this.path = HdfsUtils.getFileIdPath((FileSystem)this.fs, (Path)this.path, (long)((Long)this.fileKey));
        }
        LlapIoImpl.ORC_LOGGER.trace("Creating reader for {} ({})", (Object)this.path, (Object)this.split.getPath());
        long startTime = this.counters.startTimeCounter();
        OrcFile.ReaderOptions opts = OrcFile.readerOptions((Configuration)this.jobConf).filesystem(this.fs).fileMetadata((FileMetadata)this.fileMetadata);
        this.orcReader = EncodedOrcFile.createReader((Path)this.path, (OrcFile.ReaderOptions)opts);
        this.counters.incrTimeCounter(LlapIOCounters.HDFS_TIME_NS, startTime);
    }

    private OrcFileMetadata getOrReadFileMetadata() throws IOException {
        OrcFileMetadata metadata = null;
        if (this.fileKey != null && this.metadataCache != null) {
            metadata = this.metadataCache.getFileMetadata(this.fileKey);
            if (metadata != null) {
                this.counters.incrCounter(LlapIOCounters.METADATA_CACHE_HIT);
                return metadata;
            }
            this.counters.incrCounter(LlapIOCounters.METADATA_CACHE_MISS);
        }
        this.ensureOrcReader();
        metadata = new OrcFileMetadata(this.fileKey, (org.apache.hadoop.hive.ql.io.orc.Reader)this.orcReader);
        if (this.fileKey == null || this.metadataCache == null) {
            return metadata;
        }
        return this.metadataCache.putFileMetadata(metadata);
    }

    private ArrayList<OrcStripeMetadata> readStripesMetadata(boolean[] globalInc, boolean[] sargColumns) throws IOException {
        ArrayList<OrcStripeMetadata> result = new ArrayList<OrcStripeMetadata>(this.readState.length);
        boolean hasFileId = this.fileKey != null;
        OrcBatchKey stripeKey = hasFileId ? new OrcBatchKey(this.fileKey, 0, 0) : null;
        for (int stripeIxMod = 0; stripeIxMod < this.readState.length; ++stripeIxMod) {
            OrcStripeMetadata value = null;
            int stripeIx = stripeIxMod + this.stripeIxFrom;
            if (hasFileId && this.metadataCache != null) {
                stripeKey.stripeIx = stripeIx;
                value = this.metadataCache.getStripeMetadata(stripeKey);
            }
            if (value == null || !value.hasAllIndexes(globalInc)) {
                this.counters.incrCounter(LlapIOCounters.METADATA_CACHE_MISS);
                this.ensureMetadataReader();
                StripeInformation si = this.fileMetadata.getStripes().get(stripeIx);
                if (value == null) {
                    long startTime = this.counters.startTimeCounter();
                    value = new OrcStripeMetadata(new OrcBatchKey(this.fileKey, stripeIx, 0), this.metadataReader, si, globalInc, sargColumns);
                    this.counters.incrTimeCounter(LlapIOCounters.HDFS_TIME_NS, startTime);
                    if (hasFileId && this.metadataCache != null) {
                        value = this.metadataCache.putStripeMetadata(value);
                        if (LlapIoImpl.ORC_LOGGER.isTraceEnabled()) {
                            LlapIoImpl.ORC_LOGGER.trace("Caching stripe {} metadata with includes: {}", (Object)stripeKey.stripeIx, (Object)DebugUtils.toString((boolean[])globalInc));
                        }
                    }
                }
                if (!value.hasAllIndexes(globalInc)) {
                    if (LlapIoImpl.ORC_LOGGER.isTraceEnabled()) {
                        LlapIoImpl.ORC_LOGGER.trace("Updating indexes in stripe {} metadata for includes: {}", (Object)stripeKey.stripeIx, (Object)DebugUtils.toString((boolean[])globalInc));
                    }
                    this.updateLoadedIndexes(value, si, globalInc, sargColumns);
                }
            } else {
                this.counters.incrCounter(LlapIOCounters.METADATA_CACHE_HIT);
            }
            result.add(value);
            this.consumer.setStripeMetadata(value);
        }
        return result;
    }

    private void ensureMetadataReader() throws IOException {
        this.ensureOrcReader();
        if (this.metadataReader != null) {
            return;
        }
        long startTime = this.counters.startTimeCounter();
        boolean useZeroCopy = this.daemonConf != null && OrcConf.USE_ZEROCOPY.getBoolean(this.daemonConf);
        this.metadataReader = RecordReaderUtils.createDefaultDataReader((DataReaderProperties)DataReaderProperties.builder().withBufferSize(this.orcReader.getCompressionSize()).withCompression(this.orcReader.getCompressionKind()).withFileSystem(this.fs).withPath(this.path).withTypeCount(this.orcReader.getSchema().getMaximumId() + 1).withZeroCopy(useZeroCopy).build());
        this.counters.incrTimeCounter(LlapIOCounters.HDFS_TIME_NS, startTime);
    }

    @Override
    public void returnData(Reader.OrcEncodedColumnBatch ecb) {
        for (int colIx = 0; colIx < ecb.getTotalColCount(); ++colIx) {
            EncodedColumnBatch.ColumnStreamData[] datas;
            if (!ecb.hasData(colIx)) continue;
            for (EncodedColumnBatch.ColumnStreamData data : datas = ecb.getColumnData(colIx)) {
                if (data == null || data.decRef() != 0) continue;
                if (LlapIoImpl.LOCKING_LOGGER.isTraceEnabled()) {
                    for (MemoryBuffer buf : data.getCacheBuffers()) {
                        LlapIoImpl.LOCKING_LOGGER.trace("Unlocking {} at the end of processing", (Object)buf);
                    }
                }
                this.bufferManager.decRefBuffers(data.getCacheBuffers());
                CSD_POOL.offer((Object)data);
            }
        }
        ECB_POOL.offer((Object)ecb);
    }

    private boolean determineRgsToRead(boolean[] globalIncludes, int rowIndexStride, ArrayList<OrcStripeMetadata> metadata) throws IOException {
        RecordReaderImpl.SargApplier sargApp = null;
        if (this.sarg != null && rowIndexStride != 0) {
            List<OrcProto.Type> types = this.fileMetadata.getTypes();
            String[] colNamesForSarg = OrcInputFormat.getSargColumnNames((String[])this.columnNames, types, (boolean[])globalIncludes, (boolean)this.fileMetadata.isOriginalFormat());
            TypeDescription schema = OrcUtils.convertTypeFromProtobuf(types, (int)0);
            SchemaEvolution schemaEvolution = new SchemaEvolution(schema, globalIncludes);
            sargApp = new RecordReaderImpl.SargApplier(this.sarg, colNamesForSarg, (long)rowIndexStride, schemaEvolution);
        }
        boolean hasAnyData = false;
        for (int stripeIxMod = 0; stripeIxMod < this.readState.length; ++stripeIxMod) {
            int includeIx;
            int stripeIx = stripeIxMod + this.stripeIxFrom;
            StripeInformation stripe = this.fileMetadata.getStripes().get(stripeIx);
            int rgCount = this.getRgCount(stripe, rowIndexStride);
            boolean[] rgsToRead = null;
            if (sargApp != null) {
                OrcStripeMetadata stripeMetadata = metadata.get(stripeIxMod);
                rgsToRead = sargApp.pickRowGroups(stripe, stripeMetadata.getRowIndexes(), stripeMetadata.getBloomFilterIndexes(), true);
            }
            boolean isNone = rgsToRead == RecordReaderImpl.SargApplier.READ_NO_RGS;
            boolean isAll = rgsToRead == RecordReaderImpl.SargApplier.READ_ALL_RGS;
            boolean bl = hasAnyData = hasAnyData || !isNone;
            if (LlapIoImpl.ORC_LOGGER.isTraceEnabled()) {
                if (isNone) {
                    LlapIoImpl.ORC_LOGGER.trace("SARG eliminated all RGs for stripe {}", (Object)stripeIx);
                } else if (!isAll) {
                    LlapIoImpl.ORC_LOGGER.trace("SARG picked RGs for stripe {}: {}", (Object)stripeIx, (Object)DebugUtils.toString((boolean[])rgsToRead));
                } else {
                    LlapIoImpl.ORC_LOGGER.trace("Will read all {} RGs for stripe {}", (Object)rgCount, (Object)stripeIx);
                }
            }
            assert (isAll || isNone || rgsToRead.length == rgCount);
            int fileIncludesCount = 0;
            for (includeIx = 1; includeIx < globalIncludes.length; ++includeIx) {
                fileIncludesCount += globalIncludes[includeIx] ? 1 : 0;
            }
            this.readState[stripeIxMod] = new boolean[fileIncludesCount][];
            for (includeIx = 0; includeIx < fileIncludesCount; ++includeIx) {
                this.readState[stripeIxMod][includeIx] = isAll || isNone ? rgsToRead : Arrays.copyOf(rgsToRead, rgsToRead.length);
            }
            this.adjustRgMetric(rgCount, rgsToRead, isNone, isAll);
        }
        return hasAnyData;
    }

    private void adjustRgMetric(int rgCount, boolean[] rgsToRead, boolean isNone, boolean isAll) {
        int count = 0;
        if (!isAll) {
            for (boolean b : rgsToRead) {
                if (!b) continue;
                ++count;
            }
        } else if (!isNone) {
            count = rgCount;
        }
        this.counters.incrCounter(LlapIOCounters.SELECTED_ROWGROUPS, count);
    }

    private int getRgCount(StripeInformation stripe, int rowIndexStride) {
        return (int)Math.ceil((double)stripe.getNumberOfRows() / (double)rowIndexStride);
    }

    public void determineStripesToRead() {
        List<StripeInformation> stripes = this.fileMetadata.getStripes();
        long offset = this.split.getStart();
        long maxOffset = offset + this.split.getLength();
        this.stripeIxFrom = -1;
        int stripeIxTo = -1;
        if (LlapIoImpl.ORC_LOGGER.isDebugEnabled()) {
            String tmp = "FileSplit {" + this.split.getStart() + ", " + this.split.getLength() + "}; stripes ";
            for (StripeInformation stripe : stripes) {
                tmp = tmp + "{" + stripe.getOffset() + ", " + stripe.getLength() + "}, ";
            }
            LlapIoImpl.ORC_LOGGER.debug(tmp);
        }
        int stripeIx = 0;
        for (StripeInformation stripe : stripes) {
            long stripeStart = stripe.getOffset();
            if (offset > stripeStart) {
                ++stripeIx;
                continue;
            }
            if (this.stripeIxFrom == -1) {
                LlapIoImpl.ORC_LOGGER.trace("Including stripes from {} ({} >= {})", new Object[]{stripeIx, stripeStart, offset});
                this.stripeIxFrom = stripeIx;
            }
            if (stripeStart >= maxOffset) {
                stripeIxTo = stripeIx;
                LlapIoImpl.ORC_LOGGER.trace("Including stripes until {} ({} >= {}); {} stripes", new Object[]{stripeIxTo, stripeStart, maxOffset, stripeIxTo - this.stripeIxFrom});
                break;
            }
            ++stripeIx;
        }
        if (this.stripeIxFrom == -1) {
            LlapIoImpl.LOG.info("Not including any stripes - empty split");
        }
        if (stripeIxTo == -1 && this.stripeIxFrom != -1) {
            stripeIxTo = stripeIx;
            LlapIoImpl.ORC_LOGGER.trace("Including stripes until {} (end of file); {} stripes", (Object)stripeIx, (Object)(stripeIxTo - this.stripeIxFrom));
        }
        this.readState = new boolean[stripeIxTo - this.stripeIxFrom][][];
    }

    public TezCounters getTezCounters() {
        return this.counters.getTezCounters();
    }

    private class DataWrapperForOrc
    implements DataReader,
    DataCache {
        private final DataReader orcDataReader;

        private DataWrapperForOrc(DataWrapperForOrc other) {
            this.orcDataReader = other.orcDataReader.clone();
        }

        public DataWrapperForOrc() throws IOException {
            OrcEncodedDataReader.this.ensureMetadataReader();
            this.orcDataReader = OrcEncodedDataReader.this.metadataReader.clone();
        }

        public DiskRangeList getFileData(Object fileKey, DiskRangeList range, long baseOffset, DataCache.DiskRangeListFactory factory, DataCache.BooleanRef gotAllData) {
            DiskRangeList result = OrcEncodedDataReader.this.lowLevelCache.getFileData(fileKey, range, baseOffset, factory, OrcEncodedDataReader.this.counters, gotAllData);
            if (LlapIoImpl.ORC_LOGGER.isTraceEnabled()) {
                LlapIoImpl.ORC_LOGGER.trace("Disk ranges after data cache (file " + fileKey + ", base offset " + baseOffset + "): " + RecordReaderUtils.stringifyDiskRanges((DiskRangeList)result));
            }
            if (gotAllData.value) {
                return result;
            }
            return OrcEncodedDataReader.this.metadataCache == null ? result : OrcEncodedDataReader.this.metadataCache.getIncompleteCbs(fileKey, result, baseOffset, factory, gotAllData);
        }

        public long[] putFileData(Object fileKey, DiskRange[] ranges, MemoryBuffer[] data, long baseOffset) {
            if (data != null) {
                return OrcEncodedDataReader.this.lowLevelCache.putFileData(fileKey, ranges, data, baseOffset, LowLevelCache.Priority.NORMAL, OrcEncodedDataReader.this.counters);
            }
            if (OrcEncodedDataReader.this.metadataCache != null) {
                OrcEncodedDataReader.this.metadataCache.putIncompleteCbs(fileKey, ranges, baseOffset);
            }
            return null;
        }

        public void releaseBuffer(MemoryBuffer buffer) {
            OrcEncodedDataReader.this.bufferManager.decRefBuffer(buffer);
        }

        public void reuseBuffer(MemoryBuffer buffer) {
            boolean isReused = OrcEncodedDataReader.this.bufferManager.incRefBuffer(buffer);
            assert (isReused);
        }

        public Allocator getAllocator() {
            return OrcEncodedDataReader.this.bufferManager.getAllocator();
        }

        public void close() throws IOException {
            this.orcDataReader.close();
            if (OrcEncodedDataReader.this.metadataReader != null) {
                OrcEncodedDataReader.this.metadataReader.close();
            }
        }

        public DiskRangeList readFileData(DiskRangeList range, long baseOffset, boolean doForceDirect) throws IOException {
            long startTime = OrcEncodedDataReader.this.counters.startTimeCounter();
            DiskRangeList result = this.orcDataReader.readFileData(range, baseOffset, doForceDirect);
            OrcEncodedDataReader.this.counters.recordHdfsTime(startTime);
            if (LlapIoImpl.ORC_LOGGER.isTraceEnabled()) {
                LlapIoImpl.ORC_LOGGER.trace("Disk ranges after disk read (file {}, base offset {}): {}", new Object[]{OrcEncodedDataReader.this.fileKey, baseOffset, RecordReaderUtils.stringifyDiskRanges((DiskRangeList)result)});
            }
            return result;
        }

        public boolean isTrackingDiskRanges() {
            return this.orcDataReader.isTrackingDiskRanges();
        }

        public void releaseBuffer(ByteBuffer buffer) {
            this.orcDataReader.releaseBuffer(buffer);
        }

        public DataWrapperForOrc clone() {
            return new DataWrapperForOrc(this);
        }

        public void open() throws IOException {
            long startTime = OrcEncodedDataReader.this.counters.startTimeCounter();
            this.orcDataReader.open();
            OrcEncodedDataReader.this.counters.recordHdfsTime(startTime);
        }

        public OrcIndex readRowIndex(StripeInformation stripe, OrcProto.StripeFooter footer, boolean[] included, OrcProto.RowIndex[] indexes, boolean[] sargColumns, OrcProto.BloomFilterIndex[] bloomFilterIndices) throws IOException {
            return this.orcDataReader.readRowIndex(stripe, footer, included, indexes, sargColumns, bloomFilterIndices);
        }

        public OrcProto.StripeFooter readStripeFooter(StripeInformation stripe) throws IOException {
            return this.orcDataReader.readStripeFooter(stripe);
        }
    }
}

