/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.metrics;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.hive.llap.metrics.LlapDaemonCustomMetricsInfo;
import org.apache.hadoop.hive.llap.metrics.LlapDaemonExecutorInfo;
import org.apache.hadoop.hive.llap.metrics.LlapMetricsSystem;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.impl.MsInfo;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableGaugeInt;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;
import org.apache.hadoop.metrics2.lib.MutableQuantiles;
import org.apache.hadoop.metrics2.source.JvmMetrics;

@Metrics(about="LlapDaemon Executor Metrics", context="executors")
public class LlapDaemonExecutorMetrics
implements MetricsSource {
    private final String name;
    private final JvmMetrics jvmMetrics;
    private final String sessionId;
    private final MetricsRegistry registry;
    private final int numExecutors;
    private final ThreadMXBean threadMXBean;
    private final Map<Integer, MetricsInfo> cpuMetricsInfoMap;
    private final Map<Integer, MetricsInfo> userMetricsInfoMap;
    private long maxTimeLost = Long.MIN_VALUE;
    private long maxTimeToKill = Long.MIN_VALUE;
    private long fallOffMaxSuccessTimeLostLong = 0L;
    private long fallOffMaxFailedTimeLostLong = 0L;
    private long fallOffMaxKilledTimeLostLong = 0L;
    final MutableGaugeLong[] executorThreadCpuTime;
    final MutableGaugeLong[] executorThreadUserTime;
    @Metric
    MutableCounterLong executorTotalRequestHandled;
    @Metric
    MutableGaugeInt executorNumQueuedRequests;
    @Metric
    MutableGaugeInt executorNumPreemptableRequests;
    @Metric
    MutableGaugeInt numExecutorsAvailable;
    @Metric
    MutableCounterLong totalRejectedRequests;
    @Metric
    MutableCounterLong totalEvictedFromWaitQueue;
    @Metric
    MutableCounterLong executorTotalSuccess;
    @Metric
    MutableCounterLong executorTotalIKilled;
    @Metric
    MutableCounterLong executorTotalExecutionFailed;
    @Metric
    MutableGaugeLong cacheMemoryPerInstance;
    @Metric
    MutableGaugeLong memoryPerInstance;
    @Metric
    MutableGaugeLong jvmMaxMemory;
    @Metric
    MutableGaugeInt waitQueueSize;
    @Metric
    MutableCounterLong totalPreemptionTimeToKill;
    @Metric
    MutableCounterLong totalPreemptionTimeLost;
    @Metric
    MutableGaugeLong maxPreemptionTimeToKill;
    @Metric
    MutableGaugeLong maxPreemptionTimeLost;
    @Metric
    final MutableQuantiles[] percentileTimeToKill;
    @Metric
    final MutableQuantiles[] percentileTimeLost;
    @Metric
    MutableCounterLong fallOffNumCompletedFragments;
    @Metric
    MutableCounterLong fallOffSuccessTimeLost;
    @Metric
    MutableCounterLong fallOffFailedTimeLost;
    @Metric
    MutableCounterLong fallOffKilledTimeLost;
    @Metric
    MutableGaugeLong fallOffMaxSuccessTimeLost;
    @Metric
    MutableGaugeLong fallOffMaxFailedTimeLost;
    @Metric
    MutableGaugeLong fallOffMaxKilledTimeLost;

    private LlapDaemonExecutorMetrics(String displayName, JvmMetrics jm, String sessionId, int numExecutors, int[] intervals) {
        int i;
        this.name = displayName;
        this.jvmMetrics = jm;
        this.sessionId = sessionId;
        this.registry = new MetricsRegistry("LlapDaemonExecutorRegistry");
        this.registry.tag((MetricsInfo)MsInfo.ProcessName, "LlapDaemon").tag((MetricsInfo)MsInfo.SessionId, sessionId);
        this.numExecutors = numExecutors;
        this.threadMXBean = ManagementFactory.getThreadMXBean();
        this.executorThreadCpuTime = new MutableGaugeLong[numExecutors];
        this.executorThreadUserTime = new MutableGaugeLong[numExecutors];
        this.cpuMetricsInfoMap = new ConcurrentHashMap<Integer, MetricsInfo>();
        this.userMetricsInfoMap = new ConcurrentHashMap<Integer, MetricsInfo>();
        int len = intervals == null ? 0 : intervals.length;
        this.percentileTimeToKill = new MutableQuantiles[len];
        this.percentileTimeLost = new MutableQuantiles[len];
        for (i = 0; i < len; ++i) {
            int interval = intervals[i];
            this.percentileTimeToKill[i] = this.registry.newQuantiles(LlapDaemonExecutorInfo.ExecutorMaxPreemptionTimeToKill.name() + "_" + interval + "s", LlapDaemonExecutorInfo.ExecutorMaxPreemptionTimeToKill.description(), "ops", "latency", interval);
            this.percentileTimeLost[i] = this.registry.newQuantiles(LlapDaemonExecutorInfo.ExecutorMaxPreemptionTimeLost.name() + "_" + interval + "s", LlapDaemonExecutorInfo.ExecutorMaxPreemptionTimeLost.description(), "ops", "latency", interval);
        }
        for (i = 0; i < numExecutors; ++i) {
            LlapDaemonCustomMetricsInfo mic = new LlapDaemonCustomMetricsInfo(LlapDaemonExecutorInfo.ExecutorThreadCPUTime.name() + "_" + i, LlapDaemonExecutorInfo.ExecutorThreadCPUTime.description());
            LlapDaemonCustomMetricsInfo miu = new LlapDaemonCustomMetricsInfo(LlapDaemonExecutorInfo.ExecutorThreadUserTime.name() + "_" + i, LlapDaemonExecutorInfo.ExecutorThreadUserTime.description());
            this.cpuMetricsInfoMap.put(i, mic);
            this.userMetricsInfoMap.put(i, miu);
            this.executorThreadCpuTime[i] = this.registry.newGauge((MetricsInfo)mic, 0L);
            this.executorThreadUserTime[i] = this.registry.newGauge((MetricsInfo)miu, 0L);
        }
    }

    public static LlapDaemonExecutorMetrics create(String displayName, String sessionId, int numExecutors, int[] intervals) {
        MetricsSystem ms = LlapMetricsSystem.instance();
        JvmMetrics jm = JvmMetrics.create((String)"LlapDaemon", (String)sessionId, (MetricsSystem)ms);
        return (LlapDaemonExecutorMetrics)ms.register(displayName, "LlapDaemon Executor Metrics", (Object)new LlapDaemonExecutorMetrics(displayName, jm, sessionId, numExecutors, intervals));
    }

    public void getMetrics(MetricsCollector collector, boolean b) {
        MetricsRecordBuilder rb = collector.addRecord((MetricsInfo)LlapDaemonExecutorInfo.ExecutorMetrics).setContext("executors").tag((MetricsInfo)MsInfo.ProcessName, "LlapDaemon").tag((MetricsInfo)MsInfo.SessionId, this.sessionId);
        this.getExecutorStats(rb);
    }

    public void incrExecutorTotalRequestsHandled() {
        this.executorTotalRequestHandled.incr();
    }

    public void setExecutorNumQueuedRequests(int value) {
        this.executorNumQueuedRequests.set(value);
    }

    public void setExecutorNumPreemptableRequests(int value) {
        this.executorNumPreemptableRequests.set(value);
    }

    public void setNumExecutorsAvailable(int value) {
        this.numExecutorsAvailable.set(value);
    }

    public void incrTotalEvictedFromWaitQueue() {
        this.totalEvictedFromWaitQueue.incr();
    }

    public void incrTotalRejectedRequests() {
        this.totalRejectedRequests.incr();
    }

    public void incrExecutorTotalSuccess() {
        this.executorTotalSuccess.incr();
    }

    public void incrExecutorTotalExecutionFailed() {
        this.executorTotalExecutionFailed.incr();
    }

    public void addMetricsPreemptionTimeLost(long value) {
        this.totalPreemptionTimeLost.incr(value);
        if (value > this.maxTimeLost) {
            this.maxTimeLost = value;
            this.maxPreemptionTimeLost.set(this.maxTimeLost);
        }
        for (MutableQuantiles q : this.percentileTimeLost) {
            q.add(value);
        }
    }

    public void addMetricsPreemptionTimeToKill(long value) {
        this.totalPreemptionTimeToKill.incr(value);
        if (value > this.maxTimeToKill) {
            this.maxTimeToKill = value;
            this.maxPreemptionTimeToKill.set(this.maxTimeToKill);
        }
        for (MutableQuantiles q : this.percentileTimeToKill) {
            q.add(value);
        }
    }

    public void addMetricsFallOffSuccessTimeLost(long timeLost) {
        this.fallOffNumCompletedFragments.incr();
        this.fallOffSuccessTimeLost.incr(timeLost);
        if (timeLost > this.fallOffMaxSuccessTimeLostLong) {
            this.fallOffMaxSuccessTimeLostLong = timeLost;
            this.fallOffMaxSuccessTimeLost.set(timeLost);
        }
    }

    public void addMetricsFallOffFailedTimeLost(long timeLost) {
        this.fallOffNumCompletedFragments.incr();
        this.fallOffFailedTimeLost.incr(timeLost);
        if (timeLost > this.fallOffMaxFailedTimeLostLong) {
            this.fallOffMaxFailedTimeLostLong = timeLost;
            this.fallOffMaxFailedTimeLost.set(timeLost);
        }
    }

    public void addMetricsFallOffKilledTimeLost(long timeLost) {
        this.fallOffNumCompletedFragments.incr();
        this.fallOffKilledTimeLost.incr(timeLost);
        if (timeLost > this.fallOffMaxKilledTimeLostLong) {
            this.fallOffMaxKilledTimeLostLong = timeLost;
            this.fallOffMaxKilledTimeLost.set(timeLost);
        }
    }

    public void incrExecutorTotalKilled() {
        this.executorTotalIKilled.incr();
    }

    public void setCacheMemoryPerInstance(long value) {
        this.cacheMemoryPerInstance.set(value);
    }

    public void setMemoryPerInstance(long value) {
        this.memoryPerInstance.set(value);
    }

    public void setJvmMaxMemory(long value) {
        this.jvmMaxMemory.set(value);
    }

    public void setWaitQueueSize(int size) {
        this.waitQueueSize.set(size);
    }

    private void getExecutorStats(MetricsRecordBuilder rb) {
        this.updateThreadMetrics(rb);
        int totalSlots = this.waitQueueSize.value() + this.numExecutors;
        int slotsAvailableInQueue = this.waitQueueSize.value() - this.executorNumQueuedRequests.value();
        int slotsAvailableTotal = slotsAvailableInQueue + this.numExecutorsAvailable.value();
        float slotsAvailablePercent = totalSlots <= 0 ? 0.0f : (float)slotsAvailableTotal / (float)totalSlots;
        rb.addCounter((MetricsInfo)LlapDaemonExecutorInfo.ExecutorTotalRequestsHandled, this.executorTotalRequestHandled.value()).addCounter((MetricsInfo)LlapDaemonExecutorInfo.ExecutorTotalSuccess, this.executorTotalSuccess.value()).addCounter((MetricsInfo)LlapDaemonExecutorInfo.ExecutorTotalFailed, this.executorTotalExecutionFailed.value()).addCounter((MetricsInfo)LlapDaemonExecutorInfo.ExecutorTotalKilled, this.executorTotalIKilled.value()).addCounter((MetricsInfo)LlapDaemonExecutorInfo.ExecutorTotalEvictedFromWaitQueue, this.totalEvictedFromWaitQueue.value()).addCounter((MetricsInfo)LlapDaemonExecutorInfo.ExecutorTotalRejectedRequests, this.totalRejectedRequests.value()).addGauge((MetricsInfo)LlapDaemonExecutorInfo.ExecutorNumQueuedRequests, this.executorNumQueuedRequests.value()).addGauge((MetricsInfo)LlapDaemonExecutorInfo.ExecutorNumPreemptableRequests, this.executorNumPreemptableRequests.value()).addGauge((MetricsInfo)LlapDaemonExecutorInfo.ExecutorMemoryPerInstance, this.memoryPerInstance.value()).addGauge((MetricsInfo)LlapDaemonExecutorInfo.ExecutorCacheMemoryPerInstance, this.cacheMemoryPerInstance.value()).addGauge((MetricsInfo)LlapDaemonExecutorInfo.ExecutorJvmMaxMemory, this.jvmMaxMemory.value()).addGauge((MetricsInfo)LlapDaemonExecutorInfo.ExecutorMaxFreeSlots, totalSlots).addGauge((MetricsInfo)LlapDaemonExecutorInfo.ExecutorNumExecutorsPerInstance, this.numExecutors).addGauge((MetricsInfo)LlapDaemonExecutorInfo.ExecutorWaitQueueSize, this.waitQueueSize.value()).addGauge((MetricsInfo)LlapDaemonExecutorInfo.ExecutorNumExecutorsAvailable, this.numExecutorsAvailable.value()).addGauge((MetricsInfo)LlapDaemonExecutorInfo.ExecutorAvailableFreeSlots, slotsAvailableTotal).addGauge((MetricsInfo)LlapDaemonExecutorInfo.ExecutorAvailableFreeSlotsPercent, slotsAvailablePercent).addCounter((MetricsInfo)LlapDaemonExecutorInfo.ExecutorTotalPreemptionTimeToKill, this.totalPreemptionTimeToKill.value()).addCounter((MetricsInfo)LlapDaemonExecutorInfo.ExecutorTotalPreemptionTimeLost, this.totalPreemptionTimeLost.value()).addGauge((MetricsInfo)LlapDaemonExecutorInfo.ExecutorMaxPreemptionTimeToKill, this.maxPreemptionTimeToKill.value()).addGauge((MetricsInfo)LlapDaemonExecutorInfo.ExecutorMaxPreemptionTimeLost, this.maxPreemptionTimeLost.value()).addCounter((MetricsInfo)LlapDaemonExecutorInfo.ExecutorFallOffSuccessTimeLost, this.fallOffSuccessTimeLost.value()).addGauge((MetricsInfo)LlapDaemonExecutorInfo.ExecutorFallOffSuccessMaxTimeLost, this.fallOffMaxSuccessTimeLost.value()).addCounter((MetricsInfo)LlapDaemonExecutorInfo.ExecutorFallOffFailedTimeLost, this.fallOffFailedTimeLost.value()).addGauge((MetricsInfo)LlapDaemonExecutorInfo.ExecutorFallOffFailedMaxTimeLost, this.fallOffMaxFailedTimeLost.value()).addCounter((MetricsInfo)LlapDaemonExecutorInfo.ExecutorFallOffKilledTimeLost, this.fallOffKilledTimeLost.value()).addGauge((MetricsInfo)LlapDaemonExecutorInfo.ExecutorFallOffKilledMaxTimeLost, this.fallOffMaxKilledTimeLost.value()).addCounter((MetricsInfo)LlapDaemonExecutorInfo.ExecutorFallOffNumCompletedFragments, this.fallOffNumCompletedFragments.value());
        for (MutableQuantiles q : this.percentileTimeToKill) {
            q.snapshot(rb, true);
        }
        for (MutableQuantiles q : this.percentileTimeLost) {
            q.snapshot(rb, true);
        }
    }

    private void updateThreadMetrics(MetricsRecordBuilder rb) {
        if (this.threadMXBean.isThreadCpuTimeSupported() && this.threadMXBean.isThreadCpuTimeEnabled()) {
            int i;
            long[] ids = this.threadMXBean.getAllThreadIds();
            ThreadInfo[] infos = this.threadMXBean.getThreadInfo(ids);
            for (i = 0; i < ids.length; ++i) {
                ThreadInfo threadInfo = infos[i];
                String threadName = threadInfo.getThreadName();
                long threadId = ids[i];
                for (int j = 0; j < this.numExecutors; ++j) {
                    if (!threadName.equals("ContainerExecutor " + j)) continue;
                    this.executorThreadCpuTime[j].set(this.threadMXBean.getThreadCpuTime(threadId));
                    this.executorThreadUserTime[j].set(this.threadMXBean.getThreadUserTime(threadId));
                }
            }
            for (i = 0; i < this.numExecutors; ++i) {
                rb.addGauge(this.cpuMetricsInfoMap.get(i), this.executorThreadCpuTime[i].value());
                rb.addGauge(this.userMetricsInfoMap.get(i), this.executorThreadUserTime[i].value());
            }
        }
    }

    public JvmMetrics getJvmMetrics() {
        return this.jvmMetrics;
    }

    public String getName() {
        return this.name;
    }
}

