/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.jta;

import java.util.concurrent.atomic.AtomicReference;
import javax.cache.configuration.Factory;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.jta.CacheTmLookup;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.TransactionConfiguration;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.internal.processors.cache.jta.CacheJtaManagerAdapter;
import org.apache.ignite.internal.processors.cache.jta.CacheJtaResource;
import org.apache.ignite.lifecycle.LifecycleAware;
import org.apache.ignite.transactions.TransactionState;
import org.jetbrains.annotations.Nullable;

public class CacheJtaManager
extends CacheJtaManagerAdapter {
    private final ThreadLocal<CacheJtaResource> rsrc = new ThreadLocal();
    private TransactionManager jtaTm;
    private final AtomicReference<CacheTmLookup> tmLookupRef = new AtomicReference();
    private Factory<TransactionManager> tmFactory;
    private boolean useJtaSync;

    protected void start0() throws IgniteCheckedException {
        super.start0();
        if (this.cctx.txConfig() != null) {
            this.tmFactory = this.cctx.txConfig().getTxManagerFactory();
            if (this.tmFactory != null) {
                Object txMgr;
                this.cctx.kernalContext().resource().injectGeneric(this.tmFactory);
                if (this.tmFactory instanceof LifecycleAware) {
                    ((LifecycleAware)this.tmFactory).start();
                }
                try {
                    txMgr = this.tmFactory.create();
                }
                catch (Exception e) {
                    throw new IgniteCheckedException("Failed to create transaction manager [tmFactory=" + this.tmFactory + "]", (Throwable)e);
                }
                if (txMgr == null) {
                    throw new IgniteCheckedException("Failed to create transaction manager (transaction manager factory created null-value transaction manager) [tmFactory=" + this.tmFactory + "]");
                }
                if (!(txMgr instanceof TransactionManager)) {
                    throw new IgniteCheckedException("Failed to create transaction manager (transaction manager factory created object that is not an instance of TransactionManager) [tmFactory=" + this.tmFactory + ", txMgr=" + txMgr + "]");
                }
                this.jtaTm = (TransactionManager)txMgr;
            } else {
                String txLookupClsName = this.cctx.txConfig().getTxManagerLookupClassName();
                if (txLookupClsName != null) {
                    this.tmLookupRef.set(this.createTmLookup(txLookupClsName));
                }
            }
            this.useJtaSync = this.cctx.txConfig().isUseJtaSynchronization();
        }
    }

    protected void stop0(boolean cancel) {
        CacheTmLookup tmLookup = this.tmLookupRef.get();
        if (tmLookup instanceof LifecycleAware) {
            ((LifecycleAware)tmLookup).stop();
        }
        if (this.tmFactory instanceof LifecycleAware) {
            ((LifecycleAware)this.tmFactory).stop();
        }
    }

    private CacheTmLookup createTmLookup(String tmLookupClsName) throws IgniteCheckedException {
        try {
            Class<?> cls = Class.forName(tmLookupClsName);
            CacheTmLookup res = (CacheTmLookup)cls.newInstance();
            this.cctx.kernalContext().resource().injectGeneric((Object)res);
            if (res instanceof LifecycleAware) {
                ((LifecycleAware)res).start();
            }
            return res;
        }
        catch (Exception e) {
            throw new IgniteCheckedException("Failed to instantiate transaction manager lookup.", (Throwable)e);
        }
    }

    public void checkJta() throws IgniteCheckedException {
        CacheJtaResource rsrc;
        if (this.jtaTm == null) {
            try {
                CacheTmLookup tmLookup = this.tmLookupRef.get();
                if (tmLookup == null) {
                    return;
                }
                this.jtaTm = tmLookup.getTm();
            }
            catch (Exception e) {
                throw new IgniteCheckedException("Failed to get transaction manager: " + e, (Throwable)e);
            }
        }
        if (this.jtaTm != null && ((rsrc = this.rsrc.get()) == null || rsrc.isFinished() || rsrc.cacheTx().state() == TransactionState.SUSPENDED)) {
            try {
                Transaction jtaTx = this.jtaTm.getTransaction();
                if (jtaTx != null) {
                    GridNearTxLocal tx = this.cctx.tm().userTx();
                    if (tx == null) {
                        TransactionConfiguration tCfg = this.cctx.kernalContext().config().getTransactionConfiguration();
                        tx = this.cctx.tm().newTx(false, false, null, tCfg.getDefaultTxConcurrency(), tCfg.getDefaultTxIsolation(), tCfg.getDefaultTxTimeout(), true, Boolean.valueOf(false), 0, null, false);
                    }
                    rsrc = new CacheJtaResource(tx, this.cctx.kernalContext());
                    if (this.useJtaSync) {
                        jtaTx.registerSynchronization((Synchronization)rsrc);
                    } else if (!jtaTx.enlistResource((XAResource)rsrc)) {
                        throw new IgniteCheckedException("Failed to enlist XA resource to JTA user transaction.");
                    }
                    this.rsrc.set(rsrc);
                }
            }
            catch (SystemException e) {
                throw new IgniteCheckedException("Failed to obtain JTA transaction.", (Throwable)e);
            }
            catch (RollbackException e) {
                throw new IgniteCheckedException("Failed to enlist XAResource to JTA transaction.", (Throwable)e);
            }
        }
    }

    public void registerCache(CacheConfiguration<?, ?> cfg) throws IgniteCheckedException {
        String cacheLookupClsName = cfg.getTransactionManagerLookupClassName();
        if (cacheLookupClsName != null) {
            CacheTmLookup tmLookup = this.tmLookupRef.get();
            if (tmLookup == null) {
                tmLookup = this.createTmLookup(cacheLookupClsName);
                if (this.tmLookupRef.compareAndSet(null, tmLookup)) {
                    return;
                }
                tmLookup = this.tmLookupRef.get();
            }
            if (!cacheLookupClsName.equals(tmLookup.getClass().getName())) {
                throw new IgniteCheckedException("Failed to start cache with CacheTmLookup that specified in cache configuration, because node uses another CacheTmLookup [cache" + cfg.getName() + ", tmLookupClassName=" + cacheLookupClsName + ", tmLookupUsedByNode=" + tmLookup.getClass().getName() + ']');
            }
        }
    }

    @Nullable
    public Object tmLookup() {
        return this.tmLookupRef.get();
    }
}

