/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.commons.sort;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.jackrabbit.oak.commons.sort.BinaryFileBuffer;
import org.apache.jackrabbit.oak.commons.sort.EscapeUtils;
import org.apache.jackrabbit.oak.commons.sort.StringSizeEstimator;

public class ExternalSort {
    static final int DEFAULTMAXTEMPFILES = 1024;
    static final long DEFAULT_MAX_MEM_BYTES = 0x800000L;
    public static Comparator<String> defaultcomparator = new Comparator<String>(){

        @Override
        public int compare(String r1, String r2) {
            return r1.compareTo(r2);
        }
    };

    public static void sort(File input, File output) throws IOException {
        ExternalSort.mergeSortedFiles(ExternalSort.sortInBatch(input), output);
    }

    public static long estimateBestSizeOfBlocks(File filetobesorted, int maxtmpfiles, long maxMemory) {
        long sizeoffile = filetobesorted.length() * 2L;
        long blocksize = sizeoffile / (long)maxtmpfiles + (long)(sizeoffile % (long)maxtmpfiles == 0L ? 0 : 1);
        if (blocksize < maxMemory) {
            blocksize = maxMemory;
        }
        return blocksize;
    }

    public static List<File> sortInBatch(File file) throws IOException {
        return ExternalSort.sortInBatch(file, defaultcomparator, 1024, 0x800000L, Charset.defaultCharset(), null, false);
    }

    public static List<File> sortInBatch(File file, Comparator<String> cmp) throws IOException {
        return ExternalSort.sortInBatch(file, cmp, 1024, 0x800000L, Charset.defaultCharset(), null, false);
    }

    public static List<File> sortInBatch(File file, Comparator<String> cmp, boolean distinct) throws IOException {
        return ExternalSort.sortInBatch(file, cmp, 1024, 0x800000L, Charset.defaultCharset(), null, distinct);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<File> sortInBatch(File file, Comparator<String> cmp, int maxtmpfiles, long maxMemory, Charset cs, File tmpdirectory, boolean distinct, int numHeader, boolean usegzip) throws IOException {
        ArrayList<File> files = new ArrayList<File>();
        BufferedReader fbr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), cs));
        long blocksize = ExternalSort.estimateBestSizeOfBlocks(file, maxtmpfiles, maxMemory);
        try {
            ArrayList<String> tmplist = new ArrayList<String>();
            String line = "";
            try {
                int counter = 0;
                while (line != null) {
                    long currentblocksize = 0L;
                    while (currentblocksize < blocksize && (line = ExternalSort.readLine(fbr)) != null) {
                        if (counter < numHeader) {
                            ++counter;
                            continue;
                        }
                        tmplist.add(line);
                        currentblocksize += StringSizeEstimator.estimatedSizeOf(line);
                    }
                    files.add(ExternalSort.sortAndSave(tmplist, cmp, cs, tmpdirectory, distinct, usegzip));
                    tmplist.clear();
                }
            }
            catch (EOFException oef) {
                if (tmplist.size() > 0) {
                    files.add(ExternalSort.sortAndSave(tmplist, cmp, cs, tmpdirectory, distinct, usegzip));
                    tmplist.clear();
                }
            }
        }
        finally {
            fbr.close();
        }
        return files;
    }

    public static List<File> sortInBatch(File file, Comparator<String> cmp, int maxtmpfiles, long maxMemory, Charset cs, File tmpdirectory, boolean distinct) throws IOException {
        return ExternalSort.sortInBatch(file, cmp, maxtmpfiles, maxMemory, cs, tmpdirectory, distinct, 0, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File sortAndSave(List<String> tmplist, Comparator<String> cmp, Charset cs, File tmpdirectory, boolean distinct, boolean usegzip) throws IOException {
        Collections.sort(tmplist, cmp);
        File newtmpfile = File.createTempFile("sortInBatch", "flatfile", tmpdirectory);
        newtmpfile.deleteOnExit();
        OutputStream out = new FileOutputStream(newtmpfile);
        int zipBufferSize = 2048;
        if (usegzip) {
            out = new GZIPOutputStream(out, zipBufferSize){
                {
                    this.def.setLevel(1);
                }
            };
        }
        BufferedWriter fbw = new BufferedWriter(new OutputStreamWriter(out, cs));
        String lastLine = null;
        try {
            for (String r : tmplist) {
                if (distinct && lastLine != null && (lastLine == null || cmp.compare(r, lastLine) == 0)) continue;
                ExternalSort.writeLine(fbw, r);
                fbw.newLine();
                lastLine = r;
            }
        }
        finally {
            fbw.close();
        }
        return newtmpfile;
    }

    public static File sortAndSave(List<String> tmplist, Comparator<String> cmp, Charset cs, File tmpdirectory) throws IOException {
        return ExternalSort.sortAndSave(tmplist, cmp, cs, tmpdirectory, false, false);
    }

    public static int mergeSortedFiles(List<File> files, File outputfile) throws IOException {
        return ExternalSort.mergeSortedFiles(files, outputfile, defaultcomparator, Charset.defaultCharset());
    }

    public static int mergeSortedFiles(List<File> files, File outputfile, Comparator<String> cmp) throws IOException {
        return ExternalSort.mergeSortedFiles(files, outputfile, cmp, Charset.defaultCharset());
    }

    public static int mergeSortedFiles(List<File> files, File outputfile, Comparator<String> cmp, boolean distinct) throws IOException {
        return ExternalSort.mergeSortedFiles(files, outputfile, cmp, Charset.defaultCharset(), distinct);
    }

    public static int mergeSortedFiles(List<File> files, File outputfile, Comparator<String> cmp, Charset cs, boolean distinct, boolean append, boolean usegzip) throws IOException {
        ArrayList<BinaryFileBuffer> bfbs = new ArrayList<BinaryFileBuffer>();
        for (File f : files) {
            int bufferSize = 2048;
            FileInputStream in = new FileInputStream(f);
            BufferedReader br = usegzip ? new BufferedReader(new InputStreamReader((InputStream)new GZIPInputStream((InputStream)in, 2048), cs)) : new BufferedReader(new InputStreamReader((InputStream)in, cs));
            BinaryFileBuffer bfb = new BinaryFileBuffer(br);
            bfbs.add(bfb);
        }
        BufferedWriter fbw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputfile, append), cs));
        int rowcounter = ExternalSort.merge(fbw, cmp, distinct, bfbs);
        for (File f : files) {
            f.delete();
        }
        return rowcounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int merge(BufferedWriter fbw, final Comparator<String> cmp, boolean distinct, List<BinaryFileBuffer> buffers) throws IOException {
        PriorityQueue<BinaryFileBuffer> pq = new PriorityQueue<BinaryFileBuffer>(11, new Comparator<BinaryFileBuffer>(){

            @Override
            public int compare(BinaryFileBuffer i, BinaryFileBuffer j) {
                return cmp.compare(i.peek(), j.peek());
            }
        });
        for (BinaryFileBuffer bfb : buffers) {
            if (bfb.empty()) continue;
            pq.add(bfb);
        }
        int rowcounter = 0;
        String lastLine = null;
        try {
            while (pq.size() > 0) {
                BinaryFileBuffer bfb = pq.poll();
                String r = bfb.pop();
                if (!distinct || lastLine == null || lastLine != null && cmp.compare(r, lastLine) != 0) {
                    ExternalSort.writeLine(fbw, r);
                    fbw.newLine();
                    lastLine = r;
                }
                ++rowcounter;
                if (bfb.empty()) {
                    bfb.fbr.close();
                    continue;
                }
                pq.add(bfb);
            }
        }
        finally {
            fbw.close();
            for (BinaryFileBuffer bfb : pq) {
                bfb.close();
            }
        }
        return rowcounter;
    }

    public static int mergeSortedFiles(List<File> files, File outputfile, Comparator<String> cmp, Charset cs, boolean distinct) throws IOException {
        return ExternalSort.mergeSortedFiles(files, outputfile, cmp, cs, distinct, false, false);
    }

    public static int mergeSortedFiles(List<File> files, File outputfile, Comparator<String> cmp, Charset cs) throws IOException {
        return ExternalSort.mergeSortedFiles(files, outputfile, cmp, cs, false);
    }

    public static void displayUsage() {
        System.out.println("java com.google.externalsorting.ExternalSort inputfile outputfile");
        System.out.println("Flags are:");
        System.out.println("-v or --verbose: verbose output");
        System.out.println("-d or --distinct: prune duplicate lines");
        System.out.println("-t or --maxtmpfiles (followed by an integer): specify an upper bound on the number of temporary files");
        System.out.println("-m or --maxmembytes (followed by a long): specify an upper bound on the memory");
        System.out.println("-c or --charset (followed by a charset code): specify the character set to use (for sorting)");
        System.out.println("-z or --gzip: use compression for the temporary files");
        System.out.println("-H or --header (followed by an integer): ignore the first few lines");
        System.out.println("-s or --store (following by a path): where to store the temporary files");
        System.out.println("-h or --help: display this message");
    }

    public static void main(String[] args) throws IOException {
        boolean verbose = false;
        boolean distinct = false;
        int maxtmpfiles = 1024;
        long maxMemory = 0x800000L;
        Charset cs = Charset.defaultCharset();
        String inputfile = null;
        String outputfile = null;
        File tempFileStore = null;
        boolean usegzip = false;
        int headersize = 0;
        for (int param = 0; param < args.length; ++param) {
            if (args[param].equals("-v") || args[param].equals("--verbose")) {
                verbose = true;
                continue;
            }
            if (args[param].equals("-h") || args[param].equals("--help")) {
                ExternalSort.displayUsage();
                return;
            }
            if (args[param].equals("-d") || args[param].equals("--distinct")) {
                distinct = true;
                continue;
            }
            if ((args[param].equals("-t") || args[param].equals("--maxtmpfiles")) && args.length > param + 1) {
                maxtmpfiles = Integer.parseInt(args[++param]);
                if (headersize >= 0) continue;
                System.err.println("maxtmpfiles should be positive");
                continue;
            }
            if ((args[param].equals("-m") || args[param].equals("--maxmembytes")) && args.length > param + 1) {
                maxMemory = Long.parseLong(args[++param]);
                if (headersize >= 0) continue;
                System.err.println("maxmembytes should be positive");
                continue;
            }
            if ((args[param].equals("-c") || args[param].equals("--charset")) && args.length > param + 1) {
                cs = Charset.forName(args[++param]);
                continue;
            }
            if (args[param].equals("-z") || args[param].equals("--gzip")) {
                usegzip = true;
                continue;
            }
            if ((args[param].equals("-H") || args[param].equals("--header")) && args.length > param + 1) {
                if ((headersize = Integer.parseInt(args[++param])) >= 0) continue;
                System.err.println("headersize should be positive");
                continue;
            }
            if ((args[param].equals("-s") || args[param].equals("--store")) && args.length > param + 1) {
                tempFileStore = new File(args[++param]);
                continue;
            }
            if (inputfile == null) {
                inputfile = args[param];
                continue;
            }
            if (outputfile == null) {
                outputfile = args[param];
                continue;
            }
            System.out.println("Unparsed: " + args[param]);
        }
        if (outputfile == null) {
            System.out.println("please provide input and output file names");
            ExternalSort.displayUsage();
            return;
        }
        Comparator<String> comparator = defaultcomparator;
        List<File> l = ExternalSort.sortInBatch(new File(inputfile), comparator, maxtmpfiles, maxMemory, cs, tempFileStore, distinct, headersize, usegzip);
        if (verbose) {
            System.out.println("created " + l.size() + " tmp files");
        }
        ExternalSort.mergeSortedFiles(l, new File(outputfile), comparator, cs, distinct, false, usegzip);
    }

    static String readLine(BufferedReader br) throws IOException {
        return EscapeUtils.unescapeLineBreaks(br.readLine());
    }

    static void writeLine(BufferedWriter wr, String line) throws IOException {
        wr.write(EscapeUtils.escapeLineBreak(line));
    }
}

