/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.util.Time;

class FileInputStreamCache {
    private static final Log LOG = LogFactory.getLog(FileInputStreamCache.class);
    private static final ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("FileInputStreamCache Cleaner").build());
    private CacheCleaner cacheCleaner;
    private final int maxCacheSize;
    private final long expiryTimeMs;
    private boolean closed = false;
    private final LinkedListMultimap<Key, Value> map = LinkedListMultimap.create();

    public FileInputStreamCache(int maxCacheSize, long expiryTimeMs) {
        this.maxCacheSize = maxCacheSize;
        this.expiryTimeMs = expiryTimeMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void put(DatanodeID datanodeID, ExtendedBlock block, FileInputStream[] fis) {
        block15: {
            block14: {
                block12: {
                    inserted = false;
                    var5_5 = this;
                    synchronized (var5_5) {
                        if (!this.closed) ** break block11
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 5] lbl7 : MonitorExitStatement: MONITOREXIT : var5_5
                        if (inserted) break block12;
                    }
                    IOUtils.cleanup(FileInputStreamCache.LOG, fis);
                }
                return;
                {
                    if (this.map.size() + 1 <= this.maxCacheSize) ** GOTO lbl28
                    iter = this.map.entries().iterator();
                    if (iter.hasNext()) ** break block13
                    // MONITOREXIT @DISABLED, blocks:[2, 5] lbl15 : MonitorExitStatement: MONITOREXIT : var5_5
                    if (inserted) break block14;
                }
                IOUtils.cleanup(FileInputStreamCache.LOG, fis);
            }
            return;
            {
                entry = (Map.Entry)iter.next();
                ((Value)entry.getValue()).close();
                iter.remove();
lbl28:
                // 2 sources

                if (this.cacheCleaner == null) {
                    this.cacheCleaner = new CacheCleaner(this);
                    future = FileInputStreamCache.executor.scheduleAtFixedRate(this.cacheCleaner, this.expiryTimeMs, this.expiryTimeMs, TimeUnit.MILLISECONDS);
                    this.cacheCleaner.setFuture(future);
                }
                this.map.put(new Key(datanodeID, block), new Value(fis));
                inserted = true;
                break block15;
                {
                    catch (Throwable var8_8) {
                        throw var8_8;
                    }
                }
            }
            {
                finally {
                    if (!inserted) {
                        IOUtils.cleanup(FileInputStreamCache.LOG, fis);
                    }
                }
            }
        }
    }

    public synchronized FileInputStream[] get(DatanodeID datanodeID, ExtendedBlock block) {
        Key key = new Key(datanodeID, block);
        Collection ret = this.map.get((Object)key);
        if (ret.isEmpty()) {
            return null;
        }
        Value val = (Value)ret.get(0);
        this.map.remove(key, val);
        return val.getFileInputStreams();
    }

    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        IOUtils.cleanup(LOG, this.cacheCleaner);
        Iterator iter = this.map.entries().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            ((Value)entry.getValue()).close();
            iter.remove();
        }
    }

    public synchronized String toString() {
        StringBuilder bld = new StringBuilder();
        bld.append("FileInputStreamCache(");
        String prefix = "";
        for (Map.Entry entry : this.map.entries()) {
            bld.append(prefix);
            bld.append(entry.getKey());
            prefix = ", ";
        }
        bld.append(")");
        return bld.toString();
    }

    public long getExpiryTimeMs() {
        return this.expiryTimeMs;
    }

    public int getMaxCacheSize() {
        return this.maxCacheSize;
    }

    static class Value {
        private final FileInputStream[] fis;
        private final long time;

        public Value(FileInputStream[] fis) {
            this.fis = fis;
            this.time = Time.monotonicNow();
        }

        public FileInputStream[] getFileInputStreams() {
            return this.fis;
        }

        public long getTime() {
            return this.time;
        }

        public void close() {
            IOUtils.cleanup(LOG, this.fis);
        }
    }

    static class Key {
        private final DatanodeID datanodeID;
        private final ExtendedBlock block;

        public Key(DatanodeID datanodeID, ExtendedBlock block) {
            this.datanodeID = datanodeID;
            this.block = block;
        }

        public boolean equals(Object other) {
            if (!(other instanceof Key)) {
                return false;
            }
            Key otherKey = (Key)other;
            return this.block.equals(otherKey.block) && this.block.getGenerationStamp() == otherKey.block.getGenerationStamp() && this.datanodeID.equals(otherKey.datanodeID);
        }

        public int hashCode() {
            return this.block.hashCode();
        }
    }

    private static class CacheCleaner
    implements Runnable,
    Closeable {
        private WeakReference<FileInputStreamCache> cacheRef;
        private ScheduledFuture<?> future;

        CacheCleaner(FileInputStreamCache cache) {
            this.cacheRef = new WeakReference<FileInputStreamCache>(cache);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            FileInputStreamCache cache = (FileInputStreamCache)this.cacheRef.get();
            if (cache == null) {
                return;
            }
            FileInputStreamCache fileInputStreamCache = cache;
            synchronized (fileInputStreamCache) {
                Map.Entry entry;
                if (cache.closed) {
                    return;
                }
                long curTime = Time.monotonicNow();
                Iterator iter = cache.map.entries().iterator();
                while (iter.hasNext() && ((Value)(entry = (Map.Entry)iter.next()).getValue()).getTime() + cache.expiryTimeMs < curTime) {
                    ((Value)entry.getValue()).close();
                    iter.remove();
                    iter = cache.map.entries().iterator();
                }
            }
        }

        @Override
        public void close() throws IOException {
            if (this.future != null) {
                this.future.cancel(false);
            }
        }

        public void setFuture(ScheduledFuture<?> future) {
            this.future = future;
        }
    }
}

