/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.LinkedListMultimap;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hdfs.net.Peer;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.util.Daemon;
import org.apache.hadoop.util.Time;

class PeerCache {
    private static final Log LOG = LogFactory.getLog(PeerCache.class);
    private Daemon daemon;
    private final LinkedListMultimap<Key, Value> multimap = LinkedListMultimap.create();
    private final int capacity;
    private final long expiryPeriod;
    private static PeerCache instance = null;

    @VisibleForTesting
    PeerCache(int c, long e) {
        this.capacity = c;
        this.expiryPeriod = e;
        if (this.capacity == 0) {
            LOG.info((Object)"SocketCache disabled.");
        } else if (this.expiryPeriod == 0L) {
            throw new IllegalStateException("Cannot initialize expiryPeriod to " + this.expiryPeriod + "when cache is enabled.");
        }
    }

    public static synchronized PeerCache getInstance(int c, long e) {
        if (instance == null) {
            instance = new PeerCache(c, e);
        } else if (PeerCache.instance.capacity != c || PeerCache.instance.expiryPeriod != e) {
            LOG.info((Object)("capacity and expiry periods already set to " + PeerCache.instance.capacity + " and " + PeerCache.instance.expiryPeriod + " respectively. Cannot set it to " + c + " and " + e));
        }
        return instance;
    }

    private boolean isDaemonStarted() {
        return this.daemon != null;
    }

    private synchronized void startExpiryDaemon() {
        if (this.isDaemonStarted()) {
            return;
        }
        this.daemon = new Daemon(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    PeerCache.this.run();
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    PeerCache.this.clear();
                }
            }

            public String toString() {
                return String.valueOf(PeerCache.this);
            }
        });
        this.daemon.start();
    }

    public synchronized Peer get(DatanodeID dnId, boolean isDomain) {
        if (this.capacity <= 0) {
            return null;
        }
        Collection sockStreamList = this.multimap.get((Object)new Key(dnId, isDomain));
        if (sockStreamList == null) {
            return null;
        }
        Iterator iter = sockStreamList.iterator();
        while (iter.hasNext()) {
            Value candidate = (Value)iter.next();
            iter.remove();
            if (candidate.getPeer().isClosed()) continue;
            return candidate.getPeer();
        }
        return null;
    }

    public synchronized void put(DatanodeID dnId, Peer peer) {
        Preconditions.checkNotNull(dnId);
        Preconditions.checkNotNull(peer);
        if (peer.isClosed()) {
            return;
        }
        if (this.capacity <= 0) {
            IOUtils.cleanup(LOG, peer);
            return;
        }
        this.startExpiryDaemon();
        if (this.capacity == this.multimap.size()) {
            this.evictOldest();
        }
        this.multimap.put(new Key(dnId, peer.getDomainSocket() != null), new Value(peer, Time.monotonicNow()));
    }

    public synchronized int size() {
        return this.multimap.size();
    }

    private synchronized void evictExpired(long expiryPeriod) {
        Iterator iter;
        Map.Entry entry;
        while (this.multimap.size() != 0 && (entry = (Map.Entry)(iter = this.multimap.entries().iterator()).next()) != null && Time.monotonicNow() - ((Value)entry.getValue()).getTime() >= expiryPeriod) {
            IOUtils.cleanup(LOG, ((Value)entry.getValue()).getPeer());
            iter.remove();
        }
    }

    private synchronized void evictOldest() {
        Iterator iter = this.multimap.entries().iterator();
        if (!iter.hasNext()) {
            throw new IllegalStateException("Cannot evict from empty cache! capacity: " + this.capacity);
        }
        Map.Entry entry = (Map.Entry)iter.next();
        IOUtils.cleanup(LOG, ((Value)entry.getValue()).getPeer());
        iter.remove();
    }

    private void run() throws InterruptedException {
        long lastExpiryTime = Time.monotonicNow();
        while (!Thread.interrupted()) {
            long elapsed = Time.monotonicNow() - lastExpiryTime;
            if (elapsed >= this.expiryPeriod) {
                this.evictExpired(this.expiryPeriod);
                lastExpiryTime = Time.monotonicNow();
            }
            Thread.sleep(this.expiryPeriod);
        }
        this.clear();
        throw new InterruptedException("Daemon Interrupted");
    }

    @VisibleForTesting
    synchronized void clear() {
        for (Value value : this.multimap.values()) {
            IOUtils.cleanup(LOG, value.getPeer());
        }
        this.multimap.clear();
    }

    @VisibleForTesting
    void close() {
        this.clear();
        if (this.daemon != null) {
            this.daemon.interrupt();
            try {
                this.daemon.join();
            }
            catch (InterruptedException e) {
                throw new RuntimeException("failed to join thread");
            }
        }
        this.daemon = null;
    }

    private static class Value {
        private final Peer peer;
        private final long time;

        Value(Peer peer, long time) {
            this.peer = peer;
            this.time = time;
        }

        Peer getPeer() {
            return this.peer;
        }

        long getTime() {
            return this.time;
        }
    }

    private static class Key {
        final DatanodeID dnID;
        final boolean isDomain;

        Key(DatanodeID dnID, boolean isDomain) {
            this.dnID = dnID;
            this.isDomain = isDomain;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Key)) {
                return false;
            }
            Key other = (Key)o;
            return this.dnID.equals(other.dnID) && this.isDomain == other.isDomain;
        }

        public int hashCode() {
            return this.dnID.hashCode() ^ (this.isDomain ? 1 : 0);
        }
    }
}

