/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URL;
import java.net.URLEncoder;
import java.security.PrivilegedExceptionAction;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspWriter;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenSecretManager;
import org.apache.hadoop.hdfs.server.common.JspHelper;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.http.HtmlQuoting;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.ServletUtil;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
public class DatanodeJspHelper {
    private static DFSClient getDFSClient(UserGroupInformation user, final String addr, final Configuration conf) throws IOException, InterruptedException {
        return user.doAs(new PrivilegedExceptionAction<DFSClient>(){

            @Override
            public DFSClient run() throws IOException {
                return new DFSClient(NetUtils.createSocketAddr(addr), conf);
            }
        });
    }

    private static String canonicalize(String addr) {
        return NetUtils.createSocketAddr(addr, 1).getAddress().getCanonicalHostName();
    }

    private static int getDefaultChunkSize(Configuration conf) {
        return conf.getInt("dfs.default.chunk.view.size", 32768);
    }

    static void generateDirectoryStructure(JspWriter out, HttpServletRequest req, HttpServletResponse resp, Configuration conf) throws IOException, InterruptedException {
        String target;
        String nnAddr;
        String dir = JspHelper.validatePath(StringEscapeUtils.unescapeHtml(req.getParameter("dir")));
        if (dir == null) {
            out.print("Invalid input");
            return;
        }
        String tokenString = req.getParameter("delegation");
        UserGroupInformation ugi = JspHelper.getUGI(req, conf);
        String namenodeInfoPortStr = req.getParameter("namenodeInfoPort");
        int namenodeInfoPort = -1;
        if (namenodeInfoPortStr != null) {
            namenodeInfoPort = Integer.parseInt(namenodeInfoPortStr);
        }
        if ((nnAddr = req.getParameter("nnaddr")) == null) {
            out.print("nnaddr url param is null");
            return;
        }
        DFSClient dfs = DatanodeJspHelper.getDFSClient(ugi, nnAddr, conf);
        HdfsFileStatus targetStatus = dfs.getFileInfo(target = dir);
        if (targetStatus == null) {
            out.print("<h3>File or directory : " + StringEscapeUtils.escapeHtml(target) + " does not exist</h3>");
            JspHelper.printGotoForm(out, namenodeInfoPort, tokenString, target, nnAddr);
        } else {
            DirectoryListing thisListing;
            if (!targetStatus.isDir()) {
                List<LocatedBlock> blocks = dfs.getNamenode().getBlockLocations(dir, 0L, 1L).getLocatedBlocks();
                LocatedBlock firstBlock = null;
                DatanodeInfo[] locations = null;
                if (blocks.size() > 0) {
                    firstBlock = blocks.get(0);
                    locations = firstBlock.getLocations();
                }
                if (locations == null || locations.length == 0) {
                    out.print("Empty file");
                } else {
                    DatanodeInfo chosenNode = JspHelper.bestNode(firstBlock, conf);
                    String fqdn = DatanodeJspHelper.canonicalize(chosenNode.getIpAddr());
                    int datanodePort = chosenNode.getXferPort();
                    String redirectLocation = HttpConfig.getSchemePrefix() + fqdn + ":" + chosenNode.getInfoPort() + "/browseBlock.jsp?blockId=" + firstBlock.getBlock().getBlockId() + "&blockSize=" + firstBlock.getBlock().getNumBytes() + "&genstamp=" + firstBlock.getBlock().getGenerationStamp() + "&filename=" + URLEncoder.encode(dir, "UTF-8") + "&datanodePort=" + datanodePort + "&namenodeInfoPort=" + namenodeInfoPort + JspHelper.getDelegationTokenUrlParam(tokenString) + JspHelper.getUrlParam("nnaddr", nnAddr);
                    resp.sendRedirect(redirectLocation);
                }
                return;
            }
            String[] headings = new String[]{"Name", "Type", "Size", "Replication", "Block Size", "Modification Time", "Permission", "Owner", "Group"};
            out.print("<h3>Contents of directory ");
            JspHelper.printPathWithLinks(dir, out, namenodeInfoPort, tokenString, nnAddr);
            out.print("</h3><hr>");
            JspHelper.printGotoForm(out, namenodeInfoPort, tokenString, dir, nnAddr);
            out.print("<hr>");
            File f = new File(dir);
            String parent = f.getParent();
            if (parent != null) {
                out.print("<a href=\"" + req.getRequestURL() + "?dir=" + parent + "&namenodeInfoPort=" + namenodeInfoPort + JspHelper.getDelegationTokenUrlParam(tokenString) + JspHelper.getUrlParam("nnaddr", nnAddr) + "\">Go to parent directory</a><br>");
            }
            if ((thisListing = dfs.listPaths(target, HdfsFileStatus.EMPTY_NAME)) == null || thisListing.getPartialListing().length == 0) {
                out.print("Empty directory");
            } else {
                JspHelper.addTableHeader(out);
                int row = 0;
                JspHelper.addTableRow(out, headings, row++);
                String[] cols = new String[headings.length];
                do {
                    HdfsFileStatus[] files = thisListing.getPartialListing();
                    for (int i = 0; i < files.length; ++i) {
                        String localFileName = files[i].getLocalName();
                        if (!files[i].isDir()) {
                            cols[1] = "file";
                            cols[2] = StringUtils.byteDesc(files[i].getLen());
                            cols[3] = Short.toString(files[i].getReplication());
                            cols[4] = StringUtils.byteDesc(files[i].getBlockSize());
                        } else {
                            cols[1] = "dir";
                            cols[2] = "";
                            cols[3] = "";
                            cols[4] = "";
                        }
                        String datanodeUrl = req.getRequestURL() + "?dir=" + URLEncoder.encode(files[i].getFullName(target), "UTF-8") + "&namenodeInfoPort=" + namenodeInfoPort + JspHelper.getDelegationTokenUrlParam(tokenString) + JspHelper.getUrlParam("nnaddr", nnAddr);
                        cols[0] = "<a href=\"" + datanodeUrl + "\">" + HtmlQuoting.quoteHtmlChars(localFileName) + "</a>";
                        cols[5] = new SimpleDateFormat("yyyy-MM-dd HH:mm").format(new Date(files[i].getModificationTime()));
                        cols[6] = files[i].getPermission().toString();
                        cols[7] = files[i].getOwner();
                        cols[8] = files[i].getGroup();
                        JspHelper.addTableRow(out, cols, row++);
                    }
                } while (thisListing.hasMore() && (thisListing = dfs.listPaths(target, thisListing.getLastName())) != null);
                JspHelper.addTableFooter(out);
            }
        }
        out.print("<br><a href=\"///" + DatanodeJspHelper.canonicalize(nnAddr) + ":" + namenodeInfoPort + "/dfshealth.jsp\">Go back to DFS home</a>");
        dfs.close();
    }

    static void generateFileDetails(JspWriter out, HttpServletRequest req, Configuration conf) throws IOException, InterruptedException {
        DatanodeInfo chosenNode;
        String filename;
        String nnAddr;
        long startOffset = 0L;
        Long blockId = JspHelper.validateLong(req.getParameter("blockId"));
        if (blockId == null) {
            out.print("Invalid input (blockId absent)");
            return;
        }
        String tokenString = req.getParameter("delegation");
        UserGroupInformation ugi = JspHelper.getUGI(req, conf);
        String datanodePortStr = req.getParameter("datanodePort");
        if (datanodePortStr == null) {
            out.print("Invalid input (datanodePort absent)");
            return;
        }
        int datanodePort = Integer.parseInt(datanodePortStr);
        Long genStamp = JspHelper.validateLong(req.getParameter("genstamp"));
        if (genStamp == null) {
            out.print("Invalid input (genstamp absent)");
            return;
        }
        String namenodeInfoPortStr = req.getParameter("namenodeInfoPort");
        int namenodeInfoPort = -1;
        if (namenodeInfoPortStr != null) {
            namenodeInfoPort = Integer.parseInt(namenodeInfoPortStr);
        }
        if ((nnAddr = StringEscapeUtils.escapeHtml(req.getParameter("nnaddr"))) == null) {
            out.print("nnaddr url param is null");
            return;
        }
        int chunkSizeToView = JspHelper.string2ChunkSizeToView(req.getParameter("chunkSizeToView"), DatanodeJspHelper.getDefaultChunkSize(conf));
        String startOffsetStr = req.getParameter("startOffset");
        startOffset = startOffsetStr == null || Long.parseLong(startOffsetStr) < 0L ? 0L : Long.parseLong(startOffsetStr);
        String path = StringEscapeUtils.unescapeHtml(req.getParameter("filename"));
        if (path == null) {
            String string = path = req.getPathInfo() == null ? "/" : req.getPathInfo();
        }
        if ((filename = JspHelper.validatePath(path)) == null) {
            out.print("Invalid input");
            return;
        }
        String blockSizeStr = req.getParameter("blockSize");
        if (blockSizeStr == null || blockSizeStr.length() == 0) {
            out.print("Invalid input");
            return;
        }
        long blockSize = Long.parseLong(blockSizeStr);
        DFSClient dfs = DatanodeJspHelper.getDFSClient(ugi, nnAddr, conf);
        List<LocatedBlock> blocks = dfs.getNamenode().getBlockLocations(filename, 0L, Long.MAX_VALUE).getLocatedBlocks();
        String downloadUrl = "/streamFile" + ServletUtil.encodePath(filename) + JspHelper.getUrlParam("nnaddr", nnAddr, true) + JspHelper.getDelegationTokenUrlParam(tokenString);
        out.print("<a name=\"viewOptions\"></a>");
        out.print("<a href=\"" + downloadUrl + "\">Download this file</a><br>");
        LocatedBlock lastBlk = blocks.get(blocks.size() - 1);
        try {
            chosenNode = JspHelper.bestNode(lastBlk, conf);
        }
        catch (IOException e) {
            out.print(e.toString());
            dfs.close();
            return;
        }
        String fqdn = DatanodeJspHelper.canonicalize(chosenNode.getIpAddr());
        String tailUrl = "///" + fqdn + ":" + chosenNode.getInfoPort() + "/tail.jsp?filename=" + URLEncoder.encode(filename, "UTF-8") + "&namenodeInfoPort=" + namenodeInfoPort + "&chunkSizeToView=" + chunkSizeToView + JspHelper.getDelegationTokenUrlParam(tokenString) + JspHelper.getUrlParam("nnaddr", nnAddr) + "&referrer=" + URLEncoder.encode(req.getRequestURL() + "?" + req.getQueryString(), "UTF-8");
        out.print("<a href=\"" + tailUrl + "\">Tail this file</a><br>");
        out.print("<form action=\"/browseBlock.jsp\" method=GET>");
        out.print("<b>Chunk size to view (in bytes, up to file's DFS block size): </b>");
        out.print("<input type=\"hidden\" name=\"blockId\" value=\"" + blockId + "\">");
        out.print("<input type=\"hidden\" name=\"blockSize\" value=\"" + blockSize + "\">");
        out.print("<input type=\"hidden\" name=\"startOffset\" value=\"" + startOffset + "\">");
        out.print("<input type=\"hidden\" name=\"filename\" value=\"" + filename + "\">");
        out.print("<input type=\"hidden\" name=\"genstamp\" value=\"" + genStamp + "\">");
        out.print("<input type=\"hidden\" name=\"datanodePort\" value=\"" + datanodePort + "\">");
        out.print("<input type=\"hidden\" name=\"namenodeInfoPort\" value=\"" + namenodeInfoPort + "\">");
        out.print("<input type=\"hidden\" name=\"nnaddr\" value=\"" + nnAddr + "\">");
        out.print("<input type=\"text\" name=\"chunkSizeToView\" value=" + chunkSizeToView + " size=10 maxlength=10>");
        out.print("&nbsp;&nbsp;<input type=\"submit\" name=\"submit\" value=\"Refresh\">");
        out.print("</form>");
        out.print("<hr>");
        out.print("<a name=\"blockDetails\"></a>");
        out.print("<B>Total number of blocks: " + blocks.size() + "</B><br>");
        out.println("\n<table>");
        String nnCanonicalName = DatanodeJspHelper.canonicalize(nnAddr);
        for (LocatedBlock cur : blocks) {
            out.print("<tr>");
            String blockidstring = Long.toString(cur.getBlock().getBlockId());
            blockSize = cur.getBlock().getNumBytes();
            out.print("<td>" + blockidstring + ":</td>");
            DatanodeInfo[] locs = cur.getLocations();
            for (int j = 0; j < locs.length; ++j) {
                String datanodeAddr = locs[j].getXferAddr();
                datanodePort = locs[j].getXferPort();
                fqdn = DatanodeJspHelper.canonicalize(locs[j].getIpAddr());
                String blockUrl = "///" + fqdn + ":" + locs[j].getInfoPort() + "/browseBlock.jsp?blockId=" + blockidstring + "&blockSize=" + blockSize + "&filename=" + URLEncoder.encode(filename, "UTF-8") + "&datanodePort=" + datanodePort + "&genstamp=" + cur.getBlock().getGenerationStamp() + "&namenodeInfoPort=" + namenodeInfoPort + "&chunkSizeToView=" + chunkSizeToView + JspHelper.getDelegationTokenUrlParam(tokenString) + JspHelper.getUrlParam("nnaddr", nnAddr);
                String blockInfoUrl = "///" + nnCanonicalName + ":" + namenodeInfoPort + "/block_info_xml.jsp?blockId=" + blockidstring;
                out.print("<td>&nbsp</td><td><a href=\"" + blockUrl + "\">" + datanodeAddr + "</a></td><td>" + "<a href=\"" + blockInfoUrl + "\">View Block Info</a></td>");
            }
            out.println("</tr>");
        }
        out.println("</table>");
        out.print("<hr>");
        out.print("<br><a href=\"///" + nnCanonicalName + ":" + namenodeInfoPort + "/dfshealth.jsp\">Go back to DFS home</a>");
        dfs.close();
    }

    static void generateFileChunks(JspWriter out, HttpServletRequest req, Configuration conf) throws IOException, InterruptedException {
        Long genStamp;
        String filename;
        long startOffset = 0L;
        int datanodePort = 0;
        String namenodeInfoPortStr = req.getParameter("namenodeInfoPort");
        String nnAddr = req.getParameter("nnaddr");
        if (nnAddr == null) {
            out.print("nnaddr url param is null");
            return;
        }
        String tokenString = req.getParameter("delegation");
        UserGroupInformation ugi = JspHelper.getUGI(req, conf);
        int namenodeInfoPort = -1;
        if (namenodeInfoPortStr != null) {
            namenodeInfoPort = Integer.parseInt(namenodeInfoPortStr);
        }
        if ((filename = JspHelper.validatePath(StringEscapeUtils.unescapeHtml(req.getParameter("filename")))) == null) {
            out.print("Invalid input (filename absent)");
            return;
        }
        Long blockId = JspHelper.validateLong(req.getParameter("blockId"));
        if (blockId == null) {
            out.print("Invalid input (blockId absent)");
            return;
        }
        DFSClient dfs = DatanodeJspHelper.getDFSClient(ugi, nnAddr, conf);
        String bpid = null;
        Token<BlockTokenIdentifier> blockToken = BlockTokenSecretManager.DUMMY_TOKEN;
        List<LocatedBlock> blks = dfs.getNamenode().getBlockLocations(filename, 0L, Long.MAX_VALUE).getLocatedBlocks();
        if (blks == null || blks.size() == 0) {
            out.print("Can't locate file blocks");
            dfs.close();
            return;
        }
        boolean needBlockToken = conf.getBoolean("dfs.block.access.token.enable", false);
        for (int i = 0; i < blks.size(); ++i) {
            if (blks.get(i).getBlock().getBlockId() != blockId.longValue()) continue;
            bpid = blks.get(i).getBlock().getBlockPoolId();
            if (!needBlockToken) break;
            blockToken = blks.get(i).getBlockToken();
            break;
        }
        if ((genStamp = JspHelper.validateLong(req.getParameter("genstamp"))) == null) {
            out.print("Invalid input (genstamp absent)");
            return;
        }
        long blockSize = 0L;
        String blockSizeStr = req.getParameter("blockSize");
        if (blockSizeStr == null) {
            out.print("Invalid input (blockSize absent)");
            return;
        }
        blockSize = Long.parseLong(blockSizeStr);
        int chunkSizeToView = JspHelper.string2ChunkSizeToView(req.getParameter("chunkSizeToView"), DatanodeJspHelper.getDefaultChunkSize(conf));
        String startOffsetStr = req.getParameter("startOffset");
        startOffset = startOffsetStr == null || Long.parseLong(startOffsetStr) < 0L ? 0L : Long.parseLong(startOffsetStr);
        String datanodePortStr = req.getParameter("datanodePort");
        if (datanodePortStr == null) {
            out.print("Invalid input (datanodePort absent)");
            return;
        }
        datanodePort = Integer.parseInt(datanodePortStr);
        out.print("<h3>File: ");
        JspHelper.printPathWithLinks(filename, out, namenodeInfoPort, tokenString, nnAddr);
        out.print("</h3><hr>");
        String parent = new File(filename).getParent();
        JspHelper.printGotoForm(out, namenodeInfoPort, tokenString, parent, nnAddr);
        out.print("<hr>");
        out.print("<a href=\"/browseDirectory.jsp?dir=" + URLEncoder.encode(parent, "UTF-8") + "&namenodeInfoPort=" + namenodeInfoPort + JspHelper.getDelegationTokenUrlParam(tokenString) + JspHelper.getUrlParam("nnaddr", nnAddr) + "\"><i>Go back to dir listing</i></a><br>");
        out.print("<a href=\"#viewOptions\">Advanced view/download options</a><br>");
        out.print("<hr>");
        long nextStartOffset = 0L;
        long nextBlockSize = 0L;
        String nextBlockIdStr = null;
        String nextGenStamp = null;
        String nextHost = req.getServerName();
        int nextPort = req.getServerPort();
        int nextDatanodePort = datanodePort;
        if (startOffset + (long)chunkSizeToView >= blockSize) {
            List<LocatedBlock> blocks = dfs.getNamenode().getBlockLocations(filename, 0L, Long.MAX_VALUE).getLocatedBlocks();
            for (int i = 0; i < blocks.size(); ++i) {
                if (blocks.get(i).getBlock().getBlockId() != blockId.longValue() || i == blocks.size() - 1) continue;
                LocatedBlock nextBlock = blocks.get(i + 1);
                nextBlockIdStr = Long.toString(nextBlock.getBlock().getBlockId());
                nextGenStamp = Long.toString(nextBlock.getBlock().getGenerationStamp());
                nextStartOffset = 0L;
                nextBlockSize = nextBlock.getBlock().getNumBytes();
                DatanodeInfo d = JspHelper.bestNode(nextBlock, conf);
                nextDatanodePort = d.getXferPort();
                nextHost = d.getIpAddr();
                nextPort = d.getInfoPort();
            }
        } else {
            nextBlockIdStr = blockId.toString();
            nextStartOffset = startOffset + (long)chunkSizeToView;
            nextBlockSize = blockSize;
            nextGenStamp = genStamp.toString();
        }
        String nextUrl = null;
        if (nextBlockIdStr != null) {
            nextUrl = "///" + DatanodeJspHelper.canonicalize(nextHost) + ":" + nextPort + "/browseBlock.jsp?blockId=" + nextBlockIdStr + "&blockSize=" + nextBlockSize + "&startOffset=" + nextStartOffset + "&genstamp=" + nextGenStamp + "&filename=" + URLEncoder.encode(filename, "UTF-8") + "&chunkSizeToView=" + chunkSizeToView + "&datanodePort=" + nextDatanodePort + "&namenodeInfoPort=" + namenodeInfoPort + JspHelper.getDelegationTokenUrlParam(tokenString) + JspHelper.getUrlParam("nnaddr", nnAddr);
            out.print("<a href=\"" + nextUrl + "\">View Next chunk</a>&nbsp;&nbsp;");
        }
        String prevBlockIdStr = null;
        String prevGenStamp = null;
        long prevStartOffset = 0L;
        long prevBlockSize = 0L;
        String prevHost = req.getServerName();
        int prevPort = req.getServerPort();
        int prevDatanodePort = datanodePort;
        if (startOffset == 0L) {
            List<LocatedBlock> blocks = dfs.getNamenode().getBlockLocations(filename, 0L, Long.MAX_VALUE).getLocatedBlocks();
            for (int i = 0; i < blocks.size(); ++i) {
                if (blocks.get(i).getBlock().getBlockId() != blockId.longValue() || i == 0) continue;
                LocatedBlock prevBlock = blocks.get(i - 1);
                prevBlockIdStr = Long.toString(prevBlock.getBlock().getBlockId());
                prevGenStamp = Long.toString(prevBlock.getBlock().getGenerationStamp());
                prevStartOffset = prevBlock.getBlock().getNumBytes() - (long)chunkSizeToView;
                if (prevStartOffset < 0L) {
                    prevStartOffset = 0L;
                }
                prevBlockSize = prevBlock.getBlock().getNumBytes();
                DatanodeInfo d = JspHelper.bestNode(prevBlock, conf);
                prevDatanodePort = d.getXferPort();
                prevHost = d.getIpAddr();
                prevPort = d.getInfoPort();
            }
        } else {
            prevBlockIdStr = blockId.toString();
            prevStartOffset = startOffset - (long)chunkSizeToView;
            if (prevStartOffset < 0L) {
                prevStartOffset = 0L;
            }
            prevBlockSize = blockSize;
            prevGenStamp = genStamp.toString();
        }
        String prevUrl = null;
        if (prevBlockIdStr != null) {
            prevUrl = "///" + DatanodeJspHelper.canonicalize(prevHost) + ":" + prevPort + "/browseBlock.jsp?blockId=" + prevBlockIdStr + "&blockSize=" + prevBlockSize + "&startOffset=" + prevStartOffset + "&filename=" + URLEncoder.encode(filename, "UTF-8") + "&chunkSizeToView=" + chunkSizeToView + "&genstamp=" + prevGenStamp + "&datanodePort=" + prevDatanodePort + "&namenodeInfoPort=" + namenodeInfoPort + JspHelper.getDelegationTokenUrlParam(tokenString) + JspHelper.getUrlParam("nnaddr", nnAddr);
            out.print("<a href=\"" + prevUrl + "\">View Prev chunk</a>&nbsp;&nbsp;");
        }
        out.print("<hr>");
        out.print("<textarea cols=\"100\" rows=\"25\" wrap=\"virtual\" style=\"width:100%\" READONLY>");
        try {
            JspHelper.streamBlockInAscii(new InetSocketAddress(req.getServerName(), datanodePort), bpid, blockId, blockToken, genStamp, blockSize, startOffset, chunkSizeToView, out, conf, dfs.getConf(), dfs.getDataEncryptionKey());
        }
        catch (Exception e) {
            out.print((Object)e);
        }
        out.print("</textarea>");
        dfs.close();
    }

    static void generateFileChunksForTail(JspWriter out, HttpServletRequest req, Configuration conf) throws IOException, InterruptedException {
        DatanodeInfo chosenNode;
        DFSClient dfs;
        List<LocatedBlock> blocks;
        String referrer = null;
        boolean noLink = false;
        try {
            referrer = new URL(req.getParameter("referrer")).toString();
        }
        catch (IOException e) {
            referrer = null;
            noLink = true;
        }
        String filename = JspHelper.validatePath(StringEscapeUtils.unescapeHtml(req.getParameter("filename")));
        if (filename == null) {
            out.print("Invalid input (file name absent)");
            return;
        }
        String tokenString = req.getParameter("delegation");
        UserGroupInformation ugi = JspHelper.getUGI(req, conf);
        String namenodeInfoPortStr = req.getParameter("namenodeInfoPort");
        String nnAddr = StringEscapeUtils.escapeHtml(req.getParameter("nnaddr"));
        int namenodeInfoPort = -1;
        if (namenodeInfoPortStr != null) {
            namenodeInfoPort = Integer.parseInt(namenodeInfoPortStr);
        }
        int chunkSizeToView = JspHelper.string2ChunkSizeToView(req.getParameter("chunkSizeToView"), DatanodeJspHelper.getDefaultChunkSize(conf));
        if (!noLink) {
            out.print("<h3>Tail of File: ");
            JspHelper.printPathWithLinks(filename, out, namenodeInfoPort, tokenString, nnAddr);
            out.print("</h3><hr>");
            out.print("<a href=\"" + referrer + "\">Go Back to File View</a><hr>");
        } else {
            out.print("<h3>" + filename + "</h3>");
        }
        out.print("<b>Chunk size to view (in bytes, up to file's DFS block size): </b>");
        out.print("<input type=\"text\" name=\"chunkSizeToView\" value=" + chunkSizeToView + " size=10 maxlength=10>");
        out.print("&nbsp;&nbsp;<input type=\"submit\" name=\"submit\" value=\"Refresh\"><hr>");
        out.print("<input type=\"hidden\" name=\"filename\" value=\"" + filename + "\">");
        out.print("<input type=\"hidden\" name=\"namenodeInfoPort\" value=\"" + namenodeInfoPort + "\">");
        out.print("<input type=\"hidden\" name=\"nnaddr\" value=\"" + nnAddr + "\">");
        if (!noLink) {
            out.print("<input type=\"hidden\" name=\"referrer\" value=\"" + referrer + "\">");
        }
        if ((blocks = (dfs = DatanodeJspHelper.getDFSClient(ugi, nnAddr, conf)).getNamenode().getBlockLocations(filename, 0L, Long.MAX_VALUE).getLocatedBlocks()) == null || blocks.size() == 0) {
            out.print("No datanodes contain blocks of file " + filename);
            dfs.close();
            return;
        }
        LocatedBlock lastBlk = blocks.get(blocks.size() - 1);
        String poolId = lastBlk.getBlock().getBlockPoolId();
        long blockSize = lastBlk.getBlock().getNumBytes();
        long blockId = lastBlk.getBlock().getBlockId();
        Token<BlockTokenIdentifier> accessToken = lastBlk.getBlockToken();
        long genStamp = lastBlk.getBlock().getGenerationStamp();
        try {
            chosenNode = JspHelper.bestNode(lastBlk, conf);
        }
        catch (IOException e) {
            out.print(e.toString());
            dfs.close();
            return;
        }
        InetSocketAddress addr = NetUtils.createSocketAddr(chosenNode.getXferAddr());
        long startOffset = blockSize >= (long)chunkSizeToView ? blockSize - (long)chunkSizeToView : 0L;
        out.print("<textarea cols=\"100\" rows=\"25\" wrap=\"virtual\" style=\"width:100%\" READONLY>");
        JspHelper.streamBlockInAscii(addr, poolId, blockId, accessToken, genStamp, blockSize, startOffset, chunkSizeToView, out, conf, dfs.getConf(), dfs.getDataEncryptionKey());
        out.print("</textarea>");
        dfs.close();
    }

    public static DFSClient getDFSClient(HttpServletRequest request, DataNode datanode, Configuration conf, UserGroupInformation ugi) throws IOException, InterruptedException {
        String nnAddr = request.getParameter("nnaddr");
        return DatanodeJspHelper.getDFSClient(ugi, nnAddr, conf);
    }
}

