/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.base.Preconditions;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.hadoop.hdfs.server.namenode.Content;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeAttributes;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodeMap;
import org.apache.hadoop.hdfs.server.namenode.INodeSymlink;
import org.apache.hadoop.hdfs.server.namenode.Quota;
import org.apache.hadoop.hdfs.server.namenode.snapshot.FileWithSnapshot;
import org.apache.hadoop.hdfs.server.namenode.snapshot.INodeDirectoryWithSnapshot;
import org.apache.hadoop.hdfs.server.namenode.snapshot.Snapshot;

public abstract class INodeReference
extends INode {
    private INode referred;

    public static int tryRemoveReference(INode inode) {
        if (!inode.isReference()) {
            return -1;
        }
        return INodeReference.removeReference(inode.asReference());
    }

    private static int removeReference(INodeReference ref) {
        INode referred = ref.getReferredINode();
        if (!(referred instanceof WithCount)) {
            return -1;
        }
        WithCount wc = (WithCount)referred;
        wc.removeReference(ref);
        return wc.getReferenceCount();
    }

    static Snapshot getPriorSnapshot(INodeReference ref) {
        WithCount wc = (WithCount)ref.getReferredINode();
        WithName wn = null;
        if (ref instanceof DstReference) {
            wn = wc.getLastWithName();
        } else if (ref instanceof WithName) {
            wn = wc.getPriorWithName((WithName)ref);
        }
        if (wn != null) {
            INode referred = wc.getReferredINode();
            if (referred instanceof FileWithSnapshot) {
                return ((FileWithSnapshot)((Object)referred)).getDiffs().getPrior(wn.lastSnapshotId);
            }
            if (referred instanceof INodeDirectoryWithSnapshot) {
                return ((INodeDirectoryWithSnapshot)referred).getDiffs().getPrior(wn.lastSnapshotId);
            }
        }
        return null;
    }

    public INodeReference(INode parent, INode referred) {
        super(parent);
        this.referred = referred;
    }

    public final INode getReferredINode() {
        return this.referred;
    }

    public final void setReferredINode(INode referred) {
        this.referred = referred;
    }

    @Override
    public final boolean isReference() {
        return true;
    }

    @Override
    public final INodeReference asReference() {
        return this;
    }

    @Override
    public final boolean isFile() {
        return this.referred.isFile();
    }

    @Override
    public final INodeFile asFile() {
        return this.referred.asFile();
    }

    @Override
    public final boolean isDirectory() {
        return this.referred.isDirectory();
    }

    @Override
    public final INodeDirectory asDirectory() {
        return this.referred.asDirectory();
    }

    @Override
    public final boolean isSymlink() {
        return this.referred.isSymlink();
    }

    @Override
    public final INodeSymlink asSymlink() {
        return this.referred.asSymlink();
    }

    @Override
    public byte[] getLocalNameBytes() {
        return this.referred.getLocalNameBytes();
    }

    @Override
    public void setLocalName(byte[] name) {
        this.referred.setLocalName(name);
    }

    @Override
    public final long getId() {
        return this.referred.getId();
    }

    @Override
    public final PermissionStatus getPermissionStatus(Snapshot snapshot) {
        return this.referred.getPermissionStatus(snapshot);
    }

    @Override
    public final String getUserName(Snapshot snapshot) {
        return this.referred.getUserName(snapshot);
    }

    @Override
    final void setUser(String user) {
        this.referred.setUser(user);
    }

    @Override
    public final String getGroupName(Snapshot snapshot) {
        return this.referred.getGroupName(snapshot);
    }

    @Override
    final void setGroup(String group) {
        this.referred.setGroup(group);
    }

    @Override
    public final FsPermission getFsPermission(Snapshot snapshot) {
        return this.referred.getFsPermission(snapshot);
    }

    @Override
    public final short getFsPermissionShort() {
        return this.referred.getFsPermissionShort();
    }

    @Override
    void setPermission(FsPermission permission) {
        this.referred.setPermission(permission);
    }

    @Override
    public long getPermissionLong() {
        return this.referred.getPermissionLong();
    }

    @Override
    public final long getModificationTime(Snapshot snapshot) {
        return this.referred.getModificationTime(snapshot);
    }

    @Override
    public final INode updateModificationTime(long mtime, Snapshot latest, INodeMap inodeMap) throws QuotaExceededException {
        return this.referred.updateModificationTime(mtime, latest, inodeMap);
    }

    @Override
    public final void setModificationTime(long modificationTime) {
        this.referred.setModificationTime(modificationTime);
    }

    @Override
    public final long getAccessTime(Snapshot snapshot) {
        return this.referred.getAccessTime(snapshot);
    }

    @Override
    public final void setAccessTime(long accessTime) {
        this.referred.setAccessTime(accessTime);
    }

    @Override
    final INode recordModification(Snapshot latest, INodeMap inodeMap) throws QuotaExceededException {
        this.referred.recordModification(latest, inodeMap);
        return this;
    }

    @Override
    public Quota.Counts cleanSubtree(Snapshot snapshot, Snapshot prior, INode.BlocksMapUpdateInfo collectedBlocks, List<INode> removedINodes, boolean countDiffChange) throws QuotaExceededException {
        return this.referred.cleanSubtree(snapshot, prior, collectedBlocks, removedINodes, countDiffChange);
    }

    @Override
    public void destroyAndCollectBlocks(INode.BlocksMapUpdateInfo collectedBlocks, List<INode> removedINodes) {
        if (INodeReference.removeReference(this) <= 0) {
            this.referred.destroyAndCollectBlocks(collectedBlocks, removedINodes);
        }
    }

    @Override
    public Content.Counts computeContentSummary(Content.Counts counts) {
        return this.referred.computeContentSummary(counts);
    }

    @Override
    public Quota.Counts computeQuotaUsage(Quota.Counts counts, boolean useCache, int lastSnapshotId) {
        return this.referred.computeQuotaUsage(counts, useCache, lastSnapshotId);
    }

    @Override
    public final INodeAttributes getSnapshotINode(Snapshot snapshot) {
        return this.referred.getSnapshotINode(snapshot);
    }

    @Override
    public final long getNsQuota() {
        return this.referred.getNsQuota();
    }

    @Override
    public final long getDsQuota() {
        return this.referred.getDsQuota();
    }

    @Override
    public final void clear() {
        super.clear();
        this.referred = null;
    }

    @Override
    public void dumpTreeRecursively(PrintWriter out, StringBuilder prefix, Snapshot snapshot) {
        super.dumpTreeRecursively(out, prefix, snapshot);
        if (this instanceof DstReference) {
            out.print(", dstSnapshotId=" + ((DstReference)this).dstSnapshotId);
        }
        if (this instanceof WithCount) {
            out.print(", count=" + ((WithCount)this).getReferenceCount());
        }
        out.println();
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < prefix.length(); ++i) {
            b.append(' ');
        }
        b.append("->");
        this.getReferredINode().dumpTreeRecursively(out, b, snapshot);
    }

    public int getDstSnapshotId() {
        return -1;
    }

    public static class DstReference
    extends INodeReference {
        private final int dstSnapshotId;

        @Override
        public final int getDstSnapshotId() {
            return this.dstSnapshotId;
        }

        public DstReference(INodeDirectory parent, WithCount referred, int dstSnapshotId) {
            super(parent, referred);
            this.dstSnapshotId = dstSnapshotId;
            referred.addReference(this);
        }

        @Override
        public Quota.Counts cleanSubtree(Snapshot snapshot, Snapshot prior, INode.BlocksMapUpdateInfo collectedBlocks, List<INode> removedINodes, boolean countDiffChange) throws QuotaExceededException {
            if (snapshot == null && prior == null) {
                Quota.Counts counts = Quota.Counts.newInstance();
                this.computeQuotaUsage(counts, true);
                this.destroyAndCollectBlocks(collectedBlocks, removedINodes);
                return counts;
            }
            if (prior == null) {
                prior = DstReference.getPriorSnapshot(this);
            }
            if (snapshot != null && prior != null && Snapshot.ID_COMPARATOR.compare(snapshot, prior) <= 0) {
                return Quota.Counts.newInstance();
            }
            return this.getReferredINode().cleanSubtree(snapshot, prior, collectedBlocks, removedINodes, countDiffChange);
        }

        @Override
        public void destroyAndCollectBlocks(INode.BlocksMapUpdateInfo collectedBlocks, List<INode> removedINodes) {
            if (INodeReference.removeReference((INodeReference)this) <= 0) {
                this.getReferredINode().destroyAndCollectBlocks(collectedBlocks, removedINodes);
            } else {
                Snapshot prior = DstReference.getPriorSnapshot(this);
                Preconditions.checkState(prior != null);
                Snapshot snapshot = this.getSelfSnapshot(prior);
                INode referred = this.getReferredINode().asReference().getReferredINode();
                if (referred instanceof FileWithSnapshot) {
                    FileWithSnapshot sfile = (FileWithSnapshot)((Object)referred);
                    sfile.deleteCurrentFile();
                    if (snapshot != null) {
                        try {
                            referred.cleanSubtree(snapshot, prior, collectedBlocks, removedINodes, true);
                        }
                        catch (QuotaExceededException e) {
                            LOG.error((Object)"should not exceed quota while snapshot deletion", (Throwable)e);
                        }
                    }
                } else if (referred instanceof INodeDirectoryWithSnapshot) {
                    INodeDirectoryWithSnapshot sdir = (INodeDirectoryWithSnapshot)referred;
                    try {
                        INodeDirectoryWithSnapshot.destroyDstSubtree(sdir, snapshot, prior, collectedBlocks, removedINodes);
                    }
                    catch (QuotaExceededException e) {
                        LOG.error((Object)"should not exceed quota while snapshot deletion", (Throwable)e);
                    }
                }
            }
        }

        private Snapshot getSelfSnapshot(Snapshot prior) {
            WithCount wc = (WithCount)this.getReferredINode().asReference();
            INode referred = wc.getReferredINode();
            Snapshot lastSnapshot = null;
            if (referred instanceof FileWithSnapshot) {
                lastSnapshot = ((FileWithSnapshot)((Object)referred)).getDiffs().getLastSnapshot();
            } else if (referred instanceof INodeDirectoryWithSnapshot) {
                lastSnapshot = ((INodeDirectoryWithSnapshot)referred).getLastSnapshot();
            }
            if (lastSnapshot != null && !lastSnapshot.equals(prior)) {
                return lastSnapshot;
            }
            return null;
        }
    }

    public static class WithName
    extends INodeReference {
        private final byte[] name;
        private final int lastSnapshotId;

        public WithName(INodeDirectory parent, WithCount referred, byte[] name, int lastSnapshotId) {
            super(parent, referred);
            this.name = name;
            this.lastSnapshotId = lastSnapshotId;
            referred.addReference(this);
        }

        @Override
        public final byte[] getLocalNameBytes() {
            return this.name;
        }

        @Override
        public final void setLocalName(byte[] name) {
            throw new UnsupportedOperationException("Cannot set name: " + this.getClass() + " is immutable.");
        }

        public int getLastSnapshotId() {
            return this.lastSnapshotId;
        }

        @Override
        public final Content.Counts computeContentSummary(Content.Counts counts) {
            Quota.Counts q = Quota.Counts.newInstance();
            this.computeQuotaUsage(q, false, this.lastSnapshotId);
            counts.add(Content.DISKSPACE, q.get(Quota.DISKSPACE));
            return counts;
        }

        @Override
        public final Quota.Counts computeQuotaUsage(Quota.Counts counts, boolean useCache, int lastSnapshotId) {
            Preconditions.checkState(this.lastSnapshotId >= lastSnapshotId);
            INode referred = this.getReferredINode().asReference().getReferredINode();
            int id = lastSnapshotId > -1 ? lastSnapshotId : this.lastSnapshotId;
            return referred.computeQuotaUsage(counts, false, id);
        }

        @Override
        public Quota.Counts cleanSubtree(Snapshot snapshot, Snapshot prior, INode.BlocksMapUpdateInfo collectedBlocks, List<INode> removedINodes, boolean countDiffChange) throws QuotaExceededException {
            Preconditions.checkArgument(snapshot != null);
            if (prior == null) {
                prior = WithName.getPriorSnapshot(this);
            }
            if (prior != null && Snapshot.ID_COMPARATOR.compare(snapshot, prior) <= 0) {
                return Quota.Counts.newInstance();
            }
            Quota.Counts counts = this.getReferredINode().cleanSubtree(snapshot, prior, collectedBlocks, removedINodes, false);
            INodeReference ref = this.getReferredINode().getParentReference();
            if (ref != null) {
                ref.addSpaceConsumed(-counts.get(Quota.NAMESPACE), -counts.get(Quota.DISKSPACE), true);
            }
            if (snapshot.getId() < this.lastSnapshotId) {
                counts = Quota.Counts.newInstance();
            }
            return counts;
        }

        @Override
        public void destroyAndCollectBlocks(INode.BlocksMapUpdateInfo collectedBlocks, List<INode> removedINodes) {
            Snapshot snapshot = this.getSelfSnapshot();
            if (INodeReference.removeReference((INodeReference)this) <= 0) {
                this.getReferredINode().destroyAndCollectBlocks(collectedBlocks, removedINodes);
            } else {
                Snapshot prior = WithName.getPriorSnapshot(this);
                INode referred = this.getReferredINode().asReference().getReferredINode();
                if (snapshot != null) {
                    if (prior != null && snapshot.getId() <= prior.getId()) {
                        return;
                    }
                    try {
                        Quota.Counts counts = referred.cleanSubtree(snapshot, prior, collectedBlocks, removedINodes, false);
                        INodeReference ref = this.getReferredINode().getParentReference();
                        if (ref != null) {
                            ref.addSpaceConsumed(-counts.get(Quota.NAMESPACE), -counts.get(Quota.DISKSPACE), true);
                        }
                    }
                    catch (QuotaExceededException e) {
                        LOG.error((Object)"should not exceed quota while snapshot deletion", (Throwable)e);
                    }
                }
            }
        }

        private Snapshot getSelfSnapshot() {
            INode referred = this.getReferredINode().asReference().getReferredINode();
            Snapshot snapshot = null;
            if (referred instanceof FileWithSnapshot) {
                snapshot = ((FileWithSnapshot)((Object)referred)).getDiffs().getPrior(this.lastSnapshotId);
            } else if (referred instanceof INodeDirectoryWithSnapshot) {
                snapshot = ((INodeDirectoryWithSnapshot)referred).getDiffs().getPrior(this.lastSnapshotId);
            }
            return snapshot;
        }
    }

    public static class WithCount
    extends INodeReference {
        private final List<WithName> withNameList = new ArrayList<WithName>();
        public static final Comparator<WithName> WITHNAME_COMPARATOR = new Comparator<WithName>(){

            @Override
            public int compare(WithName left, WithName right) {
                return left.lastSnapshotId - right.lastSnapshotId;
            }
        };

        public WithCount(INodeReference parent, INode referred) {
            super(parent, referred);
            Preconditions.checkArgument(!referred.isReference());
            referred.setParentReference(this);
        }

        public int getReferenceCount() {
            int count = this.withNameList.size();
            if (this.getParentReference() != null) {
                ++count;
            }
            return count;
        }

        public void addReference(INodeReference ref) {
            if (ref instanceof WithName) {
                WithName refWithName = (WithName)ref;
                int i = Collections.binarySearch(this.withNameList, refWithName, WITHNAME_COMPARATOR);
                Preconditions.checkState(i < 0);
                this.withNameList.add(-i - 1, refWithName);
            } else if (ref instanceof DstReference) {
                this.setParentReference(ref);
            }
        }

        public void removeReference(INodeReference ref) {
            if (ref instanceof WithName) {
                int i = Collections.binarySearch(this.withNameList, (WithName)ref, WITHNAME_COMPARATOR);
                if (i >= 0) {
                    this.withNameList.remove(i);
                }
            } else if (ref == this.getParentReference()) {
                this.setParent(null);
            }
        }

        WithName getLastWithName() {
            return this.withNameList.size() > 0 ? this.withNameList.get(this.withNameList.size() - 1) : null;
        }

        WithName getPriorWithName(WithName post) {
            int i = Collections.binarySearch(this.withNameList, post, WITHNAME_COMPARATOR);
            if (i > 0) {
                return this.withNameList.get(i - 1);
            }
            if (i == 0 || i == -1) {
                return null;
            }
            return this.withNameList.get(-i - 2);
        }
    }
}

