/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Longs;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hdfs.server.namenode.EditLogInputStream;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogOp;
import org.apache.hadoop.io.IOUtils;

class RedundantEditLogInputStream
extends EditLogInputStream {
    public static final Log LOG = LogFactory.getLog((String)EditLogInputStream.class.getName());
    private int curIdx = 0;
    private long prevTxId;
    private final EditLogInputStream[] streams;
    private State state;
    private IOException prevException;

    RedundantEditLogInputStream(Collection<EditLogInputStream> streams, long startTxId) {
        this.prevTxId = startTxId == -12345L ? -12345L : startTxId - 1L;
        this.state = streams.isEmpty() ? State.EOF : State.SKIP_UNTIL;
        this.prevException = null;
        EditLogInputStream first = null;
        for (EditLogInputStream s : streams) {
            Preconditions.checkArgument(s.getFirstTxId() != -12345L, "invalid first txid in stream: %s", s);
            Preconditions.checkArgument(s.getLastTxId() != -12345L, "invalid last txid in stream: %s", s);
            if (first == null) {
                first = s;
                continue;
            }
            Preconditions.checkArgument(s.getFirstTxId() == first.getFirstTxId(), "All streams in the RedundantEditLogInputStream must have the same start transaction ID!  " + first + " had start txId " + first.getFirstTxId() + ", but " + s + " had start txId " + s.getFirstTxId());
        }
        this.streams = streams.toArray(new EditLogInputStream[0]);
        Arrays.sort(this.streams, new Comparator<EditLogInputStream>(){

            @Override
            public int compare(EditLogInputStream a, EditLogInputStream b) {
                return Longs.compare(b.getLastTxId(), a.getLastTxId());
            }
        });
    }

    @Override
    public String getCurrentStreamName() {
        return this.streams[this.curIdx].getCurrentStreamName();
    }

    @Override
    public String getName() {
        StringBuilder bld = new StringBuilder();
        String prefix = "";
        for (EditLogInputStream elis : this.streams) {
            bld.append(prefix);
            bld.append(elis.getName());
            prefix = ", ";
        }
        return bld.toString();
    }

    @Override
    public long getFirstTxId() {
        return this.streams[this.curIdx].getFirstTxId();
    }

    @Override
    public long getLastTxId() {
        return this.streams[this.curIdx].getLastTxId();
    }

    @Override
    public void close() throws IOException {
        IOUtils.cleanup(LOG, this.streams);
    }

    @Override
    protected FSEditLogOp nextValidOp() {
        try {
            if (this.state == State.STREAM_FAILED) {
                this.state = State.STREAM_FAILED_RESYNC;
            }
            return this.nextOp();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    protected FSEditLogOp nextOp() throws IOException {
        while (true) {
            switch (this.state) {
                case SKIP_UNTIL: {
                    try {
                        if (this.prevTxId != -12345L) {
                            LOG.info((Object)("Fast-forwarding stream '" + this.streams[this.curIdx].getName() + "' to transaction ID " + (this.prevTxId + 1L)));
                            this.streams[this.curIdx].skipUntil(this.prevTxId + 1L);
                        }
                    }
                    catch (IOException e) {
                        this.prevException = e;
                        this.state = State.STREAM_FAILED;
                    }
                    this.state = State.OK;
                    break;
                }
                case OK: {
                    try {
                        FSEditLogOp op = this.streams[this.curIdx].readOp();
                        if (op == null) {
                            this.state = State.EOF;
                            if (this.streams[this.curIdx].getLastTxId() == this.prevTxId) {
                                return null;
                            }
                            throw new PrematureEOFException("got premature end-of-file at txid " + this.prevTxId + "; expected file to go up to " + this.streams[this.curIdx].getLastTxId());
                        }
                        this.prevTxId = op.getTransactionId();
                        return op;
                    }
                    catch (IOException e) {
                        this.prevException = e;
                        this.state = State.STREAM_FAILED;
                        break;
                    }
                }
                case STREAM_FAILED: {
                    if (this.curIdx + 1 == this.streams.length) {
                        throw this.prevException;
                    }
                    long oldLast = this.streams[this.curIdx].getLastTxId();
                    long newLast = this.streams[this.curIdx + 1].getLastTxId();
                    if (newLast < oldLast) {
                        throw new IOException("We encountered an error reading " + this.streams[this.curIdx].getName() + ".  During automatic edit log " + "failover, we noticed that all of the remaining edit log " + "streams are shorter than the current one!  The best " + "remaining edit log ends at transaction " + newLast + ", but we thought we could read up to transaction " + oldLast + ".  If you continue, metadata will be lost forever!");
                    }
                    LOG.error((Object)("Got error reading edit log input stream " + this.streams[this.curIdx].getName() + "; failing over to edit log " + this.streams[this.curIdx + 1].getName()), (Throwable)this.prevException);
                    ++this.curIdx;
                    this.state = State.SKIP_UNTIL;
                    break;
                }
                case STREAM_FAILED_RESYNC: {
                    if (this.curIdx + 1 == this.streams.length) {
                        if (this.prevException instanceof PrematureEOFException) {
                            this.state = State.EOF;
                            break;
                        }
                        this.streams[this.curIdx].resync();
                        this.state = State.SKIP_UNTIL;
                        break;
                    }
                    LOG.error((Object)("failing over to edit log " + this.streams[this.curIdx + 1].getName()));
                    ++this.curIdx;
                    this.state = State.SKIP_UNTIL;
                    break;
                }
                case EOF: {
                    return null;
                }
            }
        }
    }

    @Override
    public int getVersion() throws IOException {
        return this.streams[this.curIdx].getVersion();
    }

    @Override
    public long getPosition() {
        return this.streams[this.curIdx].getPosition();
    }

    @Override
    public long length() throws IOException {
        return this.streams[this.curIdx].length();
    }

    @Override
    public boolean isInProgress() {
        return this.streams[this.curIdx].isInProgress();
    }

    @Override
    public void setMaxOpSize(int maxOpSize) {
        for (EditLogInputStream elis : this.streams) {
            elis.setMaxOpSize(maxOpSize);
        }
    }

    private static final class PrematureEOFException
    extends IOException {
        private static final long serialVersionUID = 1L;

        PrematureEOFException(String msg) {
            super(msg);
        }
    }

    private static enum State {
        SKIP_UNTIL,
        OK,
        STREAM_FAILED,
        STREAM_FAILED_RESYNC,
        EOF;

    }
}

