/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.http;

import com.sun.jersey.spi.container.servlet.ServletContainer;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLServerSocketFactory;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.ConfServlet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.AdminAuthorizedServlet;
import org.apache.hadoop.http.FilterContainer;
import org.apache.hadoop.http.FilterInitializer;
import org.apache.hadoop.http.HtmlQuoting;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.http.NoCacheFilter;
import org.apache.hadoop.jmx.JMXJsonServlet;
import org.apache.hadoop.log.LogLevel;
import org.apache.hadoop.metrics.MetricsServlet;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.server.AuthenticationFilter;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.security.ssl.SSLFactory;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.Shell;
import org.mortbay.io.Buffer;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.MimeTypes;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.jetty.handler.ContextHandlerCollection;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.mortbay.jetty.security.SslSocketConnector;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.DefaultServlet;
import org.mortbay.jetty.servlet.FilterHolder;
import org.mortbay.jetty.servlet.FilterMapping;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.jetty.webapp.WebAppContext;
import org.mortbay.thread.QueuedThreadPool;
import org.mortbay.thread.ThreadPool;
import org.mortbay.util.MultiException;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce", "HBase"})
@InterfaceStability.Evolving
public class HttpServer
implements FilterContainer {
    public static final Log LOG = LogFactory.getLog(HttpServer.class);
    static final String FILTER_INITIALIZER_PROPERTY = "hadoop.http.filter.initializers";
    static final String HTTP_MAX_THREADS = "hadoop.http.max.threads";
    public static final String CONF_CONTEXT_ATTRIBUTE = "hadoop.conf";
    public static final String ADMINS_ACL = "admins.acl";
    public static final String SPNEGO_FILTER = "SpnegoFilter";
    public static final String NO_CACHE_FILTER = "NoCacheFilter";
    public static final String BIND_ADDRESS = "bind.address";
    private AccessControlList adminsAcl;
    private SSLFactory sslFactory;
    protected final Server webServer;
    protected final Connector listener;
    protected final WebAppContext webAppContext;
    protected final boolean findPort;
    protected final Map<Context, Boolean> defaultContexts = new HashMap<Context, Boolean>();
    protected final List<String> filterNames = new ArrayList<String>();
    private static final int MAX_RETRIES = 10;
    static final String STATE_DESCRIPTION_ALIVE = " - alive";
    static final String STATE_DESCRIPTION_NOT_LIVE = " - not live";
    private final boolean listenerStartedExternally;

    public HttpServer(String name, String bindAddress, int port, boolean findPort) throws IOException {
        this(name, bindAddress, port, findPort, new Configuration());
    }

    public HttpServer(String name, String bindAddress, int port, boolean findPort, Configuration conf, Connector connector) throws IOException {
        this(name, bindAddress, port, findPort, conf, null, connector, null);
    }

    public HttpServer(String name, String bindAddress, int port, boolean findPort, Configuration conf, String[] pathSpecs) throws IOException {
        this(name, bindAddress, port, findPort, conf, null, null, pathSpecs);
    }

    public HttpServer(String name, String bindAddress, int port, boolean findPort, Configuration conf) throws IOException {
        this(name, bindAddress, port, findPort, conf, null, null, null);
    }

    public HttpServer(String name, String bindAddress, int port, boolean findPort, Configuration conf, AccessControlList adminsAcl) throws IOException {
        this(name, bindAddress, port, findPort, conf, adminsAcl, null, null);
    }

    public HttpServer(String name, String bindAddress, int port, boolean findPort, Configuration conf, AccessControlList adminsAcl, Connector connector) throws IOException {
        this(name, bindAddress, port, findPort, conf, adminsAcl, connector, null);
    }

    public HttpServer(String name, String bindAddress, int port, boolean findPort, Configuration conf, AccessControlList adminsAcl, Connector connector, String[] pathSpecs) throws IOException {
        this.webServer = new Server();
        this.findPort = findPort;
        this.adminsAcl = adminsAcl;
        if (connector == null) {
            this.listenerStartedExternally = false;
            if (HttpConfig.isSecure()) {
                this.sslFactory = new SSLFactory(SSLFactory.Mode.SERVER, conf);
                try {
                    this.sslFactory.init();
                }
                catch (GeneralSecurityException ex) {
                    throw new IOException(ex);
                }
                SslSocketConnector sslListener = new SslSocketConnector(){

                    protected SSLServerSocketFactory createFactory() throws Exception {
                        return HttpServer.this.sslFactory.createSSLServerSocketFactory();
                    }
                };
                this.listener = sslListener;
            } else {
                this.listener = this.createBaseListener(conf);
            }
            this.listener.setHost(bindAddress);
            this.listener.setPort(port);
        } else {
            this.listenerStartedExternally = true;
            this.listener = connector;
        }
        this.webServer.addConnector(this.listener);
        int maxThreads = conf.getInt(HTTP_MAX_THREADS, -1);
        QueuedThreadPool threadPool = maxThreads == -1 ? new QueuedThreadPool() : new QueuedThreadPool(maxThreads);
        threadPool.setDaemon(true);
        this.webServer.setThreadPool((ThreadPool)threadPool);
        String appDir = this.getWebAppsPath(name);
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        this.webServer.setHandler((Handler)contexts);
        this.webAppContext = new WebAppContext();
        this.webAppContext.setDisplayName(name);
        this.webAppContext.setContextPath("/");
        this.webAppContext.setWar(appDir + "/" + name);
        this.webAppContext.getServletContext().setAttribute(CONF_CONTEXT_ATTRIBUTE, (Object)conf);
        this.webAppContext.getServletContext().setAttribute(ADMINS_ACL, (Object)adminsAcl);
        this.addNoCacheFilter(this.webAppContext);
        this.webServer.addHandler((Handler)this.webAppContext);
        this.addDefaultApps(contexts, appDir, conf);
        this.addGlobalFilter("safety", QuotingInputFilter.class.getName(), null);
        FilterInitializer[] initializers = HttpServer.getFilterInitializers(conf);
        if (initializers != null) {
            conf = new Configuration(conf);
            conf.set(BIND_ADDRESS, bindAddress);
            for (FilterInitializer c : initializers) {
                c.initFilter(this, conf);
            }
        }
        this.addDefaultServlets();
        if (pathSpecs != null) {
            for (String path : pathSpecs) {
                LOG.info((Object)("adding path spec: " + (String)path));
                this.addFilterPathMapping(path, (Context)this.webAppContext);
            }
        }
    }

    private void addNoCacheFilter(WebAppContext ctxt) {
        this.defineFilter((Context)ctxt, NO_CACHE_FILTER, NoCacheFilter.class.getName(), Collections.EMPTY_MAP, new String[]{"/*"});
    }

    public Connector createBaseListener(Configuration conf) throws IOException {
        return HttpServer.createDefaultChannelConnector();
    }

    @InterfaceAudience.Private
    public static Connector createDefaultChannelConnector() {
        SelectChannelConnector ret = new SelectChannelConnector();
        ret.setLowResourceMaxIdleTime(10000);
        ret.setAcceptQueueSize(128);
        ret.setResolveNames(false);
        ret.setUseDirectBuffers(false);
        if (Shell.WINDOWS) {
            ret.setReuseAddress(false);
        }
        ret.setHeaderBufferSize(65536);
        return ret;
    }

    private static FilterInitializer[] getFilterInitializers(Configuration conf) {
        if (conf == null) {
            return null;
        }
        Class<?>[] classes = conf.getClasses(FILTER_INITIALIZER_PROPERTY, new Class[0]);
        if (classes == null) {
            return null;
        }
        FilterInitializer[] initializers = new FilterInitializer[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            initializers[i] = (FilterInitializer)ReflectionUtils.newInstance(classes[i], conf);
        }
        return initializers;
    }

    protected void addDefaultApps(ContextHandlerCollection parent, String appDir, Configuration conf) throws IOException {
        String logDir = System.getProperty("hadoop.log.dir");
        if (logDir != null) {
            Context logContext = new Context((HandlerContainer)parent, "/logs");
            logContext.setResourceBase(logDir);
            logContext.addServlet(AdminAuthorizedServlet.class, "/*");
            if (conf.getBoolean("hadoop.jetty.logs.serve.aliases", true)) {
                logContext.getInitParams().put("org.mortbay.jetty.servlet.Default.aliases", "true");
            }
            logContext.setDisplayName("logs");
            this.setContextAttributes(logContext, conf);
            this.addNoCacheFilter(this.webAppContext);
            this.defaultContexts.put(logContext, true);
        }
        Context staticContext = new Context((HandlerContainer)parent, "/static");
        staticContext.setResourceBase(appDir + "/static");
        staticContext.addServlet(DefaultServlet.class, "/*");
        staticContext.setDisplayName("static");
        this.setContextAttributes(staticContext, conf);
        this.defaultContexts.put(staticContext, true);
    }

    private void setContextAttributes(Context context, Configuration conf) {
        context.getServletContext().setAttribute(CONF_CONTEXT_ATTRIBUTE, (Object)conf);
        context.getServletContext().setAttribute(ADMINS_ACL, (Object)this.adminsAcl);
    }

    protected void addDefaultServlets() {
        this.addServlet("stacks", "/stacks", StackServlet.class);
        this.addServlet("logLevel", "/logLevel", LogLevel.Servlet.class);
        this.addServlet("metrics", "/metrics", MetricsServlet.class);
        this.addServlet("jmx", "/jmx", JMXJsonServlet.class);
        this.addServlet("conf", "/conf", ConfServlet.class);
    }

    public void addContext(Context ctxt, boolean isFiltered) throws IOException {
        this.webServer.addHandler((Handler)ctxt);
        this.addNoCacheFilter(this.webAppContext);
        this.defaultContexts.put(ctxt, isFiltered);
    }

    protected void addContext(String pathSpec, String dir, boolean isFiltered) throws IOException {
        if (0 == this.webServer.getHandlers().length) {
            throw new RuntimeException("Couldn't find handler");
        }
        WebAppContext webAppCtx = new WebAppContext();
        webAppCtx.setContextPath(pathSpec);
        webAppCtx.setWar(dir);
        this.addContext((Context)webAppCtx, true);
    }

    public void setAttribute(String name, Object value) {
        this.webAppContext.setAttribute(name, value);
    }

    public void addJerseyResourcePackage(String packageName, String pathSpec) {
        LOG.info((Object)("addJerseyResourcePackage: packageName=" + packageName + ", pathSpec=" + pathSpec));
        ServletHolder sh = new ServletHolder(ServletContainer.class);
        sh.setInitParameter("com.sun.jersey.config.property.resourceConfigClass", "com.sun.jersey.api.core.PackagesResourceConfig");
        sh.setInitParameter("com.sun.jersey.config.property.packages", packageName);
        this.webAppContext.addServlet(sh, pathSpec);
    }

    public void addServlet(String name, String pathSpec, Class<? extends HttpServlet> clazz) {
        this.addInternalServlet(name, pathSpec, clazz, false);
        this.addFilterPathMapping(pathSpec, (Context)this.webAppContext);
    }

    public void addInternalServlet(String name, String pathSpec, Class<? extends HttpServlet> clazz) {
        this.addInternalServlet(name, pathSpec, clazz, false);
    }

    public void addInternalServlet(String name, String pathSpec, Class<? extends HttpServlet> clazz, boolean requireAuth) {
        ServletHolder holder = new ServletHolder(clazz);
        if (name != null) {
            holder.setName(name);
        }
        this.webAppContext.addServlet(holder, pathSpec);
        if (requireAuth && UserGroupInformation.isSecurityEnabled()) {
            LOG.info((Object)("Adding Kerberos (SPNEGO) filter to " + name));
            ServletHandler handler = this.webAppContext.getServletHandler();
            FilterMapping fmap = new FilterMapping();
            fmap.setPathSpec(pathSpec);
            fmap.setFilterName(SPNEGO_FILTER);
            fmap.setDispatches(15);
            handler.addFilterMapping(fmap);
        }
    }

    @Override
    public void addFilter(String name, String classname, Map<String, String> parameters) {
        String[] USER_FACING_URLS = new String[]{"*.html", "*.jsp"};
        this.defineFilter((Context)this.webAppContext, name, classname, parameters, USER_FACING_URLS);
        LOG.info((Object)("Added filter " + name + " (class=" + classname + ") to context " + this.webAppContext.getDisplayName()));
        String[] ALL_URLS = new String[]{"/*"};
        for (Map.Entry<Context, Boolean> e : this.defaultContexts.entrySet()) {
            if (!e.getValue().booleanValue()) continue;
            Context ctx = e.getKey();
            this.defineFilter(ctx, name, classname, parameters, ALL_URLS);
            LOG.info((Object)("Added filter " + name + " (class=" + classname + ") to context " + ctx.getDisplayName()));
        }
        this.filterNames.add(name);
    }

    @Override
    public void addGlobalFilter(String name, String classname, Map<String, String> parameters) {
        String[] ALL_URLS = new String[]{"/*"};
        this.defineFilter((Context)this.webAppContext, name, classname, parameters, ALL_URLS);
        for (Context ctx : this.defaultContexts.keySet()) {
            this.defineFilter(ctx, name, classname, parameters, ALL_URLS);
        }
        LOG.info((Object)("Added global filter '" + name + "' (class=" + classname + ")"));
    }

    public void defineFilter(Context ctx, String name, String classname, Map<String, String> parameters, String[] urls) {
        FilterHolder holder = new FilterHolder();
        holder.setName(name);
        holder.setClassName(classname);
        holder.setInitParameters(parameters);
        FilterMapping fmap = new FilterMapping();
        fmap.setPathSpecs(urls);
        fmap.setDispatches(15);
        fmap.setFilterName(name);
        ServletHandler handler = ctx.getServletHandler();
        handler.addFilter(holder, fmap);
    }

    protected void addFilterPathMapping(String pathSpec, Context webAppCtx) {
        ServletHandler handler = webAppCtx.getServletHandler();
        for (String name : this.filterNames) {
            FilterMapping fmap = new FilterMapping();
            fmap.setPathSpec(pathSpec);
            fmap.setFilterName(name);
            fmap.setDispatches(15);
            handler.addFilterMapping(fmap);
        }
    }

    public Object getAttribute(String name) {
        return this.webAppContext.getAttribute(name);
    }

    public WebAppContext getWebAppContext() {
        return this.webAppContext;
    }

    protected String getWebAppsPath(String appName) throws FileNotFoundException {
        URL url = this.getClass().getClassLoader().getResource("webapps/" + appName);
        if (url == null) {
            throw new FileNotFoundException("webapps/" + appName + " not found in CLASSPATH");
        }
        String urlString = url.toString();
        return urlString.substring(0, urlString.lastIndexOf(47));
    }

    public int getPort() {
        return this.webServer.getConnectors()[0].getLocalPort();
    }

    public void setThreads(int min, int max) {
        QueuedThreadPool pool = (QueuedThreadPool)this.webServer.getThreadPool();
        pool.setMinThreads(min);
        pool.setMaxThreads(max);
    }

    @Deprecated
    public void addSslListener(InetSocketAddress addr, String keystore, String storPass, String keyPass) throws IOException {
        if (this.webServer.isStarted()) {
            throw new IOException("Failed to add ssl listener");
        }
        SslSocketConnector sslListener = new SslSocketConnector();
        sslListener.setHost(addr.getHostName());
        sslListener.setPort(addr.getPort());
        sslListener.setKeystore(keystore);
        sslListener.setPassword(storPass);
        sslListener.setKeyPassword(keyPass);
        this.webServer.addConnector((Connector)sslListener);
    }

    public void addSslListener(InetSocketAddress addr, Configuration sslConf, boolean needCertsAuth) throws IOException {
        if (this.webServer.isStarted()) {
            throw new IOException("Failed to add ssl listener");
        }
        if (needCertsAuth) {
            System.setProperty("javax.net.ssl.trustStore", sslConf.get("ssl.server.truststore.location", ""));
            System.setProperty("javax.net.ssl.trustStorePassword", sslConf.get("ssl.server.truststore.password", ""));
            System.setProperty("javax.net.ssl.trustStoreType", sslConf.get("ssl.server.truststore.type", "jks"));
        }
        SslSocketConnector sslListener = new SslSocketConnector();
        sslListener.setHost(addr.getHostName());
        sslListener.setPort(addr.getPort());
        sslListener.setKeystore(sslConf.get("ssl.server.keystore.location"));
        sslListener.setPassword(sslConf.get("ssl.server.keystore.password", ""));
        sslListener.setKeyPassword(sslConf.get("ssl.server.keystore.keypassword", ""));
        sslListener.setKeystoreType(sslConf.get("ssl.server.keystore.type", "jks"));
        sslListener.setNeedClientAuth(needCertsAuth);
        this.webServer.addConnector((Connector)sslListener);
    }

    protected void initSpnego(Configuration conf, String usernameConfKey, String keytabConfKey) throws IOException {
        String httpKeytab;
        HashMap<String, String> params = new HashMap<String, String>();
        String principalInConf = conf.get(usernameConfKey);
        if (principalInConf != null && !principalInConf.isEmpty()) {
            params.put("kerberos.principal", SecurityUtil.getServerPrincipal(principalInConf, this.listener.getHost()));
        }
        if ((httpKeytab = conf.get(keytabConfKey)) != null && !httpKeytab.isEmpty()) {
            params.put("kerberos.keytab", httpKeytab);
        }
        params.put("type", "kerberos");
        this.defineFilter((Context)this.webAppContext, SPNEGO_FILTER, AuthenticationFilter.class.getName(), params, null);
    }

    public void start() throws IOException {
        try {
            try {
                this.openListener();
                LOG.info((Object)("Jetty bound to port " + this.listener.getLocalPort()));
                this.webServer.start();
            }
            catch (IOException ex) {
                LOG.info((Object)"HttpServer.start() threw a non Bind IOException", (Throwable)ex);
                throw ex;
            }
            catch (MultiException ex) {
                LOG.info((Object)"HttpServer.start() threw a MultiException", (Throwable)ex);
                throw ex;
            }
            Handler[] handlers = this.webServer.getHandlers();
            for (int i = 0; i < handlers.length; ++i) {
                if (!handlers[i].isFailed()) continue;
                throw new IOException("Problem in starting http server. Server handlers failed");
            }
            Throwable unavailableException = this.webAppContext.getUnavailableException();
            if (unavailableException != null) {
                this.webServer.stop();
                throw new IOException("Unable to initialize WebAppContext", unavailableException);
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException("Problem starting http server", e);
        }
    }

    void openListener() throws Exception {
        if (this.listener.getLocalPort() != -1) {
            return;
        }
        if (this.listenerStartedExternally) {
            throw new Exception("Expected webserver's listener to be started previously but wasn't");
        }
        int port = this.listener.getPort();
        while (true) {
            try {
                this.listener.close();
                this.listener.open();
            }
            catch (BindException ex) {
                if (port == 0 || !this.findPort) {
                    BindException be = new BindException("Port in use: " + this.listener.getHost() + ":" + this.listener.getPort());
                    be.initCause(ex);
                    throw be;
                }
                this.listener.setPort(++port);
                Thread.sleep(100L);
                continue;
            }
            break;
        }
    }

    public InetSocketAddress getListenerAddress() {
        int port = this.listener.getLocalPort();
        if (port == -1) {
            port = this.listener.getPort();
        }
        return new InetSocketAddress(this.listener.getHost(), port);
    }

    public void stop() throws Exception {
        MultiException exception = null;
        try {
            this.listener.close();
        }
        catch (Exception e) {
            LOG.error((Object)("Error while stopping listener for webapp" + this.webAppContext.getDisplayName()), (Throwable)e);
            exception = this.addMultiException(exception, e);
        }
        try {
            if (this.sslFactory != null) {
                this.sslFactory.destroy();
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Error while destroying the SSLFactory" + this.webAppContext.getDisplayName()), (Throwable)e);
            exception = this.addMultiException(exception, e);
        }
        try {
            this.webAppContext.clearAttributes();
            this.webAppContext.stop();
        }
        catch (Exception e) {
            LOG.error((Object)("Error while stopping web app context for webapp " + this.webAppContext.getDisplayName()), (Throwable)e);
            exception = this.addMultiException(exception, e);
        }
        try {
            this.webServer.stop();
        }
        catch (Exception e) {
            LOG.error((Object)("Error while stopping web server for webapp " + this.webAppContext.getDisplayName()), (Throwable)e);
            exception = this.addMultiException(exception, e);
        }
        if (exception != null) {
            exception.ifExceptionThrow();
        }
    }

    private MultiException addMultiException(MultiException exception, Exception e) {
        if (exception == null) {
            exception = new MultiException();
        }
        exception.add((Throwable)e);
        return exception;
    }

    public void join() throws InterruptedException {
        this.webServer.join();
    }

    public boolean isAlive() {
        return this.webServer != null && this.webServer.isStarted();
    }

    public String toString() {
        return this.listener != null ? "HttpServer at http://" + this.listener.getHost() + ":" + this.listener.getLocalPort() + "/" + (this.isAlive() ? STATE_DESCRIPTION_ALIVE : STATE_DESCRIPTION_NOT_LIVE) : "Inactive HttpServer";
    }

    public static boolean isInstrumentationAccessAllowed(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response) throws IOException {
        Configuration conf = (Configuration)servletContext.getAttribute(CONF_CONTEXT_ATTRIBUTE);
        boolean access = true;
        boolean adminAccess = conf.getBoolean("hadoop.security.instrumentation.requires.admin", false);
        if (adminAccess) {
            access = HttpServer.hasAdministratorAccess(servletContext, request, response);
        }
        return access;
    }

    public static boolean hasAdministratorAccess(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response) throws IOException {
        Configuration conf = (Configuration)servletContext.getAttribute(CONF_CONTEXT_ATTRIBUTE);
        if (!conf.getBoolean("hadoop.security.authorization", false)) {
            return true;
        }
        String remoteUser = request.getRemoteUser();
        if (remoteUser == null) {
            response.sendError(401, "Unauthenticated users are not authorized to access this page.");
            return false;
        }
        if (servletContext.getAttribute(ADMINS_ACL) != null && !HttpServer.userHasAdministratorAccess(servletContext, remoteUser)) {
            response.sendError(401, "User " + remoteUser + " is unauthorized to access this page.");
            return false;
        }
        return true;
    }

    public static boolean userHasAdministratorAccess(ServletContext servletContext, String remoteUser) {
        AccessControlList adminsAcl = (AccessControlList)servletContext.getAttribute(ADMINS_ACL);
        UserGroupInformation remoteUserUGI = UserGroupInformation.createRemoteUser(remoteUser);
        return adminsAcl != null && adminsAcl.isUserAllowed(remoteUserUGI);
    }

    public static class QuotingInputFilter
    implements Filter {
        private FilterConfig config;

        @Override
        public void init(FilterConfig config) throws ServletException {
            this.config = config;
        }

        @Override
        public void destroy() {
        }

        @Override
        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            RequestQuoter quoted = new RequestQuoter((HttpServletRequest)request);
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            String mime = this.inferMimeType(request);
            if (mime == null) {
                httpResponse.setContentType("text/plain; charset=utf-8");
            } else if (mime.startsWith("text/html")) {
                httpResponse.setContentType("text/html; charset=utf-8");
            } else if (mime.startsWith("application/xml")) {
                httpResponse.setContentType("text/xml; charset=utf-8");
            }
            chain.doFilter(quoted, httpResponse);
        }

        private String inferMimeType(ServletRequest request) {
            String path = ((HttpServletRequest)request).getRequestURI();
            ContextHandler.SContext sContext = (ContextHandler.SContext)this.config.getServletContext();
            MimeTypes mimes = sContext.getContextHandler().getMimeTypes();
            Buffer mimeBuffer = mimes.getMimeByExtension(path);
            return mimeBuffer == null ? null : mimeBuffer.toString();
        }

        public static class RequestQuoter
        extends HttpServletRequestWrapper {
            private final HttpServletRequest rawRequest;

            public RequestQuoter(HttpServletRequest rawRequest) {
                super(rawRequest);
                this.rawRequest = rawRequest;
            }

            @Override
            public Enumeration<String> getParameterNames() {
                return new Enumeration<String>(){
                    private Enumeration<String> rawIterator;
                    {
                        this.rawIterator = RequestQuoter.this.rawRequest.getParameterNames();
                    }

                    @Override
                    public boolean hasMoreElements() {
                        return this.rawIterator.hasMoreElements();
                    }

                    @Override
                    public String nextElement() {
                        return HtmlQuoting.quoteHtmlChars(this.rawIterator.nextElement());
                    }
                };
            }

            @Override
            public String getParameter(String name) {
                return HtmlQuoting.quoteHtmlChars(this.rawRequest.getParameter(HtmlQuoting.unquoteHtmlChars(name)));
            }

            @Override
            public String[] getParameterValues(String name) {
                String unquoteName = HtmlQuoting.unquoteHtmlChars(name);
                String[] unquoteValue = this.rawRequest.getParameterValues(unquoteName);
                if (unquoteValue == null) {
                    return null;
                }
                String[] result = new String[unquoteValue.length];
                for (int i = 0; i < result.length; ++i) {
                    result[i] = HtmlQuoting.quoteHtmlChars(unquoteValue[i]);
                }
                return result;
            }

            @Override
            public Map<String, String[]> getParameterMap() {
                HashMap<String, String[]> result = new HashMap<String, String[]>();
                Map<String, String[]> raw = this.rawRequest.getParameterMap();
                for (Map.Entry<String, String[]> item : raw.entrySet()) {
                    String[] rawValue = item.getValue();
                    String[] cookedValue = new String[rawValue.length];
                    for (int i = 0; i < rawValue.length; ++i) {
                        cookedValue[i] = HtmlQuoting.quoteHtmlChars(rawValue[i]);
                    }
                    result.put(HtmlQuoting.quoteHtmlChars(item.getKey()), cookedValue);
                }
                return result;
            }

            @Override
            public StringBuffer getRequestURL() {
                String url = this.rawRequest.getRequestURL().toString();
                return new StringBuffer(HtmlQuoting.quoteHtmlChars(url));
            }

            @Override
            public String getServerName() {
                return HtmlQuoting.quoteHtmlChars(this.rawRequest.getServerName());
            }
        }
    }

    public static class StackServlet
    extends HttpServlet {
        private static final long serialVersionUID = -6284183679759467039L;

        @Override
        public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            if (!HttpServer.isInstrumentationAccessAllowed(this.getServletContext(), request, response)) {
                return;
            }
            response.setContentType("text/plain; charset=UTF-8");
            PrintWriter out = response.getWriter();
            ReflectionUtils.printThreadInfo(out, "");
            out.close();
            ReflectionUtils.logThreadInfo(LOG, "jsp requested", 1L);
        }
    }
}

