/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.benchmark;

import java.security.Principal;
import javax.jcr.Credentials;
import javax.jcr.GuestCredentials;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.security.auth.login.Configuration;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.authentication.token.TokenCredentials;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.commons.jackrabbit.authorization.AccessControlUtils;
import org.apache.jackrabbit.oak.Oak;
import org.apache.jackrabbit.oak.benchmark.AbstractTest;
import org.apache.jackrabbit.oak.fixture.JcrCreator;
import org.apache.jackrabbit.oak.fixture.OakRepositoryFixture;
import org.apache.jackrabbit.oak.fixture.RepositoryFixture;
import org.apache.jackrabbit.oak.jcr.Jcr;
import org.apache.jackrabbit.oak.security.SecurityProviderImpl;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.authentication.ConfigurationUtil;
import org.apache.jackrabbit.oak.spi.security.principal.EveryonePrincipal;

abstract class AbstractLoginTest
extends AbstractTest {
    public static final int COUNT = 1000;
    public static final String USER = "user";
    public static final int DEFAULT_ITERATIONS = -1;
    public static final long NO_CACHE = -1L;
    private String runAsUser;
    private boolean runWithToken;
    private int noIterations;
    private long expiration;

    public AbstractLoginTest() {
        this("admin", false, -1);
    }

    public AbstractLoginTest(String runAsUser, boolean runWithToken, int noIterations) {
        this(runAsUser, runWithToken, noIterations, -1L);
    }

    public AbstractLoginTest(String runAsUser, boolean runWithToken, int noIterations, long expiration) {
        this.runAsUser = runAsUser;
        this.runWithToken = runWithToken;
        this.noIterations = noIterations;
        this.expiration = expiration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUp(Repository repository, Credentials credentials) throws Exception {
        super.setUp(repository, this.buildCredentials(repository, credentials));
        Session s = this.loginAdministrative();
        try {
            AccessControlUtils.addAccessControlEntry(s, "/", (Principal)EveryonePrincipal.getInstance(), new String[]{"{http://www.jcp.org/jcr/1.0}read"}, true);
            if (USER.equals(this.runAsUser)) {
                ((JackrabbitSession)s).getUserManager().createUser(USER, USER);
            }
        }
        finally {
            s.save();
            s.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tearDown() throws Exception {
        Session s = this.loginAdministrative();
        try {
            Authorizable authorizable = ((JackrabbitSession)s).getUserManager().getAuthorizable(USER);
            if (authorizable != null) {
                authorizable.remove();
                s.save();
            }
        }
        finally {
            s.logout();
            super.tearDown();
        }
    }

    @Override
    protected Repository[] createRepository(RepositoryFixture fixture) throws Exception {
        if (this.noIterations != -1 || this.expiration > 0L) {
            if (fixture instanceof OakRepositoryFixture) {
                return ((OakRepositoryFixture)fixture).setUpCluster(1, new JcrCreator(){

                    @Override
                    public Jcr customize(Oak oak) {
                        ConfigurationParameters iterations = ConfigurationParameters.of("passwordHashIterations", (Object)AbstractLoginTest.this.noIterations);
                        ConfigurationParameters cache = ConfigurationParameters.of("cacheExpiration", (Object)AbstractLoginTest.this.expiration);
                        ConfigurationParameters conf = AbstractLoginTest.this.runWithToken ? ConfigurationParameters.of("org.apache.jackrabbit.oak.authentication.token", (Object)iterations, "org.apache.jackrabbit.oak.user", (Object)cache) : ConfigurationParameters.of("org.apache.jackrabbit.oak.user", (Object)ConfigurationParameters.of(iterations, cache));
                        SecurityProviderImpl sp = new SecurityProviderImpl(conf);
                        return new Jcr(oak).with(sp);
                    }
                });
            }
            throw new UnsupportedOperationException("Not yet supported -> Change repository.xml to configure no of iterations.");
        }
        return super.createRepository(fixture);
    }

    private Credentials buildCredentials(Repository repository, Credentials credentials) throws RepositoryException {
        Credentials creds = "admin".equals(this.runAsUser) ? credentials : ("anonymous".equals(this.runAsUser) ? new GuestCredentials() : new SimpleCredentials(USER, USER.toCharArray()));
        if (this.runWithToken) {
            Configuration.setConfiguration(ConfigurationUtil.getJackrabbit2Configuration(ConfigurationParameters.EMPTY));
            if (creds instanceof SimpleCredentials) {
                SimpleCredentials sc = (SimpleCredentials)creds;
                sc.setAttribute(".token", "");
                repository.login(sc).logout();
                creds = new TokenCredentials(sc.getAttribute(".token").toString());
            } else {
                throw new UnsupportedOperationException();
            }
        }
        return creds;
    }
}

