/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.benchmark;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import javax.jcr.Credentials;
import javax.jcr.GuestCredentials;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import org.apache.commons.math.stat.descriptive.DescriptiveStatistics;
import org.apache.commons.math.stat.descriptive.SynchronizedDescriptiveStatistics;
import org.apache.jackrabbit.oak.benchmark.Benchmark;
import org.apache.jackrabbit.oak.benchmark.CSVResultGenerator;
import org.apache.jackrabbit.oak.benchmark.util.Profiler;
import org.apache.jackrabbit.oak.fixture.RepositoryFixture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractTest<T>
extends Benchmark
implements CSVResultGenerator {
    static final String TEST_ID = Integer.toHexString(new Random().nextInt());
    static AtomicInteger nodeNameCounter = new AtomicInteger();
    private static final Credentials CREDENTIALS = new SimpleCredentials("admin", "admin".toCharArray());
    private static final long WARMUP = TimeUnit.SECONDS.toMillis(Long.getLong("warmup", 5L));
    private static final long RUNTIME = TimeUnit.SECONDS.toMillis(Long.getLong("runtime", 60L));
    private static final boolean PROFILE = Boolean.getBoolean("profile");
    private static final Logger LOG = LoggerFactory.getLogger(AbstractTest.class);
    private Repository repository;
    private Credentials credentials;
    private List<Session> sessions;
    private List<Thread> threads;
    private volatile boolean running;
    private Profiler profiler;
    private PrintStream out;
    private boolean haltRequested;

    AbstractTest() {
    }

    static String nextNodeName() {
        return "n" + Integer.toHexString(nodeNameCounter.getAndIncrement());
    }

    protected void issueHaltRequest(@Nullable String message) {
        String m = message == null ? "" : message;
        LOG.info("halt requested. {}", (Object)m);
        this.haltRequested = true;
    }

    protected void issueHaltChildThreads() {
    }

    @Override
    public void setPrintStream(PrintStream out) {
        this.out = out;
    }

    protected static int getScale(int def) {
        int scale = Integer.getInteger("scale", 0);
        if (scale == 0) {
            scale = def;
        }
        return scale;
    }

    public void setUp(Repository repository, Credentials credentials) throws Exception {
        this.repository = repository;
        this.credentials = credentials;
        this.sessions = new LinkedList<Session>();
        this.threads = new LinkedList<Thread>();
        this.running = true;
        this.haltRequested = false;
        this.beforeSuite();
        if (PROFILE) {
            this.profiler = new Profiler().startCollecting();
        }
    }

    @Override
    public void run(Iterable<RepositoryFixture> fixtures) {
        this.run(fixtures, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(Iterable<RepositoryFixture> fixtures, List<Integer> concurrencyLevels) {
        System.out.format("# %-26.26s       C     min     10%%     50%%     90%%     max       N%n", this.toString());
        if (this.out != null) {
            this.out.format("# %-26.26s,      C,    min,    10%%,    50%%,    90%%,    max,      N%n", this.toString());
        }
        for (RepositoryFixture fixture : fixtures) {
            try {
                Repository[] cluster = this.createRepository(fixture);
                try {
                    this.runTest(fixture, cluster[0], concurrencyLevels);
                }
                finally {
                    fixture.tearDownCluster();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTest(RepositoryFixture fixture, Repository repository, List<Integer> concurrencyLevels) throws Exception {
        this.setUp(repository, CREDENTIALS);
        try {
            long warmupEnd = System.currentTimeMillis() + WARMUP;
            boolean stop = false;
            while (System.currentTimeMillis() < warmupEnd && !stop) {
                if (!stop) {
                    stop = this.haltRequested;
                }
                this.execute();
            }
            if (concurrencyLevels == null || concurrencyLevels.isEmpty()) {
                concurrencyLevels = Arrays.asList(1);
            }
            for (Integer concurrency : concurrencyLevels) {
                DescriptiveStatistics statistics = this.runTest(concurrency);
                if (statistics.getN() <= 0L) continue;
                System.out.format("%-28.28s  %6d  %6.0f  %6.0f  %6.0f  %6.0f  %6.0f  %6d%n", fixture.toString(), concurrency, statistics.getMin(), statistics.getPercentile(10.0), statistics.getPercentile(50.0), statistics.getPercentile(90.0), statistics.getMax(), statistics.getN());
                if (this.out == null) continue;
                this.out.format("%-28.28s, %6d, %6.0f, %6.0f, %6.0f, %6.0f, %6.0f, %6d%n", fixture.toString(), concurrency, statistics.getMin(), statistics.getPercentile(10.0), statistics.getPercentile(50.0), statistics.getPercentile(90.0), statistics.getMax(), statistics.getN());
            }
        }
        finally {
            this.tearDown();
        }
    }

    private DescriptiveStatistics runTest(int concurrencyLevel) throws Exception {
        SynchronizedDescriptiveStatistics statistics = new SynchronizedDescriptiveStatistics();
        if (concurrencyLevel == 1) {
            boolean bl;
            long runtimeEnd = System.currentTimeMillis() + RUNTIME;
            boolean bl2 = false;
            while (System.currentTimeMillis() < runtimeEnd && !bl) {
                if (!bl) {
                    bl = this.haltRequested;
                }
                statistics.addValue(this.execute());
            }
        } else {
            LinkedList<Executor> threads = new LinkedList<Executor>();
            for (int n = 0; n < concurrencyLevel; ++n) {
                threads.add(new Executor("Background job " + n, statistics));
            }
            for (Thread thread : threads) {
                thread.start();
            }
            long runtimeEnd = System.currentTimeMillis() + RUNTIME;
            while (System.currentTimeMillis() < runtimeEnd) {
                Thread.sleep(runtimeEnd - System.currentTimeMillis());
            }
            for (Executor e : threads) {
                e.running = false;
            }
            for (Executor e : threads) {
                e.join();
            }
        }
        return statistics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long execute() throws Exception {
        this.beforeTest();
        try {
            long start = System.currentTimeMillis();
            this.runTest();
            long l = System.currentTimeMillis() - start;
            return l;
        }
        finally {
            this.afterTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long execute(T executionContext) throws Exception {
        if (executionContext == null) {
            return this.execute();
        }
        this.beforeTest(executionContext);
        try {
            long start = System.currentTimeMillis();
            this.runTest(executionContext);
            long l = System.currentTimeMillis() - start;
            return l;
        }
        finally {
            this.afterTest(executionContext);
        }
    }

    public void tearDown() throws Exception {
        this.issueHaltChildThreads();
        this.running = false;
        for (Thread thread : this.threads) {
            thread.join();
        }
        if (this.profiler != null) {
            System.out.println(this.profiler.stopCollecting().getTop(5));
            this.profiler = null;
        }
        this.afterSuite();
        for (Session session : this.sessions) {
            if (!session.isLive()) continue;
            session.logout();
        }
        this.threads = null;
        this.sessions = null;
        this.credentials = null;
        this.repository = null;
    }

    protected void beforeSuite() throws Exception {
    }

    protected void beforeTest() throws Exception {
    }

    protected abstract void runTest() throws Exception;

    protected void afterTest() throws Exception {
    }

    protected void afterSuite() throws Exception {
    }

    protected T prepareThreadExecutionContext() {
        return null;
    }

    protected void disposeThreadExecutionContext(T context) {
    }

    protected void afterTest(T executionContext) {
    }

    protected void runTest(T executionContext) throws Exception {
        throw new IllegalStateException("If thread execution context is used then subclass must override this method");
    }

    protected void beforeTest(T executionContext) {
    }

    protected void failOnRepositoryVersions(String ... versions) throws RepositoryException {
        String repositoryVersion = this.repository.getDescriptor("jcr.repository.version");
        for (String version : versions) {
            if (!repositoryVersion.startsWith(version)) continue;
            throw new RepositoryException("Unable to run " + this.getClass().getName() + " on repository version " + version);
        }
    }

    protected Repository getRepository() {
        return this.repository;
    }

    protected Credentials getCredentials() {
        return this.credentials;
    }

    protected Session loginAnonymous() {
        return this.login(new GuestCredentials());
    }

    protected Session loginAdministrative() {
        return this.login(CREDENTIALS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Session login(Credentials credentials) {
        try {
            Session session = this.repository.login(credentials);
            List<Session> list = this.sessions;
            synchronized (list) {
                this.sessions.add(session);
            }
            return session;
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void logout(Session session) {
        if (session != null) {
            session.logout();
        }
        List<Session> list = this.sessions;
        synchronized (list) {
            this.sessions.remove(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Session loginWriter() {
        try {
            Session session = this.repository.login(this.credentials);
            List<Session> list = this.sessions;
            synchronized (list) {
                this.sessions.add(session);
            }
            return session;
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    protected void addBackgroundJob(final Runnable job) {
        Thread thread = new Thread("Background job " + job){

            @Override
            public void run() {
                while (AbstractTest.this.running) {
                    job.run();
                }
            }
        };
        thread.start();
        this.threads.add(thread);
    }

    protected Repository[] createRepository(RepositoryFixture fixture) throws Exception {
        return fixture.setUpCluster(1);
    }

    private class Executor
    extends Thread {
        private final SynchronizedDescriptiveStatistics statistics;
        private boolean running;

        private Executor(String name, SynchronizedDescriptiveStatistics statistics) {
            super(name);
            this.running = true;
            this.statistics = statistics;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Object context = AbstractTest.this.prepareThreadExecutionContext();
                try {
                    while (this.running) {
                        this.statistics.addValue(AbstractTest.this.execute(context));
                    }
                }
                finally {
                    AbstractTest.this.disposeThreadExecutionContext(context);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

