/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.benchmark;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.apache.commons.io.FileUtils;
import org.apache.jackrabbit.oak.benchmark.Benchmark;
import org.apache.jackrabbit.oak.benchmark.CSVResultGenerator;
import org.apache.jackrabbit.oak.benchmark.CompositeAuthorizationTest;
import org.apache.jackrabbit.oak.benchmark.ConcurrentCreateNodesTest;
import org.apache.jackrabbit.oak.benchmark.ConcurrentEveryoneACLTest;
import org.apache.jackrabbit.oak.benchmark.ConcurrentFileWriteTest;
import org.apache.jackrabbit.oak.benchmark.ConcurrentHasPermissionTest;
import org.apache.jackrabbit.oak.benchmark.ConcurrentHasPermissionTest2;
import org.apache.jackrabbit.oak.benchmark.ConcurrentReadAccessControlledTreeTest;
import org.apache.jackrabbit.oak.benchmark.ConcurrentReadAccessControlledTreeTest2;
import org.apache.jackrabbit.oak.benchmark.ConcurrentReadDeepTreeTest;
import org.apache.jackrabbit.oak.benchmark.ConcurrentReadRandomNodeAndItsPropertiesTest;
import org.apache.jackrabbit.oak.benchmark.ConcurrentReadSinglePolicyTreeTest;
import org.apache.jackrabbit.oak.benchmark.ConcurrentReadTest;
import org.apache.jackrabbit.oak.benchmark.ConcurrentReadWriteTest;
import org.apache.jackrabbit.oak.benchmark.ConcurrentTraversalTest;
import org.apache.jackrabbit.oak.benchmark.ConcurrentWriteACLTest;
import org.apache.jackrabbit.oak.benchmark.ConcurrentWriteReadTest;
import org.apache.jackrabbit.oak.benchmark.ConcurrentWriteTest;
import org.apache.jackrabbit.oak.benchmark.ContinuousRevisionGCTest;
import org.apache.jackrabbit.oak.benchmark.CreateManyChildNodesTest;
import org.apache.jackrabbit.oak.benchmark.CreateManyIndexedNodesTest;
import org.apache.jackrabbit.oak.benchmark.CreateManyNodesTest;
import org.apache.jackrabbit.oak.benchmark.CreateNodesBenchmark;
import org.apache.jackrabbit.oak.benchmark.CugOakTest;
import org.apache.jackrabbit.oak.benchmark.CugTest;
import org.apache.jackrabbit.oak.benchmark.DescendantSearchTest;
import org.apache.jackrabbit.oak.benchmark.FindAuthorizableWithScopeTest;
import org.apache.jackrabbit.oak.benchmark.FlatTreeUpdateTest;
import org.apache.jackrabbit.oak.benchmark.FlatTreeWithAceForSamePrincipalTest;
import org.apache.jackrabbit.oak.benchmark.FullTextSearchTest;
import org.apache.jackrabbit.oak.benchmark.FullTextSolrSearchTest;
import org.apache.jackrabbit.oak.benchmark.GetAuthorizableByIdTest;
import org.apache.jackrabbit.oak.benchmark.GetAuthorizableByPrincipalTest;
import org.apache.jackrabbit.oak.benchmark.GetDeepNodeTest;
import org.apache.jackrabbit.oak.benchmark.GetGroupPrincipalsTest;
import org.apache.jackrabbit.oak.benchmark.GetNodeTest;
import org.apache.jackrabbit.oak.benchmark.GetPoliciesTest;
import org.apache.jackrabbit.oak.benchmark.GetPrincipalTest;
import org.apache.jackrabbit.oak.benchmark.LoginGetRootLogoutTest;
import org.apache.jackrabbit.oak.benchmark.LoginImpersonateTest;
import org.apache.jackrabbit.oak.benchmark.LoginLogoutTest;
import org.apache.jackrabbit.oak.benchmark.LoginSystemTest;
import org.apache.jackrabbit.oak.benchmark.LoginTest;
import org.apache.jackrabbit.oak.benchmark.LoginWithMembersTest;
import org.apache.jackrabbit.oak.benchmark.LoginWithMembershipTest;
import org.apache.jackrabbit.oak.benchmark.LucenePropertyFTSeparated;
import org.apache.jackrabbit.oak.benchmark.LucenePropertyFullTextTest;
import org.apache.jackrabbit.oak.benchmark.ManyGroupMembersTest;
import org.apache.jackrabbit.oak.benchmark.ManyNodes;
import org.apache.jackrabbit.oak.benchmark.ManyUserReadTest;
import org.apache.jackrabbit.oak.benchmark.NamespaceRegistryTest;
import org.apache.jackrabbit.oak.benchmark.NamespaceTest;
import org.apache.jackrabbit.oak.benchmark.ObservationTest;
import org.apache.jackrabbit.oak.benchmark.OrderedIndexInsertNoIndexTest;
import org.apache.jackrabbit.oak.benchmark.OrderedIndexInsertOrderedPropertyTest;
import org.apache.jackrabbit.oak.benchmark.OrderedIndexInsertStandardPropertyTest;
import org.apache.jackrabbit.oak.benchmark.OrderedIndexQueryNoIndexTest;
import org.apache.jackrabbit.oak.benchmark.OrderedIndexQueryOrderedIndexTest;
import org.apache.jackrabbit.oak.benchmark.OrderedIndexQueryStandardIndexTest;
import org.apache.jackrabbit.oak.benchmark.ReadDeepTreeTest;
import org.apache.jackrabbit.oak.benchmark.ReadManyTest;
import org.apache.jackrabbit.oak.benchmark.ReadPropertyTest;
import org.apache.jackrabbit.oak.benchmark.ReplicaCrashResilienceTest;
import org.apache.jackrabbit.oak.benchmark.RepositoryGrowthTest;
import org.apache.jackrabbit.oak.benchmark.RevisionGCTest;
import org.apache.jackrabbit.oak.benchmark.SQL2DescendantSearchTest;
import org.apache.jackrabbit.oak.benchmark.SQL2SearchTest;
import org.apache.jackrabbit.oak.benchmark.SequentialCreateNodesTest;
import org.apache.jackrabbit.oak.benchmark.SetMultiPropertyTest;
import org.apache.jackrabbit.oak.benchmark.SetPropertyTest;
import org.apache.jackrabbit.oak.benchmark.SimpleSearchTest;
import org.apache.jackrabbit.oak.benchmark.SmallFileReadTest;
import org.apache.jackrabbit.oak.benchmark.SmallFileWriteTest;
import org.apache.jackrabbit.oak.benchmark.TransientManyChildNodesTest;
import org.apache.jackrabbit.oak.benchmark.UUIDLookupTest;
import org.apache.jackrabbit.oak.benchmark.UpdateManyChildNodesTest;
import org.apache.jackrabbit.oak.benchmark.XmlImportTest;
import org.apache.jackrabbit.oak.benchmark.wikipedia.WikipediaImport;
import org.apache.jackrabbit.oak.fixture.JackrabbitRepositoryFixture;
import org.apache.jackrabbit.oak.fixture.OakFixture;
import org.apache.jackrabbit.oak.fixture.OakRepositoryFixture;
import org.apache.jackrabbit.oak.fixture.RepositoryFixture;

public class BenchmarkRunner {
    private static final int MB = 0x100000;

    public static void main(String[] args) throws Exception {
        String uri;
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec<File> base = parser.accepts("base", "Base directory").withRequiredArg().ofType(File.class).defaultsTo(new File("target"), (File[])new File[0]);
        ArgumentAcceptingOptionSpec<String> host = parser.accepts("host", "MongoDB host").withRequiredArg().defaultsTo("localhost", (String[])new String[0]);
        ArgumentAcceptingOptionSpec<Integer> port = parser.accepts("port", "MongoDB port").withRequiredArg().ofType(Integer.class).defaultsTo(27017, (Integer[])new Integer[0]);
        ArgumentAcceptingOptionSpec<String> dbName = parser.accepts("db", "MongoDB database").withRequiredArg();
        ArgumentAcceptingOptionSpec<String> mongouri = parser.accepts("mongouri", "MongoDB URI").withRequiredArg();
        ArgumentAcceptingOptionSpec<Boolean> dropDBAfterTest = parser.accepts("dropDBAfterTest", "Whether to drop the MongoDB database after the test").withOptionalArg().ofType(Boolean.class).defaultsTo(true, (Boolean[])new Boolean[0]);
        ArgumentAcceptingOptionSpec<String> rdbjdbcuri = parser.accepts("rdbjdbcuri", "RDB JDBC URI").withOptionalArg().defaultsTo("jdbc:h2:target/benchmark", (String[])new String[0]);
        ArgumentAcceptingOptionSpec<String> rdbjdbcuser = parser.accepts("rdbjdbcuser", "RDB JDBC user").withOptionalArg().defaultsTo("", (String[])new String[0]);
        ArgumentAcceptingOptionSpec<String> rdbjdbcpasswd = parser.accepts("rdbjdbcpasswd", "RDB JDBC password").withOptionalArg().defaultsTo("", (String[])new String[0]);
        ArgumentAcceptingOptionSpec<String> rdbjdbctableprefix = parser.accepts("rdbjdbctableprefix", "RDB JDBC table prefix").withOptionalArg().defaultsTo("", (String[])new String[0]);
        ArgumentAcceptingOptionSpec<Boolean> mmap = parser.accepts("mmap", "TarMK memory mapping").withOptionalArg().ofType(Boolean.class).defaultsTo("64".equals(System.getProperty("sun.arch.data.model")), (Boolean[])new Boolean[0]);
        ArgumentAcceptingOptionSpec<Integer> cache = parser.accepts("cache", "cache size (MB)").withRequiredArg().ofType(Integer.class).defaultsTo(100, (Integer[])new Integer[0]);
        ArgumentAcceptingOptionSpec<Integer> fdsCache = parser.accepts("blobCache", "cache size (MB)").withRequiredArg().ofType(Integer.class).defaultsTo(32, (Integer[])new Integer[0]);
        ArgumentAcceptingOptionSpec<File> wikipedia = parser.accepts("wikipedia", "Wikipedia dump").withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec<Boolean> luceneIndexOnFS = parser.accepts("luceneIndexOnFS", "Store Lucene index on file system").withOptionalArg().ofType(Boolean.class).defaultsTo(false, (Boolean[])new Boolean[0]);
        ArgumentAcceptingOptionSpec<Boolean> withStorage = parser.accepts("storage", "Index storage enabled").withOptionalArg().ofType(Boolean.class);
        ArgumentAcceptingOptionSpec<String> withServer = parser.accepts("server", "Solr server host").withOptionalArg().ofType(String.class);
        ArgumentAcceptingOptionSpec<Boolean> runAsAdmin = parser.accepts("runAsAdmin", "Run test using admin session").withRequiredArg().ofType(Boolean.class).defaultsTo(Boolean.FALSE, (Boolean[])new Boolean[0]);
        ArgumentAcceptingOptionSpec<String> runAsUser = parser.accepts("runAsUser", "Run test using admin, anonymous or a test user").withOptionalArg().ofType(String.class).defaultsTo("admin", (String[])new String[0]);
        ArgumentAcceptingOptionSpec<Boolean> runWithToken = parser.accepts("runWithToken", "Run test using a login token vs. simplecredentials").withOptionalArg().ofType(Boolean.class).defaultsTo(Boolean.FALSE, (Boolean[])new Boolean[0]);
        ArgumentAcceptingOptionSpec<Integer> noIterations = parser.accepts("noIterations", "Change default 'passwordHashIterations' parameter.").withOptionalArg().ofType(Integer.class).defaultsTo(-1, (Integer[])new Integer[0]);
        ArgumentAcceptingOptionSpec<Long> expiration = parser.accepts("expiration", "Expiration time (e.g. principal cache.").withOptionalArg().ofType(Long.class).defaultsTo(-1L, (Long[])new Long[0]);
        ArgumentAcceptingOptionSpec<Integer> numberOfGroups = parser.accepts("numberOfGroups", "Number of groups to create.").withOptionalArg().ofType(Integer.class).defaultsTo(10, (Integer[])new Integer[0]);
        ArgumentAcceptingOptionSpec<Boolean> nestedGroups = parser.accepts("nestedGroups", "Use nested groups.").withOptionalArg().ofType(Boolean.class).defaultsTo(false, (Boolean[])new Boolean[0]);
        ArgumentAcceptingOptionSpec<Integer> batchSize = parser.accepts("batchSize", "Batch size before persisting operations.").withOptionalArg().ofType(Integer.class).defaultsTo(1, (Integer[])new Integer[0]);
        ArgumentAcceptingOptionSpec<String> importBehavior = parser.accepts("importBehavior", "Protected Item Import Behavior").withOptionalArg().ofType(String.class).defaultsTo("besteffort", (String[])new String[0]);
        ArgumentAcceptingOptionSpec<Integer> itemsToRead = parser.accepts("itemsToRead", "Number of items to read").withRequiredArg().ofType(Integer.class).defaultsTo(1000, (Integer[])new Integer[0]);
        ArgumentAcceptingOptionSpec<Integer> concurrency = parser.accepts("concurrency", "Number of test threads.").withRequiredArg().ofType(Integer.class).withValuesSeparatedBy(',');
        ArgumentAcceptingOptionSpec<Boolean> report = parser.accepts("report", "Whether to output intermediate results").withOptionalArg().ofType(Boolean.class).defaultsTo(Boolean.FALSE, (Boolean[])new Boolean[0]);
        ArgumentAcceptingOptionSpec<Boolean> randomUser = parser.accepts("randomUser", "Whether to use a random user to read.").withOptionalArg().ofType(Boolean.class).defaultsTo(Boolean.FALSE, (Boolean[])new Boolean[0]);
        ArgumentAcceptingOptionSpec<File> csvFile = parser.accepts("csvFile", "File to write a CSV version of the benchmark data.").withOptionalArg().ofType(File.class);
        ArgumentAcceptingOptionSpec<Boolean> flatStructure = parser.accepts("flatStructure", "Whether the test should use a flat structure or not.").withOptionalArg().ofType(Boolean.class).defaultsTo(Boolean.FALSE, (Boolean[])new Boolean[0]);
        ArgumentAcceptingOptionSpec<Integer> numberOfUsers = parser.accepts("numberOfUsers").withOptionalArg().ofType(Integer.class).defaultsTo(10000, (Integer[])new Integer[0]);
        ArgumentAcceptingOptionSpec<Boolean> setScope = parser.accepts("setScope", "Whether to use include setScope in the user query.").withOptionalArg().ofType(Boolean.class).defaultsTo(Boolean.FALSE, (Boolean[])new Boolean[0]);
        ArgumentAcceptingOptionSpec<Boolean> reverseOrder = parser.accepts("reverseOrder", "Invert order of configurations in composite setup.").withOptionalArg().ofType(Boolean.class).defaultsTo(Boolean.FALSE, (Boolean[])new Boolean[0]);
        ArgumentAcceptingOptionSpec<String> supportedPaths = parser.accepts("supportedPaths", "Supported paths in composite setup.").withOptionalArg().ofType(String.class).withValuesSeparatedBy(',');
        NonOptionArgumentSpec<String> nonOption = parser.nonOptions();
        AbstractOptionSpec help = parser.acceptsAll(Arrays.asList("h", "?", "help"), "show help").forHelp();
        OptionSet options = parser.parse(args);
        if (options.has(help)) {
            parser.printHelpOn(System.out);
            System.exit(0);
        }
        if ((uri = (String)mongouri.value(options)) == null) {
            String db = (String)dbName.value(options);
            if (db == null) {
                db = OakFixture.getUniqueDatabaseName("Oak-Mongo");
            }
            uri = "mongodb://" + (String)host.value(options) + ":" + port.value(options) + "/" + db;
        }
        int cacheSize = (Integer)cache.value(options);
        RepositoryFixture[] allFixtures = new RepositoryFixture[]{new JackrabbitRepositoryFixture((File)base.value(options), cacheSize), OakRepositoryFixture.getMemoryNS(cacheSize * 0x100000), OakRepositoryFixture.getMongo(uri, (Boolean)dropDBAfterTest.value(options), cacheSize * 0x100000), OakRepositoryFixture.getMongoWithFDS(uri, (Boolean)dropDBAfterTest.value(options), cacheSize * 0x100000, (File)base.value(options), (Integer)fdsCache.value(options)), OakRepositoryFixture.getMongoNS(uri, (Boolean)dropDBAfterTest.value(options), cacheSize * 0x100000), OakRepositoryFixture.getTar((File)base.value(options), 256, cacheSize, (Boolean)mmap.value(options)), OakRepositoryFixture.getTarWithBlobStore((File)base.value(options), 256, cacheSize, (Boolean)mmap.value(options)), OakRepositoryFixture.getRDB((String)rdbjdbcuri.value(options), (String)rdbjdbcuser.value(options), (String)rdbjdbcpasswd.value(options), (String)rdbjdbctableprefix.value(options), (Boolean)dropDBAfterTest.value(options), cacheSize * 0x100000)};
        OakRepositoryFixture.getRDBWithFDS((String)rdbjdbcuri.value(options), (String)rdbjdbcuser.value(options), (String)rdbjdbcpasswd.value(options), (String)rdbjdbctableprefix.value(options), (Boolean)dropDBAfterTest.value(options), cacheSize * 0x100000, (File)base.value(options), (Integer)fdsCache.value(options));
        Benchmark[] allBenchmarks = new Benchmark[]{new OrderedIndexQueryOrderedIndexTest(), new OrderedIndexQueryStandardIndexTest(), new OrderedIndexQueryNoIndexTest(), new OrderedIndexInsertOrderedPropertyTest(), new OrderedIndexInsertStandardPropertyTest(), new OrderedIndexInsertNoIndexTest(), new LoginTest((String)runAsUser.value(options), (Boolean)runWithToken.value(options), (Integer)noIterations.value(options)), new LoginLogoutTest((String)runAsUser.value(options), (Boolean)runWithToken.value(options), (Integer)noIterations.value(options)), new LoginGetRootLogoutTest((String)runAsUser.value(options), (Boolean)runWithToken.value(options), (Integer)noIterations.value(options)), new LoginSystemTest(), new LoginImpersonateTest(), new LoginWithMembershipTest((Boolean)runWithToken.value(options), (Integer)noIterations.value(options), (Integer)numberOfGroups.value(options), (Boolean)nestedGroups.value(options), (Long)expiration.value(options)), new LoginWithMembersTest((Boolean)runWithToken.value(options), (Integer)noIterations.value(options), (int)((Integer)numberOfGroups.value(options)), (long)((Long)expiration.value(options))), new NamespaceTest(), new NamespaceRegistryTest(), new ReadPropertyTest(), GetNodeTest.withAdmin(), GetNodeTest.withAnonymous(), new GetDeepNodeTest(), new SetPropertyTest(), new SetMultiPropertyTest(), new SmallFileReadTest(), new SmallFileWriteTest(), new ConcurrentReadTest(), new ConcurrentReadWriteTest(), new ConcurrentWriteReadTest(), new ConcurrentWriteTest(), new SimpleSearchTest(), new UUIDLookupTest(), new SQL2SearchTest(), new DescendantSearchTest(), new SQL2DescendantSearchTest(), new FlatTreeUpdateTest(), new CreateManyChildNodesTest(), new CreateManyNodesTest(), new UpdateManyChildNodesTest(), new TransientManyChildNodesTest(), new WikipediaImport((File)wikipedia.value(options), (Boolean)flatStructure.value(options), (Boolean)report.value(options)), new RepositoryGrowthTest((File)wikipedia.value(options), (File)base.value(options), (boolean)((Boolean)luceneIndexOnFS.value(options))), new CreateNodesBenchmark(), new ManyNodes(), new ObservationTest(), new RevisionGCTest(), new ContinuousRevisionGCTest(), new XmlImportTest(), new FlatTreeWithAceForSamePrincipalTest(), new ReadDeepTreeTest((Boolean)runAsAdmin.value(options), (Integer)itemsToRead.value(options), (Boolean)report.value(options)), new CompositeAuthorizationTest((Boolean)runAsAdmin.value(options), (Integer)itemsToRead.value(options)), new CugTest((Boolean)runAsAdmin.value(options), (Integer)itemsToRead.value(options), (Boolean)randomUser.value(options), supportedPaths.values(options), (Boolean)reverseOrder.value(options)), new CugOakTest((Boolean)runAsAdmin.value(options), (Integer)itemsToRead.value(options), (Boolean)randomUser.value(options), supportedPaths.values(options), (Boolean)reverseOrder.value(options)), new ConcurrentReadDeepTreeTest((Boolean)runAsAdmin.value(options), (Integer)itemsToRead.value(options), (Boolean)report.value(options)), new ConcurrentReadSinglePolicyTreeTest((Boolean)runAsAdmin.value(options), (Integer)itemsToRead.value(options), (Boolean)report.value(options)), new ConcurrentReadAccessControlledTreeTest((Boolean)runAsAdmin.value(options), (Integer)itemsToRead.value(options), (Boolean)report.value(options)), new ConcurrentReadAccessControlledTreeTest2((Boolean)runAsAdmin.value(options), (Integer)itemsToRead.value(options), (Boolean)report.value(options)), new ConcurrentReadRandomNodeAndItsPropertiesTest((Boolean)runAsAdmin.value(options), (Integer)itemsToRead.value(options), (Boolean)report.value(options)), new ConcurrentHasPermissionTest((Boolean)runAsAdmin.value(options), (Integer)itemsToRead.value(options), (Boolean)report.value(options)), new ConcurrentHasPermissionTest2((Boolean)runAsAdmin.value(options), (Integer)itemsToRead.value(options), (Boolean)report.value(options)), new ManyUserReadTest((Boolean)runAsAdmin.value(options), (Integer)itemsToRead.value(options), (Boolean)report.value(options), (Boolean)randomUser.value(options)), new ConcurrentTraversalTest((Boolean)runAsAdmin.value(options), (Integer)itemsToRead.value(options), (Boolean)report.value(options), (Boolean)randomUser.value(options)), new ConcurrentWriteACLTest((Integer)itemsToRead.value(options)), new ConcurrentEveryoneACLTest((Boolean)runAsAdmin.value(options), (Integer)itemsToRead.value(options)), ReadManyTest.linear("LinearReadEmpty", 1, ReadManyTest.EMPTY), ReadManyTest.linear("LinearReadFiles", 1, ReadManyTest.FILES), ReadManyTest.linear("LinearReadNodes", 1, ReadManyTest.NODES), ReadManyTest.uniform("UniformReadEmpty", 1, ReadManyTest.EMPTY), ReadManyTest.uniform("UniformReadFiles", 1, ReadManyTest.FILES), ReadManyTest.uniform("UniformReadNodes", 1, ReadManyTest.NODES), new ConcurrentCreateNodesTest(), new SequentialCreateNodesTest(), new CreateManyIndexedNodesTest(), new GetPoliciesTest(), new ConcurrentFileWriteTest(), new GetAuthorizableByIdTest((Integer)numberOfUsers.value(options), (Boolean)flatStructure.value(options)), new GetAuthorizableByPrincipalTest((Integer)numberOfUsers.value(options), (Boolean)flatStructure.value(options)), new GetPrincipalTest((Integer)numberOfUsers.value(options), (Boolean)flatStructure.value(options)), new GetGroupPrincipalsTest((Integer)numberOfGroups.value(options), (Boolean)nestedGroups.value(options)), new ManyGroupMembersTest((Integer)numberOfUsers.value(options), (Integer)batchSize.value(options), (String)importBehavior.value(options)), new FullTextSearchTest((File)wikipedia.value(options), (Boolean)flatStructure.value(options), (Boolean)report.value(options), (Boolean)withStorage.value(options)), new FullTextSolrSearchTest((File)wikipedia.value(options), (Boolean)flatStructure.value(options), (Boolean)report.value(options), (Boolean)withStorage.value(options), (String)withServer.value(options)), new FindAuthorizableWithScopeTest(((Integer)numberOfUsers.value(options)).intValue(), (Boolean)setScope.value(options)), new LucenePropertyFullTextTest((File)wikipedia.value(options), (Boolean)flatStructure.value(options), (Boolean)report.value(options), (Boolean)withStorage.value(options)), new LucenePropertyFTSeparated((File)wikipedia.value(options), (Boolean)flatStructure.value(options), (Boolean)report.value(options), (Boolean)withStorage.value(options)), new ReplicaCrashResilienceTest()};
        HashSet argset = Sets.newHashSet(nonOption.values(options));
        ArrayList<RepositoryFixture> fixtures = Lists.newArrayList();
        for (RepositoryFixture fixture : allFixtures) {
            if (!argset.remove(fixture.toString())) continue;
            fixtures.add(fixture);
        }
        if (fixtures.isEmpty()) {
            System.err.println("Warning: no repository fixtures specified, supported fixtures are: " + BenchmarkRunner.asSortedString(Arrays.asList(allFixtures)));
        }
        ArrayList<Benchmark> benchmarks = Lists.newArrayList();
        for (Benchmark benchmark : allBenchmarks) {
            if (!argset.remove(benchmark.toString())) continue;
            benchmarks.add(benchmark);
        }
        if (benchmarks.isEmpty()) {
            System.err.println("Warning: no benchmarks specified, supported benchmarks are: " + BenchmarkRunner.asSortedString(Arrays.asList(allBenchmarks)));
        }
        if (argset.isEmpty()) {
            PrintStream out = null;
            if (options.has(csvFile)) {
                out = new PrintStream(FileUtils.openOutputStream((File)csvFile.value(options), true));
            }
            for (Benchmark benchmark : benchmarks) {
                if (benchmark instanceof CSVResultGenerator) {
                    ((CSVResultGenerator)((Object)benchmark)).setPrintStream(out);
                }
                benchmark.run(fixtures, options.valuesOf(concurrency));
            }
            if (out != null) {
                out.close();
            }
        } else {
            System.err.println("Unknown arguments: " + argset);
        }
    }

    private static String asSortedString(List<?> in) {
        ArrayList<String> tmp = new ArrayList<String>();
        for (Object o : in) {
            tmp.add(o.toString());
        }
        Collections.sort(tmp);
        return ((Object)tmp).toString();
    }
}

