/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.benchmark;

import com.google.common.base.Preconditions;
import java.security.Principal;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.jcr.Repository;
import javax.jcr.security.AccessControlManager;
import org.apache.jackrabbit.oak.Oak;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.benchmark.ReadDeepTreeTest;
import org.apache.jackrabbit.oak.fixture.JcrCreator;
import org.apache.jackrabbit.oak.fixture.OakRepositoryFixture;
import org.apache.jackrabbit.oak.fixture.RepositoryFixture;
import org.apache.jackrabbit.oak.jcr.Jcr;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.tree.RootFactory;
import org.apache.jackrabbit.oak.plugins.tree.TreeLocation;
import org.apache.jackrabbit.oak.plugins.tree.TreeType;
import org.apache.jackrabbit.oak.security.SecurityProviderImpl;
import org.apache.jackrabbit.oak.security.authorization.composite.CompositeAuthorizationConfiguration;
import org.apache.jackrabbit.oak.spi.commit.CommitHook;
import org.apache.jackrabbit.oak.spi.commit.MoveTracker;
import org.apache.jackrabbit.oak.spi.commit.ValidatorProvider;
import org.apache.jackrabbit.oak.spi.lifecycle.RepositoryInitializer;
import org.apache.jackrabbit.oak.spi.lifecycle.WorkspaceInitializer;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.Context;
import org.apache.jackrabbit.oak.spi.security.authorization.AuthorizationConfiguration;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.AggregatedPermissionProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.PermissionProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.RepositoryPermission;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.TreePermission;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionProvider;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeBits;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeBitsProvider;
import org.apache.jackrabbit.oak.spi.xml.ProtectedItemImporter;

public class CompositeAuthorizationTest
extends ReadDeepTreeTest {
    private int cnt;

    protected CompositeAuthorizationTest(boolean runAsAdmin, int cntConfigurations) {
        super(runAsAdmin, 1000, false);
        this.cnt = cntConfigurations;
    }

    @Override
    protected Repository[] createRepository(RepositoryFixture fixture) throws Exception {
        if (fixture instanceof OakRepositoryFixture) {
            return ((OakRepositoryFixture)fixture).setUpCluster(1, new JcrCreator(){

                @Override
                public Jcr customize(Oak oak) {
                    return new Jcr(oak).with(new TmpSecurityProvider(CompositeAuthorizationTest.this.cnt));
                }
            });
        }
        return super.createRepository(fixture);
    }

    private static final class TmpPermissionProvider
    implements AggregatedPermissionProvider {
        private static final String POLICY_NAME = "customPolicy";
        private Root root;
        private Root immutableRoot;

        private TmpPermissionProvider(Root root) {
            this.root = root;
            this.immutableRoot = RootFactory.createReadOnlyRoot(root);
        }

        @Override
        public void refresh() {
            this.immutableRoot = RootFactory.createReadOnlyRoot(this.root);
        }

        @Override
        @Nonnull
        public Set<String> getPrivileges(@Nullable Tree tree) {
            this.performSomeRead(tree);
            return Collections.singleton("jcr:all");
        }

        @Override
        public boolean hasPrivileges(@Nullable Tree tree, String ... privilegeNames) {
            this.performSomeRead(tree);
            return true;
        }

        @Override
        @Nonnull
        public RepositoryPermission getRepositoryPermission() {
            return RepositoryPermission.ALL;
        }

        @Override
        @Nonnull
        public TreePermission getTreePermission(@Nonnull Tree tree, @Nonnull TreePermission parentPermission) {
            this.performSomeRead(tree);
            return TreePermission.ALL;
        }

        @Override
        public boolean isGranted(@Nonnull Tree tree, @Nullable PropertyState property, long permissions) {
            this.performSomeRead(tree);
            return true;
        }

        @Override
        public boolean isGranted(@Nonnull String oakPath, @Nonnull String jcrActions) {
            this.performSomeRead(this.immutableRoot.getTree(oakPath));
            return true;
        }

        private void performSomeRead(@Nullable Tree tree) {
        }

        @Override
        @Nonnull
        public PrivilegeBits supportedPrivileges(@Nullable Tree tree, @Nullable PrivilegeBits privilegeBits) {
            return privilegeBits != null ? privilegeBits : new PrivilegeBitsProvider(this.immutableRoot).getBits("jcr:all");
        }

        @Override
        public long supportedPermissions(@Nullable Tree tree, @Nullable PropertyState property, long permissions) {
            return permissions;
        }

        @Override
        public long supportedPermissions(@Nonnull TreeLocation location, long permissions) {
            return permissions;
        }

        @Override
        public long supportedPermissions(@Nonnull TreePermission treePermission, @Nullable PropertyState property, long permissions) {
            return permissions;
        }

        @Override
        public boolean isGranted(@Nonnull TreeLocation location, long permissions) {
            return true;
        }

        @Override
        @Nonnull
        public TreePermission getTreePermission(@Nonnull Tree tree, @Nonnull TreeType type, @Nonnull TreePermission parentPermission) {
            return this.getTreePermission(tree, parentPermission);
        }
    }

    private static final class TmpAuthorizationConfig
    implements AuthorizationConfiguration {
        private final AuthorizationConfiguration defConfig;

        private TmpAuthorizationConfig(@Nonnull AuthorizationConfiguration defConfig) {
            this.defConfig = defConfig;
        }

        @Override
        @Nonnull
        public AccessControlManager getAccessControlManager(@Nonnull Root root, @Nonnull NamePathMapper namePathMapper) {
            return this.defConfig.getAccessControlManager(root, namePathMapper);
        }

        @Override
        @Nonnull
        public RestrictionProvider getRestrictionProvider() {
            return this.defConfig.getRestrictionProvider();
        }

        @Override
        @Nonnull
        public PermissionProvider getPermissionProvider(@Nonnull Root root, @Nonnull String workspaceName, @Nonnull Set<Principal> principals) {
            return new TmpPermissionProvider(root);
        }

        @Override
        @Nonnull
        public String getName() {
            return this.defConfig.getName();
        }

        @Override
        @Nonnull
        public ConfigurationParameters getParameters() {
            return this.defConfig.getParameters();
        }

        @Override
        @Nonnull
        public WorkspaceInitializer getWorkspaceInitializer() {
            return WorkspaceInitializer.DEFAULT;
        }

        @Override
        @Nonnull
        public RepositoryInitializer getRepositoryInitializer() {
            return RepositoryInitializer.DEFAULT;
        }

        @Override
        @Nonnull
        public List<? extends CommitHook> getCommitHooks(@Nonnull String workspaceName) {
            return Collections.EMPTY_LIST;
        }

        @Override
        @Nonnull
        public List<? extends ValidatorProvider> getValidators(@Nonnull String workspaceName, @Nonnull Set<Principal> principals, @Nonnull MoveTracker moveTracker) {
            return Collections.EMPTY_LIST;
        }

        @Override
        @Nonnull
        public List<ProtectedItemImporter> getProtectedItemImporters() {
            return Collections.EMPTY_LIST;
        }

        @Override
        @Nonnull
        public Context getContext() {
            return this.defConfig.getContext();
        }
    }

    private static final class TmpSecurityProvider
    extends SecurityProviderImpl {
        private TmpSecurityProvider(int cnt) {
            AuthorizationConfiguration authorizationConfiguration = this.getConfiguration(AuthorizationConfiguration.class);
            if (!(authorizationConfiguration instanceof CompositeAuthorizationConfiguration)) {
                throw new IllegalStateException();
            }
            AuthorizationConfiguration defConfig = (AuthorizationConfiguration)Preconditions.checkNotNull(((CompositeAuthorizationConfiguration)authorizationConfiguration).getDefaultConfig());
            for (int i = 0; i < cnt; ++i) {
                this.bindAuthorizationConfiguration(new TmpAuthorizationConfig(defConfig));
            }
            this.bindAuthorizationConfiguration(defConfig);
        }
    }
}

