/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.benchmark;

import java.util.concurrent.atomic.AtomicInteger;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import org.apache.jackrabbit.oak.benchmark.AbstractTest;

public class ConcurrentCreateNodesTest
extends AbstractTest {
    public static final int EVENT_TYPES = 127;
    protected static final String ROOT_NODE_NAME = "test" + TEST_ID;
    private static final int WORKER_COUNT = Integer.getInteger("workerCount", 20);
    private static final int LISTENER_COUNT = Integer.getInteger("listenerCount", 0);
    private static final int NODE_COUNT_LEVEL2 = 50;
    private static final String NODE_TYPE = System.getProperty("nodeType", "nt:unstructured");
    private static final boolean DISABLE_INDEX = Boolean.getBoolean("disableIndex");
    private static final boolean VERBOSE = Boolean.getBoolean("verbose");
    private Writer writer;
    private final AtomicInteger NODE_COUNT = new AtomicInteger();

    @Override
    protected void beforeSuite() throws Exception {
        int i;
        Node rootNode;
        Session session = this.loginWriter();
        if (DISABLE_INDEX) {
            this.disableNodeTypeIndex(session);
        }
        if ((rootNode = session.getRootNode()).hasNode(ROOT_NODE_NAME)) {
            Node root = rootNode.getNode(ROOT_NODE_NAME);
            root.remove();
        }
        rootNode = session.getRootNode().addNode(ROOT_NODE_NAME, NODE_TYPE);
        for (i = 0; i < WORKER_COUNT; ++i) {
            rootNode.addNode("node" + i);
        }
        session.save();
        for (i = 1; i < WORKER_COUNT; ++i) {
            this.addBackgroundJob(new Writer(rootNode.getPath() + "/node" + i));
        }
        for (i = 0; i < LISTENER_COUNT; ++i) {
            Session s = this.loginWriter();
            s.getWorkspace().getObservationManager().addEventListener(new Listener(), 127, "/", true, null, null, false);
        }
        this.writer = new Writer(rootNode.getPath() + "/node" + 0);
    }

    @Override
    public void runTest() throws Exception {
        this.writer.run();
    }

    private void disableNodeTypeIndex(Session session) throws RepositoryException {
        if (!session.nodeExists("/oak:index/nodetype")) {
            return;
        }
        Node ntIndex = session.getNode("/oak:index/nodetype");
        ntIndex.setProperty("reindex", true);
        ntIndex.setProperty("declaringNodeTypes", new String[0], 7);
        session.save();
    }

    private class Listener
    implements EventListener {
        private Listener() {
        }

        @Override
        public void onEvent(EventIterator events) {
            try {
                while (events.hasNext()) {
                    events.nextEvent().getPath();
                }
            }
            catch (RepositoryException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
    }

    private class Writer
    implements Runnable {
        private final Session session;
        private final String path;
        private int count;

        private Writer(String path) {
            this.session = ConcurrentCreateNodesTest.this.loginWriter();
            this.count = 0;
            this.path = path;
        }

        @Override
        public void run() {
            try {
                int numNodes = ConcurrentCreateNodesTest.this.NODE_COUNT.get();
                long time = System.currentTimeMillis();
                this.session.refresh(false);
                Node root = this.session.getNode(this.path);
                Node node = root.addNode("node" + this.count++);
                for (int j = 0; j < 50; ++j) {
                    node.addNode("node" + j);
                    this.session.save();
                    ConcurrentCreateNodesTest.this.NODE_COUNT.incrementAndGet();
                }
                numNodes = ConcurrentCreateNodesTest.this.NODE_COUNT.get() - numNodes;
                time = System.currentTimeMillis() - time;
                if (this == ConcurrentCreateNodesTest.this.writer && VERBOSE) {
                    long perSecond = (long)(numNodes * 1000) / time;
                    System.out.println("Created " + numNodes + " in " + time + " ms. (" + perSecond + " nodes/sec)");
                }
            }
            catch (RepositoryException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
    }
}

