/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.benchmark;

import java.util.Random;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.Privilege;
import javax.jcr.util.TraversingItemVisitor;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;
import org.apache.jackrabbit.commons.jackrabbit.authorization.AccessControlUtils;
import org.apache.jackrabbit.oak.benchmark.AbstractTest;
import org.apache.jackrabbit.oak.spi.security.principal.EveryonePrincipal;

public class ConcurrentEveryoneACLTest
extends AbstractTest {
    private final Random random = new Random();
    protected static final int NODE_COUNT = 100;
    protected static final String ROOT_NODE_NAME = "test" + TEST_ID;
    private final boolean runAsAdmin;
    private final int itemsToRead;

    public ConcurrentEveryoneACLTest(boolean runAsAdmin, int itemsToRead) {
        this.runAsAdmin = runAsAdmin;
        this.itemsToRead = itemsToRead;
    }

    @Override
    public void beforeSuite() throws Exception {
        Session session = this.loginWriter();
        AccessControlManager acMgr = session.getAccessControlManager();
        Privilege[] privileges = new Privilege[]{acMgr.privilegeFromName("{http://www.jcp.org/jcr/1.0}read"), acMgr.privilegeFromName("{http://www.jcp.org/jcr/1.0}readAccessControl")};
        Node root = session.getRootNode().addNode(ROOT_NODE_NAME, "nt:unstructured");
        for (int i = 0; i < 100; ++i) {
            Node node = root.addNode("node" + i, "nt:unstructured");
            for (int j = 0; j < 100; ++j) {
                Node newNode = node.addNode("node" + j, "nt:unstructured");
                JackrabbitAccessControlList acl = AccessControlUtils.getAccessControlList(session, newNode.getPath());
                acl.addEntry(EveryonePrincipal.getInstance(), privileges, true);
                acMgr.setPolicy(newNode.getPath(), acl);
            }
            session.save();
        }
        JackrabbitAccessControlList acl = AccessControlUtils.getAccessControlList(session, root.getPath());
        acl.addEntry(EveryonePrincipal.getInstance(), privileges, false);
        acMgr.setPolicy(root.getPath(), acl);
        session.save();
        final int[] numACEs = new int[1];
        TraversingItemVisitor.Default v = new TraversingItemVisitor.Default(){

            @Override
            protected void entering(Node node, int i) throws RepositoryException {
                if (node.isNodeType("rep:ACE")) {
                    numACEs[0] = numACEs[0] + 1;
                }
                super.entering(node, i);
            }

            @Override
            protected void entering(Property prop, int i) throws RepositoryException {
                super.entering(prop, i);
            }
        };
        v.visit(root);
        System.out.println("Num ACEs: " + numACEs[0]);
        session.logout();
    }

    @Override
    public void afterSuite() throws Exception {
        Session session = this.loginWriter();
        Node root = session.getRootNode().getNode(ROOT_NODE_NAME);
        root.remove();
        session.logout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runTest() throws Exception {
        Session session = null;
        try {
            session = this.runAsAdmin ? this.loginWriter() : this.loginAnonymous();
            for (int i = 0; i < this.itemsToRead; ++i) {
                session.refresh(false);
                int a = this.random.nextInt(100);
                int b = this.random.nextInt(100);
                String path = "/" + ROOT_NODE_NAME + "/node" + a + "/node" + b + "/jcr:primaryType";
                session.getProperty(path).getString();
            }
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }
}

