/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.benchmark;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.jackrabbit.oak.benchmark.AbstractTest;
import org.apache.jackrabbit.oak.benchmark.TestInputStream;

public class ConcurrentFileWriteTest
extends AbstractTest {
    private static final int FILE_SIZE = Integer.getInteger("fileSize", 1900);
    private static final int WRITERS = Integer.getInteger("fileWriters", 50);
    private static final int READERS = Integer.getInteger("fileReaders", 50);
    protected static final String ROOT_NODE_NAME = "concurrentFileWriteTest" + TEST_ID;
    private final Random random = new Random();
    private final List<String> paths = Lists.newArrayList();
    private Writer writer;

    @Override
    public void beforeSuite() throws RepositoryException {
        int i;
        Session session = this.loginWriter();
        session.getRootNode().addNode(ROOT_NODE_NAME);
        session.save();
        this.writer = new Writer(0);
        this.writer.run();
        for (i = 1; i < WRITERS; ++i) {
            this.addBackgroundJob(new Writer(i));
        }
        for (i = 0; i < READERS; ++i) {
            this.addBackgroundJob(new Reader());
        }
    }

    @Override
    public void runTest() throws Exception {
        this.writer.run();
    }

    private synchronized String getRandomPath() {
        return this.paths.get(this.random.nextInt(this.paths.size()));
    }

    private synchronized void addPath(String path) {
        this.paths.add(path);
    }

    private class Writer
    implements Runnable {
        private final Node parent;
        private long counter = 0L;

        Writer(int id) throws RepositoryException {
            this.parent = ConcurrentFileWriteTest.this.loginWriter().getRootNode().getNode(ROOT_NODE_NAME).addNode("writer-" + id);
            this.parent.getSession().save();
        }

        @Override
        public void run() {
            try {
                this.parent.getSession().refresh(false);
                Node file = JcrUtils.putFile(this.parent, "file-" + this.counter++, "application/octet-stream", new TestInputStream(FILE_SIZE * 1024));
                this.parent.getSession().save();
                ConcurrentFileWriteTest.this.addPath(file.getPath());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private class Reader
    implements Runnable {
        private final Session session;

        private Reader() {
            this.session = ConcurrentFileWriteTest.this.loginWriter();
        }

        @Override
        public void run() {
            try {
                String path = ConcurrentFileWriteTest.this.getRandomPath();
                this.session.refresh(false);
                JcrUtils.readFile(this.session.getNode(path), new NullOutputStream());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

