/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.benchmark;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.oak.benchmark.ConcurrentReadDeepTreeTest;

public class ConcurrentHasPermissionTest
extends ConcurrentReadDeepTreeTest {
    private static final List<String> ACTIONS = ImmutableList.of("read", "add_node", "set_property", "remove", "read,add_node,set_property,remove", "add_node,set_property,remove", "add_node,remove", "set_property,remove", "read,add_node", "read,set_property");

    protected ConcurrentHasPermissionTest(boolean runAsAdmin, int itemsToRead, boolean doReport) {
        super(runAsAdmin, itemsToRead, doReport);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void randomRead(Session testSession, List<String> allPaths, int cnt) throws RepositoryException {
        boolean logout = false;
        if (testSession == null) {
            testSession = this.getTestSession();
            logout = true;
        }
        try {
            int allows = 0;
            int denies = 0;
            int size = allPaths.size();
            long start = System.currentTimeMillis();
            for (int i = 0; i < cnt; ++i) {
                String actions;
                double rand = (double)size * Math.random();
                int index = (int)Math.floor(rand);
                String path = allPaths.get(index);
                if (testSession.hasPermission(path, actions = ConcurrentHasPermissionTest.getRandomActions())) {
                    ++allows;
                    continue;
                }
                ++denies;
            }
            long end = System.currentTimeMillis();
            if (this.doReport) {
                System.out.println("Session " + testSession.getUserID() + " calling #hasPermission (Allows: " + allows + "; Denies: " + denies + ") completed in " + (end - start));
            }
        }
        finally {
            if (logout) {
                this.logout(testSession);
            }
        }
    }

    private static String getRandomActions() {
        int index = (int)Math.floor(10.0 * Math.random());
        return ACTIONS.get(index);
    }
}

