/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.benchmark;

import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.commons.jackrabbit.authorization.AccessControlUtils;
import org.apache.jackrabbit.oak.benchmark.ConcurrentHasPermissionTest;
import org.apache.jackrabbit.util.Text;

public class ConcurrentHasPermissionTest2
extends ConcurrentHasPermissionTest {
    int counter = 0;
    final List<Principal> principals = new ArrayList<Principal>();

    public ConcurrentHasPermissionTest2(boolean runAsAdmin, int itemsToRead, boolean doReport) {
        super(runAsAdmin, itemsToRead, doReport);
    }

    @Override
    protected void createDeepTree() throws Exception {
        UserManager uMgr = ((JackrabbitSession)this.adminSession).getUserManager();
        for (int i = 0; i < 100; ++i) {
            Authorizable a = uMgr.getAuthorizable("group" + i);
            if (a != null) continue;
            a = uMgr.createGroup("group" + i);
            this.principals.add(a.getPrincipal());
        }
        super.createDeepTree();
    }

    @Override
    protected void visitingNode(Node node, int i) throws RepositoryException {
        super.visitingNode(node, i);
        if (!node.getPath().contains("rep:policy") && ++this.counter == 100) {
            this.addPolicy(node);
            this.counter = 0;
        }
    }

    private void addPolicy(Node node) throws RepositoryException {
        JackrabbitAccessControlList acl;
        AccessControlManager acMgr = node.getSession().getAccessControlManager();
        String path = node.getPath();
        int level = 0;
        if (node.isNodeType("rep:Policy")) {
            level = 1;
        } else if (node.isNodeType("rep:ACE")) {
            level = 2;
        } else if (node.isNodeType("rep:Restrictions")) {
            level = 3;
        }
        if (level > 0) {
            path = Text.getRelativeParent(path, level);
        }
        if ((acl = AccessControlUtils.getAccessControlList(node.getSession(), path)) != null) {
            Privilege[] privileges = new Privilege[]{acMgr.privilegeFromName("{http://www.jcp.org/jcr/1.0}read"), acMgr.privilegeFromName("{http://www.jcp.org/jcr/1.0}readAccessControl")};
            for (Principal principal : this.principals) {
                acl.addAccessControlEntry(principal, privileges);
            }
            acMgr.setPolicy(path, acl);
            this.adminSession.save();
        }
    }
}

