/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.benchmark;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;
import org.apache.jackrabbit.commons.jackrabbit.authorization.AccessControlUtils;
import org.apache.jackrabbit.oak.benchmark.ConcurrentReadDeepTreeTest;
import org.apache.jackrabbit.oak.spi.security.principal.EveryonePrincipal;
import org.apache.jackrabbit.util.Text;

public class ConcurrentReadAccessControlledTreeTest
extends ConcurrentReadDeepTreeTest {
    int counter = 0;

    public ConcurrentReadAccessControlledTreeTest(boolean runAsAdmin, int itemsToRead, boolean doReport) {
        super(runAsAdmin, itemsToRead, doReport);
    }

    @Override
    protected void visitingNode(Node node, int i) throws RepositoryException {
        super.visitingNode(node, i);
        String path = node.getPath();
        if (!path.contains("rep:policy") && ++this.counter == 10) {
            this.addPolicy(path, node);
            this.counter = 0;
        }
    }

    private void addPolicy(String path, Node node) throws RepositoryException {
        JackrabbitAccessControlList acl;
        AccessControlManager acMgr = node.getSession().getAccessControlManager();
        int level = 0;
        if (node.isNodeType("rep:Policy")) {
            level = 1;
        } else if (node.isNodeType("rep:ACE")) {
            level = 2;
        } else if (node.isNodeType("rep:Restrictions")) {
            level = 3;
        }
        if (level > 0) {
            path = Text.getRelativeParent(path, level);
        }
        if ((acl = AccessControlUtils.getAccessControlList(node.getSession(), path)) != null) {
            Privilege[] privileges = new Privilege[]{acMgr.privilegeFromName("{http://www.jcp.org/jcr/1.0}read"), acMgr.privilegeFromName("{http://www.jcp.org/jcr/1.0}readAccessControl")};
            if (acl.addAccessControlEntry(EveryonePrincipal.getInstance(), privileges)) {
                acMgr.setPolicy(path, acl);
                node.getSession().save();
            }
        }
    }
}

