/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.benchmark;

import java.util.List;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.oak.benchmark.ReadDeepTreeTest;

public class ConcurrentReadRandomNodeAndItsPropertiesTest
extends ReadDeepTreeTest {
    public ConcurrentReadRandomNodeAndItsPropertiesTest(boolean runAsAdmin, int itemsToRead, boolean doReport) {
        super(runAsAdmin, itemsToRead, doReport);
    }

    @Override
    protected void visitingProperty(Property property, int i) throws RepositoryException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void randomRead(Session testSession, List<String> allPaths, int cnt) throws RepositoryException {
        boolean logout = false;
        if (testSession == null) {
            testSession = this.getTestSession();
            logout = true;
        }
        try {
            int nodeCnt = 0;
            int propertyCnt = 0;
            int noAccess = 0;
            int size = allPaths.size();
            long start = System.currentTimeMillis();
            for (int i = 0; i < cnt; ++i) {
                double rand = (double)size * Math.random();
                int index = (int)Math.floor(rand);
                String path = allPaths.get(index);
                if (testSession.itemExists(path)) {
                    Item item = testSession.getItem(path);
                    if (!item.isNode()) continue;
                    ++nodeCnt;
                    Node n = (Node)item;
                    PropertyIterator it = n.getProperties();
                    while (it.hasNext()) {
                        Property p = it.nextProperty();
                        ++propertyCnt;
                    }
                    continue;
                }
                ++noAccess;
            }
            long end = System.currentTimeMillis();
            if (this.doReport) {
                System.out.println("Session " + testSession.getUserID() + " reading " + (cnt - noAccess) + " (Nodes: " + nodeCnt + "; Properties: " + propertyCnt + ") completed in " + (end - start));
            }
        }
        finally {
            if (logout) {
                this.logout(testSession);
            }
        }
    }
}

