/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.benchmark;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;
import org.apache.jackrabbit.commons.jackrabbit.authorization.AccessControlUtils;
import org.apache.jackrabbit.oak.benchmark.ConcurrentReadDeepTreeTest;
import org.apache.jackrabbit.oak.spi.security.principal.EveryonePrincipal;

public class ConcurrentReadSinglePolicyTreeTest
extends ConcurrentReadDeepTreeTest {
    public ConcurrentReadSinglePolicyTreeTest(boolean runAsAdmin, int itemsToRead, boolean doReport) {
        super(runAsAdmin, itemsToRead, doReport);
    }

    @Override
    protected void visitingNode(Node node, int i) throws RepositoryException {
        super.visitingNode(node, i);
        String path = node.getPath();
        AccessControlManager acMgr = node.getSession().getAccessControlManager();
        if (this.testRoot.getPath().equals(path)) {
            JackrabbitAccessControlList policy = AccessControlUtils.getAccessControlList(acMgr, path);
            if (policy != null) {
                policy.addEntry(EveryonePrincipal.getInstance(), AccessControlUtils.privilegesFromNames(acMgr, "{http://www.jcp.org/jcr/1.0}read"), true);
            }
            acMgr.setPolicy(path, policy);
        } else if (!path.contains("rep:policy")) {
            for (AccessControlPolicy policy : acMgr.getPolicies(path)) {
                if (!(policy instanceof JackrabbitAccessControlList)) continue;
                acMgr.removePolicy(path, policy);
            }
        }
        node.getSession().save();
    }
}

