/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.benchmark;

import java.util.Random;
import javax.jcr.InvalidItemStateException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.oak.benchmark.AbstractTest;

public class ConcurrentReadTest
extends AbstractTest {
    protected static final int NODE_COUNT = 100;
    protected static final String ROOT_NODE_NAME = "test" + TEST_ID;
    private final int backgroundReaderCount;
    private final int backgroundWriterCount;
    private final boolean foregroundIsReader;
    private Runnable foregroundTask;

    protected ConcurrentReadTest(int backgroundReaderCount, int backgroundWriterCount, boolean foregroundIsReader) {
        this.backgroundReaderCount = backgroundReaderCount;
        this.backgroundWriterCount = backgroundWriterCount;
        this.foregroundIsReader = foregroundIsReader;
    }

    public ConcurrentReadTest() {
        this(ConcurrentReadTest.getScale(20), 0, true);
    }

    @Override
    public void beforeSuite() throws Exception {
        int i;
        Session session = this.loginWriter();
        Node root = session.getRootNode().addNode(ROOT_NODE_NAME, "nt:unstructured");
        for (i = 0; i < 100; ++i) {
            Node node = root.addNode("node" + i, "nt:unstructured");
            for (int j = 0; j < 100; ++j) {
                node.addNode("node" + j, "nt:unstructured");
            }
            session.save();
        }
        this.foregroundTask = this.foregroundIsReader ? new Reader() : new Writer();
        for (i = 0; i < this.backgroundReaderCount; ++i) {
            this.addBackgroundJob(new Reader());
        }
        for (i = 0; i < this.backgroundWriterCount; ++i) {
            this.addBackgroundJob(new Writer());
        }
    }

    @Override
    public void runTest() throws Exception {
        this.foregroundTask.run();
    }

    @Override
    public void afterSuite() throws Exception {
        Session session = this.loginWriter();
        Node root = session.getRootNode().getNode(ROOT_NODE_NAME);
        for (int i = 0; i < 100; ++i) {
            root.getNode("node" + i).remove();
            session.save();
        }
        root.remove();
        session.save();
    }

    private class Writer
    implements Runnable {
        private final Random random = new Random();
        private final Session session = ConcurrentReadTest.this.loginWriter();
        private long count;

        private Writer() {
        }

        @Override
        public void run() {
            try {
                this.session.refresh(false);
                for (int i = 0; i < 10; ++i) {
                    int a = this.random.nextInt(100);
                    int b = this.random.nextInt(100);
                    Node node = this.session.getRootNode().getNode(ROOT_NODE_NAME + "/node" + a + "/node" + b);
                    boolean done = false;
                    while (!done) {
                        try {
                            node.setProperty("count", this.count++);
                            this.session.save();
                            done = true;
                        }
                        catch (InvalidItemStateException e) {
                            this.session.refresh(false);
                        }
                    }
                }
            }
            catch (RepositoryException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private class Reader
    implements Runnable {
        private final Random random = new Random();
        private final Session session = ConcurrentReadTest.this.loginWriter();

        private Reader() {
        }

        @Override
        public void run() {
            try {
                this.session.refresh(false);
                for (int i = 0; i < 10000; ++i) {
                    int a = this.random.nextInt(100);
                    int b = this.random.nextInt(100);
                    this.session.getRootNode().getNode(ROOT_NODE_NAME + "/node" + a + "/node" + b);
                }
            }
            catch (RepositoryException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

