/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.benchmark;

import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.util.TraversingItemVisitor;
import org.apache.jackrabbit.oak.benchmark.ManyUserReadTest;

public class ConcurrentTraversalTest
extends ManyUserReadTest {
    private static final int MAX_LEVEL = 10;

    protected ConcurrentTraversalTest(boolean runAsAdmin, int itemsToRead, boolean doReport, boolean randomUser) {
        super(runAsAdmin, itemsToRead, doReport, randomUser);
    }

    @Override
    protected void runTest() throws Exception {
        this.traverse(this.testSession, this.itemsToRead);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void traverse(Session testSession, int cnt) throws RepositoryException {
        boolean logout = false;
        if (testSession == null) {
            testSession = this.getTestSession();
            logout = true;
        }
        try {
            int nodeCnt = 0;
            int propertyCnt = 0;
            int noAccess = 0;
            int size = this.allPaths.size();
            long start = System.currentTimeMillis();
            for (int i = 0; i < cnt; ++i) {
                double rand = (double)size * Math.random();
                int index = (int)Math.floor(rand);
                String path = (String)this.allPaths.get(index);
                if (testSession.itemExists(path)) {
                    Item item = testSession.getItem(path);
                    Visitor visitor = new Visitor();
                    item.accept(visitor);
                    nodeCnt = (int)((long)nodeCnt + visitor.nodeCnt);
                    propertyCnt = (int)((long)propertyCnt + visitor.propertyCnt);
                    continue;
                }
                ++noAccess;
            }
            long end = System.currentTimeMillis();
            if (this.doReport) {
                System.out.println("Session " + testSession.getUserID() + " reading " + (cnt - noAccess) + " (Nodes: " + nodeCnt + "; Properties: " + propertyCnt + ") completed in " + (end - start));
            }
        }
        finally {
            if (logout) {
                this.logout(testSession);
            }
        }
    }

    private final class Visitor
    extends TraversingItemVisitor.Default {
        private long propertyCnt;
        private long nodeCnt;

        public Visitor() {
            super(false, 10);
        }

        @Override
        protected void entering(Property property, int level) {
            ++this.propertyCnt;
        }

        @Override
        protected void entering(Node node, int level) {
            ++this.nodeCnt;
        }
    }
}

