/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.benchmark;

import java.util.Random;
import javax.jcr.InvalidItemStateException;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;
import org.apache.jackrabbit.commons.jackrabbit.authorization.AccessControlUtils;
import org.apache.jackrabbit.oak.benchmark.AbstractTest;
import org.apache.jackrabbit.oak.spi.security.principal.EveryonePrincipal;

public class ConcurrentWriteACLTest
extends AbstractTest {
    private final Random random = new Random();
    protected static final int NODE_COUNT = 200;
    protected static final String ROOT_NODE_NAME = "test" + TEST_ID;
    private int numItems;

    public ConcurrentWriteACLTest(int numItems) {
        this.numItems = numItems;
    }

    @Override
    public void beforeSuite() throws Exception {
        Session session = this.loginWriter();
        Node root = session.getRootNode().addNode(ROOT_NODE_NAME, "nt:unstructured");
        for (int i = 0; i < 200; ++i) {
            Node node = root.addNode("node" + i, "nt:unstructured");
            for (int j = 0; j < 200; ++j) {
                Node newNode = node.addNode("node" + j, "nt:unstructured");
                newNode.addMixin("rep:AccessControllable");
            }
            session.save();
        }
        session.logout();
    }

    @Override
    public void afterSuite() throws Exception {
        Session session = this.loginWriter();
        Node root = session.getRootNode().getNode(ROOT_NODE_NAME);
        root.remove();
        session.logout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runTest() throws Exception {
        Session session = null;
        try {
            session = this.loginWriter();
            for (int i = 0; i < this.numItems; ++i) {
                session.refresh(false);
                int a = this.random.nextInt(200);
                int b = this.random.nextInt(200);
                String path = "/" + ROOT_NODE_NAME + "/node" + a + "/node" + b;
                AccessControlManager acMgr = session.getAccessControlManager();
                JackrabbitAccessControlList acl = AccessControlUtils.getAccessControlList(session, path);
                if (acl.isEmpty()) {
                    Privilege[] privileges = new Privilege[]{acMgr.privilegeFromName("{http://www.jcp.org/jcr/1.0}read"), acMgr.privilegeFromName("{http://www.jcp.org/jcr/1.0}readAccessControl")};
                    if (acl.addAccessControlEntry(EveryonePrincipal.getInstance(), privileges)) {
                        acMgr.setPolicy(path, acl);
                    }
                } else {
                    for (AccessControlEntry ace : acl.getAccessControlEntries()) {
                        acl.removeAccessControlEntry(ace);
                    }
                    acMgr.setPolicy(path, acl);
                }
                session.save();
            }
        }
        catch (InvalidItemStateException e) {
            System.out.printf("error: %s%n", e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }
}

