/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.benchmark;

import com.google.common.base.Stopwatch;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import javax.jcr.Node;
import javax.jcr.Repository;
import javax.jcr.Session;
import org.apache.jackrabbit.oak.benchmark.RevisionGCTest;
import org.apache.jackrabbit.oak.spi.state.NodeStore;

public class ContinuousRevisionGCTest
extends RevisionGCTest {
    @Override
    protected void run(Repository repository, NodeStore nodeStore) throws Exception {
        Thread t = new Thread(new Writer(ContinuousRevisionGCTest.createSession(repository)));
        t.start();
        while (true) {
            Thread.sleep(TimeUnit.SECONDS.toMillis(10L));
            Stopwatch sw = Stopwatch.createStarted();
            String result = ContinuousRevisionGCTest.revisionGC(nodeStore);
            sw.stop();
            System.out.println("\nPerformed RevisionGC in " + sw + " (" + result + ")");
        }
    }

    private class Writer
    implements Runnable {
        private final Session s;

        public Writer(Session s) {
            this.s = s;
        }

        @Override
        public void run() {
            Random rand = new Random();
            try {
                try {
                    System.out.print("Creating garbage ");
                    int i = 0;
                    while (true) {
                        Node n = this.s.getRootNode().addNode("node-" + i);
                        for (int j = 0; j < 1000; ++j) {
                            n.addNode("child-" + j, RevisionGCTest.NODE_TYPE);
                        }
                        this.s.save();
                        if (rand.nextFloat() <= RevisionGCTest.GARBAGE_RATIO) {
                            n.remove();
                            this.s.save();
                        }
                        System.out.print(".");
                        ++i;
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            catch (Throwable throwable) {
                this.s.logout();
                throw throwable;
            }
        }
    }
}

