/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.benchmark;

import java.util.Random;
import java.util.UUID;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.oak.benchmark.AbstractTest;
import org.apache.jackrabbit.oak.benchmark.util.OakIndexUtils;

public class CreateManyIndexedNodesTest
extends AbstractTest {
    private static final String NODE_TYPE = "oak:Unstructured";
    protected static final String ROOT_NODE_NAME = "test" + TEST_ID;
    private static final int PARENT_COUNT = 100;
    private static final int THREAD_COUNT = 1;
    private static final int NODES_PER_THREAD = 50;
    private Session session;
    private Writer foregroundJob;

    @Override
    public void beforeSuite() throws RepositoryException {
        this.session = this.loginWriter();
        Node rootNode = this.session.getRootNode().addNode(ROOT_NODE_NAME, NODE_TYPE);
        Node testNode = rootNode.addNode("testNode", NODE_TYPE);
        for (int i = 0; i < 100; ++i) {
            Node level1Node = testNode.addNode("level1_" + i, NODE_TYPE);
        }
        this.session.save();
        OakIndexUtils.PropertyIndex index = new OakIndexUtils.PropertyIndex();
        index.property("indexedProperty");
        index.create(this.session);
        this.session.save();
        for (int i = 0; i < 0; ++i) {
            this.addBackgroundJob(new Writer());
        }
        this.foregroundJob = new Writer();
    }

    @Override
    public void beforeTest() throws RepositoryException {
    }

    @Override
    public void runTest() throws Exception {
        this.foregroundJob.run();
    }

    @Override
    public void afterTest() throws RepositoryException {
    }

    @Override
    protected void afterSuite() throws Exception {
        this.session.save();
    }

    private class Writer
    implements Runnable {
        private final Random random = new Random();
        private final Session session = CreateManyIndexedNodesTest.this.loginWriter();
        private long count;

        private Writer() {
        }

        @Override
        public void run() {
            try {
                for (int i = 0; i < 50; ++i) {
                    this.session.refresh(false);
                    int level1 = this.random.nextInt(100);
                    Node level1Node = this.session.getNode("/" + ROOT_NODE_NAME + "/testNode/level1_" + level1);
                    String randomName = UUID.randomUUID().toString();
                    Node newNode = level1Node.addNode(randomName);
                    newNode.setProperty("indexedProperty", randomName);
                    this.session.save();
                }
            }
            catch (RepositoryException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

