/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.benchmark;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.oak.benchmark.AbstractTest;

public class CreateManyNodesTest
extends AbstractTest {
    protected static final String ROOT_NODE_NAME = "many" + TEST_ID;
    private static final int FANOUT = 5;
    private static final int LEVELS = 4;
    private static final int SAVE_EVERY = 150;
    private Session session;
    private Node testRootNode;
    private int nodeCount;

    @Override
    public void beforeSuite() throws RepositoryException {
        this.session = this.loginWriter();
        this.testRootNode = this.session.getRootNode().addNode(ROOT_NODE_NAME, "nt:unstructured");
    }

    @Override
    public void afterSuite() throws RepositoryException {
        this.testRootNode.remove();
    }

    @Override
    public void runTest() throws Exception {
        this.nodeCount = 0;
        ++this.nodeCount;
        Node node = this.testRootNode.addNode(CreateManyNodesTest.nextNodeName(), "nt:unstructured");
        this.addChildNodes(node, 4);
        this.session.save();
    }

    private void addChildNodes(Node parent, int level) throws Exception {
        for (int i = 0; i < 5; ++i) {
            ++this.nodeCount;
            Node n = parent.addNode("l" + level + "n" + i, "nt:unstructured");
            if (this.nodeCount % 150 == 0) {
                n.getSession().save();
            }
            if (level <= 0) continue;
            this.addChildNodes(n, level - 1);
        }
    }
}

