/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.benchmark;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jcr.Node;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import org.apache.jackrabbit.oak.benchmark.AbstractTest;
import org.apache.jackrabbit.oak.benchmark.Benchmark;
import org.apache.jackrabbit.oak.fixture.RepositoryFixture;

public class CreateNodesBenchmark
extends Benchmark {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(Iterable<RepositoryFixture> fixtures) {
        for (RepositoryFixture fixture : fixtures) {
            if (!fixture.isAvailable(1)) continue;
            System.out.format("%s: Create nodes benchmark%n", fixture);
            try {
                Repository[] cluster = fixture.setUpCluster(1);
                try {
                    this.run(cluster[0]);
                }
                finally {
                    fixture.tearDownCluster();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void run(Repository repository) throws RepositoryException {
        Session session = repository.login(new SimpleCredentials("admin", "admin".toCharArray()));
        AtomicInteger count = new AtomicInteger();
        long startTime = System.currentTimeMillis();
        Node testRoot = session.getRootNode().addNode("r" + AbstractTest.TEST_ID);
        this.createNodes(testRoot, 20, 6, count, startTime);
        long duration = System.currentTimeMillis() - startTime;
        System.out.format("Created %d nodes in %d seconds (%.2fms/node)%n", count.get(), duration / 1000L, (double)duration / (double)count.get());
    }

    private void createNodes(Node n, int nodesPerLevel, int levels, AtomicInteger count, long startTime) throws RepositoryException {
        --levels;
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (int i = 0; i < nodesPerLevel; ++i) {
            nodes.add(n.addNode("folder-" + i, "nt:folder"));
            if (count.incrementAndGet() % 1000 != 0) continue;
            long duration = System.currentTimeMillis() - startTime;
            System.out.format("Created %d nodes in %d seconds (%.2fms/node)...%n", count.get(), duration / 1000L, (double)duration / (double)count.get());
        }
        n.getSession().save();
        if (levels > 0) {
            for (Node child : nodes) {
                this.createNodes(child, nodesPerLevel, levels, count, startTime);
            }
        }
    }
}

