/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.benchmark;

import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.jcr.Credentials;
import javax.jcr.GuestCredentials;
import javax.jcr.Repository;
import javax.security.auth.Subject;
import org.apache.jackrabbit.oak.Oak;
import org.apache.jackrabbit.oak.api.ContentRepository;
import org.apache.jackrabbit.oak.api.ContentSession;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.benchmark.CugTest;
import org.apache.jackrabbit.oak.fixture.JcrCreator;
import org.apache.jackrabbit.oak.fixture.OakRepositoryFixture;
import org.apache.jackrabbit.oak.fixture.RepositoryFixture;
import org.apache.jackrabbit.oak.jcr.Jcr;
import org.apache.jackrabbit.oak.plugins.tree.TreeLocation;

public class CugOakTest
extends CugTest {
    private ContentRepository contentRepository;
    private ContentSession cs;
    private Subject subject;

    protected CugOakTest(boolean runAsAdmin, int itemsToRead, boolean singleSession, @Nonnull List<String> supportedPaths, boolean reverseOrder) {
        super(runAsAdmin, itemsToRead, singleSession, supportedPaths, reverseOrder);
    }

    @Override
    protected Repository[] createRepository(RepositoryFixture fixture) throws Exception {
        if (fixture instanceof OakRepositoryFixture) {
            return ((OakRepositoryFixture)fixture).setUpCluster(1, new JcrCreator(){

                @Override
                public Jcr customize(Oak oak) {
                    Jcr jcr = new Jcr(oak).with(CugOakTest.this.createSecurityProvider());
                    CugOakTest.this.contentRepository = jcr.createContentRepository();
                    return jcr;
                }
            });
        }
        throw new IllegalArgumentException("Fixture " + fixture + " not supported for this benchmark.");
    }

    @Override
    protected void beforeSuite() throws Exception {
        super.beforeSuite();
        Credentials creds = this.runAsAdmin ? this.getCredentials() : new GuestCredentials();
        this.cs = this.contentRepository.login(creds, null);
        this.subject = new Subject(true, this.cs.getAuthInfo().getPrincipals(), Collections.emptySet(), Collections.emptySet());
    }

    @Override
    protected void afterSuite() throws Exception {
        super.afterSuite();
        this.cs.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void runTest() throws Exception {
        ContentSession readSession;
        boolean logout = false;
        if (this.singleSession) {
            readSession = this.cs;
        } else {
            readSession = Subject.doAs(this.subject, new PrivilegedAction<ContentSession>(){

                @Override
                public ContentSession run() {
                    try {
                        return CugOakTest.this.contentRepository.login(null, null);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            logout = true;
        }
        Root root = readSession.getLatestRoot();
        try {
            int nodeCnt = 0;
            int propertyCnt = 0;
            int noAccess = 0;
            int size = this.allPaths.size();
            long start = System.currentTimeMillis();
            for (int i = 0; i < this.itemsToRead; ++i) {
                double rand = (double)size * Math.random();
                int index = (int)Math.floor(rand);
                String path = (String)this.allPaths.get(index);
                TreeLocation treeLocation = TreeLocation.create(root, path);
                if (treeLocation.exists()) {
                    PropertyState ps = treeLocation.getProperty();
                    if (ps != null) {
                        ++propertyCnt;
                        continue;
                    }
                    ++nodeCnt;
                    continue;
                }
                ++noAccess;
            }
            long end = System.currentTimeMillis();
            if (this.doReport) {
                System.out.println("ContentSession " + this.cs.getAuthInfo().getUserID() + " reading " + (this.itemsToRead - noAccess) + " (Tree: " + nodeCnt + "; PropertyState: " + propertyCnt + ") completed in " + (end - start));
            }
        }
        finally {
            if (logout) {
                readSession.close();
            }
        }
    }
}

